/*
 * Classic Platforms - Notifications
 *
 * The version of the OpenAPI document: 6
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.marketpaywebhooks;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

/** AccountHolderUpcomingDeadlineNotificationContent */
@JsonPropertyOrder({
  AccountHolderUpcomingDeadlineNotificationContent.JSON_PROPERTY_ACCOUNT_HOLDER_CODE,
  AccountHolderUpcomingDeadlineNotificationContent.JSON_PROPERTY_EVENT,
  AccountHolderUpcomingDeadlineNotificationContent.JSON_PROPERTY_EXECUTION_DATE,
  AccountHolderUpcomingDeadlineNotificationContent.JSON_PROPERTY_REASON
})
public class AccountHolderUpcomingDeadlineNotificationContent {
  public static final String JSON_PROPERTY_ACCOUNT_HOLDER_CODE = "accountHolderCode";
  private String accountHolderCode;

  /** The event name that will be trigger if no action is taken. */
  public enum EventEnum {
    ACCESSPII("AccessPii"),

    APITIERUPDATE("ApiTierUpdate"),

    CLOSEACCOUNT("CloseAccount"),

    CLOSESTORES("CloseStores"),

    DELETEBALANCEACCOUNTS("DeleteBalanceAccounts"),

    DELETEBANKACCOUNTS("DeleteBankAccounts"),

    DELETELEGALARRANGEMENTS("DeleteLegalArrangements"),

    DELETELIABLEBANKACCOUNT("DeleteLiableBankAccount"),

    DELETEPAYOUTMETHODS("DeletePayoutMethods"),

    DELETESHAREHOLDERS("DeleteShareholders"),

    DELETESIGNATORIES("DeleteSignatories"),

    INACTIVATEACCOUNT("InactivateAccount"),

    KYCDEADLINEEXTENSION("KYCDeadlineExtension"),

    MIGRATEACCOUNTTOBP("MigrateAccountToBP"),

    RECALCULATEACCOUNTSTATUSANDPROCESSINGTIER("RecalculateAccountStatusAndProcessingTier"),

    REFUNDNOTPAIDOUTTRANSFERS("RefundNotPaidOutTransfers"),

    RESOLVEEVENTS("ResolveEvents"),

    SAVEACCOUNTHOLDER("SaveAccountHolder"),

    SAVEKYCCHECKSTATUS("SaveKYCCheckStatus"),

    SAVEPEPCHECKS("SavePEPChecks"),

    SUSPENDACCOUNT("SuspendAccount"),

    UNSUSPENDACCOUNT("UnSuspendAccount"),

    UPDATEACCOUNTHOLDERSTATE("UpdateAccountHolderState"),

    VERIFICATION("Verification");

    private String value;

    EventEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static EventEnum fromValue(String value) {
      for (EventEnum b : EventEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_EVENT = "event";
  private EventEnum event;

  public static final String JSON_PROPERTY_EXECUTION_DATE = "executionDate";
  private OffsetDateTime executionDate;

  public static final String JSON_PROPERTY_REASON = "reason";
  private String reason;

  public AccountHolderUpcomingDeadlineNotificationContent() {}

  public AccountHolderUpcomingDeadlineNotificationContent accountHolderCode(
      String accountHolderCode) {
    this.accountHolderCode = accountHolderCode;
    return this;
  }

  /**
   * The code of the account holder whom the event refers to.
   *
   * @return accountHolderCode
   */
  @ApiModelProperty(value = "The code of the account holder whom the event refers to.")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_HOLDER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAccountHolderCode() {
    return accountHolderCode;
  }

  @JsonProperty(JSON_PROPERTY_ACCOUNT_HOLDER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountHolderCode(String accountHolderCode) {
    this.accountHolderCode = accountHolderCode;
  }

  public AccountHolderUpcomingDeadlineNotificationContent event(EventEnum event) {
    this.event = event;
    return this;
  }

  /**
   * The event name that will be trigger if no action is taken.
   *
   * @return event
   */
  @ApiModelProperty(value = "The event name that will be trigger if no action is taken.")
  @JsonProperty(JSON_PROPERTY_EVENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public EventEnum getEvent() {
    return event;
  }

  @JsonProperty(JSON_PROPERTY_EVENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEvent(EventEnum event) {
    this.event = event;
  }

  public AccountHolderUpcomingDeadlineNotificationContent executionDate(
      OffsetDateTime executionDate) {
    this.executionDate = executionDate;
    return this;
  }

  /**
   * The execution date scheduled for the event.
   *
   * @return executionDate
   */
  @ApiModelProperty(value = "The execution date scheduled for the event.")
  @JsonProperty(JSON_PROPERTY_EXECUTION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getExecutionDate() {
    return executionDate;
  }

  @JsonProperty(JSON_PROPERTY_EXECUTION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExecutionDate(OffsetDateTime executionDate) {
    this.executionDate = executionDate;
  }

  public AccountHolderUpcomingDeadlineNotificationContent reason(String reason) {
    this.reason = reason;
    return this;
  }

  /**
   * The reason that leads to scheduling of the event.
   *
   * @return reason
   */
  @ApiModelProperty(value = "The reason that leads to scheduling of the event.")
  @JsonProperty(JSON_PROPERTY_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getReason() {
    return reason;
  }

  @JsonProperty(JSON_PROPERTY_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReason(String reason) {
    this.reason = reason;
  }

  /** Return true if this AccountHolderUpcomingDeadlineNotificationContent object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AccountHolderUpcomingDeadlineNotificationContent
        accountHolderUpcomingDeadlineNotificationContent =
            (AccountHolderUpcomingDeadlineNotificationContent) o;
    return Objects.equals(
            this.accountHolderCode,
            accountHolderUpcomingDeadlineNotificationContent.accountHolderCode)
        && Objects.equals(this.event, accountHolderUpcomingDeadlineNotificationContent.event)
        && Objects.equals(
            this.executionDate, accountHolderUpcomingDeadlineNotificationContent.executionDate)
        && Objects.equals(this.reason, accountHolderUpcomingDeadlineNotificationContent.reason);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountHolderCode, event, executionDate, reason);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AccountHolderUpcomingDeadlineNotificationContent {\n");
    sb.append("    accountHolderCode: ").append(toIndentedString(accountHolderCode)).append("\n");
    sb.append("    event: ").append(toIndentedString(event)).append("\n");
    sb.append("    executionDate: ").append(toIndentedString(executionDate)).append("\n");
    sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of AccountHolderUpcomingDeadlineNotificationContent given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of AccountHolderUpcomingDeadlineNotificationContent
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     AccountHolderUpcomingDeadlineNotificationContent
   */
  public static AccountHolderUpcomingDeadlineNotificationContent fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper()
        .readValue(jsonString, AccountHolderUpcomingDeadlineNotificationContent.class);
  }

  /**
   * Convert an instance of AccountHolderUpcomingDeadlineNotificationContent to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
