/*
 * Classic Platforms - Notifications
 *
 * The version of the OpenAPI document: 6
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.marketpaywebhooks;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/** AccountHolderVerificationNotificationContent */
@JsonPropertyOrder({
  AccountHolderVerificationNotificationContent.JSON_PROPERTY_ACCOUNT_HOLDER_CODE,
  AccountHolderVerificationNotificationContent.JSON_PROPERTY_KYC_CHECK_STATUS_DATA,
  AccountHolderVerificationNotificationContent.JSON_PROPERTY_LEGAL_ARRANGEMENT_CODE,
  AccountHolderVerificationNotificationContent.JSON_PROPERTY_LEGAL_ARRANGEMENT_ENTITY_CODE,
  AccountHolderVerificationNotificationContent.JSON_PROPERTY_PAYOUT_METHOD_CODE,
  AccountHolderVerificationNotificationContent.JSON_PROPERTY_SHAREHOLDER_CODE,
  AccountHolderVerificationNotificationContent.JSON_PROPERTY_SIGNATORY_CODE
})
public class AccountHolderVerificationNotificationContent {
  public static final String JSON_PROPERTY_ACCOUNT_HOLDER_CODE = "accountHolderCode";
  private String accountHolderCode;

  public static final String JSON_PROPERTY_KYC_CHECK_STATUS_DATA = "kycCheckStatusData";
  private KYCCheckStatusData kycCheckStatusData;

  public static final String JSON_PROPERTY_LEGAL_ARRANGEMENT_CODE = "legalArrangementCode";
  private String legalArrangementCode;

  public static final String JSON_PROPERTY_LEGAL_ARRANGEMENT_ENTITY_CODE =
      "legalArrangementEntityCode";
  private String legalArrangementEntityCode;

  public static final String JSON_PROPERTY_PAYOUT_METHOD_CODE = "payoutMethodCode";
  private String payoutMethodCode;

  public static final String JSON_PROPERTY_SHAREHOLDER_CODE = "shareholderCode";
  private String shareholderCode;

  public static final String JSON_PROPERTY_SIGNATORY_CODE = "signatoryCode";
  private String signatoryCode;

  public AccountHolderVerificationNotificationContent() {}

  public AccountHolderVerificationNotificationContent accountHolderCode(String accountHolderCode) {
    this.accountHolderCode = accountHolderCode;
    return this;
  }

  /**
   * The code of the account holder.
   *
   * @return accountHolderCode
   */
  @ApiModelProperty(value = "The code of the account holder.")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_HOLDER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAccountHolderCode() {
    return accountHolderCode;
  }

  @JsonProperty(JSON_PROPERTY_ACCOUNT_HOLDER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountHolderCode(String accountHolderCode) {
    this.accountHolderCode = accountHolderCode;
  }

  public AccountHolderVerificationNotificationContent kycCheckStatusData(
      KYCCheckStatusData kycCheckStatusData) {
    this.kycCheckStatusData = kycCheckStatusData;
    return this;
  }

  /**
   * Get kycCheckStatusData
   *
   * @return kycCheckStatusData
   */
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_KYC_CHECK_STATUS_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public KYCCheckStatusData getKycCheckStatusData() {
    return kycCheckStatusData;
  }

  @JsonProperty(JSON_PROPERTY_KYC_CHECK_STATUS_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setKycCheckStatusData(KYCCheckStatusData kycCheckStatusData) {
    this.kycCheckStatusData = kycCheckStatusData;
  }

  public AccountHolderVerificationNotificationContent legalArrangementCode(
      String legalArrangementCode) {
    this.legalArrangementCode = legalArrangementCode;
    return this;
  }

  /**
   * The unique ID of the legal arrangement that has been verified.
   *
   * @return legalArrangementCode
   */
  @ApiModelProperty(value = "The unique ID of the legal arrangement that has been verified.")
  @JsonProperty(JSON_PROPERTY_LEGAL_ARRANGEMENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getLegalArrangementCode() {
    return legalArrangementCode;
  }

  @JsonProperty(JSON_PROPERTY_LEGAL_ARRANGEMENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLegalArrangementCode(String legalArrangementCode) {
    this.legalArrangementCode = legalArrangementCode;
  }

  public AccountHolderVerificationNotificationContent legalArrangementEntityCode(
      String legalArrangementEntityCode) {
    this.legalArrangementEntityCode = legalArrangementEntityCode;
    return this;
  }

  /**
   * The unique ID of the legal arrangement entity that has been verified.
   *
   * @return legalArrangementEntityCode
   */
  @ApiModelProperty(value = "The unique ID of the legal arrangement entity that has been verified.")
  @JsonProperty(JSON_PROPERTY_LEGAL_ARRANGEMENT_ENTITY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getLegalArrangementEntityCode() {
    return legalArrangementEntityCode;
  }

  @JsonProperty(JSON_PROPERTY_LEGAL_ARRANGEMENT_ENTITY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLegalArrangementEntityCode(String legalArrangementEntityCode) {
    this.legalArrangementEntityCode = legalArrangementEntityCode;
  }

  public AccountHolderVerificationNotificationContent payoutMethodCode(String payoutMethodCode) {
    this.payoutMethodCode = payoutMethodCode;
    return this;
  }

  /**
   * The unique code of the payout method that has been verified.
   *
   * @return payoutMethodCode
   */
  @ApiModelProperty(value = "The unique code of the payout method that has been verified.")
  @JsonProperty(JSON_PROPERTY_PAYOUT_METHOD_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPayoutMethodCode() {
    return payoutMethodCode;
  }

  @JsonProperty(JSON_PROPERTY_PAYOUT_METHOD_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPayoutMethodCode(String payoutMethodCode) {
    this.payoutMethodCode = payoutMethodCode;
  }

  public AccountHolderVerificationNotificationContent shareholderCode(String shareholderCode) {
    this.shareholderCode = shareholderCode;
    return this;
  }

  /**
   * The code of the shareholder that has been verified.
   *
   * @return shareholderCode
   */
  @ApiModelProperty(value = "The code of the shareholder that has been verified.")
  @JsonProperty(JSON_PROPERTY_SHAREHOLDER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getShareholderCode() {
    return shareholderCode;
  }

  @JsonProperty(JSON_PROPERTY_SHAREHOLDER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShareholderCode(String shareholderCode) {
    this.shareholderCode = shareholderCode;
  }

  public AccountHolderVerificationNotificationContent signatoryCode(String signatoryCode) {
    this.signatoryCode = signatoryCode;
    return this;
  }

  /**
   * The code of the signatory that has been verified.
   *
   * @return signatoryCode
   */
  @ApiModelProperty(value = "The code of the signatory that has been verified.")
  @JsonProperty(JSON_PROPERTY_SIGNATORY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getSignatoryCode() {
    return signatoryCode;
  }

  @JsonProperty(JSON_PROPERTY_SIGNATORY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSignatoryCode(String signatoryCode) {
    this.signatoryCode = signatoryCode;
  }

  /** Return true if this AccountHolderVerificationNotificationContent object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AccountHolderVerificationNotificationContent accountHolderVerificationNotificationContent =
        (AccountHolderVerificationNotificationContent) o;
    return Objects.equals(
            this.accountHolderCode, accountHolderVerificationNotificationContent.accountHolderCode)
        && Objects.equals(
            this.kycCheckStatusData,
            accountHolderVerificationNotificationContent.kycCheckStatusData)
        && Objects.equals(
            this.legalArrangementCode,
            accountHolderVerificationNotificationContent.legalArrangementCode)
        && Objects.equals(
            this.legalArrangementEntityCode,
            accountHolderVerificationNotificationContent.legalArrangementEntityCode)
        && Objects.equals(
            this.payoutMethodCode, accountHolderVerificationNotificationContent.payoutMethodCode)
        && Objects.equals(
            this.shareholderCode, accountHolderVerificationNotificationContent.shareholderCode)
        && Objects.equals(
            this.signatoryCode, accountHolderVerificationNotificationContent.signatoryCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        accountHolderCode,
        kycCheckStatusData,
        legalArrangementCode,
        legalArrangementEntityCode,
        payoutMethodCode,
        shareholderCode,
        signatoryCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AccountHolderVerificationNotificationContent {\n");
    sb.append("    accountHolderCode: ").append(toIndentedString(accountHolderCode)).append("\n");
    sb.append("    kycCheckStatusData: ").append(toIndentedString(kycCheckStatusData)).append("\n");
    sb.append("    legalArrangementCode: ")
        .append(toIndentedString(legalArrangementCode))
        .append("\n");
    sb.append("    legalArrangementEntityCode: ")
        .append(toIndentedString(legalArrangementEntityCode))
        .append("\n");
    sb.append("    payoutMethodCode: ").append(toIndentedString(payoutMethodCode)).append("\n");
    sb.append("    shareholderCode: ").append(toIndentedString(shareholderCode)).append("\n");
    sb.append("    signatoryCode: ").append(toIndentedString(signatoryCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of AccountHolderVerificationNotificationContent given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of AccountHolderVerificationNotificationContent
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     AccountHolderVerificationNotificationContent
   */
  public static AccountHolderVerificationNotificationContent fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper()
        .readValue(jsonString, AccountHolderVerificationNotificationContent.class);
  }

  /**
   * Convert an instance of AccountHolderVerificationNotificationContent to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
