/*
 * Adyen Payout API
 *
 * The version of the OpenAPI document: 68
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.payout;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/** PayoutResponse */
@JsonPropertyOrder({
  PayoutResponse.JSON_PROPERTY_ADDITIONAL_DATA,
  PayoutResponse.JSON_PROPERTY_AUTH_CODE,
  PayoutResponse.JSON_PROPERTY_DCC_AMOUNT,
  PayoutResponse.JSON_PROPERTY_DCC_SIGNATURE,
  PayoutResponse.JSON_PROPERTY_FRAUD_RESULT,
  PayoutResponse.JSON_PROPERTY_ISSUER_URL,
  PayoutResponse.JSON_PROPERTY_MD,
  PayoutResponse.JSON_PROPERTY_PA_REQUEST,
  PayoutResponse.JSON_PROPERTY_PSP_REFERENCE,
  PayoutResponse.JSON_PROPERTY_REFUSAL_REASON,
  PayoutResponse.JSON_PROPERTY_RESULT_CODE
})
public class PayoutResponse {
  public static final String JSON_PROPERTY_ADDITIONAL_DATA = "additionalData";
  private Map<String, String> additionalData;

  public static final String JSON_PROPERTY_AUTH_CODE = "authCode";
  private String authCode;

  public static final String JSON_PROPERTY_DCC_AMOUNT = "dccAmount";
  private Amount dccAmount;

  public static final String JSON_PROPERTY_DCC_SIGNATURE = "dccSignature";
  private String dccSignature;

  public static final String JSON_PROPERTY_FRAUD_RESULT = "fraudResult";
  private FraudResult fraudResult;

  public static final String JSON_PROPERTY_ISSUER_URL = "issuerUrl";
  private String issuerUrl;

  public static final String JSON_PROPERTY_MD = "md";
  private String md;

  public static final String JSON_PROPERTY_PA_REQUEST = "paRequest";
  private String paRequest;

  public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
  private String pspReference;

  public static final String JSON_PROPERTY_REFUSAL_REASON = "refusalReason";
  private String refusalReason;

  /**
   * The result of the payment. For more information, see [Result
   * codes](https://docs.adyen.com/online-payments/payment-result-codes). Possible values: *
   * **AuthenticationFinished** – The payment has been successfully authenticated with 3D Secure 2.
   * Returned for 3D Secure 2 authentication-only transactions. * **AuthenticationNotRequired** –
   * The transaction does not require 3D Secure authentication. Returned for [standalone
   * authentication-only
   * integrations](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only).
   * * **Authorised** – The payment was successfully authorised. This state serves as an indicator
   * to proceed with the delivery of goods and services. This is a final state. * **Cancelled** –
   * Indicates the payment has been cancelled (either by the shopper or the merchant) before
   * processing was completed. This is a final state. * **ChallengeShopper** – The issuer requires
   * further shopper interaction before the payment can be authenticated. Returned for 3D Secure 2
   * transactions. * **Error** – There was an error when the payment was being processed. The reason
   * is given in the &#x60;refusalReason&#x60; field. This is a final state. * **IdentifyShopper** –
   * The issuer requires the shopper&#39;s device fingerprint before the payment can be
   * authenticated. Returned for 3D Secure 2 transactions. * **PartiallyAuthorised** – The payment
   * has been authorised for a partial amount. This happens for card payments when the merchant
   * supports Partial Authorisations and the cardholder has insufficient funds. * **Pending** –
   * Indicates that it is not possible to obtain the final status of the payment. This can happen if
   * the systems providing final status information for the payment are unavailable, or if the
   * shopper needs to take further action to complete the payment. * **PresentToShopper** –
   * Indicates that the response contains additional information that you need to present to a
   * shopper, so that they can use it to complete a payment. * **Received** – Indicates the payment
   * has successfully been received by Adyen, and will be processed. This is the initial state for
   * all payments. * **RedirectShopper** – Indicates the shopper should be redirected to an external
   * web page or app to complete the authorisation. * **Refused** – Indicates the payment was
   * refused. The reason is given in the &#x60;refusalReason&#x60; field. This is a final state.
   */
  public enum ResultCodeEnum {
    AUTHENTICATIONFINISHED(String.valueOf("AuthenticationFinished")),

    AUTHENTICATIONNOTREQUIRED(String.valueOf("AuthenticationNotRequired")),

    AUTHORISED(String.valueOf("Authorised")),

    CANCELLED(String.valueOf("Cancelled")),

    CHALLENGESHOPPER(String.valueOf("ChallengeShopper")),

    ERROR(String.valueOf("Error")),

    IDENTIFYSHOPPER(String.valueOf("IdentifyShopper")),

    PARTIALLYAUTHORISED(String.valueOf("PartiallyAuthorised")),

    PENDING(String.valueOf("Pending")),

    PRESENTTOSHOPPER(String.valueOf("PresentToShopper")),

    RECEIVED(String.valueOf("Received")),

    REDIRECTSHOPPER(String.valueOf("RedirectShopper")),

    REFUSED(String.valueOf("Refused")),

    SUCCESS(String.valueOf("Success"));

    private String value;

    ResultCodeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ResultCodeEnum fromValue(String value) {
      for (ResultCodeEnum b : ResultCodeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_RESULT_CODE = "resultCode";
  private ResultCodeEnum resultCode;

  public PayoutResponse() {}

  /**
   * Contains additional information about the payment. Some data fields are included only if you
   * select them first: Go to **Customer Area** &gt; **Developers** &gt; **Additional data**.
   *
   * @param additionalData Contains additional information about the payment. Some data fields are
   *     included only if you select them first: Go to **Customer Area** &gt; **Developers** &gt;
   *     **Additional data**.
   * @return the current {@code PayoutResponse} instance, allowing for method chaining
   */
  public PayoutResponse additionalData(Map<String, String> additionalData) {
    this.additionalData = additionalData;
    return this;
  }

  public PayoutResponse putAdditionalDataItem(String key, String additionalDataItem) {
    if (this.additionalData == null) {
      this.additionalData = new HashMap<>();
    }
    this.additionalData.put(key, additionalDataItem);
    return this;
  }

  /**
   * Contains additional information about the payment. Some data fields are included only if you
   * select them first: Go to **Customer Area** &gt; **Developers** &gt; **Additional data**.
   *
   * @return additionalData Contains additional information about the payment. Some data fields are
   *     included only if you select them first: Go to **Customer Area** &gt; **Developers** &gt;
   *     **Additional data**.
   */
  @JsonProperty(JSON_PROPERTY_ADDITIONAL_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Map<String, String> getAdditionalData() {
    return additionalData;
  }

  /**
   * Contains additional information about the payment. Some data fields are included only if you
   * select them first: Go to **Customer Area** &gt; **Developers** &gt; **Additional data**.
   *
   * @param additionalData Contains additional information about the payment. Some data fields are
   *     included only if you select them first: Go to **Customer Area** &gt; **Developers** &gt;
   *     **Additional data**.
   */
  @JsonProperty(JSON_PROPERTY_ADDITIONAL_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdditionalData(Map<String, String> additionalData) {
    this.additionalData = additionalData;
  }

  /**
   * Authorisation code: * When the payment is authorised successfully, this field holds the
   * authorisation code for the payment. * When the payment is not authorised, this field is empty.
   *
   * @param authCode Authorisation code: * When the payment is authorised successfully, this field
   *     holds the authorisation code for the payment. * When the payment is not authorised, this
   *     field is empty.
   * @return the current {@code PayoutResponse} instance, allowing for method chaining
   */
  public PayoutResponse authCode(String authCode) {
    this.authCode = authCode;
    return this;
  }

  /**
   * Authorisation code: * When the payment is authorised successfully, this field holds the
   * authorisation code for the payment. * When the payment is not authorised, this field is empty.
   *
   * @return authCode Authorisation code: * When the payment is authorised successfully, this field
   *     holds the authorisation code for the payment. * When the payment is not authorised, this
   *     field is empty.
   */
  @JsonProperty(JSON_PROPERTY_AUTH_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAuthCode() {
    return authCode;
  }

  /**
   * Authorisation code: * When the payment is authorised successfully, this field holds the
   * authorisation code for the payment. * When the payment is not authorised, this field is empty.
   *
   * @param authCode Authorisation code: * When the payment is authorised successfully, this field
   *     holds the authorisation code for the payment. * When the payment is not authorised, this
   *     field is empty.
   */
  @JsonProperty(JSON_PROPERTY_AUTH_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAuthCode(String authCode) {
    this.authCode = authCode;
  }

  /**
   * dccAmount
   *
   * @param dccAmount
   * @return the current {@code PayoutResponse} instance, allowing for method chaining
   */
  public PayoutResponse dccAmount(Amount dccAmount) {
    this.dccAmount = dccAmount;
    return this;
  }

  /**
   * Get dccAmount
   *
   * @return dccAmount
   */
  @JsonProperty(JSON_PROPERTY_DCC_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Amount getDccAmount() {
    return dccAmount;
  }

  /**
   * dccAmount
   *
   * @param dccAmount
   */
  @JsonProperty(JSON_PROPERTY_DCC_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDccAmount(Amount dccAmount) {
    this.dccAmount = dccAmount;
  }

  /**
   * Cryptographic signature used to verify &#x60;dccQuote&#x60;. &gt; This value only applies if
   * you have implemented Dynamic Currency Conversion. For more information, [contact
   * Support](https://www.adyen.help/hc/en-us/requests/new).
   *
   * @param dccSignature Cryptographic signature used to verify &#x60;dccQuote&#x60;. &gt; This
   *     value only applies if you have implemented Dynamic Currency Conversion. For more
   *     information, [contact Support](https://www.adyen.help/hc/en-us/requests/new).
   * @return the current {@code PayoutResponse} instance, allowing for method chaining
   */
  public PayoutResponse dccSignature(String dccSignature) {
    this.dccSignature = dccSignature;
    return this;
  }

  /**
   * Cryptographic signature used to verify &#x60;dccQuote&#x60;. &gt; This value only applies if
   * you have implemented Dynamic Currency Conversion. For more information, [contact
   * Support](https://www.adyen.help/hc/en-us/requests/new).
   *
   * @return dccSignature Cryptographic signature used to verify &#x60;dccQuote&#x60;. &gt; This
   *     value only applies if you have implemented Dynamic Currency Conversion. For more
   *     information, [contact Support](https://www.adyen.help/hc/en-us/requests/new).
   */
  @JsonProperty(JSON_PROPERTY_DCC_SIGNATURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDccSignature() {
    return dccSignature;
  }

  /**
   * Cryptographic signature used to verify &#x60;dccQuote&#x60;. &gt; This value only applies if
   * you have implemented Dynamic Currency Conversion. For more information, [contact
   * Support](https://www.adyen.help/hc/en-us/requests/new).
   *
   * @param dccSignature Cryptographic signature used to verify &#x60;dccQuote&#x60;. &gt; This
   *     value only applies if you have implemented Dynamic Currency Conversion. For more
   *     information, [contact Support](https://www.adyen.help/hc/en-us/requests/new).
   */
  @JsonProperty(JSON_PROPERTY_DCC_SIGNATURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDccSignature(String dccSignature) {
    this.dccSignature = dccSignature;
  }

  /**
   * fraudResult
   *
   * @param fraudResult
   * @return the current {@code PayoutResponse} instance, allowing for method chaining
   */
  public PayoutResponse fraudResult(FraudResult fraudResult) {
    this.fraudResult = fraudResult;
    return this;
  }

  /**
   * Get fraudResult
   *
   * @return fraudResult
   */
  @JsonProperty(JSON_PROPERTY_FRAUD_RESULT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public FraudResult getFraudResult() {
    return fraudResult;
  }

  /**
   * fraudResult
   *
   * @param fraudResult
   */
  @JsonProperty(JSON_PROPERTY_FRAUD_RESULT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFraudResult(FraudResult fraudResult) {
    this.fraudResult = fraudResult;
  }

  /**
   * The URL to direct the shopper to. &gt; In case of SecurePlus, do not redirect a shopper to this
   * URL.
   *
   * @param issuerUrl The URL to direct the shopper to. &gt; In case of SecurePlus, do not redirect
   *     a shopper to this URL.
   * @return the current {@code PayoutResponse} instance, allowing for method chaining
   */
  public PayoutResponse issuerUrl(String issuerUrl) {
    this.issuerUrl = issuerUrl;
    return this;
  }

  /**
   * The URL to direct the shopper to. &gt; In case of SecurePlus, do not redirect a shopper to this
   * URL.
   *
   * @return issuerUrl The URL to direct the shopper to. &gt; In case of SecurePlus, do not redirect
   *     a shopper to this URL.
   */
  @JsonProperty(JSON_PROPERTY_ISSUER_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getIssuerUrl() {
    return issuerUrl;
  }

  /**
   * The URL to direct the shopper to. &gt; In case of SecurePlus, do not redirect a shopper to this
   * URL.
   *
   * @param issuerUrl The URL to direct the shopper to. &gt; In case of SecurePlus, do not redirect
   *     a shopper to this URL.
   */
  @JsonProperty(JSON_PROPERTY_ISSUER_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIssuerUrl(String issuerUrl) {
    this.issuerUrl = issuerUrl;
  }

  /**
   * The payment session.
   *
   * @param md The payment session.
   * @return the current {@code PayoutResponse} instance, allowing for method chaining
   */
  public PayoutResponse md(String md) {
    this.md = md;
    return this;
  }

  /**
   * The payment session.
   *
   * @return md The payment session.
   */
  @JsonProperty(JSON_PROPERTY_MD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMd() {
    return md;
  }

  /**
   * The payment session.
   *
   * @param md The payment session.
   */
  @JsonProperty(JSON_PROPERTY_MD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMd(String md) {
    this.md = md;
  }

  /**
   * The 3D request data for the issuer. If the value is
   * **CUPSecurePlus-CollectSMSVerificationCode**, collect an SMS code from the shopper and pass it
   * in the &#x60;/authorise3D&#x60; request. For more information, see [3D
   * Secure](https://docs.adyen.com/classic-integration/3d-secure).
   *
   * @param paRequest The 3D request data for the issuer. If the value is
   *     **CUPSecurePlus-CollectSMSVerificationCode**, collect an SMS code from the shopper and pass
   *     it in the &#x60;/authorise3D&#x60; request. For more information, see [3D
   *     Secure](https://docs.adyen.com/classic-integration/3d-secure).
   * @return the current {@code PayoutResponse} instance, allowing for method chaining
   */
  public PayoutResponse paRequest(String paRequest) {
    this.paRequest = paRequest;
    return this;
  }

  /**
   * The 3D request data for the issuer. If the value is
   * **CUPSecurePlus-CollectSMSVerificationCode**, collect an SMS code from the shopper and pass it
   * in the &#x60;/authorise3D&#x60; request. For more information, see [3D
   * Secure](https://docs.adyen.com/classic-integration/3d-secure).
   *
   * @return paRequest The 3D request data for the issuer. If the value is
   *     **CUPSecurePlus-CollectSMSVerificationCode**, collect an SMS code from the shopper and pass
   *     it in the &#x60;/authorise3D&#x60; request. For more information, see [3D
   *     Secure](https://docs.adyen.com/classic-integration/3d-secure).
   */
  @JsonProperty(JSON_PROPERTY_PA_REQUEST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPaRequest() {
    return paRequest;
  }

  /**
   * The 3D request data for the issuer. If the value is
   * **CUPSecurePlus-CollectSMSVerificationCode**, collect an SMS code from the shopper and pass it
   * in the &#x60;/authorise3D&#x60; request. For more information, see [3D
   * Secure](https://docs.adyen.com/classic-integration/3d-secure).
   *
   * @param paRequest The 3D request data for the issuer. If the value is
   *     **CUPSecurePlus-CollectSMSVerificationCode**, collect an SMS code from the shopper and pass
   *     it in the &#x60;/authorise3D&#x60; request. For more information, see [3D
   *     Secure](https://docs.adyen.com/classic-integration/3d-secure).
   */
  @JsonProperty(JSON_PROPERTY_PA_REQUEST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaRequest(String paRequest) {
    this.paRequest = paRequest;
  }

  /**
   * Adyen&#39;s 16-character reference associated with the transaction/request. This value is
   * globally unique; quote it when communicating with us about this request.
   *
   * @param pspReference Adyen&#39;s 16-character reference associated with the transaction/request.
   *     This value is globally unique; quote it when communicating with us about this request.
   * @return the current {@code PayoutResponse} instance, allowing for method chaining
   */
  public PayoutResponse pspReference(String pspReference) {
    this.pspReference = pspReference;
    return this;
  }

  /**
   * Adyen&#39;s 16-character reference associated with the transaction/request. This value is
   * globally unique; quote it when communicating with us about this request.
   *
   * @return pspReference Adyen&#39;s 16-character reference associated with the
   *     transaction/request. This value is globally unique; quote it when communicating with us
   *     about this request.
   */
  @JsonProperty(JSON_PROPERTY_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPspReference() {
    return pspReference;
  }

  /**
   * Adyen&#39;s 16-character reference associated with the transaction/request. This value is
   * globally unique; quote it when communicating with us about this request.
   *
   * @param pspReference Adyen&#39;s 16-character reference associated with the transaction/request.
   *     This value is globally unique; quote it when communicating with us about this request.
   */
  @JsonProperty(JSON_PROPERTY_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPspReference(String pspReference) {
    this.pspReference = pspReference;
  }

  /**
   * If the payment&#39;s authorisation is refused or an error occurs during authorisation, this
   * field holds Adyen&#39;s mapped reason for the refusal or a description of the error. When a
   * transaction fails, the authorisation response includes &#x60;resultCode&#x60; and
   * &#x60;refusalReason&#x60; values. For more information, see [Refusal
   * reasons](https://docs.adyen.com/development-resources/refusal-reasons).
   *
   * @param refusalReason If the payment&#39;s authorisation is refused or an error occurs during
   *     authorisation, this field holds Adyen&#39;s mapped reason for the refusal or a description
   *     of the error. When a transaction fails, the authorisation response includes
   *     &#x60;resultCode&#x60; and &#x60;refusalReason&#x60; values. For more information, see
   *     [Refusal reasons](https://docs.adyen.com/development-resources/refusal-reasons).
   * @return the current {@code PayoutResponse} instance, allowing for method chaining
   */
  public PayoutResponse refusalReason(String refusalReason) {
    this.refusalReason = refusalReason;
    return this;
  }

  /**
   * If the payment&#39;s authorisation is refused or an error occurs during authorisation, this
   * field holds Adyen&#39;s mapped reason for the refusal or a description of the error. When a
   * transaction fails, the authorisation response includes &#x60;resultCode&#x60; and
   * &#x60;refusalReason&#x60; values. For more information, see [Refusal
   * reasons](https://docs.adyen.com/development-resources/refusal-reasons).
   *
   * @return refusalReason If the payment&#39;s authorisation is refused or an error occurs during
   *     authorisation, this field holds Adyen&#39;s mapped reason for the refusal or a description
   *     of the error. When a transaction fails, the authorisation response includes
   *     &#x60;resultCode&#x60; and &#x60;refusalReason&#x60; values. For more information, see
   *     [Refusal reasons](https://docs.adyen.com/development-resources/refusal-reasons).
   */
  @JsonProperty(JSON_PROPERTY_REFUSAL_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getRefusalReason() {
    return refusalReason;
  }

  /**
   * If the payment&#39;s authorisation is refused or an error occurs during authorisation, this
   * field holds Adyen&#39;s mapped reason for the refusal or a description of the error. When a
   * transaction fails, the authorisation response includes &#x60;resultCode&#x60; and
   * &#x60;refusalReason&#x60; values. For more information, see [Refusal
   * reasons](https://docs.adyen.com/development-resources/refusal-reasons).
   *
   * @param refusalReason If the payment&#39;s authorisation is refused or an error occurs during
   *     authorisation, this field holds Adyen&#39;s mapped reason for the refusal or a description
   *     of the error. When a transaction fails, the authorisation response includes
   *     &#x60;resultCode&#x60; and &#x60;refusalReason&#x60; values. For more information, see
   *     [Refusal reasons](https://docs.adyen.com/development-resources/refusal-reasons).
   */
  @JsonProperty(JSON_PROPERTY_REFUSAL_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefusalReason(String refusalReason) {
    this.refusalReason = refusalReason;
  }

  /**
   * The result of the payment. For more information, see [Result
   * codes](https://docs.adyen.com/online-payments/payment-result-codes). Possible values: *
   * **AuthenticationFinished** – The payment has been successfully authenticated with 3D Secure 2.
   * Returned for 3D Secure 2 authentication-only transactions. * **AuthenticationNotRequired** –
   * The transaction does not require 3D Secure authentication. Returned for [standalone
   * authentication-only
   * integrations](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only).
   * * **Authorised** – The payment was successfully authorised. This state serves as an indicator
   * to proceed with the delivery of goods and services. This is a final state. * **Cancelled** –
   * Indicates the payment has been cancelled (either by the shopper or the merchant) before
   * processing was completed. This is a final state. * **ChallengeShopper** – The issuer requires
   * further shopper interaction before the payment can be authenticated. Returned for 3D Secure 2
   * transactions. * **Error** – There was an error when the payment was being processed. The reason
   * is given in the &#x60;refusalReason&#x60; field. This is a final state. * **IdentifyShopper** –
   * The issuer requires the shopper&#39;s device fingerprint before the payment can be
   * authenticated. Returned for 3D Secure 2 transactions. * **PartiallyAuthorised** – The payment
   * has been authorised for a partial amount. This happens for card payments when the merchant
   * supports Partial Authorisations and the cardholder has insufficient funds. * **Pending** –
   * Indicates that it is not possible to obtain the final status of the payment. This can happen if
   * the systems providing final status information for the payment are unavailable, or if the
   * shopper needs to take further action to complete the payment. * **PresentToShopper** –
   * Indicates that the response contains additional information that you need to present to a
   * shopper, so that they can use it to complete a payment. * **Received** – Indicates the payment
   * has successfully been received by Adyen, and will be processed. This is the initial state for
   * all payments. * **RedirectShopper** – Indicates the shopper should be redirected to an external
   * web page or app to complete the authorisation. * **Refused** – Indicates the payment was
   * refused. The reason is given in the &#x60;refusalReason&#x60; field. This is a final state.
   *
   * @param resultCode The result of the payment. For more information, see [Result
   *     codes](https://docs.adyen.com/online-payments/payment-result-codes). Possible values: *
   *     **AuthenticationFinished** – The payment has been successfully authenticated with 3D Secure
   *     2. Returned for 3D Secure 2 authentication-only transactions. *
   *     **AuthenticationNotRequired** – The transaction does not require 3D Secure authentication.
   *     Returned for [standalone authentication-only
   *     integrations](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only).
   *     * **Authorised** – The payment was successfully authorised. This state serves as an
   *     indicator to proceed with the delivery of goods and services. This is a final state. *
   *     **Cancelled** – Indicates the payment has been cancelled (either by the shopper or the
   *     merchant) before processing was completed. This is a final state. * **ChallengeShopper** –
   *     The issuer requires further shopper interaction before the payment can be authenticated.
   *     Returned for 3D Secure 2 transactions. * **Error** – There was an error when the payment
   *     was being processed. The reason is given in the &#x60;refusalReason&#x60; field. This is a
   *     final state. * **IdentifyShopper** – The issuer requires the shopper&#39;s device
   *     fingerprint before the payment can be authenticated. Returned for 3D Secure 2 transactions.
   *     * **PartiallyAuthorised** – The payment has been authorised for a partial amount. This
   *     happens for card payments when the merchant supports Partial Authorisations and the
   *     cardholder has insufficient funds. * **Pending** – Indicates that it is not possible to
   *     obtain the final status of the payment. This can happen if the systems providing final
   *     status information for the payment are unavailable, or if the shopper needs to take further
   *     action to complete the payment. * **PresentToShopper** – Indicates that the response
   *     contains additional information that you need to present to a shopper, so that they can use
   *     it to complete a payment. * **Received** – Indicates the payment has successfully been
   *     received by Adyen, and will be processed. This is the initial state for all payments. *
   *     **RedirectShopper** – Indicates the shopper should be redirected to an external web page or
   *     app to complete the authorisation. * **Refused** – Indicates the payment was refused. The
   *     reason is given in the &#x60;refusalReason&#x60; field. This is a final state.
   * @return the current {@code PayoutResponse} instance, allowing for method chaining
   */
  public PayoutResponse resultCode(ResultCodeEnum resultCode) {
    this.resultCode = resultCode;
    return this;
  }

  /**
   * The result of the payment. For more information, see [Result
   * codes](https://docs.adyen.com/online-payments/payment-result-codes). Possible values: *
   * **AuthenticationFinished** – The payment has been successfully authenticated with 3D Secure 2.
   * Returned for 3D Secure 2 authentication-only transactions. * **AuthenticationNotRequired** –
   * The transaction does not require 3D Secure authentication. Returned for [standalone
   * authentication-only
   * integrations](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only).
   * * **Authorised** – The payment was successfully authorised. This state serves as an indicator
   * to proceed with the delivery of goods and services. This is a final state. * **Cancelled** –
   * Indicates the payment has been cancelled (either by the shopper or the merchant) before
   * processing was completed. This is a final state. * **ChallengeShopper** – The issuer requires
   * further shopper interaction before the payment can be authenticated. Returned for 3D Secure 2
   * transactions. * **Error** – There was an error when the payment was being processed. The reason
   * is given in the &#x60;refusalReason&#x60; field. This is a final state. * **IdentifyShopper** –
   * The issuer requires the shopper&#39;s device fingerprint before the payment can be
   * authenticated. Returned for 3D Secure 2 transactions. * **PartiallyAuthorised** – The payment
   * has been authorised for a partial amount. This happens for card payments when the merchant
   * supports Partial Authorisations and the cardholder has insufficient funds. * **Pending** –
   * Indicates that it is not possible to obtain the final status of the payment. This can happen if
   * the systems providing final status information for the payment are unavailable, or if the
   * shopper needs to take further action to complete the payment. * **PresentToShopper** –
   * Indicates that the response contains additional information that you need to present to a
   * shopper, so that they can use it to complete a payment. * **Received** – Indicates the payment
   * has successfully been received by Adyen, and will be processed. This is the initial state for
   * all payments. * **RedirectShopper** – Indicates the shopper should be redirected to an external
   * web page or app to complete the authorisation. * **Refused** – Indicates the payment was
   * refused. The reason is given in the &#x60;refusalReason&#x60; field. This is a final state.
   *
   * @return resultCode The result of the payment. For more information, see [Result
   *     codes](https://docs.adyen.com/online-payments/payment-result-codes). Possible values: *
   *     **AuthenticationFinished** – The payment has been successfully authenticated with 3D Secure
   *     2. Returned for 3D Secure 2 authentication-only transactions. *
   *     **AuthenticationNotRequired** – The transaction does not require 3D Secure authentication.
   *     Returned for [standalone authentication-only
   *     integrations](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only).
   *     * **Authorised** – The payment was successfully authorised. This state serves as an
   *     indicator to proceed with the delivery of goods and services. This is a final state. *
   *     **Cancelled** – Indicates the payment has been cancelled (either by the shopper or the
   *     merchant) before processing was completed. This is a final state. * **ChallengeShopper** –
   *     The issuer requires further shopper interaction before the payment can be authenticated.
   *     Returned for 3D Secure 2 transactions. * **Error** – There was an error when the payment
   *     was being processed. The reason is given in the &#x60;refusalReason&#x60; field. This is a
   *     final state. * **IdentifyShopper** – The issuer requires the shopper&#39;s device
   *     fingerprint before the payment can be authenticated. Returned for 3D Secure 2 transactions.
   *     * **PartiallyAuthorised** – The payment has been authorised for a partial amount. This
   *     happens for card payments when the merchant supports Partial Authorisations and the
   *     cardholder has insufficient funds. * **Pending** – Indicates that it is not possible to
   *     obtain the final status of the payment. This can happen if the systems providing final
   *     status information for the payment are unavailable, or if the shopper needs to take further
   *     action to complete the payment. * **PresentToShopper** – Indicates that the response
   *     contains additional information that you need to present to a shopper, so that they can use
   *     it to complete a payment. * **Received** – Indicates the payment has successfully been
   *     received by Adyen, and will be processed. This is the initial state for all payments. *
   *     **RedirectShopper** – Indicates the shopper should be redirected to an external web page or
   *     app to complete the authorisation. * **Refused** – Indicates the payment was refused. The
   *     reason is given in the &#x60;refusalReason&#x60; field. This is a final state.
   */
  @JsonProperty(JSON_PROPERTY_RESULT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ResultCodeEnum getResultCode() {
    return resultCode;
  }

  /**
   * The result of the payment. For more information, see [Result
   * codes](https://docs.adyen.com/online-payments/payment-result-codes). Possible values: *
   * **AuthenticationFinished** – The payment has been successfully authenticated with 3D Secure 2.
   * Returned for 3D Secure 2 authentication-only transactions. * **AuthenticationNotRequired** –
   * The transaction does not require 3D Secure authentication. Returned for [standalone
   * authentication-only
   * integrations](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only).
   * * **Authorised** – The payment was successfully authorised. This state serves as an indicator
   * to proceed with the delivery of goods and services. This is a final state. * **Cancelled** –
   * Indicates the payment has been cancelled (either by the shopper or the merchant) before
   * processing was completed. This is a final state. * **ChallengeShopper** – The issuer requires
   * further shopper interaction before the payment can be authenticated. Returned for 3D Secure 2
   * transactions. * **Error** – There was an error when the payment was being processed. The reason
   * is given in the &#x60;refusalReason&#x60; field. This is a final state. * **IdentifyShopper** –
   * The issuer requires the shopper&#39;s device fingerprint before the payment can be
   * authenticated. Returned for 3D Secure 2 transactions. * **PartiallyAuthorised** – The payment
   * has been authorised for a partial amount. This happens for card payments when the merchant
   * supports Partial Authorisations and the cardholder has insufficient funds. * **Pending** –
   * Indicates that it is not possible to obtain the final status of the payment. This can happen if
   * the systems providing final status information for the payment are unavailable, or if the
   * shopper needs to take further action to complete the payment. * **PresentToShopper** –
   * Indicates that the response contains additional information that you need to present to a
   * shopper, so that they can use it to complete a payment. * **Received** – Indicates the payment
   * has successfully been received by Adyen, and will be processed. This is the initial state for
   * all payments. * **RedirectShopper** – Indicates the shopper should be redirected to an external
   * web page or app to complete the authorisation. * **Refused** – Indicates the payment was
   * refused. The reason is given in the &#x60;refusalReason&#x60; field. This is a final state.
   *
   * @param resultCode The result of the payment. For more information, see [Result
   *     codes](https://docs.adyen.com/online-payments/payment-result-codes). Possible values: *
   *     **AuthenticationFinished** – The payment has been successfully authenticated with 3D Secure
   *     2. Returned for 3D Secure 2 authentication-only transactions. *
   *     **AuthenticationNotRequired** – The transaction does not require 3D Secure authentication.
   *     Returned for [standalone authentication-only
   *     integrations](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only).
   *     * **Authorised** – The payment was successfully authorised. This state serves as an
   *     indicator to proceed with the delivery of goods and services. This is a final state. *
   *     **Cancelled** – Indicates the payment has been cancelled (either by the shopper or the
   *     merchant) before processing was completed. This is a final state. * **ChallengeShopper** –
   *     The issuer requires further shopper interaction before the payment can be authenticated.
   *     Returned for 3D Secure 2 transactions. * **Error** – There was an error when the payment
   *     was being processed. The reason is given in the &#x60;refusalReason&#x60; field. This is a
   *     final state. * **IdentifyShopper** – The issuer requires the shopper&#39;s device
   *     fingerprint before the payment can be authenticated. Returned for 3D Secure 2 transactions.
   *     * **PartiallyAuthorised** – The payment has been authorised for a partial amount. This
   *     happens for card payments when the merchant supports Partial Authorisations and the
   *     cardholder has insufficient funds. * **Pending** – Indicates that it is not possible to
   *     obtain the final status of the payment. This can happen if the systems providing final
   *     status information for the payment are unavailable, or if the shopper needs to take further
   *     action to complete the payment. * **PresentToShopper** – Indicates that the response
   *     contains additional information that you need to present to a shopper, so that they can use
   *     it to complete a payment. * **Received** – Indicates the payment has successfully been
   *     received by Adyen, and will be processed. This is the initial state for all payments. *
   *     **RedirectShopper** – Indicates the shopper should be redirected to an external web page or
   *     app to complete the authorisation. * **Refused** – Indicates the payment was refused. The
   *     reason is given in the &#x60;refusalReason&#x60; field. This is a final state.
   */
  @JsonProperty(JSON_PROPERTY_RESULT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResultCode(ResultCodeEnum resultCode) {
    this.resultCode = resultCode;
  }

  /** Return true if this PayoutResponse object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PayoutResponse payoutResponse = (PayoutResponse) o;
    return Objects.equals(this.additionalData, payoutResponse.additionalData)
        && Objects.equals(this.authCode, payoutResponse.authCode)
        && Objects.equals(this.dccAmount, payoutResponse.dccAmount)
        && Objects.equals(this.dccSignature, payoutResponse.dccSignature)
        && Objects.equals(this.fraudResult, payoutResponse.fraudResult)
        && Objects.equals(this.issuerUrl, payoutResponse.issuerUrl)
        && Objects.equals(this.md, payoutResponse.md)
        && Objects.equals(this.paRequest, payoutResponse.paRequest)
        && Objects.equals(this.pspReference, payoutResponse.pspReference)
        && Objects.equals(this.refusalReason, payoutResponse.refusalReason)
        && Objects.equals(this.resultCode, payoutResponse.resultCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        additionalData,
        authCode,
        dccAmount,
        dccSignature,
        fraudResult,
        issuerUrl,
        md,
        paRequest,
        pspReference,
        refusalReason,
        resultCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PayoutResponse {\n");
    sb.append("    additionalData: ").append(toIndentedString(additionalData)).append("\n");
    sb.append("    authCode: ").append(toIndentedString(authCode)).append("\n");
    sb.append("    dccAmount: ").append(toIndentedString(dccAmount)).append("\n");
    sb.append("    dccSignature: ").append(toIndentedString(dccSignature)).append("\n");
    sb.append("    fraudResult: ").append(toIndentedString(fraudResult)).append("\n");
    sb.append("    issuerUrl: ").append(toIndentedString(issuerUrl)).append("\n");
    sb.append("    md: ").append(toIndentedString(md)).append("\n");
    sb.append("    paRequest: ").append(toIndentedString(paRequest)).append("\n");
    sb.append("    pspReference: ").append(toIndentedString(pspReference)).append("\n");
    sb.append("    refusalReason: ").append(toIndentedString(refusalReason)).append("\n");
    sb.append("    resultCode: ").append(toIndentedString(resultCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of PayoutResponse given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of PayoutResponse
   * @throws JsonProcessingException if the JSON string is invalid with respect to PayoutResponse
   */
  public static PayoutResponse fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, PayoutResponse.class);
  }

  /**
   * Convert an instance of PayoutResponse to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
