/*
 * Report webhooks
 *
 * The version of the OpenAPI document: 1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.reportwebhooks;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.OffsetDateTime;
import java.util.Objects;

/** ReportNotificationRequest */
@JsonPropertyOrder({
  ReportNotificationRequest.JSON_PROPERTY_DATA,
  ReportNotificationRequest.JSON_PROPERTY_ENVIRONMENT,
  ReportNotificationRequest.JSON_PROPERTY_TIMESTAMP,
  ReportNotificationRequest.JSON_PROPERTY_TYPE
})
public class ReportNotificationRequest {
  public static final String JSON_PROPERTY_DATA = "data";
  private ReportNotificationData data;

  public static final String JSON_PROPERTY_ENVIRONMENT = "environment";
  private String environment;

  public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
  private OffsetDateTime timestamp;

  /** Type of webhook. */
  public enum TypeEnum {
    BALANCEPLATFORM_REPORT_CREATED(String.valueOf("balancePlatform.report.created"));

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public ReportNotificationRequest() {}

  /**
   * data
   *
   * @param data
   * @return the current {@code ReportNotificationRequest} instance, allowing for method chaining
   */
  public ReportNotificationRequest data(ReportNotificationData data) {
    this.data = data;
    return this;
  }

  /**
   * Get data
   *
   * @return data
   */
  @JsonProperty(JSON_PROPERTY_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ReportNotificationData getData() {
    return data;
  }

  /**
   * data
   *
   * @param data
   */
  @JsonProperty(JSON_PROPERTY_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setData(ReportNotificationData data) {
    this.data = data;
  }

  /**
   * The environment from which the webhook originated. Possible values: **test**, **live**.
   *
   * @param environment The environment from which the webhook originated. Possible values:
   *     **test**, **live**.
   * @return the current {@code ReportNotificationRequest} instance, allowing for method chaining
   */
  public ReportNotificationRequest environment(String environment) {
    this.environment = environment;
    return this;
  }

  /**
   * The environment from which the webhook originated. Possible values: **test**, **live**.
   *
   * @return environment The environment from which the webhook originated. Possible values:
   *     **test**, **live**.
   */
  @JsonProperty(JSON_PROPERTY_ENVIRONMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getEnvironment() {
    return environment;
  }

  /**
   * The environment from which the webhook originated. Possible values: **test**, **live**.
   *
   * @param environment The environment from which the webhook originated. Possible values:
   *     **test**, **live**.
   */
  @JsonProperty(JSON_PROPERTY_ENVIRONMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEnvironment(String environment) {
    this.environment = environment;
  }

  /**
   * When the event was queued.
   *
   * @param timestamp When the event was queued.
   * @return the current {@code ReportNotificationRequest} instance, allowing for method chaining
   */
  public ReportNotificationRequest timestamp(OffsetDateTime timestamp) {
    this.timestamp = timestamp;
    return this;
  }

  /**
   * When the event was queued.
   *
   * @return timestamp When the event was queued.
   */
  @JsonProperty(JSON_PROPERTY_TIMESTAMP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getTimestamp() {
    return timestamp;
  }

  /**
   * When the event was queued.
   *
   * @param timestamp When the event was queued.
   */
  @JsonProperty(JSON_PROPERTY_TIMESTAMP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimestamp(OffsetDateTime timestamp) {
    this.timestamp = timestamp;
  }

  /**
   * Type of webhook.
   *
   * @param type Type of webhook.
   * @return the current {@code ReportNotificationRequest} instance, allowing for method chaining
   */
  public ReportNotificationRequest type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * Type of webhook.
   *
   * @return type Type of webhook.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * Type of webhook.
   *
   * @param type Type of webhook.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /** Return true if this ReportNotificationRequest object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ReportNotificationRequest reportNotificationRequest = (ReportNotificationRequest) o;
    return Objects.equals(this.data, reportNotificationRequest.data)
        && Objects.equals(this.environment, reportNotificationRequest.environment)
        && Objects.equals(this.timestamp, reportNotificationRequest.timestamp)
        && Objects.equals(this.type, reportNotificationRequest.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(data, environment, timestamp, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ReportNotificationRequest {\n");
    sb.append("    data: ").append(toIndentedString(data)).append("\n");
    sb.append("    environment: ").append(toIndentedString(environment)).append("\n");
    sb.append("    timestamp: ").append(toIndentedString(timestamp)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of ReportNotificationRequest given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of ReportNotificationRequest
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     ReportNotificationRequest
   */
  public static ReportNotificationRequest fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, ReportNotificationRequest.class);
  }

  /**
   * Convert an instance of ReportNotificationRequest to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
