/*
 * Transfers API
 *
 * The version of the OpenAPI document: 4
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.transfers;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** ApproveTransfersRequest */
@JsonPropertyOrder({ApproveTransfersRequest.JSON_PROPERTY_TRANSFER_IDS})
public class ApproveTransfersRequest {
  public static final String JSON_PROPERTY_TRANSFER_IDS = "transferIds";
  private List<String> transferIds;

  public ApproveTransfersRequest() {}

  /**
   * Contains the unique identifiers of the transfers that you want to approve.
   *
   * @param transferIds Contains the unique identifiers of the transfers that you want to approve.
   * @return the current {@code ApproveTransfersRequest} instance, allowing for method chaining
   */
  public ApproveTransfersRequest transferIds(List<String> transferIds) {
    this.transferIds = transferIds;
    return this;
  }

  public ApproveTransfersRequest addTransferIdsItem(String transferIdsItem) {
    if (this.transferIds == null) {
      this.transferIds = new ArrayList<>();
    }
    this.transferIds.add(transferIdsItem);
    return this;
  }

  /**
   * Contains the unique identifiers of the transfers that you want to approve.
   *
   * @return transferIds Contains the unique identifiers of the transfers that you want to approve.
   */
  @JsonProperty(JSON_PROPERTY_TRANSFER_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getTransferIds() {
    return transferIds;
  }

  /**
   * Contains the unique identifiers of the transfers that you want to approve.
   *
   * @param transferIds Contains the unique identifiers of the transfers that you want to approve.
   */
  @JsonProperty(JSON_PROPERTY_TRANSFER_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransferIds(List<String> transferIds) {
    this.transferIds = transferIds;
  }

  /** Return true if this ApproveTransfersRequest object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApproveTransfersRequest approveTransfersRequest = (ApproveTransfersRequest) o;
    return Objects.equals(this.transferIds, approveTransfersRequest.transferIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(transferIds);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApproveTransfersRequest {\n");
    sb.append("    transferIds: ").append(toIndentedString(transferIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of ApproveTransfersRequest given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of ApproveTransfersRequest
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     ApproveTransfersRequest
   */
  public static ApproveTransfersRequest fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, ApproveTransfersRequest.class);
  }

  /**
   * Convert an instance of ApproveTransfersRequest to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
