/*
 * Transfers API
 *
 * The version of the OpenAPI document: 4
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.transfers;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Objects;

/** InternalReviewTrackingData */
@JsonPropertyOrder({
  InternalReviewTrackingData.JSON_PROPERTY_REASON,
  InternalReviewTrackingData.JSON_PROPERTY_STATUS,
  InternalReviewTrackingData.JSON_PROPERTY_TYPE
})
public class InternalReviewTrackingData {
  /**
   * The reason why the transfer failed Adyen&#39;s internal review. Possible values: -
   * **refusedForRegulatoryReasons**: the transfer does not comply with Adyen&#39;s risk policy. For
   * more information, [contact the Support Team](https://www.adyen.help/hc/en-us/requests/new).
   */
  public enum ReasonEnum {
    REFUSEDFORREGULATORYREASONS(String.valueOf("refusedForRegulatoryReasons"));

    private String value;

    ReasonEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ReasonEnum fromValue(String value) {
      for (ReasonEnum b : ReasonEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_REASON = "reason";
  private ReasonEnum reason;

  /**
   * The status of the transfer. Possible values: - **pending**: the transfer is under internal
   * review. - **failed**: the transfer failed Adyen&#39;s internal review. For details, see
   * &#x60;reason&#x60;.
   */
  public enum StatusEnum {
    PENDING(String.valueOf("pending")),

    FAILED(String.valueOf("failed"));

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  /**
   * The type of tracking event. Possible values: - **internalReview**: the transfer was flagged
   * because it does not comply with Adyen&#39;s risk policy.
   */
  public enum TypeEnum {
    INTERNALREVIEW(String.valueOf("internalReview"));

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type = TypeEnum.INTERNALREVIEW;

  public InternalReviewTrackingData() {}

  /**
   * The reason why the transfer failed Adyen&#39;s internal review. Possible values: -
   * **refusedForRegulatoryReasons**: the transfer does not comply with Adyen&#39;s risk policy. For
   * more information, [contact the Support Team](https://www.adyen.help/hc/en-us/requests/new).
   *
   * @param reason The reason why the transfer failed Adyen&#39;s internal review. Possible values:
   *     - **refusedForRegulatoryReasons**: the transfer does not comply with Adyen&#39;s risk
   *     policy. For more information, [contact the Support
   *     Team](https://www.adyen.help/hc/en-us/requests/new).
   * @return the current {@code InternalReviewTrackingData} instance, allowing for method chaining
   */
  public InternalReviewTrackingData reason(ReasonEnum reason) {
    this.reason = reason;
    return this;
  }

  /**
   * The reason why the transfer failed Adyen&#39;s internal review. Possible values: -
   * **refusedForRegulatoryReasons**: the transfer does not comply with Adyen&#39;s risk policy. For
   * more information, [contact the Support Team](https://www.adyen.help/hc/en-us/requests/new).
   *
   * @return reason The reason why the transfer failed Adyen&#39;s internal review. Possible values:
   *     - **refusedForRegulatoryReasons**: the transfer does not comply with Adyen&#39;s risk
   *     policy. For more information, [contact the Support
   *     Team](https://www.adyen.help/hc/en-us/requests/new).
   */
  @JsonProperty(JSON_PROPERTY_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ReasonEnum getReason() {
    return reason;
  }

  /**
   * The reason why the transfer failed Adyen&#39;s internal review. Possible values: -
   * **refusedForRegulatoryReasons**: the transfer does not comply with Adyen&#39;s risk policy. For
   * more information, [contact the Support Team](https://www.adyen.help/hc/en-us/requests/new).
   *
   * @param reason The reason why the transfer failed Adyen&#39;s internal review. Possible values:
   *     - **refusedForRegulatoryReasons**: the transfer does not comply with Adyen&#39;s risk
   *     policy. For more information, [contact the Support
   *     Team](https://www.adyen.help/hc/en-us/requests/new).
   */
  @JsonProperty(JSON_PROPERTY_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReason(ReasonEnum reason) {
    this.reason = reason;
  }

  /**
   * The status of the transfer. Possible values: - **pending**: the transfer is under internal
   * review. - **failed**: the transfer failed Adyen&#39;s internal review. For details, see
   * &#x60;reason&#x60;.
   *
   * @param status The status of the transfer. Possible values: - **pending**: the transfer is under
   *     internal review. - **failed**: the transfer failed Adyen&#39;s internal review. For
   *     details, see &#x60;reason&#x60;.
   * @return the current {@code InternalReviewTrackingData} instance, allowing for method chaining
   */
  public InternalReviewTrackingData status(StatusEnum status) {
    this.status = status;
    return this;
  }

  /**
   * The status of the transfer. Possible values: - **pending**: the transfer is under internal
   * review. - **failed**: the transfer failed Adyen&#39;s internal review. For details, see
   * &#x60;reason&#x60;.
   *
   * @return status The status of the transfer. Possible values: - **pending**: the transfer is
   *     under internal review. - **failed**: the transfer failed Adyen&#39;s internal review. For
   *     details, see &#x60;reason&#x60;.
   */
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StatusEnum getStatus() {
    return status;
  }

  /**
   * The status of the transfer. Possible values: - **pending**: the transfer is under internal
   * review. - **failed**: the transfer failed Adyen&#39;s internal review. For details, see
   * &#x60;reason&#x60;.
   *
   * @param status The status of the transfer. Possible values: - **pending**: the transfer is under
   *     internal review. - **failed**: the transfer failed Adyen&#39;s internal review. For
   *     details, see &#x60;reason&#x60;.
   */
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  /**
   * The type of tracking event. Possible values: - **internalReview**: the transfer was flagged
   * because it does not comply with Adyen&#39;s risk policy.
   *
   * @param type The type of tracking event. Possible values: - **internalReview**: the transfer was
   *     flagged because it does not comply with Adyen&#39;s risk policy.
   * @return the current {@code InternalReviewTrackingData} instance, allowing for method chaining
   */
  public InternalReviewTrackingData type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * The type of tracking event. Possible values: - **internalReview**: the transfer was flagged
   * because it does not comply with Adyen&#39;s risk policy.
   *
   * @return type The type of tracking event. Possible values: - **internalReview**: the transfer
   *     was flagged because it does not comply with Adyen&#39;s risk policy.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * The type of tracking event. Possible values: - **internalReview**: the transfer was flagged
   * because it does not comply with Adyen&#39;s risk policy.
   *
   * @param type The type of tracking event. Possible values: - **internalReview**: the transfer was
   *     flagged because it does not comply with Adyen&#39;s risk policy.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /** Return true if this InternalReviewTrackingData object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InternalReviewTrackingData internalReviewTrackingData = (InternalReviewTrackingData) o;
    return Objects.equals(this.reason, internalReviewTrackingData.reason)
        && Objects.equals(this.status, internalReviewTrackingData.status)
        && Objects.equals(this.type, internalReviewTrackingData.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(reason, status, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InternalReviewTrackingData {\n");
    sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of InternalReviewTrackingData given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of InternalReviewTrackingData
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     InternalReviewTrackingData
   */
  public static InternalReviewTrackingData fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, InternalReviewTrackingData.class);
  }

  /**
   * Convert an instance of InternalReviewTrackingData to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
