/*
 * Transfers API
 *
 * The version of the OpenAPI document: 4
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.transfers;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Objects;

/** TransferReview */
@JsonPropertyOrder({
  TransferReview.JSON_PROPERTY_NUMBER_OF_APPROVALS_REQUIRED,
  TransferReview.JSON_PROPERTY_SCA_ON_APPROVAL
})
public class TransferReview {
  public static final String JSON_PROPERTY_NUMBER_OF_APPROVALS_REQUIRED =
      "numberOfApprovalsRequired";
  private Integer numberOfApprovalsRequired;

  /**
   * Shows the status of the Strong Customer Authentication (SCA) process. Possible values:
   * **required**, **notApplicable**.
   */
  public enum ScaOnApprovalEnum {
    COMPLETED(String.valueOf("completed")),

    NOTAPPLICABLE(String.valueOf("notApplicable")),

    REQUIRED(String.valueOf("required"));

    private String value;

    ScaOnApprovalEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ScaOnApprovalEnum fromValue(String value) {
      for (ScaOnApprovalEnum b : ScaOnApprovalEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SCA_ON_APPROVAL = "scaOnApproval";
  private ScaOnApprovalEnum scaOnApproval;

  public TransferReview() {}

  /**
   * Shows the number of
   * [approvals](https://docs.adyen.com/api-explorer/transfers/latest/post/transfers/approve)
   * required to process the transfer.
   *
   * @param numberOfApprovalsRequired Shows the number of
   *     [approvals](https://docs.adyen.com/api-explorer/transfers/latest/post/transfers/approve)
   *     required to process the transfer.
   * @return the current {@code TransferReview} instance, allowing for method chaining
   */
  public TransferReview numberOfApprovalsRequired(Integer numberOfApprovalsRequired) {
    this.numberOfApprovalsRequired = numberOfApprovalsRequired;
    return this;
  }

  /**
   * Shows the number of
   * [approvals](https://docs.adyen.com/api-explorer/transfers/latest/post/transfers/approve)
   * required to process the transfer.
   *
   * @return numberOfApprovalsRequired Shows the number of
   *     [approvals](https://docs.adyen.com/api-explorer/transfers/latest/post/transfers/approve)
   *     required to process the transfer.
   */
  @JsonProperty(JSON_PROPERTY_NUMBER_OF_APPROVALS_REQUIRED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getNumberOfApprovalsRequired() {
    return numberOfApprovalsRequired;
  }

  /**
   * Shows the number of
   * [approvals](https://docs.adyen.com/api-explorer/transfers/latest/post/transfers/approve)
   * required to process the transfer.
   *
   * @param numberOfApprovalsRequired Shows the number of
   *     [approvals](https://docs.adyen.com/api-explorer/transfers/latest/post/transfers/approve)
   *     required to process the transfer.
   */
  @JsonProperty(JSON_PROPERTY_NUMBER_OF_APPROVALS_REQUIRED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumberOfApprovalsRequired(Integer numberOfApprovalsRequired) {
    this.numberOfApprovalsRequired = numberOfApprovalsRequired;
  }

  /**
   * Shows the status of the Strong Customer Authentication (SCA) process. Possible values:
   * **required**, **notApplicable**.
   *
   * @param scaOnApproval Shows the status of the Strong Customer Authentication (SCA) process.
   *     Possible values: **required**, **notApplicable**.
   * @return the current {@code TransferReview} instance, allowing for method chaining
   */
  public TransferReview scaOnApproval(ScaOnApprovalEnum scaOnApproval) {
    this.scaOnApproval = scaOnApproval;
    return this;
  }

  /**
   * Shows the status of the Strong Customer Authentication (SCA) process. Possible values:
   * **required**, **notApplicable**.
   *
   * @return scaOnApproval Shows the status of the Strong Customer Authentication (SCA) process.
   *     Possible values: **required**, **notApplicable**.
   */
  @JsonProperty(JSON_PROPERTY_SCA_ON_APPROVAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ScaOnApprovalEnum getScaOnApproval() {
    return scaOnApproval;
  }

  /**
   * Shows the status of the Strong Customer Authentication (SCA) process. Possible values:
   * **required**, **notApplicable**.
   *
   * @param scaOnApproval Shows the status of the Strong Customer Authentication (SCA) process.
   *     Possible values: **required**, **notApplicable**.
   */
  @JsonProperty(JSON_PROPERTY_SCA_ON_APPROVAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setScaOnApproval(ScaOnApprovalEnum scaOnApproval) {
    this.scaOnApproval = scaOnApproval;
  }

  /** Return true if this TransferReview object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TransferReview transferReview = (TransferReview) o;
    return Objects.equals(this.numberOfApprovalsRequired, transferReview.numberOfApprovalsRequired)
        && Objects.equals(this.scaOnApproval, transferReview.scaOnApproval);
  }

  @Override
  public int hashCode() {
    return Objects.hash(numberOfApprovalsRequired, scaOnApproval);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TransferReview {\n");
    sb.append("    numberOfApprovalsRequired: ")
        .append(toIndentedString(numberOfApprovalsRequired))
        .append("\n");
    sb.append("    scaOnApproval: ").append(toIndentedString(scaOnApproval)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of TransferReview given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of TransferReview
   * @throws JsonProcessingException if the JSON string is invalid with respect to TransferReview
   */
  public static TransferReview fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, TransferReview.class);
  }

  /**
   * Convert an instance of TransferReview to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
