/*
 * Transfer webhooks
 *
 * The version of the OpenAPI document: 4
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.transferwebhooks;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Objects;

/** Leg */
@JsonPropertyOrder({
  Leg.JSON_PROPERTY_ARRIVAL_AIRPORT_CODE,
  Leg.JSON_PROPERTY_BASIC_FARE_CODE,
  Leg.JSON_PROPERTY_CARRIER_CODE,
  Leg.JSON_PROPERTY_DEPARTURE_AIRPORT_CODE,
  Leg.JSON_PROPERTY_DEPARTURE_DATE,
  Leg.JSON_PROPERTY_FLIGHT_NUMBER
})
public class Leg {
  public static final String JSON_PROPERTY_ARRIVAL_AIRPORT_CODE = "arrivalAirportCode";
  private String arrivalAirportCode;

  public static final String JSON_PROPERTY_BASIC_FARE_CODE = "basicFareCode";
  private String basicFareCode;

  public static final String JSON_PROPERTY_CARRIER_CODE = "carrierCode";
  private String carrierCode;

  public static final String JSON_PROPERTY_DEPARTURE_AIRPORT_CODE = "departureAirportCode";
  private String departureAirportCode;

  public static final String JSON_PROPERTY_DEPARTURE_DATE = "departureDate";
  private String departureDate;

  public static final String JSON_PROPERTY_FLIGHT_NUMBER = "flightNumber";
  private String flightNumber;

  public Leg() {}

  /**
   * The IATA 3-letter airport code of the destination airport. This field is required if the
   * airline data includes leg details.
   *
   * @param arrivalAirportCode The IATA 3-letter airport code of the destination airport. This field
   *     is required if the airline data includes leg details.
   * @return the current {@code Leg} instance, allowing for method chaining
   */
  public Leg arrivalAirportCode(String arrivalAirportCode) {
    this.arrivalAirportCode = arrivalAirportCode;
    return this;
  }

  /**
   * The IATA 3-letter airport code of the destination airport. This field is required if the
   * airline data includes leg details.
   *
   * @return arrivalAirportCode The IATA 3-letter airport code of the destination airport. This
   *     field is required if the airline data includes leg details.
   */
  @JsonProperty(JSON_PROPERTY_ARRIVAL_AIRPORT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getArrivalAirportCode() {
    return arrivalAirportCode;
  }

  /**
   * The IATA 3-letter airport code of the destination airport. This field is required if the
   * airline data includes leg details.
   *
   * @param arrivalAirportCode The IATA 3-letter airport code of the destination airport. This field
   *     is required if the airline data includes leg details.
   */
  @JsonProperty(JSON_PROPERTY_ARRIVAL_AIRPORT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setArrivalAirportCode(String arrivalAirportCode) {
    this.arrivalAirportCode = arrivalAirportCode;
  }

  /**
   * The basic fare code for this leg.
   *
   * @param basicFareCode The basic fare code for this leg.
   * @return the current {@code Leg} instance, allowing for method chaining
   */
  public Leg basicFareCode(String basicFareCode) {
    this.basicFareCode = basicFareCode;
    return this;
  }

  /**
   * The basic fare code for this leg.
   *
   * @return basicFareCode The basic fare code for this leg.
   */
  @JsonProperty(JSON_PROPERTY_BASIC_FARE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getBasicFareCode() {
    return basicFareCode;
  }

  /**
   * The basic fare code for this leg.
   *
   * @param basicFareCode The basic fare code for this leg.
   */
  @JsonProperty(JSON_PROPERTY_BASIC_FARE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBasicFareCode(String basicFareCode) {
    this.basicFareCode = basicFareCode;
  }

  /**
   * IATA code of the carrier operating the flight.
   *
   * @param carrierCode IATA code of the carrier operating the flight.
   * @return the current {@code Leg} instance, allowing for method chaining
   */
  public Leg carrierCode(String carrierCode) {
    this.carrierCode = carrierCode;
    return this;
  }

  /**
   * IATA code of the carrier operating the flight.
   *
   * @return carrierCode IATA code of the carrier operating the flight.
   */
  @JsonProperty(JSON_PROPERTY_CARRIER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCarrierCode() {
    return carrierCode;
  }

  /**
   * IATA code of the carrier operating the flight.
   *
   * @param carrierCode IATA code of the carrier operating the flight.
   */
  @JsonProperty(JSON_PROPERTY_CARRIER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCarrierCode(String carrierCode) {
    this.carrierCode = carrierCode;
  }

  /**
   * The IATA three-letter airport code of the departure airport. This field is required if the
   * airline data includes leg details
   *
   * @param departureAirportCode The IATA three-letter airport code of the departure airport. This
   *     field is required if the airline data includes leg details
   * @return the current {@code Leg} instance, allowing for method chaining
   */
  public Leg departureAirportCode(String departureAirportCode) {
    this.departureAirportCode = departureAirportCode;
    return this;
  }

  /**
   * The IATA three-letter airport code of the departure airport. This field is required if the
   * airline data includes leg details
   *
   * @return departureAirportCode The IATA three-letter airport code of the departure airport. This
   *     field is required if the airline data includes leg details
   */
  @JsonProperty(JSON_PROPERTY_DEPARTURE_AIRPORT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDepartureAirportCode() {
    return departureAirportCode;
  }

  /**
   * The IATA three-letter airport code of the departure airport. This field is required if the
   * airline data includes leg details
   *
   * @param departureAirportCode The IATA three-letter airport code of the departure airport. This
   *     field is required if the airline data includes leg details
   */
  @JsonProperty(JSON_PROPERTY_DEPARTURE_AIRPORT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDepartureAirportCode(String departureAirportCode) {
    this.departureAirportCode = departureAirportCode;
  }

  /**
   * The flight departure date.
   *
   * @param departureDate The flight departure date.
   * @return the current {@code Leg} instance, allowing for method chaining
   */
  public Leg departureDate(String departureDate) {
    this.departureDate = departureDate;
    return this;
  }

  /**
   * The flight departure date.
   *
   * @return departureDate The flight departure date.
   */
  @JsonProperty(JSON_PROPERTY_DEPARTURE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDepartureDate() {
    return departureDate;
  }

  /**
   * The flight departure date.
   *
   * @param departureDate The flight departure date.
   */
  @JsonProperty(JSON_PROPERTY_DEPARTURE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDepartureDate(String departureDate) {
    this.departureDate = departureDate;
  }

  /**
   * The flight identifier.
   *
   * @param flightNumber The flight identifier.
   * @return the current {@code Leg} instance, allowing for method chaining
   */
  public Leg flightNumber(String flightNumber) {
    this.flightNumber = flightNumber;
    return this;
  }

  /**
   * The flight identifier.
   *
   * @return flightNumber The flight identifier.
   */
  @JsonProperty(JSON_PROPERTY_FLIGHT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getFlightNumber() {
    return flightNumber;
  }

  /**
   * The flight identifier.
   *
   * @param flightNumber The flight identifier.
   */
  @JsonProperty(JSON_PROPERTY_FLIGHT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFlightNumber(String flightNumber) {
    this.flightNumber = flightNumber;
  }

  /** Return true if this Leg object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Leg leg = (Leg) o;
    return Objects.equals(this.arrivalAirportCode, leg.arrivalAirportCode)
        && Objects.equals(this.basicFareCode, leg.basicFareCode)
        && Objects.equals(this.carrierCode, leg.carrierCode)
        && Objects.equals(this.departureAirportCode, leg.departureAirportCode)
        && Objects.equals(this.departureDate, leg.departureDate)
        && Objects.equals(this.flightNumber, leg.flightNumber);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        arrivalAirportCode,
        basicFareCode,
        carrierCode,
        departureAirportCode,
        departureDate,
        flightNumber);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Leg {\n");
    sb.append("    arrivalAirportCode: ").append(toIndentedString(arrivalAirportCode)).append("\n");
    sb.append("    basicFareCode: ").append(toIndentedString(basicFareCode)).append("\n");
    sb.append("    carrierCode: ").append(toIndentedString(carrierCode)).append("\n");
    sb.append("    departureAirportCode: ")
        .append(toIndentedString(departureAirportCode))
        .append("\n");
    sb.append("    departureDate: ").append(toIndentedString(departureDate)).append("\n");
    sb.append("    flightNumber: ").append(toIndentedString(flightNumber)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of Leg given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of Leg
   * @throws JsonProcessingException if the JSON string is invalid with respect to Leg
   */
  public static Leg fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, Leg.class);
  }

  /**
   * Convert an instance of Leg to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
