/*
 * Adyen Payout API
 *
 * The version of the OpenAPI document: 68
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.service.payout;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.payout.StoreDetailAndSubmitRequest;
import com.adyen.model.payout.StoreDetailAndSubmitResponse;
import com.adyen.model.payout.StoreDetailRequest;
import com.adyen.model.payout.StoreDetailResponse;
import com.adyen.model.payout.SubmitRequest;
import com.adyen.model.payout.SubmitResponse;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;

public class InitializationApi extends Service {

  public static final String API_VERSION = "68";

  protected String baseURL;

  /**
   * Initialization constructor in {@link com.adyen.service.payout package}.
   *
   * @param client {@link Client } (required)
   */
  public InitializationApi(Client client) {
    super(client);
    this.baseURL = createBaseURL("https://pal-test.adyen.com/pal/servlet/Payout/v68");
  }

  /**
   * Initialization constructor in {@link com.adyen.service.payout package}. Please use this
   * constructor only if you would like to pass along your own url for routing or testing purposes.
   * The latest API version is defined in this class as a constant.
   *
   * @param client {@link Client } (required)
   * @param baseURL {@link String } (required)
   */
  public InitializationApi(Client client, String baseURL) {
    super(client);
    this.baseURL = baseURL;
  }

  /**
   * Store payout details
   *
   * @param storeDetailRequest {@link StoreDetailRequest } (required)
   * @return {@link StoreDetailResponse }
   * @throws ApiException if fails to make API call
   */
  public StoreDetailResponse storeDetail(StoreDetailRequest storeDetailRequest)
      throws ApiException, IOException {
    return storeDetail(storeDetailRequest, null);
  }

  /**
   * Store payout details
   *
   * @param storeDetailRequest {@link StoreDetailRequest } (required)
   * @param requestOptions {@link RequestOptions } Object to store additional data such as
   *     idempotency-keys (optional)
   * @return {@link StoreDetailResponse }
   * @throws ApiException if fails to make API call
   */
  public StoreDetailResponse storeDetail(
      StoreDetailRequest storeDetailRequest, RequestOptions requestOptions)
      throws ApiException, IOException {
    String requestBody = storeDetailRequest.toJson();
    Resource resource = new Resource(this, this.baseURL + "/storeDetail", null);
    String jsonResult =
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
    return StoreDetailResponse.fromJson(jsonResult);
  }

  /**
   * Store details and submit a payout
   *
   * @param storeDetailAndSubmitRequest {@link StoreDetailAndSubmitRequest } (required)
   * @return {@link StoreDetailAndSubmitResponse }
   * @throws ApiException if fails to make API call
   */
  public StoreDetailAndSubmitResponse storeDetailAndSubmitThirdParty(
      StoreDetailAndSubmitRequest storeDetailAndSubmitRequest) throws ApiException, IOException {
    return storeDetailAndSubmitThirdParty(storeDetailAndSubmitRequest, null);
  }

  /**
   * Store details and submit a payout
   *
   * @param storeDetailAndSubmitRequest {@link StoreDetailAndSubmitRequest } (required)
   * @param requestOptions {@link RequestOptions } Object to store additional data such as
   *     idempotency-keys (optional)
   * @return {@link StoreDetailAndSubmitResponse }
   * @throws ApiException if fails to make API call
   */
  public StoreDetailAndSubmitResponse storeDetailAndSubmitThirdParty(
      StoreDetailAndSubmitRequest storeDetailAndSubmitRequest, RequestOptions requestOptions)
      throws ApiException, IOException {
    String requestBody = storeDetailAndSubmitRequest.toJson();
    Resource resource = new Resource(this, this.baseURL + "/storeDetailAndSubmitThirdParty", null);
    String jsonResult =
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
    return StoreDetailAndSubmitResponse.fromJson(jsonResult);
  }

  /**
   * Submit a payout
   *
   * @param submitRequest {@link SubmitRequest } (required)
   * @return {@link SubmitResponse }
   * @throws ApiException if fails to make API call
   */
  public SubmitResponse submitThirdParty(SubmitRequest submitRequest)
      throws ApiException, IOException {
    return submitThirdParty(submitRequest, null);
  }

  /**
   * Submit a payout
   *
   * @param submitRequest {@link SubmitRequest } (required)
   * @param requestOptions {@link RequestOptions } Object to store additional data such as
   *     idempotency-keys (optional)
   * @return {@link SubmitResponse }
   * @throws ApiException if fails to make API call
   */
  public SubmitResponse submitThirdParty(SubmitRequest submitRequest, RequestOptions requestOptions)
      throws ApiException, IOException {
    String requestBody = submitRequest.toJson();
    Resource resource = new Resource(this, this.baseURL + "/submitThirdParty", null);
    String jsonResult =
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
    return SubmitResponse.fromJson(jsonResult);
  }
}
