/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpaywebhooks;

import com.adyen.model.marketpaywebhooks.ErrorFieldType;
import com.adyen.model.marketpaywebhooks.JSON;
import com.adyen.model.marketpaywebhooks.PayoutScheduleResponse;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"accountCode", "accountHolderCode", "bankAccountUUID", "description", "invalidFields", "metadata", "payoutMethodCode", "payoutSchedule", "payoutSpeed", "pspReference", "resultCode", "status"})
public class CreateAccountResponse {
    public static final String JSON_PROPERTY_ACCOUNT_CODE = "accountCode";
    private String accountCode;
    public static final String JSON_PROPERTY_ACCOUNT_HOLDER_CODE = "accountHolderCode";
    private String accountHolderCode;
    public static final String JSON_PROPERTY_BANK_ACCOUNT_U_U_I_D = "bankAccountUUID";
    private String bankAccountUUID;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_INVALID_FIELDS = "invalidFields";
    private List<ErrorFieldType> invalidFields = null;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private Map<String, String> metadata = null;
    public static final String JSON_PROPERTY_PAYOUT_METHOD_CODE = "payoutMethodCode";
    private String payoutMethodCode;
    public static final String JSON_PROPERTY_PAYOUT_SCHEDULE = "payoutSchedule";
    private PayoutScheduleResponse payoutSchedule;
    public static final String JSON_PROPERTY_PAYOUT_SPEED = "payoutSpeed";
    private PayoutSpeedEnum payoutSpeed;
    public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
    private String pspReference;
    public static final String JSON_PROPERTY_RESULT_CODE = "resultCode";
    private String resultCode;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;

    public CreateAccountResponse accountCode(String accountCode) {
        this.accountCode = accountCode;
        return this;
    }

    @ApiModelProperty(value="The code of the new account.")
    @JsonProperty(value="accountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountCode() {
        return this.accountCode;
    }

    @JsonProperty(value="accountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountCode(String accountCode) {
        this.accountCode = accountCode;
    }

    public CreateAccountResponse accountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
        return this;
    }

    @ApiModelProperty(value="The code of the account holder.")
    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountHolderCode() {
        return this.accountHolderCode;
    }

    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
    }

    public CreateAccountResponse bankAccountUUID(String bankAccountUUID) {
        this.bankAccountUUID = bankAccountUUID;
        return this;
    }

    @ApiModelProperty(value="The bankAccountUUID of the bank account held by the account holder to couple the account with. Scheduled payouts in currencies matching the currency of this bank account will be sent to this bank account. Payouts in different currencies will be sent to a matching bank account of the account holder.")
    @JsonProperty(value="bankAccountUUID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBankAccountUUID() {
        return this.bankAccountUUID;
    }

    @JsonProperty(value="bankAccountUUID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankAccountUUID(String bankAccountUUID) {
        this.bankAccountUUID = bankAccountUUID;
    }

    public CreateAccountResponse description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The description of the account.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateAccountResponse invalidFields(List<ErrorFieldType> invalidFields) {
        this.invalidFields = invalidFields;
        return this;
    }

    public CreateAccountResponse addInvalidFieldsItem(ErrorFieldType invalidFieldsItem) {
        if (this.invalidFields == null) {
            this.invalidFields = new ArrayList<ErrorFieldType>();
        }
        this.invalidFields.add(invalidFieldsItem);
        return this;
    }

    @ApiModelProperty(value="A list of fields that caused the `/createAccount` request to fail.")
    @JsonProperty(value="invalidFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ErrorFieldType> getInvalidFields() {
        return this.invalidFields;
    }

    @JsonProperty(value="invalidFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInvalidFields(List<ErrorFieldType> invalidFields) {
        this.invalidFields = invalidFields;
    }

    public CreateAccountResponse metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public CreateAccountResponse putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @ApiModelProperty(value="A set of key and value pairs containing metadata.")
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public CreateAccountResponse payoutMethodCode(String payoutMethodCode) {
        this.payoutMethodCode = payoutMethodCode;
        return this;
    }

    @ApiModelProperty(value="The payout method code held by the account holder to couple the account with. Scheduled card payouts will be sent using this payout method code.")
    @JsonProperty(value="payoutMethodCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPayoutMethodCode() {
        return this.payoutMethodCode;
    }

    @JsonProperty(value="payoutMethodCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayoutMethodCode(String payoutMethodCode) {
        this.payoutMethodCode = payoutMethodCode;
    }

    public CreateAccountResponse payoutSchedule(PayoutScheduleResponse payoutSchedule) {
        this.payoutSchedule = payoutSchedule;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="payoutSchedule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PayoutScheduleResponse getPayoutSchedule() {
        return this.payoutSchedule;
    }

    @JsonProperty(value="payoutSchedule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayoutSchedule(PayoutScheduleResponse payoutSchedule) {
        this.payoutSchedule = payoutSchedule;
    }

    public CreateAccountResponse payoutSpeed(PayoutSpeedEnum payoutSpeed) {
        this.payoutSpeed = payoutSpeed;
        return this;
    }

    @ApiModelProperty(value="Speed with which payouts for this account are processed. Permitted values: `STANDARD`, `SAME_DAY`.")
    @JsonProperty(value="payoutSpeed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PayoutSpeedEnum getPayoutSpeed() {
        return this.payoutSpeed;
    }

    @JsonProperty(value="payoutSpeed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayoutSpeed(PayoutSpeedEnum payoutSpeed) {
        this.payoutSpeed = payoutSpeed;
    }

    public CreateAccountResponse pspReference(String pspReference) {
        this.pspReference = pspReference;
        return this;
    }

    @ApiModelProperty(value="The reference of a request. Can be used to uniquely identify the request.")
    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPspReference() {
        return this.pspReference;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
    }

    public CreateAccountResponse resultCode(String resultCode) {
        this.resultCode = resultCode;
        return this;
    }

    @ApiModelProperty(value="The result code.")
    @JsonProperty(value="resultCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getResultCode() {
        return this.resultCode;
    }

    @JsonProperty(value="resultCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResultCode(String resultCode) {
        this.resultCode = resultCode;
    }

    public CreateAccountResponse status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="The status of the account. >Permitted values: `Active`.")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateAccountResponse createAccountResponse = (CreateAccountResponse)o;
        return Objects.equals(this.accountCode, createAccountResponse.accountCode) && Objects.equals(this.accountHolderCode, createAccountResponse.accountHolderCode) && Objects.equals(this.bankAccountUUID, createAccountResponse.bankAccountUUID) && Objects.equals(this.description, createAccountResponse.description) && Objects.equals(this.invalidFields, createAccountResponse.invalidFields) && Objects.equals(this.metadata, createAccountResponse.metadata) && Objects.equals(this.payoutMethodCode, createAccountResponse.payoutMethodCode) && Objects.equals(this.payoutSchedule, createAccountResponse.payoutSchedule) && Objects.equals((Object)this.payoutSpeed, (Object)createAccountResponse.payoutSpeed) && Objects.equals(this.pspReference, createAccountResponse.pspReference) && Objects.equals(this.resultCode, createAccountResponse.resultCode) && Objects.equals((Object)this.status, (Object)createAccountResponse.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountCode, this.accountHolderCode, this.bankAccountUUID, this.description, this.invalidFields, this.metadata, this.payoutMethodCode, this.payoutSchedule, this.payoutSpeed, this.pspReference, this.resultCode, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateAccountResponse {\n");
        sb.append("    accountCode: ").append(this.toIndentedString(this.accountCode)).append("\n");
        sb.append("    accountHolderCode: ").append(this.toIndentedString(this.accountHolderCode)).append("\n");
        sb.append("    bankAccountUUID: ").append(this.toIndentedString(this.bankAccountUUID)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    invalidFields: ").append(this.toIndentedString(this.invalidFields)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    payoutMethodCode: ").append(this.toIndentedString(this.payoutMethodCode)).append("\n");
        sb.append("    payoutSchedule: ").append(this.toIndentedString(this.payoutSchedule)).append("\n");
        sb.append("    payoutSpeed: ").append(this.toIndentedString((Object)this.payoutSpeed)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("    resultCode: ").append(this.toIndentedString(this.resultCode)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static CreateAccountResponse fromJson(String jsonString) throws JsonProcessingException {
        return (CreateAccountResponse)JSON.getMapper().readValue(jsonString, CreateAccountResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum StatusEnum {
        ACTIVE("Active"),
        CLOSED("Closed"),
        INACTIVE("Inactive"),
        SUSPENDED("Suspended");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PayoutSpeedEnum {
        INSTANT("INSTANT"),
        SAME_DAY("SAME_DAY"),
        STANDARD("STANDARD");

        private String value;

        private PayoutSpeedEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PayoutSpeedEnum fromValue(String value) {
            for (PayoutSpeedEnum b : PayoutSpeedEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

