/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transfers;

import com.adyen.model.transfers.Amount;
import com.adyen.model.transfers.CapitalBalance;
import com.adyen.model.transfers.Counterparty;
import com.adyen.model.transfers.Fee;
import com.adyen.model.transfers.JSON;
import com.adyen.model.transfers.Repayment;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Objects;

@JsonPropertyOrder(value={"amount", "balances", "counterparty", "fee", "grantAccountId", "grantOfferId", "id", "repayment", "status"})
public class CapitalGrant {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    public static final String JSON_PROPERTY_BALANCES = "balances";
    private CapitalBalance balances;
    public static final String JSON_PROPERTY_COUNTERPARTY = "counterparty";
    private Counterparty counterparty;
    public static final String JSON_PROPERTY_FEE = "fee";
    private Fee fee;
    public static final String JSON_PROPERTY_GRANT_ACCOUNT_ID = "grantAccountId";
    private String grantAccountId;
    public static final String JSON_PROPERTY_GRANT_OFFER_ID = "grantOfferId";
    private String grantOfferId;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_REPAYMENT = "repayment";
    private Repayment repayment;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;

    public CapitalGrant amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public CapitalGrant balances(CapitalBalance balances) {
        this.balances = balances;
        return this;
    }

    @JsonProperty(value="balances")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CapitalBalance getBalances() {
        return this.balances;
    }

    @JsonProperty(value="balances")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalances(CapitalBalance balances) {
        this.balances = balances;
    }

    public CapitalGrant counterparty(Counterparty counterparty) {
        this.counterparty = counterparty;
        return this;
    }

    @JsonProperty(value="counterparty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Counterparty getCounterparty() {
        return this.counterparty;
    }

    @JsonProperty(value="counterparty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCounterparty(Counterparty counterparty) {
        this.counterparty = counterparty;
    }

    public CapitalGrant fee(Fee fee) {
        this.fee = fee;
        return this;
    }

    @JsonProperty(value="fee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Fee getFee() {
        return this.fee;
    }

    @JsonProperty(value="fee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFee(Fee fee) {
        this.fee = fee;
    }

    public CapitalGrant grantAccountId(String grantAccountId) {
        this.grantAccountId = grantAccountId;
        return this;
    }

    @JsonProperty(value="grantAccountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGrantAccountId() {
        return this.grantAccountId;
    }

    @JsonProperty(value="grantAccountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGrantAccountId(String grantAccountId) {
        this.grantAccountId = grantAccountId;
    }

    public CapitalGrant grantOfferId(String grantOfferId) {
        this.grantOfferId = grantOfferId;
        return this;
    }

    @JsonProperty(value="grantOfferId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGrantOfferId() {
        return this.grantOfferId;
    }

    @JsonProperty(value="grantOfferId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGrantOfferId(String grantOfferId) {
        this.grantOfferId = grantOfferId;
    }

    public CapitalGrant id(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public CapitalGrant repayment(Repayment repayment) {
        this.repayment = repayment;
        return this;
    }

    @JsonProperty(value="repayment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Repayment getRepayment() {
        return this.repayment;
    }

    @JsonProperty(value="repayment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRepayment(Repayment repayment) {
        this.repayment = repayment;
    }

    public CapitalGrant status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CapitalGrant capitalGrant = (CapitalGrant)o;
        return Objects.equals(this.amount, capitalGrant.amount) && Objects.equals(this.balances, capitalGrant.balances) && Objects.equals(this.counterparty, capitalGrant.counterparty) && Objects.equals(this.fee, capitalGrant.fee) && Objects.equals(this.grantAccountId, capitalGrant.grantAccountId) && Objects.equals(this.grantOfferId, capitalGrant.grantOfferId) && Objects.equals(this.id, capitalGrant.id) && Objects.equals(this.repayment, capitalGrant.repayment) && Objects.equals((Object)this.status, (Object)capitalGrant.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.balances, this.counterparty, this.fee, this.grantAccountId, this.grantOfferId, this.id, this.repayment, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CapitalGrant {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    balances: ").append(this.toIndentedString(this.balances)).append("\n");
        sb.append("    counterparty: ").append(this.toIndentedString(this.counterparty)).append("\n");
        sb.append("    fee: ").append(this.toIndentedString(this.fee)).append("\n");
        sb.append("    grantAccountId: ").append(this.toIndentedString(this.grantAccountId)).append("\n");
        sb.append("    grantOfferId: ").append(this.toIndentedString(this.grantOfferId)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    repayment: ").append(this.toIndentedString(this.repayment)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static CapitalGrant fromJson(String jsonString) throws JsonProcessingException {
        return (CapitalGrant)JSON.getMapper().readValue(jsonString, CapitalGrant.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum StatusEnum {
        PENDING(String.valueOf("Pending")),
        ACTIVE(String.valueOf("Active")),
        REPAID(String.valueOf("Repaid")),
        FAILED(String.valueOf("Failed")),
        WRITTENOFF(String.valueOf("WrittenOff")),
        REVOKED(String.valueOf("Revoked"));

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

