/*
 *                       ######
 *                       ######
 * ############    ####( ######  #####. ######  ############   ############
 * #############  #####( ######  #####. ######  #############  #############
 *        ######  #####( ######  #####. ######  #####  ######  #####  ######
 * ###### ######  #####( ######  #####. ######  #####  #####   #####  ######
 * ###### ######  #####( ######  #####. ######  #####          #####  ######
 * #############  #############  #############  #############  #####  ######
 *  ############   ############  #############   ############  #####  ######
 *                                      ######
 *                               #############
 *                               ############
 *
 * Adyen Java API Library
 *
 * Copyright (c) 2018 Adyen B.V.
 * This file is open source and available under the MIT license.
 * See the LICENSE file for more info.
 */
package com.adyen;

/**
 * A service base class that enforces API key authentication.
 *
 * <p>This class extends Service and ensures that any extending service requires an API key for
 * authentication.
 */
public class ApiKeyAuthenticatedService extends Service {

  protected ApiKeyAuthenticatedService(Client client) {
    super(client);
    setApiKeyRequired(true);
  }
}
