/*
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.balanceplatform;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;
import java.util.ArrayList;
import java.util.List;

/** AuthorisedCardUsers */
@JsonPropertyOrder({AuthorisedCardUsers.JSON_PROPERTY_LEGAL_ENTITY_IDS})
public class AuthorisedCardUsers {
  public static final String JSON_PROPERTY_LEGAL_ENTITY_IDS = "legalEntityIds";
  private List<String> legalEntityIds;

  public AuthorisedCardUsers() {}

  /**
   * The legal entity IDs of the authorized card users linked to the specified payment instrument.
   *
   * @param legalEntityIds The legal entity IDs of the authorized card users linked to the specified
   *     payment instrument.
   * @return the current {@code AuthorisedCardUsers} instance, allowing for method chaining
   */
  public AuthorisedCardUsers legalEntityIds(List<String> legalEntityIds) {
    this.legalEntityIds = legalEntityIds;
    return this;
  }

  public AuthorisedCardUsers addLegalEntityIdsItem(String legalEntityIdsItem) {
    if (this.legalEntityIds == null) {
      this.legalEntityIds = new ArrayList<>();
    }
    this.legalEntityIds.add(legalEntityIdsItem);
    return this;
  }

  /**
   * The legal entity IDs of the authorized card users linked to the specified payment instrument.
   *
   * @return legalEntityIds The legal entity IDs of the authorized card users linked to the
   *     specified payment instrument.
   */
  @JsonProperty(JSON_PROPERTY_LEGAL_ENTITY_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getLegalEntityIds() {
    return legalEntityIds;
  }

  /**
   * The legal entity IDs of the authorized card users linked to the specified payment instrument.
   *
   * @param legalEntityIds The legal entity IDs of the authorized card users linked to the specified
   *     payment instrument.
   */
  @JsonProperty(JSON_PROPERTY_LEGAL_ENTITY_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLegalEntityIds(List<String> legalEntityIds) {
    this.legalEntityIds = legalEntityIds;
  }

  /** Return true if this AuthorisedCardUsers object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AuthorisedCardUsers authorisedCardUsers = (AuthorisedCardUsers) o;
    return Objects.equals(this.legalEntityIds, authorisedCardUsers.legalEntityIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(legalEntityIds);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AuthorisedCardUsers {\n");
    sb.append("    legalEntityIds: ").append(toIndentedString(legalEntityIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of AuthorisedCardUsers given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of AuthorisedCardUsers
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     AuthorisedCardUsers
   */
  public static AuthorisedCardUsers fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, AuthorisedCardUsers.class);
  }

  /**
   * Convert an instance of AuthorisedCardUsers to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
