/*
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.balanceplatform;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

/** BalanceWebhookSettingInfo */
@JsonPropertyOrder({
  BalanceWebhookSettingInfo.JSON_PROPERTY_CONDITIONS,
  BalanceWebhookSettingInfo.JSON_PROPERTY_CURRENCY,
  BalanceWebhookSettingInfo.JSON_PROPERTY_STATUS,
  BalanceWebhookSettingInfo.JSON_PROPERTY_TARGET,
  BalanceWebhookSettingInfo.JSON_PROPERTY_TYPE
})
public class BalanceWebhookSettingInfo {
  public static final String JSON_PROPERTY_CONDITIONS = "conditions";
  private List<Condition> conditions;

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private String currency;

  /**
   * The status of the webhook setting. Possible values: * **active**: You receive a balance webhook
   * if any of the conditions in this setting are met. * **inactive**: You do not receive a balance
   * webhook even if the conditions in this settings are met.
   */
  public enum StatusEnum {
    ACTIVE(String.valueOf("active")),

    INACTIVE(String.valueOf("inactive"));

    private static final Logger LOG = Logger.getLogger(StatusEnum.class.getName());

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "StatusEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(StatusEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  public static final String JSON_PROPERTY_TARGET = "target";
  private Target target;

  /** The type of the webhook you are configuring. Set to **balance**. */
  public enum TypeEnum {
    BALANCE(String.valueOf("balance"));

    private static final Logger LOG = Logger.getLogger(TypeEnum.class.getName());

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "TypeEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(TypeEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public BalanceWebhookSettingInfo() {}

  /**
   * The array of conditions a balance change must meet for Adyen to send the webhook.
   *
   * @param conditions The array of conditions a balance change must meet for Adyen to send the
   *     webhook.
   * @return the current {@code BalanceWebhookSettingInfo} instance, allowing for method chaining
   */
  public BalanceWebhookSettingInfo conditions(List<Condition> conditions) {
    this.conditions = conditions;
    return this;
  }

  public BalanceWebhookSettingInfo addConditionsItem(Condition conditionsItem) {
    if (this.conditions == null) {
      this.conditions = new ArrayList<>();
    }
    this.conditions.add(conditionsItem);
    return this;
  }

  /**
   * The array of conditions a balance change must meet for Adyen to send the webhook.
   *
   * @return conditions The array of conditions a balance change must meet for Adyen to send the
   *     webhook.
   */
  @JsonProperty(JSON_PROPERTY_CONDITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<Condition> getConditions() {
    return conditions;
  }

  /**
   * The array of conditions a balance change must meet for Adyen to send the webhook.
   *
   * @param conditions The array of conditions a balance change must meet for Adyen to send the
   *     webhook.
   */
  @JsonProperty(JSON_PROPERTY_CONDITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setConditions(List<Condition> conditions) {
    this.conditions = conditions;
  }

  /**
   * The three-character [ISO currency
   * code](https://docs.adyen.com/development-resources/currency-codes) of the balance.
   *
   * @param currency The three-character [ISO currency
   *     code](https://docs.adyen.com/development-resources/currency-codes) of the balance.
   * @return the current {@code BalanceWebhookSettingInfo} instance, allowing for method chaining
   */
  public BalanceWebhookSettingInfo currency(String currency) {
    this.currency = currency;
    return this;
  }

  /**
   * The three-character [ISO currency
   * code](https://docs.adyen.com/development-resources/currency-codes) of the balance.
   *
   * @return currency The three-character [ISO currency
   *     code](https://docs.adyen.com/development-resources/currency-codes) of the balance.
   */
  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCurrency() {
    return currency;
  }

  /**
   * The three-character [ISO currency
   * code](https://docs.adyen.com/development-resources/currency-codes) of the balance.
   *
   * @param currency The three-character [ISO currency
   *     code](https://docs.adyen.com/development-resources/currency-codes) of the balance.
   */
  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrency(String currency) {
    this.currency = currency;
  }

  /**
   * The status of the webhook setting. Possible values: * **active**: You receive a balance webhook
   * if any of the conditions in this setting are met. * **inactive**: You do not receive a balance
   * webhook even if the conditions in this settings are met.
   *
   * @param status The status of the webhook setting. Possible values: * **active**: You receive a
   *     balance webhook if any of the conditions in this setting are met. * **inactive**: You do
   *     not receive a balance webhook even if the conditions in this settings are met.
   * @return the current {@code BalanceWebhookSettingInfo} instance, allowing for method chaining
   */
  public BalanceWebhookSettingInfo status(StatusEnum status) {
    this.status = status;
    return this;
  }

  /**
   * The status of the webhook setting. Possible values: * **active**: You receive a balance webhook
   * if any of the conditions in this setting are met. * **inactive**: You do not receive a balance
   * webhook even if the conditions in this settings are met.
   *
   * @return status The status of the webhook setting. Possible values: * **active**: You receive a
   *     balance webhook if any of the conditions in this setting are met. * **inactive**: You do
   *     not receive a balance webhook even if the conditions in this settings are met.
   */
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StatusEnum getStatus() {
    return status;
  }

  /**
   * The status of the webhook setting. Possible values: * **active**: You receive a balance webhook
   * if any of the conditions in this setting are met. * **inactive**: You do not receive a balance
   * webhook even if the conditions in this settings are met.
   *
   * @param status The status of the webhook setting. Possible values: * **active**: You receive a
   *     balance webhook if any of the conditions in this setting are met. * **inactive**: You do
   *     not receive a balance webhook even if the conditions in this settings are met.
   */
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  /**
   * target
   *
   * @param target
   * @return the current {@code BalanceWebhookSettingInfo} instance, allowing for method chaining
   */
  public BalanceWebhookSettingInfo target(Target target) {
    this.target = target;
    return this;
  }

  /**
   * Get target
   *
   * @return target
   */
  @JsonProperty(JSON_PROPERTY_TARGET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Target getTarget() {
    return target;
  }

  /**
   * target
   *
   * @param target
   */
  @JsonProperty(JSON_PROPERTY_TARGET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTarget(Target target) {
    this.target = target;
  }

  /**
   * The type of the webhook you are configuring. Set to **balance**.
   *
   * @param type The type of the webhook you are configuring. Set to **balance**.
   * @return the current {@code BalanceWebhookSettingInfo} instance, allowing for method chaining
   */
  public BalanceWebhookSettingInfo type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * The type of the webhook you are configuring. Set to **balance**.
   *
   * @return type The type of the webhook you are configuring. Set to **balance**.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * The type of the webhook you are configuring. Set to **balance**.
   *
   * @param type The type of the webhook you are configuring. Set to **balance**.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /** Return true if this BalanceWebhookSettingInfo object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BalanceWebhookSettingInfo balanceWebhookSettingInfo = (BalanceWebhookSettingInfo) o;
    return Objects.equals(this.conditions, balanceWebhookSettingInfo.conditions)
        && Objects.equals(this.currency, balanceWebhookSettingInfo.currency)
        && Objects.equals(this.status, balanceWebhookSettingInfo.status)
        && Objects.equals(this.target, balanceWebhookSettingInfo.target)
        && Objects.equals(this.type, balanceWebhookSettingInfo.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(conditions, currency, status, target, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BalanceWebhookSettingInfo {\n");
    sb.append("    conditions: ").append(toIndentedString(conditions)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    target: ").append(toIndentedString(target)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of BalanceWebhookSettingInfo given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of BalanceWebhookSettingInfo
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     BalanceWebhookSettingInfo
   */
  public static BalanceWebhookSettingInfo fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, BalanceWebhookSettingInfo.class);
  }

  /**
   * Convert an instance of BalanceWebhookSettingInfo to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
