/*
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.balanceplatform;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.OffsetDateTime;
import java.util.*;
import java.util.Arrays;
import java.util.logging.Logger;

/** CardOrder */
@JsonPropertyOrder({
  CardOrder.JSON_PROPERTY_BEGIN_DATE,
  CardOrder.JSON_PROPERTY_CARD_MANUFACTURING_PROFILE_ID,
  CardOrder.JSON_PROPERTY_CLOSED_DATE,
  CardOrder.JSON_PROPERTY_END_DATE,
  CardOrder.JSON_PROPERTY_ID,
  CardOrder.JSON_PROPERTY_LOCK_DATE,
  CardOrder.JSON_PROPERTY_SERVICE_CENTER,
  CardOrder.JSON_PROPERTY_STATUS
})
public class CardOrder {
  public static final String JSON_PROPERTY_BEGIN_DATE = "beginDate";
  private OffsetDateTime beginDate;

  public static final String JSON_PROPERTY_CARD_MANUFACTURING_PROFILE_ID =
      "cardManufacturingProfileId";
  private String cardManufacturingProfileId;

  public static final String JSON_PROPERTY_CLOSED_DATE = "closedDate";
  private OffsetDateTime closedDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  private OffsetDateTime endDate;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_LOCK_DATE = "lockDate";
  private OffsetDateTime lockDate;

  public static final String JSON_PROPERTY_SERVICE_CENTER = "serviceCenter";
  private String serviceCenter;

  /** The status of the card order. Possible values: **Open**, **Closed**. */
  public enum StatusEnum {
    CLOSED(String.valueOf("closed")),

    OPEN(String.valueOf("open"));

    private static final Logger LOG = Logger.getLogger(StatusEnum.class.getName());

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "StatusEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(StatusEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  public CardOrder() {}

  /**
   * The date when the card order is created.
   *
   * @param beginDate The date when the card order is created.
   * @return the current {@code CardOrder} instance, allowing for method chaining
   */
  public CardOrder beginDate(OffsetDateTime beginDate) {
    this.beginDate = beginDate;
    return this;
  }

  /**
   * The date when the card order is created.
   *
   * @return beginDate The date when the card order is created.
   */
  @JsonProperty(JSON_PROPERTY_BEGIN_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getBeginDate() {
    return beginDate;
  }

  /**
   * The date when the card order is created.
   *
   * @param beginDate The date when the card order is created.
   */
  @JsonProperty(JSON_PROPERTY_BEGIN_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBeginDate(OffsetDateTime beginDate) {
    this.beginDate = beginDate;
  }

  /**
   * The unique identifier of the card manufacturer profile.
   *
   * @param cardManufacturingProfileId The unique identifier of the card manufacturer profile.
   * @return the current {@code CardOrder} instance, allowing for method chaining
   */
  public CardOrder cardManufacturingProfileId(String cardManufacturingProfileId) {
    this.cardManufacturingProfileId = cardManufacturingProfileId;
    return this;
  }

  /**
   * The unique identifier of the card manufacturer profile.
   *
   * @return cardManufacturingProfileId The unique identifier of the card manufacturer profile.
   */
  @JsonProperty(JSON_PROPERTY_CARD_MANUFACTURING_PROFILE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCardManufacturingProfileId() {
    return cardManufacturingProfileId;
  }

  /**
   * The unique identifier of the card manufacturer profile.
   *
   * @param cardManufacturingProfileId The unique identifier of the card manufacturer profile.
   */
  @JsonProperty(JSON_PROPERTY_CARD_MANUFACTURING_PROFILE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCardManufacturingProfileId(String cardManufacturingProfileId) {
    this.cardManufacturingProfileId = cardManufacturingProfileId;
  }

  /**
   * The date when the card order processing ends.
   *
   * @param closedDate The date when the card order processing ends.
   * @return the current {@code CardOrder} instance, allowing for method chaining
   */
  public CardOrder closedDate(OffsetDateTime closedDate) {
    this.closedDate = closedDate;
    return this;
  }

  /**
   * The date when the card order processing ends.
   *
   * @return closedDate The date when the card order processing ends.
   */
  @JsonProperty(JSON_PROPERTY_CLOSED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getClosedDate() {
    return closedDate;
  }

  /**
   * The date when the card order processing ends.
   *
   * @param closedDate The date when the card order processing ends.
   */
  @JsonProperty(JSON_PROPERTY_CLOSED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClosedDate(OffsetDateTime closedDate) {
    this.closedDate = closedDate;
  }

  /**
   * The date when you manually closed the card order. Card orders are automatically closed by the
   * end of the day it was created. If you manually closed it beforehand, the closing date is shown
   * as the &#x60;endDate&#x60;.
   *
   * @param endDate The date when you manually closed the card order. Card orders are automatically
   *     closed by the end of the day it was created. If you manually closed it beforehand, the
   *     closing date is shown as the &#x60;endDate&#x60;.
   * @return the current {@code CardOrder} instance, allowing for method chaining
   */
  public CardOrder endDate(OffsetDateTime endDate) {
    this.endDate = endDate;
    return this;
  }

  /**
   * The date when you manually closed the card order. Card orders are automatically closed by the
   * end of the day it was created. If you manually closed it beforehand, the closing date is shown
   * as the &#x60;endDate&#x60;.
   *
   * @return endDate The date when you manually closed the card order. Card orders are automatically
   *     closed by the end of the day it was created. If you manually closed it beforehand, the
   *     closing date is shown as the &#x60;endDate&#x60;.
   */
  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getEndDate() {
    return endDate;
  }

  /**
   * The date when you manually closed the card order. Card orders are automatically closed by the
   * end of the day it was created. If you manually closed it beforehand, the closing date is shown
   * as the &#x60;endDate&#x60;.
   *
   * @param endDate The date when you manually closed the card order. Card orders are automatically
   *     closed by the end of the day it was created. If you manually closed it beforehand, the
   *     closing date is shown as the &#x60;endDate&#x60;.
   */
  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEndDate(OffsetDateTime endDate) {
    this.endDate = endDate;
  }

  /**
   * The unique identifier of the card order.
   *
   * @param id The unique identifier of the card order.
   * @return the current {@code CardOrder} instance, allowing for method chaining
   */
  public CardOrder id(String id) {
    this.id = id;
    return this;
  }

  /**
   * The unique identifier of the card order.
   *
   * @return id The unique identifier of the card order.
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getId() {
    return id;
  }

  /**
   * The unique identifier of the card order.
   *
   * @param id The unique identifier of the card order.
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }

  /**
   * The date when the card order processing begins.
   *
   * @param lockDate The date when the card order processing begins.
   * @return the current {@code CardOrder} instance, allowing for method chaining
   */
  public CardOrder lockDate(OffsetDateTime lockDate) {
    this.lockDate = lockDate;
    return this;
  }

  /**
   * The date when the card order processing begins.
   *
   * @return lockDate The date when the card order processing begins.
   */
  @JsonProperty(JSON_PROPERTY_LOCK_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getLockDate() {
    return lockDate;
  }

  /**
   * The date when the card order processing begins.
   *
   * @param lockDate The date when the card order processing begins.
   */
  @JsonProperty(JSON_PROPERTY_LOCK_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLockDate(OffsetDateTime lockDate) {
    this.lockDate = lockDate;
  }

  /**
   * The service center.
   *
   * @param serviceCenter The service center.
   * @return the current {@code CardOrder} instance, allowing for method chaining
   */
  public CardOrder serviceCenter(String serviceCenter) {
    this.serviceCenter = serviceCenter;
    return this;
  }

  /**
   * The service center.
   *
   * @return serviceCenter The service center.
   */
  @JsonProperty(JSON_PROPERTY_SERVICE_CENTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getServiceCenter() {
    return serviceCenter;
  }

  /**
   * The service center.
   *
   * @param serviceCenter The service center.
   */
  @JsonProperty(JSON_PROPERTY_SERVICE_CENTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setServiceCenter(String serviceCenter) {
    this.serviceCenter = serviceCenter;
  }

  /**
   * The status of the card order. Possible values: **Open**, **Closed**.
   *
   * @param status The status of the card order. Possible values: **Open**, **Closed**.
   * @return the current {@code CardOrder} instance, allowing for method chaining
   */
  public CardOrder status(StatusEnum status) {
    this.status = status;
    return this;
  }

  /**
   * The status of the card order. Possible values: **Open**, **Closed**.
   *
   * @return status The status of the card order. Possible values: **Open**, **Closed**.
   */
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StatusEnum getStatus() {
    return status;
  }

  /**
   * The status of the card order. Possible values: **Open**, **Closed**.
   *
   * @param status The status of the card order. Possible values: **Open**, **Closed**.
   */
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  /** Return true if this CardOrder object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CardOrder cardOrder = (CardOrder) o;
    return Objects.equals(this.beginDate, cardOrder.beginDate)
        && Objects.equals(this.cardManufacturingProfileId, cardOrder.cardManufacturingProfileId)
        && Objects.equals(this.closedDate, cardOrder.closedDate)
        && Objects.equals(this.endDate, cardOrder.endDate)
        && Objects.equals(this.id, cardOrder.id)
        && Objects.equals(this.lockDate, cardOrder.lockDate)
        && Objects.equals(this.serviceCenter, cardOrder.serviceCenter)
        && Objects.equals(this.status, cardOrder.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        beginDate,
        cardManufacturingProfileId,
        closedDate,
        endDate,
        id,
        lockDate,
        serviceCenter,
        status);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CardOrder {\n");
    sb.append("    beginDate: ").append(toIndentedString(beginDate)).append("\n");
    sb.append("    cardManufacturingProfileId: ")
        .append(toIndentedString(cardManufacturingProfileId))
        .append("\n");
    sb.append("    closedDate: ").append(toIndentedString(closedDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    lockDate: ").append(toIndentedString(lockDate)).append("\n");
    sb.append("    serviceCenter: ").append(toIndentedString(serviceCenter)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of CardOrder given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of CardOrder
   * @throws JsonProcessingException if the JSON string is invalid with respect to CardOrder
   */
  public static CardOrder fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, CardOrder.class);
  }

  /**
   * Convert an instance of CardOrder to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
