/*
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.balanceplatform;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;
import java.util.Arrays;
import java.util.logging.Logger;

/** Device */
@JsonPropertyOrder({
  Device.JSON_PROPERTY_ID,
  Device.JSON_PROPERTY_NAME,
  Device.JSON_PROPERTY_PAYMENT_INSTRUMENT_ID,
  Device.JSON_PROPERTY_TYPE
})
public class Device {
  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_PAYMENT_INSTRUMENT_ID = "paymentInstrumentId";
  private String paymentInstrumentId;

  /** The type of device. Possible values: **ios**, **android**, **browser**. */
  public enum TypeEnum {
    IOS(String.valueOf("ios")),

    ANDROID(String.valueOf("android")),

    BROWSER(String.valueOf("browser"));

    private static final Logger LOG = Logger.getLogger(TypeEnum.class.getName());

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "TypeEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(TypeEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public Device() {}

  /**
   * The unique identifier of the SCA device.
   *
   * @param id The unique identifier of the SCA device.
   * @return the current {@code Device} instance, allowing for method chaining
   */
  public Device id(String id) {
    this.id = id;
    return this;
  }

  /**
   * The unique identifier of the SCA device.
   *
   * @return id The unique identifier of the SCA device.
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getId() {
    return id;
  }

  /**
   * The unique identifier of the SCA device.
   *
   * @param id The unique identifier of the SCA device.
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }

  /**
   * The name of the SCA device. You can show this name to your user to help them identify the
   * device.
   *
   * @param name The name of the SCA device. You can show this name to your user to help them
   *     identify the device.
   * @return the current {@code Device} instance, allowing for method chaining
   */
  public Device name(String name) {
    this.name = name;
    return this;
  }

  /**
   * The name of the SCA device. You can show this name to your user to help them identify the
   * device.
   *
   * @return name The name of the SCA device. You can show this name to your user to help them
   *     identify the device.
   */
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getName() {
    return name;
  }

  /**
   * The name of the SCA device. You can show this name to your user to help them identify the
   * device.
   *
   * @param name The name of the SCA device. You can show this name to your user to help them
   *     identify the device.
   */
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }

  /**
   * The unique identifier of the payment instrument that is associated with the SCA device.
   *
   * @param paymentInstrumentId The unique identifier of the payment instrument that is associated
   *     with the SCA device.
   * @return the current {@code Device} instance, allowing for method chaining
   */
  public Device paymentInstrumentId(String paymentInstrumentId) {
    this.paymentInstrumentId = paymentInstrumentId;
    return this;
  }

  /**
   * The unique identifier of the payment instrument that is associated with the SCA device.
   *
   * @return paymentInstrumentId The unique identifier of the payment instrument that is associated
   *     with the SCA device.
   */
  @JsonProperty(JSON_PROPERTY_PAYMENT_INSTRUMENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPaymentInstrumentId() {
    return paymentInstrumentId;
  }

  /**
   * The unique identifier of the payment instrument that is associated with the SCA device.
   *
   * @param paymentInstrumentId The unique identifier of the payment instrument that is associated
   *     with the SCA device.
   */
  @JsonProperty(JSON_PROPERTY_PAYMENT_INSTRUMENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentInstrumentId(String paymentInstrumentId) {
    this.paymentInstrumentId = paymentInstrumentId;
  }

  /**
   * The type of device. Possible values: **ios**, **android**, **browser**.
   *
   * @param type The type of device. Possible values: **ios**, **android**, **browser**.
   * @return the current {@code Device} instance, allowing for method chaining
   */
  public Device type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * The type of device. Possible values: **ios**, **android**, **browser**.
   *
   * @return type The type of device. Possible values: **ios**, **android**, **browser**.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * The type of device. Possible values: **ios**, **android**, **browser**.
   *
   * @param type The type of device. Possible values: **ios**, **android**, **browser**.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /** Return true if this Device object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Device device = (Device) o;
    return Objects.equals(this.id, device.id)
        && Objects.equals(this.name, device.name)
        && Objects.equals(this.paymentInstrumentId, device.paymentInstrumentId)
        && Objects.equals(this.type, device.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, paymentInstrumentId, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Device {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    paymentInstrumentId: ")
        .append(toIndentedString(paymentInstrumentId))
        .append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of Device given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of Device
   * @throws JsonProcessingException if the JSON string is invalid with respect to Device
   */
  public static Device fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, Device.class);
  }

  /**
   * Convert an instance of Device to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
