/*
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.balanceplatform;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;
import java.util.ArrayList;
import java.util.List;

/** MccsRestriction */
@JsonPropertyOrder({MccsRestriction.JSON_PROPERTY_OPERATION, MccsRestriction.JSON_PROPERTY_VALUE})
public class MccsRestriction {
  public static final String JSON_PROPERTY_OPERATION = "operation";
  private String operation;

  public static final String JSON_PROPERTY_VALUE = "value";
  private List<String> value;

  public MccsRestriction() {}

  /**
   * Defines how the condition must be evaluated.
   *
   * @param operation Defines how the condition must be evaluated.
   * @return the current {@code MccsRestriction} instance, allowing for method chaining
   */
  public MccsRestriction operation(String operation) {
    this.operation = operation;
    return this;
  }

  /**
   * Defines how the condition must be evaluated.
   *
   * @return operation Defines how the condition must be evaluated.
   */
  @JsonProperty(JSON_PROPERTY_OPERATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getOperation() {
    return operation;
  }

  /**
   * Defines how the condition must be evaluated.
   *
   * @param operation Defines how the condition must be evaluated.
   */
  @JsonProperty(JSON_PROPERTY_OPERATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOperation(String operation) {
    this.operation = operation;
  }

  /**
   * List of merchant category codes (MCCs).
   *
   * @param value List of merchant category codes (MCCs).
   * @return the current {@code MccsRestriction} instance, allowing for method chaining
   */
  public MccsRestriction value(List<String> value) {
    this.value = value;
    return this;
  }

  public MccsRestriction addValueItem(String valueItem) {
    if (this.value == null) {
      this.value = new ArrayList<>();
    }
    this.value.add(valueItem);
    return this;
  }

  /**
   * List of merchant category codes (MCCs).
   *
   * @return value List of merchant category codes (MCCs).
   */
  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getValue() {
    return value;
  }

  /**
   * List of merchant category codes (MCCs).
   *
   * @param value List of merchant category codes (MCCs).
   */
  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValue(List<String> value) {
    this.value = value;
  }

  /** Return true if this MccsRestriction object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MccsRestriction mccsRestriction = (MccsRestriction) o;
    return Objects.equals(this.operation, mccsRestriction.operation)
        && Objects.equals(this.value, mccsRestriction.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(operation, value);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MccsRestriction {\n");
    sb.append("    operation: ").append(toIndentedString(operation)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of MccsRestriction given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of MccsRestriction
   * @throws JsonProcessingException if the JSON string is invalid with respect to MccsRestriction
   */
  public static MccsRestriction fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, MccsRestriction.class);
  }

  /**
   * Convert an instance of MccsRestriction to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
