/*
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.balanceplatform;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;
import java.util.Arrays;
import java.util.logging.Logger;

/** PaymentInstrumentUpdateRequest */
@JsonPropertyOrder({
  PaymentInstrumentUpdateRequest.JSON_PROPERTY_BALANCE_ACCOUNT_ID,
  PaymentInstrumentUpdateRequest.JSON_PROPERTY_CARD,
  PaymentInstrumentUpdateRequest.JSON_PROPERTY_STATUS,
  PaymentInstrumentUpdateRequest.JSON_PROPERTY_STATUS_COMMENT,
  PaymentInstrumentUpdateRequest.JSON_PROPERTY_STATUS_REASON
})
public class PaymentInstrumentUpdateRequest {
  public static final String JSON_PROPERTY_BALANCE_ACCOUNT_ID = "balanceAccountId";
  private String balanceAccountId;

  public static final String JSON_PROPERTY_CARD = "card";
  private CardInfo card;

  /**
   * The status of the payment instrument. If a status is not specified when creating a payment
   * instrument, it is set to **active** by default. However, there can be exceptions for cards
   * based on the &#x60;card.formFactor&#x60; and the &#x60;issuingCountryCode&#x60;. For example,
   * when issuing physical cards in the US, the default status is **inactive**. Possible values: *
   * **active**: The payment instrument is active and can be used to make payments. * **inactive**:
   * The payment instrument is inactive and cannot be used to make payments. * **suspended**: The
   * payment instrument is suspended, either because it was stolen or lost. * **closed**: The
   * payment instrument is permanently closed. This action cannot be undone.
   */
  public enum StatusEnum {
    ACTIVE(String.valueOf("active")),

    CLOSED(String.valueOf("closed")),

    INACTIVE(String.valueOf("inactive")),

    SUSPENDED(String.valueOf("suspended"));

    private static final Logger LOG = Logger.getLogger(StatusEnum.class.getName());

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "StatusEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(StatusEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  public static final String JSON_PROPERTY_STATUS_COMMENT = "statusComment";
  private String statusComment;

  /**
   * The reason for updating the status of the payment instrument. Possible values: **lost**,
   * **stolen**, **damaged**, **suspectedFraud**, **expired**, **endOfLife**, **accountClosure**,
   * **other**. If the reason is **other**, you must also send the &#x60;statusComment&#x60;
   * parameter describing the status change.
   */
  public enum StatusReasonEnum {
    ACCOUNTCLOSURE(String.valueOf("accountClosure")),

    DAMAGED(String.valueOf("damaged")),

    ENDOFLIFE(String.valueOf("endOfLife")),

    EXPIRED(String.valueOf("expired")),

    LOST(String.valueOf("lost")),

    OTHER(String.valueOf("other")),

    STOLEN(String.valueOf("stolen")),

    SUSPECTEDFRAUD(String.valueOf("suspectedFraud")),

    TRANSACTIONRULE(String.valueOf("transactionRule"));

    private static final Logger LOG = Logger.getLogger(StatusReasonEnum.class.getName());

    private String value;

    StatusReasonEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusReasonEnum fromValue(String value) {
      for (StatusReasonEnum b : StatusReasonEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "StatusReasonEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(StatusReasonEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_STATUS_REASON = "statusReason";
  private StatusReasonEnum statusReason;

  public PaymentInstrumentUpdateRequest() {}

  /**
   * The unique identifier of the balance account associated with this payment instrument. &gt;You
   * can only change the balance account ID if the payment instrument has **inactive** status.
   *
   * @param balanceAccountId The unique identifier of the balance account associated with this
   *     payment instrument. &gt;You can only change the balance account ID if the payment
   *     instrument has **inactive** status.
   * @return the current {@code PaymentInstrumentUpdateRequest} instance, allowing for method
   *     chaining
   */
  public PaymentInstrumentUpdateRequest balanceAccountId(String balanceAccountId) {
    this.balanceAccountId = balanceAccountId;
    return this;
  }

  /**
   * The unique identifier of the balance account associated with this payment instrument. &gt;You
   * can only change the balance account ID if the payment instrument has **inactive** status.
   *
   * @return balanceAccountId The unique identifier of the balance account associated with this
   *     payment instrument. &gt;You can only change the balance account ID if the payment
   *     instrument has **inactive** status.
   */
  @JsonProperty(JSON_PROPERTY_BALANCE_ACCOUNT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getBalanceAccountId() {
    return balanceAccountId;
  }

  /**
   * The unique identifier of the balance account associated with this payment instrument. &gt;You
   * can only change the balance account ID if the payment instrument has **inactive** status.
   *
   * @param balanceAccountId The unique identifier of the balance account associated with this
   *     payment instrument. &gt;You can only change the balance account ID if the payment
   *     instrument has **inactive** status.
   */
  @JsonProperty(JSON_PROPERTY_BALANCE_ACCOUNT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBalanceAccountId(String balanceAccountId) {
    this.balanceAccountId = balanceAccountId;
  }

  /**
   * card
   *
   * @param card
   * @return the current {@code PaymentInstrumentUpdateRequest} instance, allowing for method
   *     chaining
   */
  public PaymentInstrumentUpdateRequest card(CardInfo card) {
    this.card = card;
    return this;
  }

  /**
   * Get card
   *
   * @return card
   */
  @JsonProperty(JSON_PROPERTY_CARD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public CardInfo getCard() {
    return card;
  }

  /**
   * card
   *
   * @param card
   */
  @JsonProperty(JSON_PROPERTY_CARD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCard(CardInfo card) {
    this.card = card;
  }

  /**
   * The status of the payment instrument. If a status is not specified when creating a payment
   * instrument, it is set to **active** by default. However, there can be exceptions for cards
   * based on the &#x60;card.formFactor&#x60; and the &#x60;issuingCountryCode&#x60;. For example,
   * when issuing physical cards in the US, the default status is **inactive**. Possible values: *
   * **active**: The payment instrument is active and can be used to make payments. * **inactive**:
   * The payment instrument is inactive and cannot be used to make payments. * **suspended**: The
   * payment instrument is suspended, either because it was stolen or lost. * **closed**: The
   * payment instrument is permanently closed. This action cannot be undone.
   *
   * @param status The status of the payment instrument. If a status is not specified when creating
   *     a payment instrument, it is set to **active** by default. However, there can be exceptions
   *     for cards based on the &#x60;card.formFactor&#x60; and the &#x60;issuingCountryCode&#x60;.
   *     For example, when issuing physical cards in the US, the default status is **inactive**.
   *     Possible values: * **active**: The payment instrument is active and can be used to make
   *     payments. * **inactive**: The payment instrument is inactive and cannot be used to make
   *     payments. * **suspended**: The payment instrument is suspended, either because it was
   *     stolen or lost. * **closed**: The payment instrument is permanently closed. This action
   *     cannot be undone.
   * @return the current {@code PaymentInstrumentUpdateRequest} instance, allowing for method
   *     chaining
   */
  public PaymentInstrumentUpdateRequest status(StatusEnum status) {
    this.status = status;
    return this;
  }

  /**
   * The status of the payment instrument. If a status is not specified when creating a payment
   * instrument, it is set to **active** by default. However, there can be exceptions for cards
   * based on the &#x60;card.formFactor&#x60; and the &#x60;issuingCountryCode&#x60;. For example,
   * when issuing physical cards in the US, the default status is **inactive**. Possible values: *
   * **active**: The payment instrument is active and can be used to make payments. * **inactive**:
   * The payment instrument is inactive and cannot be used to make payments. * **suspended**: The
   * payment instrument is suspended, either because it was stolen or lost. * **closed**: The
   * payment instrument is permanently closed. This action cannot be undone.
   *
   * @return status The status of the payment instrument. If a status is not specified when creating
   *     a payment instrument, it is set to **active** by default. However, there can be exceptions
   *     for cards based on the &#x60;card.formFactor&#x60; and the &#x60;issuingCountryCode&#x60;.
   *     For example, when issuing physical cards in the US, the default status is **inactive**.
   *     Possible values: * **active**: The payment instrument is active and can be used to make
   *     payments. * **inactive**: The payment instrument is inactive and cannot be used to make
   *     payments. * **suspended**: The payment instrument is suspended, either because it was
   *     stolen or lost. * **closed**: The payment instrument is permanently closed. This action
   *     cannot be undone.
   */
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StatusEnum getStatus() {
    return status;
  }

  /**
   * The status of the payment instrument. If a status is not specified when creating a payment
   * instrument, it is set to **active** by default. However, there can be exceptions for cards
   * based on the &#x60;card.formFactor&#x60; and the &#x60;issuingCountryCode&#x60;. For example,
   * when issuing physical cards in the US, the default status is **inactive**. Possible values: *
   * **active**: The payment instrument is active and can be used to make payments. * **inactive**:
   * The payment instrument is inactive and cannot be used to make payments. * **suspended**: The
   * payment instrument is suspended, either because it was stolen or lost. * **closed**: The
   * payment instrument is permanently closed. This action cannot be undone.
   *
   * @param status The status of the payment instrument. If a status is not specified when creating
   *     a payment instrument, it is set to **active** by default. However, there can be exceptions
   *     for cards based on the &#x60;card.formFactor&#x60; and the &#x60;issuingCountryCode&#x60;.
   *     For example, when issuing physical cards in the US, the default status is **inactive**.
   *     Possible values: * **active**: The payment instrument is active and can be used to make
   *     payments. * **inactive**: The payment instrument is inactive and cannot be used to make
   *     payments. * **suspended**: The payment instrument is suspended, either because it was
   *     stolen or lost. * **closed**: The payment instrument is permanently closed. This action
   *     cannot be undone.
   */
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  /**
   * Comment for the status of the payment instrument. Required if &#x60;statusReason&#x60; is
   * **other**.
   *
   * @param statusComment Comment for the status of the payment instrument. Required if
   *     &#x60;statusReason&#x60; is **other**.
   * @return the current {@code PaymentInstrumentUpdateRequest} instance, allowing for method
   *     chaining
   */
  public PaymentInstrumentUpdateRequest statusComment(String statusComment) {
    this.statusComment = statusComment;
    return this;
  }

  /**
   * Comment for the status of the payment instrument. Required if &#x60;statusReason&#x60; is
   * **other**.
   *
   * @return statusComment Comment for the status of the payment instrument. Required if
   *     &#x60;statusReason&#x60; is **other**.
   */
  @JsonProperty(JSON_PROPERTY_STATUS_COMMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getStatusComment() {
    return statusComment;
  }

  /**
   * Comment for the status of the payment instrument. Required if &#x60;statusReason&#x60; is
   * **other**.
   *
   * @param statusComment Comment for the status of the payment instrument. Required if
   *     &#x60;statusReason&#x60; is **other**.
   */
  @JsonProperty(JSON_PROPERTY_STATUS_COMMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatusComment(String statusComment) {
    this.statusComment = statusComment;
  }

  /**
   * The reason for updating the status of the payment instrument. Possible values: **lost**,
   * **stolen**, **damaged**, **suspectedFraud**, **expired**, **endOfLife**, **accountClosure**,
   * **other**. If the reason is **other**, you must also send the &#x60;statusComment&#x60;
   * parameter describing the status change.
   *
   * @param statusReason The reason for updating the status of the payment instrument. Possible
   *     values: **lost**, **stolen**, **damaged**, **suspectedFraud**, **expired**, **endOfLife**,
   *     **accountClosure**, **other**. If the reason is **other**, you must also send the
   *     &#x60;statusComment&#x60; parameter describing the status change.
   * @return the current {@code PaymentInstrumentUpdateRequest} instance, allowing for method
   *     chaining
   */
  public PaymentInstrumentUpdateRequest statusReason(StatusReasonEnum statusReason) {
    this.statusReason = statusReason;
    return this;
  }

  /**
   * The reason for updating the status of the payment instrument. Possible values: **lost**,
   * **stolen**, **damaged**, **suspectedFraud**, **expired**, **endOfLife**, **accountClosure**,
   * **other**. If the reason is **other**, you must also send the &#x60;statusComment&#x60;
   * parameter describing the status change.
   *
   * @return statusReason The reason for updating the status of the payment instrument. Possible
   *     values: **lost**, **stolen**, **damaged**, **suspectedFraud**, **expired**, **endOfLife**,
   *     **accountClosure**, **other**. If the reason is **other**, you must also send the
   *     &#x60;statusComment&#x60; parameter describing the status change.
   */
  @JsonProperty(JSON_PROPERTY_STATUS_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StatusReasonEnum getStatusReason() {
    return statusReason;
  }

  /**
   * The reason for updating the status of the payment instrument. Possible values: **lost**,
   * **stolen**, **damaged**, **suspectedFraud**, **expired**, **endOfLife**, **accountClosure**,
   * **other**. If the reason is **other**, you must also send the &#x60;statusComment&#x60;
   * parameter describing the status change.
   *
   * @param statusReason The reason for updating the status of the payment instrument. Possible
   *     values: **lost**, **stolen**, **damaged**, **suspectedFraud**, **expired**, **endOfLife**,
   *     **accountClosure**, **other**. If the reason is **other**, you must also send the
   *     &#x60;statusComment&#x60; parameter describing the status change.
   */
  @JsonProperty(JSON_PROPERTY_STATUS_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatusReason(StatusReasonEnum statusReason) {
    this.statusReason = statusReason;
  }

  /** Return true if this PaymentInstrumentUpdateRequest object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentInstrumentUpdateRequest paymentInstrumentUpdateRequest =
        (PaymentInstrumentUpdateRequest) o;
    return Objects.equals(this.balanceAccountId, paymentInstrumentUpdateRequest.balanceAccountId)
        && Objects.equals(this.card, paymentInstrumentUpdateRequest.card)
        && Objects.equals(this.status, paymentInstrumentUpdateRequest.status)
        && Objects.equals(this.statusComment, paymentInstrumentUpdateRequest.statusComment)
        && Objects.equals(this.statusReason, paymentInstrumentUpdateRequest.statusReason);
  }

  @Override
  public int hashCode() {
    return Objects.hash(balanceAccountId, card, status, statusComment, statusReason);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentInstrumentUpdateRequest {\n");
    sb.append("    balanceAccountId: ").append(toIndentedString(balanceAccountId)).append("\n");
    sb.append("    card: ").append(toIndentedString(card)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    statusComment: ").append(toIndentedString(statusComment)).append("\n");
    sb.append("    statusReason: ").append(toIndentedString(statusReason)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of PaymentInstrumentUpdateRequest given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of PaymentInstrumentUpdateRequest
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     PaymentInstrumentUpdateRequest
   */
  public static PaymentInstrumentUpdateRequest fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, PaymentInstrumentUpdateRequest.class);
  }

  /**
   * Convert an instance of PaymentInstrumentUpdateRequest to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
