/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.checkout;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

/** CreateOrderResponse */
@JsonPropertyOrder({
  CreateOrderResponse.JSON_PROPERTY_ADDITIONAL_DATA,
  CreateOrderResponse.JSON_PROPERTY_AMOUNT,
  CreateOrderResponse.JSON_PROPERTY_EXPIRES_AT,
  CreateOrderResponse.JSON_PROPERTY_FRAUD_RESULT,
  CreateOrderResponse.JSON_PROPERTY_ORDER_DATA,
  CreateOrderResponse.JSON_PROPERTY_PSP_REFERENCE,
  CreateOrderResponse.JSON_PROPERTY_REFERENCE,
  CreateOrderResponse.JSON_PROPERTY_REFUSAL_REASON,
  CreateOrderResponse.JSON_PROPERTY_REMAINING_AMOUNT,
  CreateOrderResponse.JSON_PROPERTY_RESULT_CODE
})
public class CreateOrderResponse {
  public static final String JSON_PROPERTY_ADDITIONAL_DATA = "additionalData";
  private Map<String, String> additionalData;

  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private Amount amount;

  public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
  private String expiresAt;

  public static final String JSON_PROPERTY_FRAUD_RESULT = "fraudResult";
  private FraudResult fraudResult;

  public static final String JSON_PROPERTY_ORDER_DATA = "orderData";
  private String orderData;

  public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
  private String pspReference;

  public static final String JSON_PROPERTY_REFERENCE = "reference";
  private String reference;

  public static final String JSON_PROPERTY_REFUSAL_REASON = "refusalReason";
  private String refusalReason;

  public static final String JSON_PROPERTY_REMAINING_AMOUNT = "remainingAmount";
  private Amount remainingAmount;

  /** The result of the order creation request. The value is always **Success**. */
  public enum ResultCodeEnum {
    SUCCESS(String.valueOf("Success"));

    private static final Logger LOG = Logger.getLogger(ResultCodeEnum.class.getName());

    private String value;

    ResultCodeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ResultCodeEnum fromValue(String value) {
      for (ResultCodeEnum b : ResultCodeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "ResultCodeEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(ResultCodeEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_RESULT_CODE = "resultCode";
  private ResultCodeEnum resultCode;

  public CreateOrderResponse() {}

  /**
   * Contains additional information about the payment. Some data fields are included only if you
   * select them first: Go to **Customer Area** &gt; **Developers** &gt; **Additional data**.
   *
   * @param additionalData Contains additional information about the payment. Some data fields are
   *     included only if you select them first: Go to **Customer Area** &gt; **Developers** &gt;
   *     **Additional data**.
   * @return the current {@code CreateOrderResponse} instance, allowing for method chaining
   */
  public CreateOrderResponse additionalData(Map<String, String> additionalData) {
    this.additionalData = additionalData;
    return this;
  }

  public CreateOrderResponse putAdditionalDataItem(String key, String additionalDataItem) {
    if (this.additionalData == null) {
      this.additionalData = new HashMap<>();
    }
    this.additionalData.put(key, additionalDataItem);
    return this;
  }

  /**
   * Contains additional information about the payment. Some data fields are included only if you
   * select them first: Go to **Customer Area** &gt; **Developers** &gt; **Additional data**.
   *
   * @return additionalData Contains additional information about the payment. Some data fields are
   *     included only if you select them first: Go to **Customer Area** &gt; **Developers** &gt;
   *     **Additional data**.
   */
  @JsonProperty(JSON_PROPERTY_ADDITIONAL_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Map<String, String> getAdditionalData() {
    return additionalData;
  }

  /**
   * Contains additional information about the payment. Some data fields are included only if you
   * select them first: Go to **Customer Area** &gt; **Developers** &gt; **Additional data**.
   *
   * @param additionalData Contains additional information about the payment. Some data fields are
   *     included only if you select them first: Go to **Customer Area** &gt; **Developers** &gt;
   *     **Additional data**.
   */
  @JsonProperty(JSON_PROPERTY_ADDITIONAL_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdditionalData(Map<String, String> additionalData) {
    this.additionalData = additionalData;
  }

  /**
   * amount
   *
   * @param amount
   * @return the current {@code CreateOrderResponse} instance, allowing for method chaining
   */
  public CreateOrderResponse amount(Amount amount) {
    this.amount = amount;
    return this;
  }

  /**
   * Get amount
   *
   * @return amount
   */
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Amount getAmount() {
    return amount;
  }

  /**
   * amount
   *
   * @param amount
   */
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmount(Amount amount) {
    this.amount = amount;
  }

  /**
   * The date that the order will expire.
   *
   * @param expiresAt The date that the order will expire.
   * @return the current {@code CreateOrderResponse} instance, allowing for method chaining
   */
  public CreateOrderResponse expiresAt(String expiresAt) {
    this.expiresAt = expiresAt;
    return this;
  }

  /**
   * The date that the order will expire.
   *
   * @return expiresAt The date that the order will expire.
   */
  @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getExpiresAt() {
    return expiresAt;
  }

  /**
   * The date that the order will expire.
   *
   * @param expiresAt The date that the order will expire.
   */
  @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExpiresAt(String expiresAt) {
    this.expiresAt = expiresAt;
  }

  /**
   * fraudResult
   *
   * @param fraudResult
   * @return the current {@code CreateOrderResponse} instance, allowing for method chaining
   */
  public CreateOrderResponse fraudResult(FraudResult fraudResult) {
    this.fraudResult = fraudResult;
    return this;
  }

  /**
   * Get fraudResult
   *
   * @return fraudResult
   */
  @JsonProperty(JSON_PROPERTY_FRAUD_RESULT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public FraudResult getFraudResult() {
    return fraudResult;
  }

  /**
   * fraudResult
   *
   * @param fraudResult
   */
  @JsonProperty(JSON_PROPERTY_FRAUD_RESULT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFraudResult(FraudResult fraudResult) {
    this.fraudResult = fraudResult;
  }

  /**
   * The encrypted data that will be used by merchant for adding payments to the order.
   *
   * @param orderData The encrypted data that will be used by merchant for adding payments to the
   *     order.
   * @return the current {@code CreateOrderResponse} instance, allowing for method chaining
   */
  public CreateOrderResponse orderData(String orderData) {
    this.orderData = orderData;
    return this;
  }

  /**
   * The encrypted data that will be used by merchant for adding payments to the order.
   *
   * @return orderData The encrypted data that will be used by merchant for adding payments to the
   *     order.
   */
  @JsonProperty(JSON_PROPERTY_ORDER_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getOrderData() {
    return orderData;
  }

  /**
   * The encrypted data that will be used by merchant for adding payments to the order.
   *
   * @param orderData The encrypted data that will be used by merchant for adding payments to the
   *     order.
   */
  @JsonProperty(JSON_PROPERTY_ORDER_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOrderData(String orderData) {
    this.orderData = orderData;
  }

  /**
   * Adyen&#39;s 16-character reference associated with the transaction/request. This value is
   * globally unique; quote it when communicating with us about this request.
   *
   * @param pspReference Adyen&#39;s 16-character reference associated with the transaction/request.
   *     This value is globally unique; quote it when communicating with us about this request.
   * @return the current {@code CreateOrderResponse} instance, allowing for method chaining
   */
  public CreateOrderResponse pspReference(String pspReference) {
    this.pspReference = pspReference;
    return this;
  }

  /**
   * Adyen&#39;s 16-character reference associated with the transaction/request. This value is
   * globally unique; quote it when communicating with us about this request.
   *
   * @return pspReference Adyen&#39;s 16-character reference associated with the
   *     transaction/request. This value is globally unique; quote it when communicating with us
   *     about this request.
   */
  @JsonProperty(JSON_PROPERTY_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPspReference() {
    return pspReference;
  }

  /**
   * Adyen&#39;s 16-character reference associated with the transaction/request. This value is
   * globally unique; quote it when communicating with us about this request.
   *
   * @param pspReference Adyen&#39;s 16-character reference associated with the transaction/request.
   *     This value is globally unique; quote it when communicating with us about this request.
   */
  @JsonProperty(JSON_PROPERTY_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPspReference(String pspReference) {
    this.pspReference = pspReference;
  }

  /**
   * The reference provided by merchant for creating the order.
   *
   * @param reference The reference provided by merchant for creating the order.
   * @return the current {@code CreateOrderResponse} instance, allowing for method chaining
   */
  public CreateOrderResponse reference(String reference) {
    this.reference = reference;
    return this;
  }

  /**
   * The reference provided by merchant for creating the order.
   *
   * @return reference The reference provided by merchant for creating the order.
   */
  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getReference() {
    return reference;
  }

  /**
   * The reference provided by merchant for creating the order.
   *
   * @param reference The reference provided by merchant for creating the order.
   */
  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReference(String reference) {
    this.reference = reference;
  }

  /**
   * If the payment&#39;s authorisation is refused or an error occurs during authorisation, this
   * field holds Adyen&#39;s mapped reason for the refusal or a description of the error. When a
   * transaction fails, the authorisation response includes &#x60;resultCode&#x60; and
   * &#x60;refusalReason&#x60; values. For more information, see [Refusal
   * reasons](https://docs.adyen.com/development-resources/refusal-reasons).
   *
   * @param refusalReason If the payment&#39;s authorisation is refused or an error occurs during
   *     authorisation, this field holds Adyen&#39;s mapped reason for the refusal or a description
   *     of the error. When a transaction fails, the authorisation response includes
   *     &#x60;resultCode&#x60; and &#x60;refusalReason&#x60; values. For more information, see
   *     [Refusal reasons](https://docs.adyen.com/development-resources/refusal-reasons).
   * @return the current {@code CreateOrderResponse} instance, allowing for method chaining
   */
  public CreateOrderResponse refusalReason(String refusalReason) {
    this.refusalReason = refusalReason;
    return this;
  }

  /**
   * If the payment&#39;s authorisation is refused or an error occurs during authorisation, this
   * field holds Adyen&#39;s mapped reason for the refusal or a description of the error. When a
   * transaction fails, the authorisation response includes &#x60;resultCode&#x60; and
   * &#x60;refusalReason&#x60; values. For more information, see [Refusal
   * reasons](https://docs.adyen.com/development-resources/refusal-reasons).
   *
   * @return refusalReason If the payment&#39;s authorisation is refused or an error occurs during
   *     authorisation, this field holds Adyen&#39;s mapped reason for the refusal or a description
   *     of the error. When a transaction fails, the authorisation response includes
   *     &#x60;resultCode&#x60; and &#x60;refusalReason&#x60; values. For more information, see
   *     [Refusal reasons](https://docs.adyen.com/development-resources/refusal-reasons).
   */
  @JsonProperty(JSON_PROPERTY_REFUSAL_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getRefusalReason() {
    return refusalReason;
  }

  /**
   * If the payment&#39;s authorisation is refused or an error occurs during authorisation, this
   * field holds Adyen&#39;s mapped reason for the refusal or a description of the error. When a
   * transaction fails, the authorisation response includes &#x60;resultCode&#x60; and
   * &#x60;refusalReason&#x60; values. For more information, see [Refusal
   * reasons](https://docs.adyen.com/development-resources/refusal-reasons).
   *
   * @param refusalReason If the payment&#39;s authorisation is refused or an error occurs during
   *     authorisation, this field holds Adyen&#39;s mapped reason for the refusal or a description
   *     of the error. When a transaction fails, the authorisation response includes
   *     &#x60;resultCode&#x60; and &#x60;refusalReason&#x60; values. For more information, see
   *     [Refusal reasons](https://docs.adyen.com/development-resources/refusal-reasons).
   */
  @JsonProperty(JSON_PROPERTY_REFUSAL_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefusalReason(String refusalReason) {
    this.refusalReason = refusalReason;
  }

  /**
   * remainingAmount
   *
   * @param remainingAmount
   * @return the current {@code CreateOrderResponse} instance, allowing for method chaining
   */
  public CreateOrderResponse remainingAmount(Amount remainingAmount) {
    this.remainingAmount = remainingAmount;
    return this;
  }

  /**
   * Get remainingAmount
   *
   * @return remainingAmount
   */
  @JsonProperty(JSON_PROPERTY_REMAINING_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Amount getRemainingAmount() {
    return remainingAmount;
  }

  /**
   * remainingAmount
   *
   * @param remainingAmount
   */
  @JsonProperty(JSON_PROPERTY_REMAINING_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRemainingAmount(Amount remainingAmount) {
    this.remainingAmount = remainingAmount;
  }

  /**
   * The result of the order creation request. The value is always **Success**.
   *
   * @param resultCode The result of the order creation request. The value is always **Success**.
   * @return the current {@code CreateOrderResponse} instance, allowing for method chaining
   */
  public CreateOrderResponse resultCode(ResultCodeEnum resultCode) {
    this.resultCode = resultCode;
    return this;
  }

  /**
   * The result of the order creation request. The value is always **Success**.
   *
   * @return resultCode The result of the order creation request. The value is always **Success**.
   */
  @JsonProperty(JSON_PROPERTY_RESULT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ResultCodeEnum getResultCode() {
    return resultCode;
  }

  /**
   * The result of the order creation request. The value is always **Success**.
   *
   * @param resultCode The result of the order creation request. The value is always **Success**.
   */
  @JsonProperty(JSON_PROPERTY_RESULT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResultCode(ResultCodeEnum resultCode) {
    this.resultCode = resultCode;
  }

  /** Return true if this CreateOrderResponse object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateOrderResponse createOrderResponse = (CreateOrderResponse) o;
    return Objects.equals(this.additionalData, createOrderResponse.additionalData)
        && Objects.equals(this.amount, createOrderResponse.amount)
        && Objects.equals(this.expiresAt, createOrderResponse.expiresAt)
        && Objects.equals(this.fraudResult, createOrderResponse.fraudResult)
        && Objects.equals(this.orderData, createOrderResponse.orderData)
        && Objects.equals(this.pspReference, createOrderResponse.pspReference)
        && Objects.equals(this.reference, createOrderResponse.reference)
        && Objects.equals(this.refusalReason, createOrderResponse.refusalReason)
        && Objects.equals(this.remainingAmount, createOrderResponse.remainingAmount)
        && Objects.equals(this.resultCode, createOrderResponse.resultCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        additionalData,
        amount,
        expiresAt,
        fraudResult,
        orderData,
        pspReference,
        reference,
        refusalReason,
        remainingAmount,
        resultCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateOrderResponse {\n");
    sb.append("    additionalData: ").append(toIndentedString(additionalData)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    expiresAt: ").append(toIndentedString(expiresAt)).append("\n");
    sb.append("    fraudResult: ").append(toIndentedString(fraudResult)).append("\n");
    sb.append("    orderData: ").append(toIndentedString(orderData)).append("\n");
    sb.append("    pspReference: ").append(toIndentedString(pspReference)).append("\n");
    sb.append("    reference: ").append(toIndentedString(reference)).append("\n");
    sb.append("    refusalReason: ").append(toIndentedString(refusalReason)).append("\n");
    sb.append("    remainingAmount: ").append(toIndentedString(remainingAmount)).append("\n");
    sb.append("    resultCode: ").append(toIndentedString(resultCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of CreateOrderResponse given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of CreateOrderResponse
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     CreateOrderResponse
   */
  public static CreateOrderResponse fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, CreateOrderResponse.class);
  }

  /**
   * Convert an instance of CreateOrderResponse to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
