/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.checkout;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.OffsetDateTime;
import java.util.*;

/** Leg */
@JsonPropertyOrder({
  Leg.JSON_PROPERTY_CARRIER_CODE,
  Leg.JSON_PROPERTY_CLASS_OF_TRAVEL,
  Leg.JSON_PROPERTY_DATE_OF_TRAVEL,
  Leg.JSON_PROPERTY_DEPARTURE_AIRPORT_CODE,
  Leg.JSON_PROPERTY_DEPARTURE_TAX,
  Leg.JSON_PROPERTY_DESTINATION_AIRPORT_CODE,
  Leg.JSON_PROPERTY_FARE_BASIS_CODE,
  Leg.JSON_PROPERTY_FLIGHT_NUMBER,
  Leg.JSON_PROPERTY_STOP_OVER_CODE
})
public class Leg {
  public static final String JSON_PROPERTY_CARRIER_CODE = "carrierCode";
  private String carrierCode;

  public static final String JSON_PROPERTY_CLASS_OF_TRAVEL = "classOfTravel";
  private String classOfTravel;

  public static final String JSON_PROPERTY_DATE_OF_TRAVEL = "dateOfTravel";
  private OffsetDateTime dateOfTravel;

  public static final String JSON_PROPERTY_DEPARTURE_AIRPORT_CODE = "departureAirportCode";
  private String departureAirportCode;

  public static final String JSON_PROPERTY_DEPARTURE_TAX = "departureTax";
  private Long departureTax;

  public static final String JSON_PROPERTY_DESTINATION_AIRPORT_CODE = "destinationAirportCode";
  private String destinationAirportCode;

  public static final String JSON_PROPERTY_FARE_BASIS_CODE = "fareBasisCode";
  private String fareBasisCode;

  public static final String JSON_PROPERTY_FLIGHT_NUMBER = "flightNumber";
  private String flightNumber;

  public static final String JSON_PROPERTY_STOP_OVER_CODE = "stopOverCode";
  private String stopOverCode;

  public Leg() {}

  /**
   * The [IATA](https://www.iata.org/services/pages/codes.aspx) 2-letter accounting code (PAX) that
   * identifies the carrier. This field is required if the airline data includes leg details. *
   * Example: KLM &#x3D; KL * minLength: 2 characters * maxLength: 2 characters * Must not start
   * with a space or be all spaces. * Must not be all zeros.
   *
   * @param carrierCode The [IATA](https://www.iata.org/services/pages/codes.aspx) 2-letter
   *     accounting code (PAX) that identifies the carrier. This field is required if the airline
   *     data includes leg details. * Example: KLM &#x3D; KL * minLength: 2 characters * maxLength:
   *     2 characters * Must not start with a space or be all spaces. * Must not be all zeros.
   * @return the current {@code Leg} instance, allowing for method chaining
   */
  public Leg carrierCode(String carrierCode) {
    this.carrierCode = carrierCode;
    return this;
  }

  /**
   * The [IATA](https://www.iata.org/services/pages/codes.aspx) 2-letter accounting code (PAX) that
   * identifies the carrier. This field is required if the airline data includes leg details. *
   * Example: KLM &#x3D; KL * minLength: 2 characters * maxLength: 2 characters * Must not start
   * with a space or be all spaces. * Must not be all zeros.
   *
   * @return carrierCode The [IATA](https://www.iata.org/services/pages/codes.aspx) 2-letter
   *     accounting code (PAX) that identifies the carrier. This field is required if the airline
   *     data includes leg details. * Example: KLM &#x3D; KL * minLength: 2 characters * maxLength:
   *     2 characters * Must not start with a space or be all spaces. * Must not be all zeros.
   */
  @JsonProperty(JSON_PROPERTY_CARRIER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCarrierCode() {
    return carrierCode;
  }

  /**
   * The [IATA](https://www.iata.org/services/pages/codes.aspx) 2-letter accounting code (PAX) that
   * identifies the carrier. This field is required if the airline data includes leg details. *
   * Example: KLM &#x3D; KL * minLength: 2 characters * maxLength: 2 characters * Must not start
   * with a space or be all spaces. * Must not be all zeros.
   *
   * @param carrierCode The [IATA](https://www.iata.org/services/pages/codes.aspx) 2-letter
   *     accounting code (PAX) that identifies the carrier. This field is required if the airline
   *     data includes leg details. * Example: KLM &#x3D; KL * minLength: 2 characters * maxLength:
   *     2 characters * Must not start with a space or be all spaces. * Must not be all zeros.
   */
  @JsonProperty(JSON_PROPERTY_CARRIER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCarrierCode(String carrierCode) {
    this.carrierCode = carrierCode;
  }

  /**
   * A one-letter travel class identifier. The following are common: * F: first class * J: business
   * class * Y: economy class * W: premium economy * Encoding: ASCII * minLength: 1 character *
   * maxLength: 1 character * Must not start with a space or be all spaces. * Must not be all zeros.
   *
   * @param classOfTravel A one-letter travel class identifier. The following are common: * F: first
   *     class * J: business class * Y: economy class * W: premium economy * Encoding: ASCII *
   *     minLength: 1 character * maxLength: 1 character * Must not start with a space or be all
   *     spaces. * Must not be all zeros.
   * @return the current {@code Leg} instance, allowing for method chaining
   */
  public Leg classOfTravel(String classOfTravel) {
    this.classOfTravel = classOfTravel;
    return this;
  }

  /**
   * A one-letter travel class identifier. The following are common: * F: first class * J: business
   * class * Y: economy class * W: premium economy * Encoding: ASCII * minLength: 1 character *
   * maxLength: 1 character * Must not start with a space or be all spaces. * Must not be all zeros.
   *
   * @return classOfTravel A one-letter travel class identifier. The following are common: * F:
   *     first class * J: business class * Y: economy class * W: premium economy * Encoding: ASCII *
   *     minLength: 1 character * maxLength: 1 character * Must not start with a space or be all
   *     spaces. * Must not be all zeros.
   */
  @JsonProperty(JSON_PROPERTY_CLASS_OF_TRAVEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getClassOfTravel() {
    return classOfTravel;
  }

  /**
   * A one-letter travel class identifier. The following are common: * F: first class * J: business
   * class * Y: economy class * W: premium economy * Encoding: ASCII * minLength: 1 character *
   * maxLength: 1 character * Must not start with a space or be all spaces. * Must not be all zeros.
   *
   * @param classOfTravel A one-letter travel class identifier. The following are common: * F: first
   *     class * J: business class * Y: economy class * W: premium economy * Encoding: ASCII *
   *     minLength: 1 character * maxLength: 1 character * Must not start with a space or be all
   *     spaces. * Must not be all zeros.
   */
  @JsonProperty(JSON_PROPERTY_CLASS_OF_TRAVEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClassOfTravel(String classOfTravel) {
    this.classOfTravel = classOfTravel;
  }

  /**
   * Date and time of travel in format &#x60;yyyy-MM-ddTHH:mm&#x60;. * Use local time of departure
   * airport. * minLength: 16 characters * maxLength: 16 characters
   *
   * @param dateOfTravel Date and time of travel in format &#x60;yyyy-MM-ddTHH:mm&#x60;. * Use local
   *     time of departure airport. * minLength: 16 characters * maxLength: 16 characters
   * @return the current {@code Leg} instance, allowing for method chaining
   */
  public Leg dateOfTravel(OffsetDateTime dateOfTravel) {
    this.dateOfTravel = dateOfTravel;
    return this;
  }

  /**
   * Date and time of travel in format &#x60;yyyy-MM-ddTHH:mm&#x60;. * Use local time of departure
   * airport. * minLength: 16 characters * maxLength: 16 characters
   *
   * @return dateOfTravel Date and time of travel in format &#x60;yyyy-MM-ddTHH:mm&#x60;. * Use
   *     local time of departure airport. * minLength: 16 characters * maxLength: 16 characters
   */
  @JsonProperty(JSON_PROPERTY_DATE_OF_TRAVEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getDateOfTravel() {
    return dateOfTravel;
  }

  /**
   * Date and time of travel in format &#x60;yyyy-MM-ddTHH:mm&#x60;. * Use local time of departure
   * airport. * minLength: 16 characters * maxLength: 16 characters
   *
   * @param dateOfTravel Date and time of travel in format &#x60;yyyy-MM-ddTHH:mm&#x60;. * Use local
   *     time of departure airport. * minLength: 16 characters * maxLength: 16 characters
   */
  @JsonProperty(JSON_PROPERTY_DATE_OF_TRAVEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDateOfTravel(OffsetDateTime dateOfTravel) {
    this.dateOfTravel = dateOfTravel;
  }

  /**
   * The [IATA](https://www.iata.org/services/pages/codes.aspx) three-letter airport code of the
   * departure airport. This field is required if the airline data includes leg details. * Encoding:
   * ASCII * Example: Amsterdam &#x3D; AMS * minLength: 3 characters * maxLength: 3 characters *
   * Must not start with a space or be all spaces. * Must not be all zeros.
   *
   * @param departureAirportCode The [IATA](https://www.iata.org/services/pages/codes.aspx)
   *     three-letter airport code of the departure airport. This field is required if the airline
   *     data includes leg details. * Encoding: ASCII * Example: Amsterdam &#x3D; AMS * minLength: 3
   *     characters * maxLength: 3 characters * Must not start with a space or be all spaces. * Must
   *     not be all zeros.
   * @return the current {@code Leg} instance, allowing for method chaining
   */
  public Leg departureAirportCode(String departureAirportCode) {
    this.departureAirportCode = departureAirportCode;
    return this;
  }

  /**
   * The [IATA](https://www.iata.org/services/pages/codes.aspx) three-letter airport code of the
   * departure airport. This field is required if the airline data includes leg details. * Encoding:
   * ASCII * Example: Amsterdam &#x3D; AMS * minLength: 3 characters * maxLength: 3 characters *
   * Must not start with a space or be all spaces. * Must not be all zeros.
   *
   * @return departureAirportCode The [IATA](https://www.iata.org/services/pages/codes.aspx)
   *     three-letter airport code of the departure airport. This field is required if the airline
   *     data includes leg details. * Encoding: ASCII * Example: Amsterdam &#x3D; AMS * minLength: 3
   *     characters * maxLength: 3 characters * Must not start with a space or be all spaces. * Must
   *     not be all zeros.
   */
  @JsonProperty(JSON_PROPERTY_DEPARTURE_AIRPORT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDepartureAirportCode() {
    return departureAirportCode;
  }

  /**
   * The [IATA](https://www.iata.org/services/pages/codes.aspx) three-letter airport code of the
   * departure airport. This field is required if the airline data includes leg details. * Encoding:
   * ASCII * Example: Amsterdam &#x3D; AMS * minLength: 3 characters * maxLength: 3 characters *
   * Must not start with a space or be all spaces. * Must not be all zeros.
   *
   * @param departureAirportCode The [IATA](https://www.iata.org/services/pages/codes.aspx)
   *     three-letter airport code of the departure airport. This field is required if the airline
   *     data includes leg details. * Encoding: ASCII * Example: Amsterdam &#x3D; AMS * minLength: 3
   *     characters * maxLength: 3 characters * Must not start with a space or be all spaces. * Must
   *     not be all zeros.
   */
  @JsonProperty(JSON_PROPERTY_DEPARTURE_AIRPORT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDepartureAirportCode(String departureAirportCode) {
    this.departureAirportCode = departureAirportCode;
  }

  /**
   * The amount of [departure tax](https://en.wikipedia.org/wiki/Departure_tax) charged, in [minor
   * units](https://docs.adyen.com/development-resources/currency-codes). * Encoding: Numeric *
   * minLength: 1 * maxLength: 11 * Must not be all zeros.
   *
   * @param departureTax The amount of [departure tax](https://en.wikipedia.org/wiki/Departure_tax)
   *     charged, in [minor units](https://docs.adyen.com/development-resources/currency-codes). *
   *     Encoding: Numeric * minLength: 1 * maxLength: 11 * Must not be all zeros.
   * @return the current {@code Leg} instance, allowing for method chaining
   */
  public Leg departureTax(Long departureTax) {
    this.departureTax = departureTax;
    return this;
  }

  /**
   * The amount of [departure tax](https://en.wikipedia.org/wiki/Departure_tax) charged, in [minor
   * units](https://docs.adyen.com/development-resources/currency-codes). * Encoding: Numeric *
   * minLength: 1 * maxLength: 11 * Must not be all zeros.
   *
   * @return departureTax The amount of [departure tax](https://en.wikipedia.org/wiki/Departure_tax)
   *     charged, in [minor units](https://docs.adyen.com/development-resources/currency-codes). *
   *     Encoding: Numeric * minLength: 1 * maxLength: 11 * Must not be all zeros.
   */
  @JsonProperty(JSON_PROPERTY_DEPARTURE_TAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Long getDepartureTax() {
    return departureTax;
  }

  /**
   * The amount of [departure tax](https://en.wikipedia.org/wiki/Departure_tax) charged, in [minor
   * units](https://docs.adyen.com/development-resources/currency-codes). * Encoding: Numeric *
   * minLength: 1 * maxLength: 11 * Must not be all zeros.
   *
   * @param departureTax The amount of [departure tax](https://en.wikipedia.org/wiki/Departure_tax)
   *     charged, in [minor units](https://docs.adyen.com/development-resources/currency-codes). *
   *     Encoding: Numeric * minLength: 1 * maxLength: 11 * Must not be all zeros.
   */
  @JsonProperty(JSON_PROPERTY_DEPARTURE_TAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDepartureTax(Long departureTax) {
    this.departureTax = departureTax;
  }

  /**
   * The [IATA](https://www.iata.org/services/pages/codes.aspx) 3-letter airport code of the
   * destination airport. This field is required if the airline data includes leg details. *
   * Example: Amsterdam &#x3D; AMS * Encoding: ASCII * minLength: 3 characters * maxLength: 3
   * characters * Must not start with a space or be all spaces. * Must not be all zeros.
   *
   * @param destinationAirportCode The [IATA](https://www.iata.org/services/pages/codes.aspx)
   *     3-letter airport code of the destination airport. This field is required if the airline
   *     data includes leg details. * Example: Amsterdam &#x3D; AMS * Encoding: ASCII * minLength: 3
   *     characters * maxLength: 3 characters * Must not start with a space or be all spaces. * Must
   *     not be all zeros.
   * @return the current {@code Leg} instance, allowing for method chaining
   */
  public Leg destinationAirportCode(String destinationAirportCode) {
    this.destinationAirportCode = destinationAirportCode;
    return this;
  }

  /**
   * The [IATA](https://www.iata.org/services/pages/codes.aspx) 3-letter airport code of the
   * destination airport. This field is required if the airline data includes leg details. *
   * Example: Amsterdam &#x3D; AMS * Encoding: ASCII * minLength: 3 characters * maxLength: 3
   * characters * Must not start with a space or be all spaces. * Must not be all zeros.
   *
   * @return destinationAirportCode The [IATA](https://www.iata.org/services/pages/codes.aspx)
   *     3-letter airport code of the destination airport. This field is required if the airline
   *     data includes leg details. * Example: Amsterdam &#x3D; AMS * Encoding: ASCII * minLength: 3
   *     characters * maxLength: 3 characters * Must not start with a space or be all spaces. * Must
   *     not be all zeros.
   */
  @JsonProperty(JSON_PROPERTY_DESTINATION_AIRPORT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDestinationAirportCode() {
    return destinationAirportCode;
  }

  /**
   * The [IATA](https://www.iata.org/services/pages/codes.aspx) 3-letter airport code of the
   * destination airport. This field is required if the airline data includes leg details. *
   * Example: Amsterdam &#x3D; AMS * Encoding: ASCII * minLength: 3 characters * maxLength: 3
   * characters * Must not start with a space or be all spaces. * Must not be all zeros.
   *
   * @param destinationAirportCode The [IATA](https://www.iata.org/services/pages/codes.aspx)
   *     3-letter airport code of the destination airport. This field is required if the airline
   *     data includes leg details. * Example: Amsterdam &#x3D; AMS * Encoding: ASCII * minLength: 3
   *     characters * maxLength: 3 characters * Must not start with a space or be all spaces. * Must
   *     not be all zeros.
   */
  @JsonProperty(JSON_PROPERTY_DESTINATION_AIRPORT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDestinationAirportCode(String destinationAirportCode) {
    this.destinationAirportCode = destinationAirportCode;
  }

  /**
   * The [fare basis code](https://en.wikipedia.org/wiki/Fare_basis_code), alphanumeric. *
   * minLength: 1 character * maxLength: 6 characters * Must not start with a space or be all
   * spaces. * Must not be all zeros.
   *
   * @param fareBasisCode The [fare basis code](https://en.wikipedia.org/wiki/Fare_basis_code),
   *     alphanumeric. * minLength: 1 character * maxLength: 6 characters * Must not start with a
   *     space or be all spaces. * Must not be all zeros.
   * @return the current {@code Leg} instance, allowing for method chaining
   */
  public Leg fareBasisCode(String fareBasisCode) {
    this.fareBasisCode = fareBasisCode;
    return this;
  }

  /**
   * The [fare basis code](https://en.wikipedia.org/wiki/Fare_basis_code), alphanumeric. *
   * minLength: 1 character * maxLength: 6 characters * Must not start with a space or be all
   * spaces. * Must not be all zeros.
   *
   * @return fareBasisCode The [fare basis code](https://en.wikipedia.org/wiki/Fare_basis_code),
   *     alphanumeric. * minLength: 1 character * maxLength: 6 characters * Must not start with a
   *     space or be all spaces. * Must not be all zeros.
   */
  @JsonProperty(JSON_PROPERTY_FARE_BASIS_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getFareBasisCode() {
    return fareBasisCode;
  }

  /**
   * The [fare basis code](https://en.wikipedia.org/wiki/Fare_basis_code), alphanumeric. *
   * minLength: 1 character * maxLength: 6 characters * Must not start with a space or be all
   * spaces. * Must not be all zeros.
   *
   * @param fareBasisCode The [fare basis code](https://en.wikipedia.org/wiki/Fare_basis_code),
   *     alphanumeric. * minLength: 1 character * maxLength: 6 characters * Must not start with a
   *     space or be all spaces. * Must not be all zeros.
   */
  @JsonProperty(JSON_PROPERTY_FARE_BASIS_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFareBasisCode(String fareBasisCode) {
    this.fareBasisCode = fareBasisCode;
  }

  /**
   * The flight identifier. * minLength: 1 character * maxLength: 5 characters * Must not start with
   * a space or be all spaces. * Must not be all zeros.
   *
   * @param flightNumber The flight identifier. * minLength: 1 character * maxLength: 5 characters *
   *     Must not start with a space or be all spaces. * Must not be all zeros.
   * @return the current {@code Leg} instance, allowing for method chaining
   */
  public Leg flightNumber(String flightNumber) {
    this.flightNumber = flightNumber;
    return this;
  }

  /**
   * The flight identifier. * minLength: 1 character * maxLength: 5 characters * Must not start with
   * a space or be all spaces. * Must not be all zeros.
   *
   * @return flightNumber The flight identifier. * minLength: 1 character * maxLength: 5 characters
   *     * Must not start with a space or be all spaces. * Must not be all zeros.
   */
  @JsonProperty(JSON_PROPERTY_FLIGHT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getFlightNumber() {
    return flightNumber;
  }

  /**
   * The flight identifier. * minLength: 1 character * maxLength: 5 characters * Must not start with
   * a space or be all spaces. * Must not be all zeros.
   *
   * @param flightNumber The flight identifier. * minLength: 1 character * maxLength: 5 characters *
   *     Must not start with a space or be all spaces. * Must not be all zeros.
   */
  @JsonProperty(JSON_PROPERTY_FLIGHT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFlightNumber(String flightNumber) {
    this.flightNumber = flightNumber;
  }

  /**
   * A one-letter code that indicates whether the passenger is entitled to make a stopover. Can be a
   * space, O if the passenger is entitled to make a stopover, or X if they are not. * Encoding:
   * ASCII * minLength: 1 character * maxLength: 1 character
   *
   * @param stopOverCode A one-letter code that indicates whether the passenger is entitled to make
   *     a stopover. Can be a space, O if the passenger is entitled to make a stopover, or X if they
   *     are not. * Encoding: ASCII * minLength: 1 character * maxLength: 1 character
   * @return the current {@code Leg} instance, allowing for method chaining
   */
  public Leg stopOverCode(String stopOverCode) {
    this.stopOverCode = stopOverCode;
    return this;
  }

  /**
   * A one-letter code that indicates whether the passenger is entitled to make a stopover. Can be a
   * space, O if the passenger is entitled to make a stopover, or X if they are not. * Encoding:
   * ASCII * minLength: 1 character * maxLength: 1 character
   *
   * @return stopOverCode A one-letter code that indicates whether the passenger is entitled to make
   *     a stopover. Can be a space, O if the passenger is entitled to make a stopover, or X if they
   *     are not. * Encoding: ASCII * minLength: 1 character * maxLength: 1 character
   */
  @JsonProperty(JSON_PROPERTY_STOP_OVER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getStopOverCode() {
    return stopOverCode;
  }

  /**
   * A one-letter code that indicates whether the passenger is entitled to make a stopover. Can be a
   * space, O if the passenger is entitled to make a stopover, or X if they are not. * Encoding:
   * ASCII * minLength: 1 character * maxLength: 1 character
   *
   * @param stopOverCode A one-letter code that indicates whether the passenger is entitled to make
   *     a stopover. Can be a space, O if the passenger is entitled to make a stopover, or X if they
   *     are not. * Encoding: ASCII * minLength: 1 character * maxLength: 1 character
   */
  @JsonProperty(JSON_PROPERTY_STOP_OVER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStopOverCode(String stopOverCode) {
    this.stopOverCode = stopOverCode;
  }

  /** Return true if this Leg object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Leg leg = (Leg) o;
    return Objects.equals(this.carrierCode, leg.carrierCode)
        && Objects.equals(this.classOfTravel, leg.classOfTravel)
        && Objects.equals(this.dateOfTravel, leg.dateOfTravel)
        && Objects.equals(this.departureAirportCode, leg.departureAirportCode)
        && Objects.equals(this.departureTax, leg.departureTax)
        && Objects.equals(this.destinationAirportCode, leg.destinationAirportCode)
        && Objects.equals(this.fareBasisCode, leg.fareBasisCode)
        && Objects.equals(this.flightNumber, leg.flightNumber)
        && Objects.equals(this.stopOverCode, leg.stopOverCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        carrierCode,
        classOfTravel,
        dateOfTravel,
        departureAirportCode,
        departureTax,
        destinationAirportCode,
        fareBasisCode,
        flightNumber,
        stopOverCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Leg {\n");
    sb.append("    carrierCode: ").append(toIndentedString(carrierCode)).append("\n");
    sb.append("    classOfTravel: ").append(toIndentedString(classOfTravel)).append("\n");
    sb.append("    dateOfTravel: ").append(toIndentedString(dateOfTravel)).append("\n");
    sb.append("    departureAirportCode: ")
        .append(toIndentedString(departureAirportCode))
        .append("\n");
    sb.append("    departureTax: ").append(toIndentedString(departureTax)).append("\n");
    sb.append("    destinationAirportCode: ")
        .append(toIndentedString(destinationAirportCode))
        .append("\n");
    sb.append("    fareBasisCode: ").append(toIndentedString(fareBasisCode)).append("\n");
    sb.append("    flightNumber: ").append(toIndentedString(flightNumber)).append("\n");
    sb.append("    stopOverCode: ").append(toIndentedString(stopOverCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of Leg given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of Leg
   * @throws JsonProcessingException if the JSON string is invalid with respect to Leg
   */
  public static Leg fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, Leg.class);
  }

  /**
   * Convert an instance of Leg to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
