/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.checkout;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;
import java.util.ArrayList;
import java.util.List;

/** ListStoredPaymentMethodsResponse */
@JsonPropertyOrder({
  ListStoredPaymentMethodsResponse.JSON_PROPERTY_MERCHANT_ACCOUNT,
  ListStoredPaymentMethodsResponse.JSON_PROPERTY_SHOPPER_REFERENCE,
  ListStoredPaymentMethodsResponse.JSON_PROPERTY_STORED_PAYMENT_METHODS
})
public class ListStoredPaymentMethodsResponse {
  public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
  private String merchantAccount;

  public static final String JSON_PROPERTY_SHOPPER_REFERENCE = "shopperReference";
  private String shopperReference;

  public static final String JSON_PROPERTY_STORED_PAYMENT_METHODS = "storedPaymentMethods";
  private List<StoredPaymentMethodResource> storedPaymentMethods;

  public ListStoredPaymentMethodsResponse() {}

  /**
   * Your merchant account.
   *
   * @param merchantAccount Your merchant account.
   * @return the current {@code ListStoredPaymentMethodsResponse} instance, allowing for method
   *     chaining
   */
  public ListStoredPaymentMethodsResponse merchantAccount(String merchantAccount) {
    this.merchantAccount = merchantAccount;
    return this;
  }

  /**
   * Your merchant account.
   *
   * @return merchantAccount Your merchant account.
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMerchantAccount() {
    return merchantAccount;
  }

  /**
   * Your merchant account.
   *
   * @param merchantAccount Your merchant account.
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantAccount(String merchantAccount) {
    this.merchantAccount = merchantAccount;
  }

  /**
   * Your reference to uniquely identify this shopper, for example user ID or account ID. Minimum
   * length: 3 characters. &gt; Your reference must not include personally identifiable information
   * (PII), for example name or email address.
   *
   * @param shopperReference Your reference to uniquely identify this shopper, for example user ID
   *     or account ID. Minimum length: 3 characters. &gt; Your reference must not include
   *     personally identifiable information (PII), for example name or email address.
   * @return the current {@code ListStoredPaymentMethodsResponse} instance, allowing for method
   *     chaining
   */
  public ListStoredPaymentMethodsResponse shopperReference(String shopperReference) {
    this.shopperReference = shopperReference;
    return this;
  }

  /**
   * Your reference to uniquely identify this shopper, for example user ID or account ID. Minimum
   * length: 3 characters. &gt; Your reference must not include personally identifiable information
   * (PII), for example name or email address.
   *
   * @return shopperReference Your reference to uniquely identify this shopper, for example user ID
   *     or account ID. Minimum length: 3 characters. &gt; Your reference must not include
   *     personally identifiable information (PII), for example name or email address.
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getShopperReference() {
    return shopperReference;
  }

  /**
   * Your reference to uniquely identify this shopper, for example user ID or account ID. Minimum
   * length: 3 characters. &gt; Your reference must not include personally identifiable information
   * (PII), for example name or email address.
   *
   * @param shopperReference Your reference to uniquely identify this shopper, for example user ID
   *     or account ID. Minimum length: 3 characters. &gt; Your reference must not include
   *     personally identifiable information (PII), for example name or email address.
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperReference(String shopperReference) {
    this.shopperReference = shopperReference;
  }

  /**
   * List of all stored payment methods.
   *
   * @param storedPaymentMethods List of all stored payment methods.
   * @return the current {@code ListStoredPaymentMethodsResponse} instance, allowing for method
   *     chaining
   */
  public ListStoredPaymentMethodsResponse storedPaymentMethods(
      List<StoredPaymentMethodResource> storedPaymentMethods) {
    this.storedPaymentMethods = storedPaymentMethods;
    return this;
  }

  public ListStoredPaymentMethodsResponse addStoredPaymentMethodsItem(
      StoredPaymentMethodResource storedPaymentMethodsItem) {
    if (this.storedPaymentMethods == null) {
      this.storedPaymentMethods = new ArrayList<>();
    }
    this.storedPaymentMethods.add(storedPaymentMethodsItem);
    return this;
  }

  /**
   * List of all stored payment methods.
   *
   * @return storedPaymentMethods List of all stored payment methods.
   */
  @JsonProperty(JSON_PROPERTY_STORED_PAYMENT_METHODS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<StoredPaymentMethodResource> getStoredPaymentMethods() {
    return storedPaymentMethods;
  }

  /**
   * List of all stored payment methods.
   *
   * @param storedPaymentMethods List of all stored payment methods.
   */
  @JsonProperty(JSON_PROPERTY_STORED_PAYMENT_METHODS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStoredPaymentMethods(List<StoredPaymentMethodResource> storedPaymentMethods) {
    this.storedPaymentMethods = storedPaymentMethods;
  }

  /** Return true if this ListStoredPaymentMethodsResponse object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ListStoredPaymentMethodsResponse listStoredPaymentMethodsResponse =
        (ListStoredPaymentMethodsResponse) o;
    return Objects.equals(this.merchantAccount, listStoredPaymentMethodsResponse.merchantAccount)
        && Objects.equals(this.shopperReference, listStoredPaymentMethodsResponse.shopperReference)
        && Objects.equals(
            this.storedPaymentMethods, listStoredPaymentMethodsResponse.storedPaymentMethods);
  }

  @Override
  public int hashCode() {
    return Objects.hash(merchantAccount, shopperReference, storedPaymentMethods);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ListStoredPaymentMethodsResponse {\n");
    sb.append("    merchantAccount: ").append(toIndentedString(merchantAccount)).append("\n");
    sb.append("    shopperReference: ").append(toIndentedString(shopperReference)).append("\n");
    sb.append("    storedPaymentMethods: ")
        .append(toIndentedString(storedPaymentMethods))
        .append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of ListStoredPaymentMethodsResponse given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of ListStoredPaymentMethodsResponse
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     ListStoredPaymentMethodsResponse
   */
  public static ListStoredPaymentMethodsResponse fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, ListStoredPaymentMethodsResponse.class);
  }

  /**
   * Convert an instance of ListStoredPaymentMethodsResponse to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
