/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.checkout;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.LocalDate;
import java.util.*;

/** Passenger */
@JsonPropertyOrder({
  Passenger.JSON_PROPERTY_DATE_OF_BIRTH,
  Passenger.JSON_PROPERTY_FIRST_NAME,
  Passenger.JSON_PROPERTY_LAST_NAME,
  Passenger.JSON_PROPERTY_PHONE_NUMBER,
  Passenger.JSON_PROPERTY_TRAVELLER_TYPE
})
public class Passenger {
  public static final String JSON_PROPERTY_DATE_OF_BIRTH = "dateOfBirth";
  private LocalDate dateOfBirth;

  public static final String JSON_PROPERTY_FIRST_NAME = "firstName";
  private String firstName;

  public static final String JSON_PROPERTY_LAST_NAME = "lastName";
  private String lastName;

  public static final String JSON_PROPERTY_PHONE_NUMBER = "phoneNumber";
  private String phoneNumber;

  public static final String JSON_PROPERTY_TRAVELLER_TYPE = "travellerType";
  private String travellerType;

  public Passenger() {}

  /**
   * The passenger&#39;s date of birth. * Format &#x60;yyyy-MM-dd&#x60; * minLength: 10 * maxLength:
   * 10
   *
   * @param dateOfBirth The passenger&#39;s date of birth. * Format &#x60;yyyy-MM-dd&#x60; *
   *     minLength: 10 * maxLength: 10
   * @return the current {@code Passenger} instance, allowing for method chaining
   */
  public Passenger dateOfBirth(LocalDate dateOfBirth) {
    this.dateOfBirth = dateOfBirth;
    return this;
  }

  /**
   * The passenger&#39;s date of birth. * Format &#x60;yyyy-MM-dd&#x60; * minLength: 10 * maxLength:
   * 10
   *
   * @return dateOfBirth The passenger&#39;s date of birth. * Format &#x60;yyyy-MM-dd&#x60; *
   *     minLength: 10 * maxLength: 10
   */
  @JsonProperty(JSON_PROPERTY_DATE_OF_BIRTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public LocalDate getDateOfBirth() {
    return dateOfBirth;
  }

  /**
   * The passenger&#39;s date of birth. * Format &#x60;yyyy-MM-dd&#x60; * minLength: 10 * maxLength:
   * 10
   *
   * @param dateOfBirth The passenger&#39;s date of birth. * Format &#x60;yyyy-MM-dd&#x60; *
   *     minLength: 10 * maxLength: 10
   */
  @JsonProperty(JSON_PROPERTY_DATE_OF_BIRTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDateOfBirth(LocalDate dateOfBirth) {
    this.dateOfBirth = dateOfBirth;
  }

  /**
   * The passenger&#39;s first name. &gt; This field is required if the airline data includes
   * passenger details or leg details. * Encoding: ASCII
   *
   * @param firstName The passenger&#39;s first name. &gt; This field is required if the airline
   *     data includes passenger details or leg details. * Encoding: ASCII
   * @return the current {@code Passenger} instance, allowing for method chaining
   */
  public Passenger firstName(String firstName) {
    this.firstName = firstName;
    return this;
  }

  /**
   * The passenger&#39;s first name. &gt; This field is required if the airline data includes
   * passenger details or leg details. * Encoding: ASCII
   *
   * @return firstName The passenger&#39;s first name. &gt; This field is required if the airline
   *     data includes passenger details or leg details. * Encoding: ASCII
   */
  @JsonProperty(JSON_PROPERTY_FIRST_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getFirstName() {
    return firstName;
  }

  /**
   * The passenger&#39;s first name. &gt; This field is required if the airline data includes
   * passenger details or leg details. * Encoding: ASCII
   *
   * @param firstName The passenger&#39;s first name. &gt; This field is required if the airline
   *     data includes passenger details or leg details. * Encoding: ASCII
   */
  @JsonProperty(JSON_PROPERTY_FIRST_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFirstName(String firstName) {
    this.firstName = firstName;
  }

  /**
   * The passenger&#39;s last name. &gt; This field is required if the airline data includes
   * passenger details or leg details. * Encoding: ASCII
   *
   * @param lastName The passenger&#39;s last name. &gt; This field is required if the airline data
   *     includes passenger details or leg details. * Encoding: ASCII
   * @return the current {@code Passenger} instance, allowing for method chaining
   */
  public Passenger lastName(String lastName) {
    this.lastName = lastName;
    return this;
  }

  /**
   * The passenger&#39;s last name. &gt; This field is required if the airline data includes
   * passenger details or leg details. * Encoding: ASCII
   *
   * @return lastName The passenger&#39;s last name. &gt; This field is required if the airline data
   *     includes passenger details or leg details. * Encoding: ASCII
   */
  @JsonProperty(JSON_PROPERTY_LAST_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getLastName() {
    return lastName;
  }

  /**
   * The passenger&#39;s last name. &gt; This field is required if the airline data includes
   * passenger details or leg details. * Encoding: ASCII
   *
   * @param lastName The passenger&#39;s last name. &gt; This field is required if the airline data
   *     includes passenger details or leg details. * Encoding: ASCII
   */
  @JsonProperty(JSON_PROPERTY_LAST_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastName(String lastName) {
    this.lastName = lastName;
  }

  /**
   * The passenger&#39;s phone number, including country code. This is an alphanumeric field that
   * can include the &#39;+&#39; and &#39;-&#39; signs. * Encoding: ASCII * minLength: 3 characters
   * * maxLength: 30 characters
   *
   * @param phoneNumber The passenger&#39;s phone number, including country code. This is an
   *     alphanumeric field that can include the &#39;+&#39; and &#39;-&#39; signs. * Encoding:
   *     ASCII * minLength: 3 characters * maxLength: 30 characters
   * @return the current {@code Passenger} instance, allowing for method chaining
   */
  public Passenger phoneNumber(String phoneNumber) {
    this.phoneNumber = phoneNumber;
    return this;
  }

  /**
   * The passenger&#39;s phone number, including country code. This is an alphanumeric field that
   * can include the &#39;+&#39; and &#39;-&#39; signs. * Encoding: ASCII * minLength: 3 characters
   * * maxLength: 30 characters
   *
   * @return phoneNumber The passenger&#39;s phone number, including country code. This is an
   *     alphanumeric field that can include the &#39;+&#39; and &#39;-&#39; signs. * Encoding:
   *     ASCII * minLength: 3 characters * maxLength: 30 characters
   */
  @JsonProperty(JSON_PROPERTY_PHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPhoneNumber() {
    return phoneNumber;
  }

  /**
   * The passenger&#39;s phone number, including country code. This is an alphanumeric field that
   * can include the &#39;+&#39; and &#39;-&#39; signs. * Encoding: ASCII * minLength: 3 characters
   * * maxLength: 30 characters
   *
   * @param phoneNumber The passenger&#39;s phone number, including country code. This is an
   *     alphanumeric field that can include the &#39;+&#39; and &#39;-&#39; signs. * Encoding:
   *     ASCII * minLength: 3 characters * maxLength: 30 characters
   */
  @JsonProperty(JSON_PROPERTY_PHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPhoneNumber(String phoneNumber) {
    this.phoneNumber = phoneNumber;
  }

  /**
   * The IATA passenger type code (PTC). * Encoding: ASCII * minLength: 3 characters * maxLength: 6
   * characters
   *
   * @param travellerType The IATA passenger type code (PTC). * Encoding: ASCII * minLength: 3
   *     characters * maxLength: 6 characters
   * @return the current {@code Passenger} instance, allowing for method chaining
   */
  public Passenger travellerType(String travellerType) {
    this.travellerType = travellerType;
    return this;
  }

  /**
   * The IATA passenger type code (PTC). * Encoding: ASCII * minLength: 3 characters * maxLength: 6
   * characters
   *
   * @return travellerType The IATA passenger type code (PTC). * Encoding: ASCII * minLength: 3
   *     characters * maxLength: 6 characters
   */
  @JsonProperty(JSON_PROPERTY_TRAVELLER_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getTravellerType() {
    return travellerType;
  }

  /**
   * The IATA passenger type code (PTC). * Encoding: ASCII * minLength: 3 characters * maxLength: 6
   * characters
   *
   * @param travellerType The IATA passenger type code (PTC). * Encoding: ASCII * minLength: 3
   *     characters * maxLength: 6 characters
   */
  @JsonProperty(JSON_PROPERTY_TRAVELLER_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTravellerType(String travellerType) {
    this.travellerType = travellerType;
  }

  /** Return true if this Passenger object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Passenger passenger = (Passenger) o;
    return Objects.equals(this.dateOfBirth, passenger.dateOfBirth)
        && Objects.equals(this.firstName, passenger.firstName)
        && Objects.equals(this.lastName, passenger.lastName)
        && Objects.equals(this.phoneNumber, passenger.phoneNumber)
        && Objects.equals(this.travellerType, passenger.travellerType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dateOfBirth, firstName, lastName, phoneNumber, travellerType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Passenger {\n");
    sb.append("    dateOfBirth: ").append(toIndentedString(dateOfBirth)).append("\n");
    sb.append("    firstName: ").append(toIndentedString(firstName)).append("\n");
    sb.append("    lastName: ").append(toIndentedString(lastName)).append("\n");
    sb.append("    phoneNumber: ").append(toIndentedString(phoneNumber)).append("\n");
    sb.append("    travellerType: ").append(toIndentedString(travellerType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of Passenger given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of Passenger
   * @throws JsonProcessingException if the JSON string is invalid with respect to Passenger
   */
  public static Passenger fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, Passenger.class);
  }

  /**
   * Convert an instance of Passenger to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
