/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.checkout;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;

/** PaymentReversalRequest */
@JsonPropertyOrder({
  PaymentReversalRequest.JSON_PROPERTY_APPLICATION_INFO,
  PaymentReversalRequest.JSON_PROPERTY_MERCHANT_ACCOUNT,
  PaymentReversalRequest.JSON_PROPERTY_REFERENCE
})
public class PaymentReversalRequest {
  public static final String JSON_PROPERTY_APPLICATION_INFO = "applicationInfo";
  private ApplicationInfo applicationInfo;

  public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
  private String merchantAccount;

  public static final String JSON_PROPERTY_REFERENCE = "reference";
  private String reference;

  public PaymentReversalRequest() {}

  /**
   * applicationInfo
   *
   * @param applicationInfo
   * @return the current {@code PaymentReversalRequest} instance, allowing for method chaining
   */
  public PaymentReversalRequest applicationInfo(ApplicationInfo applicationInfo) {
    this.applicationInfo = applicationInfo;
    return this;
  }

  /**
   * Get applicationInfo
   *
   * @return applicationInfo
   */
  @JsonProperty(JSON_PROPERTY_APPLICATION_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ApplicationInfo getApplicationInfo() {
    return applicationInfo;
  }

  /**
   * applicationInfo
   *
   * @param applicationInfo
   */
  @JsonProperty(JSON_PROPERTY_APPLICATION_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApplicationInfo(ApplicationInfo applicationInfo) {
    this.applicationInfo = applicationInfo;
  }

  /**
   * The merchant account that is used to process the payment.
   *
   * @param merchantAccount The merchant account that is used to process the payment.
   * @return the current {@code PaymentReversalRequest} instance, allowing for method chaining
   */
  public PaymentReversalRequest merchantAccount(String merchantAccount) {
    this.merchantAccount = merchantAccount;
    return this;
  }

  /**
   * The merchant account that is used to process the payment.
   *
   * @return merchantAccount The merchant account that is used to process the payment.
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMerchantAccount() {
    return merchantAccount;
  }

  /**
   * The merchant account that is used to process the payment.
   *
   * @param merchantAccount The merchant account that is used to process the payment.
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantAccount(String merchantAccount) {
    this.merchantAccount = merchantAccount;
  }

  /**
   * Your reference for the reversal request. Maximum length: 80 characters.
   *
   * @param reference Your reference for the reversal request. Maximum length: 80 characters.
   * @return the current {@code PaymentReversalRequest} instance, allowing for method chaining
   */
  public PaymentReversalRequest reference(String reference) {
    this.reference = reference;
    return this;
  }

  /**
   * Your reference for the reversal request. Maximum length: 80 characters.
   *
   * @return reference Your reference for the reversal request. Maximum length: 80 characters.
   */
  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getReference() {
    return reference;
  }

  /**
   * Your reference for the reversal request. Maximum length: 80 characters.
   *
   * @param reference Your reference for the reversal request. Maximum length: 80 characters.
   */
  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReference(String reference) {
    this.reference = reference;
  }

  /** Return true if this PaymentReversalRequest object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentReversalRequest paymentReversalRequest = (PaymentReversalRequest) o;
    return Objects.equals(this.applicationInfo, paymentReversalRequest.applicationInfo)
        && Objects.equals(this.merchantAccount, paymentReversalRequest.merchantAccount)
        && Objects.equals(this.reference, paymentReversalRequest.reference);
  }

  @Override
  public int hashCode() {
    return Objects.hash(applicationInfo, merchantAccount, reference);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentReversalRequest {\n");
    sb.append("    applicationInfo: ").append(toIndentedString(applicationInfo)).append("\n");
    sb.append("    merchantAccount: ").append(toIndentedString(merchantAccount)).append("\n");
    sb.append("    reference: ").append(toIndentedString(reference)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of PaymentReversalRequest given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of PaymentReversalRequest
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     PaymentReversalRequest
   */
  public static PaymentReversalRequest fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, PaymentReversalRequest.class);
  }

  /**
   * Convert an instance of PaymentReversalRequest to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
