/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.checkout;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;
import java.util.ArrayList;
import java.util.List;

/** StoredPaymentMethodResource */
@JsonPropertyOrder({
  StoredPaymentMethodResource.JSON_PROPERTY_BRAND,
  StoredPaymentMethodResource.JSON_PROPERTY_EXPIRY_MONTH,
  StoredPaymentMethodResource.JSON_PROPERTY_EXPIRY_YEAR,
  StoredPaymentMethodResource.JSON_PROPERTY_EXTERNAL_RESPONSE_CODE,
  StoredPaymentMethodResource.JSON_PROPERTY_EXTERNAL_TOKEN_REFERENCE,
  StoredPaymentMethodResource.JSON_PROPERTY_HOLDER_NAME,
  StoredPaymentMethodResource.JSON_PROPERTY_IBAN,
  StoredPaymentMethodResource.JSON_PROPERTY_ID,
  StoredPaymentMethodResource.JSON_PROPERTY_ISSUER_NAME,
  StoredPaymentMethodResource.JSON_PROPERTY_LAST_FOUR,
  StoredPaymentMethodResource.JSON_PROPERTY_NAME,
  StoredPaymentMethodResource.JSON_PROPERTY_NETWORK_TX_REFERENCE,
  StoredPaymentMethodResource.JSON_PROPERTY_OWNER_NAME,
  StoredPaymentMethodResource.JSON_PROPERTY_SHOPPER_EMAIL,
  StoredPaymentMethodResource.JSON_PROPERTY_SHOPPER_REFERENCE,
  StoredPaymentMethodResource.JSON_PROPERTY_SUPPORTED_RECURRING_PROCESSING_MODELS,
  StoredPaymentMethodResource.JSON_PROPERTY_TYPE
})
public class StoredPaymentMethodResource {
  public static final String JSON_PROPERTY_BRAND = "brand";
  private String brand;

  public static final String JSON_PROPERTY_EXPIRY_MONTH = "expiryMonth";
  private String expiryMonth;

  public static final String JSON_PROPERTY_EXPIRY_YEAR = "expiryYear";
  private String expiryYear;

  public static final String JSON_PROPERTY_EXTERNAL_RESPONSE_CODE = "externalResponseCode";
  private String externalResponseCode;

  public static final String JSON_PROPERTY_EXTERNAL_TOKEN_REFERENCE = "externalTokenReference";
  private String externalTokenReference;

  public static final String JSON_PROPERTY_HOLDER_NAME = "holderName";
  private String holderName;

  public static final String JSON_PROPERTY_IBAN = "iban";
  private String iban;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_ISSUER_NAME = "issuerName";
  private String issuerName;

  public static final String JSON_PROPERTY_LAST_FOUR = "lastFour";
  private String lastFour;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_NETWORK_TX_REFERENCE = "networkTxReference";
  private String networkTxReference;

  public static final String JSON_PROPERTY_OWNER_NAME = "ownerName";
  private String ownerName;

  public static final String JSON_PROPERTY_SHOPPER_EMAIL = "shopperEmail";
  private String shopperEmail;

  public static final String JSON_PROPERTY_SHOPPER_REFERENCE = "shopperReference";
  private String shopperReference;

  public static final String JSON_PROPERTY_SUPPORTED_RECURRING_PROCESSING_MODELS =
      "supportedRecurringProcessingModels";
  private List<String> supportedRecurringProcessingModels;

  public static final String JSON_PROPERTY_TYPE = "type";
  private String type;

  public StoredPaymentMethodResource() {}

  /**
   * The brand of the card.
   *
   * @param brand The brand of the card.
   * @return the current {@code StoredPaymentMethodResource} instance, allowing for method chaining
   */
  public StoredPaymentMethodResource brand(String brand) {
    this.brand = brand;
    return this;
  }

  /**
   * The brand of the card.
   *
   * @return brand The brand of the card.
   */
  @JsonProperty(JSON_PROPERTY_BRAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getBrand() {
    return brand;
  }

  /**
   * The brand of the card.
   *
   * @param brand The brand of the card.
   */
  @JsonProperty(JSON_PROPERTY_BRAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBrand(String brand) {
    this.brand = brand;
  }

  /**
   * The month the card expires.
   *
   * @param expiryMonth The month the card expires.
   * @return the current {@code StoredPaymentMethodResource} instance, allowing for method chaining
   */
  public StoredPaymentMethodResource expiryMonth(String expiryMonth) {
    this.expiryMonth = expiryMonth;
    return this;
  }

  /**
   * The month the card expires.
   *
   * @return expiryMonth The month the card expires.
   */
  @JsonProperty(JSON_PROPERTY_EXPIRY_MONTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getExpiryMonth() {
    return expiryMonth;
  }

  /**
   * The month the card expires.
   *
   * @param expiryMonth The month the card expires.
   */
  @JsonProperty(JSON_PROPERTY_EXPIRY_MONTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExpiryMonth(String expiryMonth) {
    this.expiryMonth = expiryMonth;
  }

  /**
   * The last two digits of the year the card expires. For example, **22** for the year 2022.
   *
   * @param expiryYear The last two digits of the year the card expires. For example, **22** for the
   *     year 2022.
   * @return the current {@code StoredPaymentMethodResource} instance, allowing for method chaining
   */
  public StoredPaymentMethodResource expiryYear(String expiryYear) {
    this.expiryYear = expiryYear;
    return this;
  }

  /**
   * The last two digits of the year the card expires. For example, **22** for the year 2022.
   *
   * @return expiryYear The last two digits of the year the card expires. For example, **22** for
   *     the year 2022.
   */
  @JsonProperty(JSON_PROPERTY_EXPIRY_YEAR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getExpiryYear() {
    return expiryYear;
  }

  /**
   * The last two digits of the year the card expires. For example, **22** for the year 2022.
   *
   * @param expiryYear The last two digits of the year the card expires. For example, **22** for the
   *     year 2022.
   */
  @JsonProperty(JSON_PROPERTY_EXPIRY_YEAR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExpiryYear(String expiryYear) {
    this.expiryYear = expiryYear;
  }

  /**
   * The response code returned by an external system (for example after a provisioning operation).
   *
   * @param externalResponseCode The response code returned by an external system (for example after
   *     a provisioning operation).
   * @return the current {@code StoredPaymentMethodResource} instance, allowing for method chaining
   */
  public StoredPaymentMethodResource externalResponseCode(String externalResponseCode) {
    this.externalResponseCode = externalResponseCode;
    return this;
  }

  /**
   * The response code returned by an external system (for example after a provisioning operation).
   *
   * @return externalResponseCode The response code returned by an external system (for example
   *     after a provisioning operation).
   */
  @JsonProperty(JSON_PROPERTY_EXTERNAL_RESPONSE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getExternalResponseCode() {
    return externalResponseCode;
  }

  /**
   * The response code returned by an external system (for example after a provisioning operation).
   *
   * @param externalResponseCode The response code returned by an external system (for example after
   *     a provisioning operation).
   */
  @JsonProperty(JSON_PROPERTY_EXTERNAL_RESPONSE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalResponseCode(String externalResponseCode) {
    this.externalResponseCode = externalResponseCode;
  }

  /**
   * The token reference of a linked token in an external system (for example a network token
   * reference).
   *
   * @param externalTokenReference The token reference of a linked token in an external system (for
   *     example a network token reference).
   * @return the current {@code StoredPaymentMethodResource} instance, allowing for method chaining
   */
  public StoredPaymentMethodResource externalTokenReference(String externalTokenReference) {
    this.externalTokenReference = externalTokenReference;
    return this;
  }

  /**
   * The token reference of a linked token in an external system (for example a network token
   * reference).
   *
   * @return externalTokenReference The token reference of a linked token in an external system (for
   *     example a network token reference).
   */
  @JsonProperty(JSON_PROPERTY_EXTERNAL_TOKEN_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getExternalTokenReference() {
    return externalTokenReference;
  }

  /**
   * The token reference of a linked token in an external system (for example a network token
   * reference).
   *
   * @param externalTokenReference The token reference of a linked token in an external system (for
   *     example a network token reference).
   */
  @JsonProperty(JSON_PROPERTY_EXTERNAL_TOKEN_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalTokenReference(String externalTokenReference) {
    this.externalTokenReference = externalTokenReference;
  }

  /**
   * The unique payment method code.
   *
   * @param holderName The unique payment method code.
   * @return the current {@code StoredPaymentMethodResource} instance, allowing for method chaining
   */
  public StoredPaymentMethodResource holderName(String holderName) {
    this.holderName = holderName;
    return this;
  }

  /**
   * The unique payment method code.
   *
   * @return holderName The unique payment method code.
   */
  @JsonProperty(JSON_PROPERTY_HOLDER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getHolderName() {
    return holderName;
  }

  /**
   * The unique payment method code.
   *
   * @param holderName The unique payment method code.
   */
  @JsonProperty(JSON_PROPERTY_HOLDER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHolderName(String holderName) {
    this.holderName = holderName;
  }

  /**
   * The IBAN of the bank account.
   *
   * @param iban The IBAN of the bank account.
   * @return the current {@code StoredPaymentMethodResource} instance, allowing for method chaining
   */
  public StoredPaymentMethodResource iban(String iban) {
    this.iban = iban;
    return this;
  }

  /**
   * The IBAN of the bank account.
   *
   * @return iban The IBAN of the bank account.
   */
  @JsonProperty(JSON_PROPERTY_IBAN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getIban() {
    return iban;
  }

  /**
   * The IBAN of the bank account.
   *
   * @param iban The IBAN of the bank account.
   */
  @JsonProperty(JSON_PROPERTY_IBAN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIban(String iban) {
    this.iban = iban;
  }

  /**
   * A unique identifier of this stored payment method.
   *
   * @param id A unique identifier of this stored payment method.
   * @return the current {@code StoredPaymentMethodResource} instance, allowing for method chaining
   */
  public StoredPaymentMethodResource id(String id) {
    this.id = id;
    return this;
  }

  /**
   * A unique identifier of this stored payment method.
   *
   * @return id A unique identifier of this stored payment method.
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getId() {
    return id;
  }

  /**
   * A unique identifier of this stored payment method.
   *
   * @param id A unique identifier of this stored payment method.
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }

  /**
   * The name of the issuer of token or card.
   *
   * @param issuerName The name of the issuer of token or card.
   * @return the current {@code StoredPaymentMethodResource} instance, allowing for method chaining
   */
  public StoredPaymentMethodResource issuerName(String issuerName) {
    this.issuerName = issuerName;
    return this;
  }

  /**
   * The name of the issuer of token or card.
   *
   * @return issuerName The name of the issuer of token or card.
   */
  @JsonProperty(JSON_PROPERTY_ISSUER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getIssuerName() {
    return issuerName;
  }

  /**
   * The name of the issuer of token or card.
   *
   * @param issuerName The name of the issuer of token or card.
   */
  @JsonProperty(JSON_PROPERTY_ISSUER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIssuerName(String issuerName) {
    this.issuerName = issuerName;
  }

  /**
   * The last four digits of the PAN.
   *
   * @param lastFour The last four digits of the PAN.
   * @return the current {@code StoredPaymentMethodResource} instance, allowing for method chaining
   */
  public StoredPaymentMethodResource lastFour(String lastFour) {
    this.lastFour = lastFour;
    return this;
  }

  /**
   * The last four digits of the PAN.
   *
   * @return lastFour The last four digits of the PAN.
   */
  @JsonProperty(JSON_PROPERTY_LAST_FOUR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getLastFour() {
    return lastFour;
  }

  /**
   * The last four digits of the PAN.
   *
   * @param lastFour The last four digits of the PAN.
   */
  @JsonProperty(JSON_PROPERTY_LAST_FOUR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastFour(String lastFour) {
    this.lastFour = lastFour;
  }

  /**
   * The display name of the stored payment method.
   *
   * @param name The display name of the stored payment method.
   * @return the current {@code StoredPaymentMethodResource} instance, allowing for method chaining
   */
  public StoredPaymentMethodResource name(String name) {
    this.name = name;
    return this;
  }

  /**
   * The display name of the stored payment method.
   *
   * @return name The display name of the stored payment method.
   */
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getName() {
    return name;
  }

  /**
   * The display name of the stored payment method.
   *
   * @param name The display name of the stored payment method.
   */
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }

  /**
   * Returned in the response if you are not tokenizing with Adyen and are using the
   * Merchant-initiated transactions (MIT) framework from Mastercard or Visa. This contains either
   * the Mastercard Trace ID or the Visa Transaction ID.
   *
   * @param networkTxReference Returned in the response if you are not tokenizing with Adyen and are
   *     using the Merchant-initiated transactions (MIT) framework from Mastercard or Visa. This
   *     contains either the Mastercard Trace ID or the Visa Transaction ID.
   * @return the current {@code StoredPaymentMethodResource} instance, allowing for method chaining
   */
  public StoredPaymentMethodResource networkTxReference(String networkTxReference) {
    this.networkTxReference = networkTxReference;
    return this;
  }

  /**
   * Returned in the response if you are not tokenizing with Adyen and are using the
   * Merchant-initiated transactions (MIT) framework from Mastercard or Visa. This contains either
   * the Mastercard Trace ID or the Visa Transaction ID.
   *
   * @return networkTxReference Returned in the response if you are not tokenizing with Adyen and
   *     are using the Merchant-initiated transactions (MIT) framework from Mastercard or Visa. This
   *     contains either the Mastercard Trace ID or the Visa Transaction ID.
   */
  @JsonProperty(JSON_PROPERTY_NETWORK_TX_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getNetworkTxReference() {
    return networkTxReference;
  }

  /**
   * Returned in the response if you are not tokenizing with Adyen and are using the
   * Merchant-initiated transactions (MIT) framework from Mastercard or Visa. This contains either
   * the Mastercard Trace ID or the Visa Transaction ID.
   *
   * @param networkTxReference Returned in the response if you are not tokenizing with Adyen and are
   *     using the Merchant-initiated transactions (MIT) framework from Mastercard or Visa. This
   *     contains either the Mastercard Trace ID or the Visa Transaction ID.
   */
  @JsonProperty(JSON_PROPERTY_NETWORK_TX_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetworkTxReference(String networkTxReference) {
    this.networkTxReference = networkTxReference;
  }

  /**
   * The name of the bank account holder.
   *
   * @param ownerName The name of the bank account holder.
   * @return the current {@code StoredPaymentMethodResource} instance, allowing for method chaining
   */
  public StoredPaymentMethodResource ownerName(String ownerName) {
    this.ownerName = ownerName;
    return this;
  }

  /**
   * The name of the bank account holder.
   *
   * @return ownerName The name of the bank account holder.
   */
  @JsonProperty(JSON_PROPERTY_OWNER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getOwnerName() {
    return ownerName;
  }

  /**
   * The name of the bank account holder.
   *
   * @param ownerName The name of the bank account holder.
   */
  @JsonProperty(JSON_PROPERTY_OWNER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerName(String ownerName) {
    this.ownerName = ownerName;
  }

  /**
   * The shopper’s email address.
   *
   * @param shopperEmail The shopper’s email address.
   * @return the current {@code StoredPaymentMethodResource} instance, allowing for method chaining
   */
  public StoredPaymentMethodResource shopperEmail(String shopperEmail) {
    this.shopperEmail = shopperEmail;
    return this;
  }

  /**
   * The shopper’s email address.
   *
   * @return shopperEmail The shopper’s email address.
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getShopperEmail() {
    return shopperEmail;
  }

  /**
   * The shopper’s email address.
   *
   * @param shopperEmail The shopper’s email address.
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperEmail(String shopperEmail) {
    this.shopperEmail = shopperEmail;
  }

  /**
   * Your reference to uniquely identify this shopper, for example user ID or account ID. The value
   * is case-sensitive and must be at least three characters. &gt; Your reference must not include
   * personally identifiable information (PII) such as name or email address.
   *
   * @param shopperReference Your reference to uniquely identify this shopper, for example user ID
   *     or account ID. The value is case-sensitive and must be at least three characters. &gt; Your
   *     reference must not include personally identifiable information (PII) such as name or email
   *     address.
   * @return the current {@code StoredPaymentMethodResource} instance, allowing for method chaining
   */
  public StoredPaymentMethodResource shopperReference(String shopperReference) {
    this.shopperReference = shopperReference;
    return this;
  }

  /**
   * Your reference to uniquely identify this shopper, for example user ID or account ID. The value
   * is case-sensitive and must be at least three characters. &gt; Your reference must not include
   * personally identifiable information (PII) such as name or email address.
   *
   * @return shopperReference Your reference to uniquely identify this shopper, for example user ID
   *     or account ID. The value is case-sensitive and must be at least three characters. &gt; Your
   *     reference must not include personally identifiable information (PII) such as name or email
   *     address.
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getShopperReference() {
    return shopperReference;
  }

  /**
   * Your reference to uniquely identify this shopper, for example user ID or account ID. The value
   * is case-sensitive and must be at least three characters. &gt; Your reference must not include
   * personally identifiable information (PII) such as name or email address.
   *
   * @param shopperReference Your reference to uniquely identify this shopper, for example user ID
   *     or account ID. The value is case-sensitive and must be at least three characters. &gt; Your
   *     reference must not include personally identifiable information (PII) such as name or email
   *     address.
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperReference(String shopperReference) {
    this.shopperReference = shopperReference;
  }

  /**
   * Defines a recurring payment type. Allowed values: * &#x60;Subscription&#x60; – A transaction
   * for a fixed or variable amount, which follows a fixed schedule. * &#x60;CardOnFile&#x60; – With
   * a card-on-file (CoF) transaction, card details are stored to enable one-click or omnichannel
   * journeys, or simply to streamline the checkout process. Any subscription not following a fixed
   * schedule is also considered a card-on-file transaction. * &#x60;UnscheduledCardOnFile&#x60; –
   * An unscheduled card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed
   * schedule and/or have variable amounts. For example, automatic top-ups when a cardholder&#39;s
   * balance drops below a certain amount.
   *
   * @param supportedRecurringProcessingModels Defines a recurring payment type. Allowed values: *
   *     &#x60;Subscription&#x60; – A transaction for a fixed or variable amount, which follows a
   *     fixed schedule. * &#x60;CardOnFile&#x60; – With a card-on-file (CoF) transaction, card
   *     details are stored to enable one-click or omnichannel journeys, or simply to streamline the
   *     checkout process. Any subscription not following a fixed schedule is also considered a
   *     card-on-file transaction. * &#x60;UnscheduledCardOnFile&#x60; – An unscheduled card-on-file
   *     (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or have
   *     variable amounts. For example, automatic top-ups when a cardholder&#39;s balance drops
   *     below a certain amount.
   * @return the current {@code StoredPaymentMethodResource} instance, allowing for method chaining
   */
  public StoredPaymentMethodResource supportedRecurringProcessingModels(
      List<String> supportedRecurringProcessingModels) {
    this.supportedRecurringProcessingModels = supportedRecurringProcessingModels;
    return this;
  }

  public StoredPaymentMethodResource addSupportedRecurringProcessingModelsItem(
      String supportedRecurringProcessingModelsItem) {
    if (this.supportedRecurringProcessingModels == null) {
      this.supportedRecurringProcessingModels = new ArrayList<>();
    }
    this.supportedRecurringProcessingModels.add(supportedRecurringProcessingModelsItem);
    return this;
  }

  /**
   * Defines a recurring payment type. Allowed values: * &#x60;Subscription&#x60; – A transaction
   * for a fixed or variable amount, which follows a fixed schedule. * &#x60;CardOnFile&#x60; – With
   * a card-on-file (CoF) transaction, card details are stored to enable one-click or omnichannel
   * journeys, or simply to streamline the checkout process. Any subscription not following a fixed
   * schedule is also considered a card-on-file transaction. * &#x60;UnscheduledCardOnFile&#x60; –
   * An unscheduled card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed
   * schedule and/or have variable amounts. For example, automatic top-ups when a cardholder&#39;s
   * balance drops below a certain amount.
   *
   * @return supportedRecurringProcessingModels Defines a recurring payment type. Allowed values: *
   *     &#x60;Subscription&#x60; – A transaction for a fixed or variable amount, which follows a
   *     fixed schedule. * &#x60;CardOnFile&#x60; – With a card-on-file (CoF) transaction, card
   *     details are stored to enable one-click or omnichannel journeys, or simply to streamline the
   *     checkout process. Any subscription not following a fixed schedule is also considered a
   *     card-on-file transaction. * &#x60;UnscheduledCardOnFile&#x60; – An unscheduled card-on-file
   *     (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or have
   *     variable amounts. For example, automatic top-ups when a cardholder&#39;s balance drops
   *     below a certain amount.
   */
  @JsonProperty(JSON_PROPERTY_SUPPORTED_RECURRING_PROCESSING_MODELS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getSupportedRecurringProcessingModels() {
    return supportedRecurringProcessingModels;
  }

  /**
   * Defines a recurring payment type. Allowed values: * &#x60;Subscription&#x60; – A transaction
   * for a fixed or variable amount, which follows a fixed schedule. * &#x60;CardOnFile&#x60; – With
   * a card-on-file (CoF) transaction, card details are stored to enable one-click or omnichannel
   * journeys, or simply to streamline the checkout process. Any subscription not following a fixed
   * schedule is also considered a card-on-file transaction. * &#x60;UnscheduledCardOnFile&#x60; –
   * An unscheduled card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed
   * schedule and/or have variable amounts. For example, automatic top-ups when a cardholder&#39;s
   * balance drops below a certain amount.
   *
   * @param supportedRecurringProcessingModels Defines a recurring payment type. Allowed values: *
   *     &#x60;Subscription&#x60; – A transaction for a fixed or variable amount, which follows a
   *     fixed schedule. * &#x60;CardOnFile&#x60; – With a card-on-file (CoF) transaction, card
   *     details are stored to enable one-click or omnichannel journeys, or simply to streamline the
   *     checkout process. Any subscription not following a fixed schedule is also considered a
   *     card-on-file transaction. * &#x60;UnscheduledCardOnFile&#x60; – An unscheduled card-on-file
   *     (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or have
   *     variable amounts. For example, automatic top-ups when a cardholder&#39;s balance drops
   *     below a certain amount.
   */
  @JsonProperty(JSON_PROPERTY_SUPPORTED_RECURRING_PROCESSING_MODELS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupportedRecurringProcessingModels(
      List<String> supportedRecurringProcessingModels) {
    this.supportedRecurringProcessingModels = supportedRecurringProcessingModels;
  }

  /**
   * The type of payment method.
   *
   * @param type The type of payment method.
   * @return the current {@code StoredPaymentMethodResource} instance, allowing for method chaining
   */
  public StoredPaymentMethodResource type(String type) {
    this.type = type;
    return this;
  }

  /**
   * The type of payment method.
   *
   * @return type The type of payment method.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getType() {
    return type;
  }

  /**
   * The type of payment method.
   *
   * @param type The type of payment method.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(String type) {
    this.type = type;
  }

  /** Return true if this StoredPaymentMethodResource object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    StoredPaymentMethodResource storedPaymentMethodResource = (StoredPaymentMethodResource) o;
    return Objects.equals(this.brand, storedPaymentMethodResource.brand)
        && Objects.equals(this.expiryMonth, storedPaymentMethodResource.expiryMonth)
        && Objects.equals(this.expiryYear, storedPaymentMethodResource.expiryYear)
        && Objects.equals(
            this.externalResponseCode, storedPaymentMethodResource.externalResponseCode)
        && Objects.equals(
            this.externalTokenReference, storedPaymentMethodResource.externalTokenReference)
        && Objects.equals(this.holderName, storedPaymentMethodResource.holderName)
        && Objects.equals(this.iban, storedPaymentMethodResource.iban)
        && Objects.equals(this.id, storedPaymentMethodResource.id)
        && Objects.equals(this.issuerName, storedPaymentMethodResource.issuerName)
        && Objects.equals(this.lastFour, storedPaymentMethodResource.lastFour)
        && Objects.equals(this.name, storedPaymentMethodResource.name)
        && Objects.equals(this.networkTxReference, storedPaymentMethodResource.networkTxReference)
        && Objects.equals(this.ownerName, storedPaymentMethodResource.ownerName)
        && Objects.equals(this.shopperEmail, storedPaymentMethodResource.shopperEmail)
        && Objects.equals(this.shopperReference, storedPaymentMethodResource.shopperReference)
        && Objects.equals(
            this.supportedRecurringProcessingModels,
            storedPaymentMethodResource.supportedRecurringProcessingModels)
        && Objects.equals(this.type, storedPaymentMethodResource.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        brand,
        expiryMonth,
        expiryYear,
        externalResponseCode,
        externalTokenReference,
        holderName,
        iban,
        id,
        issuerName,
        lastFour,
        name,
        networkTxReference,
        ownerName,
        shopperEmail,
        shopperReference,
        supportedRecurringProcessingModels,
        type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class StoredPaymentMethodResource {\n");
    sb.append("    brand: ").append(toIndentedString(brand)).append("\n");
    sb.append("    expiryMonth: ").append(toIndentedString(expiryMonth)).append("\n");
    sb.append("    expiryYear: ").append(toIndentedString(expiryYear)).append("\n");
    sb.append("    externalResponseCode: ")
        .append(toIndentedString(externalResponseCode))
        .append("\n");
    sb.append("    externalTokenReference: ")
        .append(toIndentedString(externalTokenReference))
        .append("\n");
    sb.append("    holderName: ").append(toIndentedString(holderName)).append("\n");
    sb.append("    iban: ").append(toIndentedString(iban)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    issuerName: ").append(toIndentedString(issuerName)).append("\n");
    sb.append("    lastFour: ").append(toIndentedString(lastFour)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    networkTxReference: ").append(toIndentedString(networkTxReference)).append("\n");
    sb.append("    ownerName: ").append(toIndentedString(ownerName)).append("\n");
    sb.append("    shopperEmail: ").append(toIndentedString(shopperEmail)).append("\n");
    sb.append("    shopperReference: ").append(toIndentedString(shopperReference)).append("\n");
    sb.append("    supportedRecurringProcessingModels: ")
        .append(toIndentedString(supportedRecurringProcessingModels))
        .append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of StoredPaymentMethodResource given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of StoredPaymentMethodResource
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     StoredPaymentMethodResource
   */
  public static StoredPaymentMethodResource fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, StoredPaymentMethodResource.class);
  }

  /**
   * Convert an instance of StoredPaymentMethodResource to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
