/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.checkout;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;

/** Surcharge */
@JsonPropertyOrder({Surcharge.JSON_PROPERTY_VALUE})
public class Surcharge {
  public static final String JSON_PROPERTY_VALUE = "value";
  private Long value;

  public Surcharge() {}

  /**
   * The [surcharge](https://docs.adyen.com/online-payments/surcharge/) amount to apply to the
   * transaction, in [minor units](https://docs.adyen.com/development-resources/currency-codes).
   * When you apply surcharge, include the surcharge in the &#x60;amount.value&#x60; field. Review
   * our [Surcharge compliance
   * guide](https://docs.adyen.com/development-resources/surcharge-compliance/) to learn about how
   * to comply with regulatory requirements when applying surcharge.
   *
   * @param value The [surcharge](https://docs.adyen.com/online-payments/surcharge/) amount to apply
   *     to the transaction, in [minor
   *     units](https://docs.adyen.com/development-resources/currency-codes). When you apply
   *     surcharge, include the surcharge in the &#x60;amount.value&#x60; field. Review our
   *     [Surcharge compliance
   *     guide](https://docs.adyen.com/development-resources/surcharge-compliance/) to learn about
   *     how to comply with regulatory requirements when applying surcharge.
   * @return the current {@code Surcharge} instance, allowing for method chaining
   */
  public Surcharge value(Long value) {
    this.value = value;
    return this;
  }

  /**
   * The [surcharge](https://docs.adyen.com/online-payments/surcharge/) amount to apply to the
   * transaction, in [minor units](https://docs.adyen.com/development-resources/currency-codes).
   * When you apply surcharge, include the surcharge in the &#x60;amount.value&#x60; field. Review
   * our [Surcharge compliance
   * guide](https://docs.adyen.com/development-resources/surcharge-compliance/) to learn about how
   * to comply with regulatory requirements when applying surcharge.
   *
   * @return value The [surcharge](https://docs.adyen.com/online-payments/surcharge/) amount to
   *     apply to the transaction, in [minor
   *     units](https://docs.adyen.com/development-resources/currency-codes). When you apply
   *     surcharge, include the surcharge in the &#x60;amount.value&#x60; field. Review our
   *     [Surcharge compliance
   *     guide](https://docs.adyen.com/development-resources/surcharge-compliance/) to learn about
   *     how to comply with regulatory requirements when applying surcharge.
   */
  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Long getValue() {
    return value;
  }

  /**
   * The [surcharge](https://docs.adyen.com/online-payments/surcharge/) amount to apply to the
   * transaction, in [minor units](https://docs.adyen.com/development-resources/currency-codes).
   * When you apply surcharge, include the surcharge in the &#x60;amount.value&#x60; field. Review
   * our [Surcharge compliance
   * guide](https://docs.adyen.com/development-resources/surcharge-compliance/) to learn about how
   * to comply with regulatory requirements when applying surcharge.
   *
   * @param value The [surcharge](https://docs.adyen.com/online-payments/surcharge/) amount to apply
   *     to the transaction, in [minor
   *     units](https://docs.adyen.com/development-resources/currency-codes). When you apply
   *     surcharge, include the surcharge in the &#x60;amount.value&#x60; field. Review our
   *     [Surcharge compliance
   *     guide](https://docs.adyen.com/development-resources/surcharge-compliance/) to learn about
   *     how to comply with regulatory requirements when applying surcharge.
   */
  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValue(Long value) {
    this.value = value;
  }

  /** Return true if this Surcharge object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Surcharge surcharge = (Surcharge) o;
    return Objects.equals(this.value, surcharge.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(value);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Surcharge {\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of Surcharge given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of Surcharge
   * @throws JsonProcessingException if the JSON string is invalid with respect to Surcharge
   */
  public static Surcharge fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, Surcharge.class);
  }

  /**
   * Convert an instance of Surcharge to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
