/*
 * Disputes API
 *
 * The version of the OpenAPI document: 30
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.disputes;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;

/** DefendDisputeRequest */
@JsonPropertyOrder({
  DefendDisputeRequest.JSON_PROPERTY_DEFENSE_REASON_CODE,
  DefendDisputeRequest.JSON_PROPERTY_DISPUTE_PSP_REFERENCE,
  DefendDisputeRequest.JSON_PROPERTY_MERCHANT_ACCOUNT_CODE
})
public class DefendDisputeRequest {
  public static final String JSON_PROPERTY_DEFENSE_REASON_CODE = "defenseReasonCode";
  private String defenseReasonCode;

  public static final String JSON_PROPERTY_DISPUTE_PSP_REFERENCE = "disputePspReference";
  private String disputePspReference;

  public static final String JSON_PROPERTY_MERCHANT_ACCOUNT_CODE = "merchantAccountCode";
  private String merchantAccountCode;

  public DefendDisputeRequest() {}

  /**
   * The defense reason code that was selected to defend this dispute.
   *
   * @param defenseReasonCode The defense reason code that was selected to defend this dispute.
   * @return the current {@code DefendDisputeRequest} instance, allowing for method chaining
   */
  public DefendDisputeRequest defenseReasonCode(String defenseReasonCode) {
    this.defenseReasonCode = defenseReasonCode;
    return this;
  }

  /**
   * The defense reason code that was selected to defend this dispute.
   *
   * @return defenseReasonCode The defense reason code that was selected to defend this dispute.
   */
  @JsonProperty(JSON_PROPERTY_DEFENSE_REASON_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDefenseReasonCode() {
    return defenseReasonCode;
  }

  /**
   * The defense reason code that was selected to defend this dispute.
   *
   * @param defenseReasonCode The defense reason code that was selected to defend this dispute.
   */
  @JsonProperty(JSON_PROPERTY_DEFENSE_REASON_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDefenseReasonCode(String defenseReasonCode) {
    this.defenseReasonCode = defenseReasonCode;
  }

  /**
   * The PSP reference assigned to the dispute.
   *
   * @param disputePspReference The PSP reference assigned to the dispute.
   * @return the current {@code DefendDisputeRequest} instance, allowing for method chaining
   */
  public DefendDisputeRequest disputePspReference(String disputePspReference) {
    this.disputePspReference = disputePspReference;
    return this;
  }

  /**
   * The PSP reference assigned to the dispute.
   *
   * @return disputePspReference The PSP reference assigned to the dispute.
   */
  @JsonProperty(JSON_PROPERTY_DISPUTE_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDisputePspReference() {
    return disputePspReference;
  }

  /**
   * The PSP reference assigned to the dispute.
   *
   * @param disputePspReference The PSP reference assigned to the dispute.
   */
  @JsonProperty(JSON_PROPERTY_DISPUTE_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisputePspReference(String disputePspReference) {
    this.disputePspReference = disputePspReference;
  }

  /**
   * The merchant account identifier, for which you want to process the dispute transaction.
   *
   * @param merchantAccountCode The merchant account identifier, for which you want to process the
   *     dispute transaction.
   * @return the current {@code DefendDisputeRequest} instance, allowing for method chaining
   */
  public DefendDisputeRequest merchantAccountCode(String merchantAccountCode) {
    this.merchantAccountCode = merchantAccountCode;
    return this;
  }

  /**
   * The merchant account identifier, for which you want to process the dispute transaction.
   *
   * @return merchantAccountCode The merchant account identifier, for which you want to process the
   *     dispute transaction.
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMerchantAccountCode() {
    return merchantAccountCode;
  }

  /**
   * The merchant account identifier, for which you want to process the dispute transaction.
   *
   * @param merchantAccountCode The merchant account identifier, for which you want to process the
   *     dispute transaction.
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantAccountCode(String merchantAccountCode) {
    this.merchantAccountCode = merchantAccountCode;
  }

  /** Return true if this DefendDisputeRequest object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DefendDisputeRequest defendDisputeRequest = (DefendDisputeRequest) o;
    return Objects.equals(this.defenseReasonCode, defendDisputeRequest.defenseReasonCode)
        && Objects.equals(this.disputePspReference, defendDisputeRequest.disputePspReference)
        && Objects.equals(this.merchantAccountCode, defendDisputeRequest.merchantAccountCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(defenseReasonCode, disputePspReference, merchantAccountCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DefendDisputeRequest {\n");
    sb.append("    defenseReasonCode: ").append(toIndentedString(defenseReasonCode)).append("\n");
    sb.append("    disputePspReference: ")
        .append(toIndentedString(disputePspReference))
        .append("\n");
    sb.append("    merchantAccountCode: ")
        .append(toIndentedString(merchantAccountCode))
        .append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of DefendDisputeRequest given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of DefendDisputeRequest
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     DefendDisputeRequest
   */
  public static DefendDisputeRequest fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, DefendDisputeRequest.class);
  }

  /**
   * Convert an instance of DefendDisputeRequest to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
