/*
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.legalentitymanagement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;
import java.util.Arrays;
import java.util.logging.Logger;

/** AdditionalBankIdentification */
@JsonPropertyOrder({
  AdditionalBankIdentification.JSON_PROPERTY_CODE,
  AdditionalBankIdentification.JSON_PROPERTY_TYPE
})
public class AdditionalBankIdentification {
  public static final String JSON_PROPERTY_CODE = "code";
  private String code;

  /**
   * The type of additional bank identification, depending on the country. Possible values: *
   * **auBsbCode**: The 6-digit [Australian Bank State Branch (BSB)
   * code](https://en.wikipedia.org/wiki/Bank_state_branch), without separators or spaces. *
   * **caRoutingNumber**: The 9-digit [Canadian routing
   * number](https://en.wikipedia.org/wiki/Routing_number_(Canada)), in EFT format, without
   * separators or spaces. * **gbSortCode**: The 6-digit [UK sort
   * code](https://en.wikipedia.org/wiki/Sort_code), without separators or spaces *
   * **usRoutingNumber**: The 9-digit [routing
   * number](https://en.wikipedia.org/wiki/ABA_routing_transit_number), without separators or
   * spaces.
   */
  public enum TypeEnum {
    AUBSBCODE(String.valueOf("auBsbCode")),

    CAROUTINGNUMBER(String.valueOf("caRoutingNumber")),

    GBSORTCODE(String.valueOf("gbSortCode")),

    USROUTINGNUMBER(String.valueOf("usRoutingNumber"));

    private static final Logger LOG = Logger.getLogger(TypeEnum.class.getName());

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "TypeEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(TypeEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public AdditionalBankIdentification() {}

  /**
   * The value of the additional bank identification.
   *
   * @param code The value of the additional bank identification.
   * @return the current {@code AdditionalBankIdentification} instance, allowing for method chaining
   */
  public AdditionalBankIdentification code(String code) {
    this.code = code;
    return this;
  }

  /**
   * The value of the additional bank identification.
   *
   * @return code The value of the additional bank identification.
   */
  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCode() {
    return code;
  }

  /**
   * The value of the additional bank identification.
   *
   * @param code The value of the additional bank identification.
   */
  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCode(String code) {
    this.code = code;
  }

  /**
   * The type of additional bank identification, depending on the country. Possible values: *
   * **auBsbCode**: The 6-digit [Australian Bank State Branch (BSB)
   * code](https://en.wikipedia.org/wiki/Bank_state_branch), without separators or spaces. *
   * **caRoutingNumber**: The 9-digit [Canadian routing
   * number](https://en.wikipedia.org/wiki/Routing_number_(Canada)), in EFT format, without
   * separators or spaces. * **gbSortCode**: The 6-digit [UK sort
   * code](https://en.wikipedia.org/wiki/Sort_code), without separators or spaces *
   * **usRoutingNumber**: The 9-digit [routing
   * number](https://en.wikipedia.org/wiki/ABA_routing_transit_number), without separators or
   * spaces.
   *
   * @param type The type of additional bank identification, depending on the country. Possible
   *     values: * **auBsbCode**: The 6-digit [Australian Bank State Branch (BSB)
   *     code](https://en.wikipedia.org/wiki/Bank_state_branch), without separators or spaces. *
   *     **caRoutingNumber**: The 9-digit [Canadian routing
   *     number](https://en.wikipedia.org/wiki/Routing_number_(Canada)), in EFT format, without
   *     separators or spaces. * **gbSortCode**: The 6-digit [UK sort
   *     code](https://en.wikipedia.org/wiki/Sort_code), without separators or spaces *
   *     **usRoutingNumber**: The 9-digit [routing
   *     number](https://en.wikipedia.org/wiki/ABA_routing_transit_number), without separators or
   *     spaces.
   * @return the current {@code AdditionalBankIdentification} instance, allowing for method chaining
   */
  public AdditionalBankIdentification type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * The type of additional bank identification, depending on the country. Possible values: *
   * **auBsbCode**: The 6-digit [Australian Bank State Branch (BSB)
   * code](https://en.wikipedia.org/wiki/Bank_state_branch), without separators or spaces. *
   * **caRoutingNumber**: The 9-digit [Canadian routing
   * number](https://en.wikipedia.org/wiki/Routing_number_(Canada)), in EFT format, without
   * separators or spaces. * **gbSortCode**: The 6-digit [UK sort
   * code](https://en.wikipedia.org/wiki/Sort_code), without separators or spaces *
   * **usRoutingNumber**: The 9-digit [routing
   * number](https://en.wikipedia.org/wiki/ABA_routing_transit_number), without separators or
   * spaces.
   *
   * @return type The type of additional bank identification, depending on the country. Possible
   *     values: * **auBsbCode**: The 6-digit [Australian Bank State Branch (BSB)
   *     code](https://en.wikipedia.org/wiki/Bank_state_branch), without separators or spaces. *
   *     **caRoutingNumber**: The 9-digit [Canadian routing
   *     number](https://en.wikipedia.org/wiki/Routing_number_(Canada)), in EFT format, without
   *     separators or spaces. * **gbSortCode**: The 6-digit [UK sort
   *     code](https://en.wikipedia.org/wiki/Sort_code), without separators or spaces *
   *     **usRoutingNumber**: The 9-digit [routing
   *     number](https://en.wikipedia.org/wiki/ABA_routing_transit_number), without separators or
   *     spaces.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * The type of additional bank identification, depending on the country. Possible values: *
   * **auBsbCode**: The 6-digit [Australian Bank State Branch (BSB)
   * code](https://en.wikipedia.org/wiki/Bank_state_branch), without separators or spaces. *
   * **caRoutingNumber**: The 9-digit [Canadian routing
   * number](https://en.wikipedia.org/wiki/Routing_number_(Canada)), in EFT format, without
   * separators or spaces. * **gbSortCode**: The 6-digit [UK sort
   * code](https://en.wikipedia.org/wiki/Sort_code), without separators or spaces *
   * **usRoutingNumber**: The 9-digit [routing
   * number](https://en.wikipedia.org/wiki/ABA_routing_transit_number), without separators or
   * spaces.
   *
   * @param type The type of additional bank identification, depending on the country. Possible
   *     values: * **auBsbCode**: The 6-digit [Australian Bank State Branch (BSB)
   *     code](https://en.wikipedia.org/wiki/Bank_state_branch), without separators or spaces. *
   *     **caRoutingNumber**: The 9-digit [Canadian routing
   *     number](https://en.wikipedia.org/wiki/Routing_number_(Canada)), in EFT format, without
   *     separators or spaces. * **gbSortCode**: The 6-digit [UK sort
   *     code](https://en.wikipedia.org/wiki/Sort_code), without separators or spaces *
   *     **usRoutingNumber**: The 9-digit [routing
   *     number](https://en.wikipedia.org/wiki/ABA_routing_transit_number), without separators or
   *     spaces.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /** Return true if this AdditionalBankIdentification object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AdditionalBankIdentification additionalBankIdentification = (AdditionalBankIdentification) o;
    return Objects.equals(this.code, additionalBankIdentification.code)
        && Objects.equals(this.type, additionalBankIdentification.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AdditionalBankIdentification {\n");
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of AdditionalBankIdentification given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of AdditionalBankIdentification
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     AdditionalBankIdentification
   */
  public static AdditionalBankIdentification fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, AdditionalBankIdentification.class);
  }

  /**
   * Convert an instance of AdditionalBankIdentification to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
