/*
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.legalentitymanagement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

/** CalculateTermsOfServiceStatusResponse */
@JsonPropertyOrder({CalculateTermsOfServiceStatusResponse.JSON_PROPERTY_TERMS_OF_SERVICE_TYPES})
public class CalculateTermsOfServiceStatusResponse {
  /** Gets or Sets termsOfServiceTypes */
  public enum TermsOfServiceTypesEnum {
    ADYENACCOUNT(String.valueOf("adyenAccount")),

    ADYENCAPITAL(String.valueOf("adyenCapital")),

    ADYENCARD(String.valueOf("adyenCard")),

    ADYENCHARGECARD(String.valueOf("adyenChargeCard")),

    ADYENFORPLATFORMSADVANCED(String.valueOf("adyenForPlatformsAdvanced")),

    ADYENFORPLATFORMSMANAGE(String.valueOf("adyenForPlatformsManage")),

    ADYENFRANCHISEE(String.valueOf("adyenFranchisee")),

    ADYENISSUING(String.valueOf("adyenIssuing")),

    ADYENPCCR(String.valueOf("adyenPccr")),

    KYCONINVITE(String.valueOf("kycOnInvite"));

    private static final Logger LOG = Logger.getLogger(TermsOfServiceTypesEnum.class.getName());

    private String value;

    TermsOfServiceTypesEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TermsOfServiceTypesEnum fromValue(String value) {
      for (TermsOfServiceTypesEnum b : TermsOfServiceTypesEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "TermsOfServiceTypesEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(TermsOfServiceTypesEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_TERMS_OF_SERVICE_TYPES = "termsOfServiceTypes";
  private List<TermsOfServiceTypesEnum> termsOfServiceTypes;

  public CalculateTermsOfServiceStatusResponse() {}

  /**
   * The type of Terms of Service that the legal entity needs to accept. If empty, no Terms of
   * Service needs to be accepted.
   *
   * @param termsOfServiceTypes The type of Terms of Service that the legal entity needs to accept.
   *     If empty, no Terms of Service needs to be accepted.
   * @return the current {@code CalculateTermsOfServiceStatusResponse} instance, allowing for method
   *     chaining
   */
  public CalculateTermsOfServiceStatusResponse termsOfServiceTypes(
      List<TermsOfServiceTypesEnum> termsOfServiceTypes) {
    this.termsOfServiceTypes = termsOfServiceTypes;
    return this;
  }

  public CalculateTermsOfServiceStatusResponse addTermsOfServiceTypesItem(
      TermsOfServiceTypesEnum termsOfServiceTypesItem) {
    if (this.termsOfServiceTypes == null) {
      this.termsOfServiceTypes = new ArrayList<>();
    }
    this.termsOfServiceTypes.add(termsOfServiceTypesItem);
    return this;
  }

  /**
   * The type of Terms of Service that the legal entity needs to accept. If empty, no Terms of
   * Service needs to be accepted.
   *
   * @return termsOfServiceTypes The type of Terms of Service that the legal entity needs to accept.
   *     If empty, no Terms of Service needs to be accepted.
   */
  @JsonProperty(JSON_PROPERTY_TERMS_OF_SERVICE_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<TermsOfServiceTypesEnum> getTermsOfServiceTypes() {
    return termsOfServiceTypes;
  }

  /**
   * The type of Terms of Service that the legal entity needs to accept. If empty, no Terms of
   * Service needs to be accepted.
   *
   * @param termsOfServiceTypes The type of Terms of Service that the legal entity needs to accept.
   *     If empty, no Terms of Service needs to be accepted.
   */
  @JsonProperty(JSON_PROPERTY_TERMS_OF_SERVICE_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTermsOfServiceTypes(List<TermsOfServiceTypesEnum> termsOfServiceTypes) {
    this.termsOfServiceTypes = termsOfServiceTypes;
  }

  /** Return true if this CalculateTermsOfServiceStatusResponse object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CalculateTermsOfServiceStatusResponse calculateTermsOfServiceStatusResponse =
        (CalculateTermsOfServiceStatusResponse) o;
    return Objects.equals(
        this.termsOfServiceTypes, calculateTermsOfServiceStatusResponse.termsOfServiceTypes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(termsOfServiceTypes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CalculateTermsOfServiceStatusResponse {\n");
    sb.append("    termsOfServiceTypes: ")
        .append(toIndentedString(termsOfServiceTypes))
        .append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of CalculateTermsOfServiceStatusResponse given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of CalculateTermsOfServiceStatusResponse
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     CalculateTermsOfServiceStatusResponse
   */
  public static CalculateTermsOfServiceStatusResponse fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, CalculateTermsOfServiceStatusResponse.class);
  }

  /**
   * Convert an instance of CalculateTermsOfServiceStatusResponse to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
