/*
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.legalentitymanagement;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;
import java.util.ArrayList;
import java.util.List;

/** OnboardingThemes */
@JsonPropertyOrder({
  OnboardingThemes.JSON_PROPERTY_NEXT,
  OnboardingThemes.JSON_PROPERTY_PREVIOUS,
  OnboardingThemes.JSON_PROPERTY_THEMES
})
public class OnboardingThemes {
  public static final String JSON_PROPERTY_NEXT = "next";
  private String next;

  public static final String JSON_PROPERTY_PREVIOUS = "previous";
  private String previous;

  public static final String JSON_PROPERTY_THEMES = "themes";
  private List<OnboardingTheme> themes;

  public OnboardingThemes() {}

  /**
   * The next page. Only present if there is a next page.
   *
   * @param next The next page. Only present if there is a next page.
   * @return the current {@code OnboardingThemes} instance, allowing for method chaining
   */
  public OnboardingThemes next(String next) {
    this.next = next;
    return this;
  }

  /**
   * The next page. Only present if there is a next page.
   *
   * @return next The next page. Only present if there is a next page.
   */
  @JsonProperty(JSON_PROPERTY_NEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getNext() {
    return next;
  }

  /**
   * The next page. Only present if there is a next page.
   *
   * @param next The next page. Only present if there is a next page.
   */
  @JsonProperty(JSON_PROPERTY_NEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNext(String next) {
    this.next = next;
  }

  /**
   * The previous page. Only present if there is a previous page.
   *
   * @param previous The previous page. Only present if there is a previous page.
   * @return the current {@code OnboardingThemes} instance, allowing for method chaining
   */
  public OnboardingThemes previous(String previous) {
    this.previous = previous;
    return this;
  }

  /**
   * The previous page. Only present if there is a previous page.
   *
   * @return previous The previous page. Only present if there is a previous page.
   */
  @JsonProperty(JSON_PROPERTY_PREVIOUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPrevious() {
    return previous;
  }

  /**
   * The previous page. Only present if there is a previous page.
   *
   * @param previous The previous page. Only present if there is a previous page.
   */
  @JsonProperty(JSON_PROPERTY_PREVIOUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrevious(String previous) {
    this.previous = previous;
  }

  /**
   * List of onboarding themes.
   *
   * @param themes List of onboarding themes.
   * @return the current {@code OnboardingThemes} instance, allowing for method chaining
   */
  public OnboardingThemes themes(List<OnboardingTheme> themes) {
    this.themes = themes;
    return this;
  }

  public OnboardingThemes addThemesItem(OnboardingTheme themesItem) {
    if (this.themes == null) {
      this.themes = new ArrayList<>();
    }
    this.themes.add(themesItem);
    return this;
  }

  /**
   * List of onboarding themes.
   *
   * @return themes List of onboarding themes.
   */
  @JsonProperty(JSON_PROPERTY_THEMES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<OnboardingTheme> getThemes() {
    return themes;
  }

  /**
   * List of onboarding themes.
   *
   * @param themes List of onboarding themes.
   */
  @JsonProperty(JSON_PROPERTY_THEMES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThemes(List<OnboardingTheme> themes) {
    this.themes = themes;
  }

  /** Return true if this OnboardingThemes object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OnboardingThemes onboardingThemes = (OnboardingThemes) o;
    return Objects.equals(this.next, onboardingThemes.next)
        && Objects.equals(this.previous, onboardingThemes.previous)
        && Objects.equals(this.themes, onboardingThemes.themes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(next, previous, themes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OnboardingThemes {\n");
    sb.append("    next: ").append(toIndentedString(next)).append("\n");
    sb.append("    previous: ").append(toIndentedString(previous)).append("\n");
    sb.append("    themes: ").append(toIndentedString(themes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of OnboardingThemes given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of OnboardingThemes
   * @throws JsonProcessingException if the JSON string is invalid with respect to OnboardingThemes
   */
  public static OnboardingThemes fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, OnboardingThemes.class);
  }

  /**
   * Convert an instance of OnboardingThemes to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
