/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.management;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;
import java.util.ArrayList;
import java.util.List;

/** CreateCompanyApiCredentialResponse */
@JsonPropertyOrder({
  CreateCompanyApiCredentialResponse.JSON_PROPERTY_LINKS,
  CreateCompanyApiCredentialResponse.JSON_PROPERTY_ACTIVE,
  CreateCompanyApiCredentialResponse.JSON_PROPERTY_ALLOWED_IP_ADDRESSES,
  CreateCompanyApiCredentialResponse.JSON_PROPERTY_ALLOWED_ORIGINS,
  CreateCompanyApiCredentialResponse.JSON_PROPERTY_API_KEY,
  CreateCompanyApiCredentialResponse.JSON_PROPERTY_ASSOCIATED_MERCHANT_ACCOUNTS,
  CreateCompanyApiCredentialResponse.JSON_PROPERTY_CLIENT_KEY,
  CreateCompanyApiCredentialResponse.JSON_PROPERTY_DESCRIPTION,
  CreateCompanyApiCredentialResponse.JSON_PROPERTY_ID,
  CreateCompanyApiCredentialResponse.JSON_PROPERTY_PASSWORD,
  CreateCompanyApiCredentialResponse.JSON_PROPERTY_ROLES,
  CreateCompanyApiCredentialResponse.JSON_PROPERTY_USERNAME
})
public class CreateCompanyApiCredentialResponse {
  public static final String JSON_PROPERTY_LINKS = "_links";
  private ApiCredentialLinks links;

  public static final String JSON_PROPERTY_ACTIVE = "active";
  private Boolean active;

  public static final String JSON_PROPERTY_ALLOWED_IP_ADDRESSES = "allowedIpAddresses";
  private List<String> allowedIpAddresses;

  public static final String JSON_PROPERTY_ALLOWED_ORIGINS = "allowedOrigins";
  private List<AllowedOrigin> allowedOrigins;

  public static final String JSON_PROPERTY_API_KEY = "apiKey";
  private String apiKey;

  public static final String JSON_PROPERTY_ASSOCIATED_MERCHANT_ACCOUNTS =
      "associatedMerchantAccounts";
  private List<String> associatedMerchantAccounts;

  public static final String JSON_PROPERTY_CLIENT_KEY = "clientKey";
  private String clientKey;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_PASSWORD = "password";
  private String password;

  public static final String JSON_PROPERTY_ROLES = "roles";
  private List<String> roles;

  public static final String JSON_PROPERTY_USERNAME = "username";
  private String username;

  public CreateCompanyApiCredentialResponse() {}

  /**
   * links
   *
   * @param links
   * @return the current {@code CreateCompanyApiCredentialResponse} instance, allowing for method
   *     chaining
   */
  public CreateCompanyApiCredentialResponse links(ApiCredentialLinks links) {
    this.links = links;
    return this;
  }

  /**
   * Get links
   *
   * @return links
   */
  @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ApiCredentialLinks getLinks() {
    return links;
  }

  /**
   * links
   *
   * @param links
   */
  @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLinks(ApiCredentialLinks links) {
    this.links = links;
  }

  /**
   * Indicates if the API credential is enabled. Must be set to **true** to use the credential in
   * your integration.
   *
   * @param active Indicates if the API credential is enabled. Must be set to **true** to use the
   *     credential in your integration.
   * @return the current {@code CreateCompanyApiCredentialResponse} instance, allowing for method
   *     chaining
   */
  public CreateCompanyApiCredentialResponse active(Boolean active) {
    this.active = active;
    return this;
  }

  /**
   * Indicates if the API credential is enabled. Must be set to **true** to use the credential in
   * your integration.
   *
   * @return active Indicates if the API credential is enabled. Must be set to **true** to use the
   *     credential in your integration.
   */
  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getActive() {
    return active;
  }

  /**
   * Indicates if the API credential is enabled. Must be set to **true** to use the credential in
   * your integration.
   *
   * @param active Indicates if the API credential is enabled. Must be set to **true** to use the
   *     credential in your integration.
   */
  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActive(Boolean active) {
    this.active = active;
  }

  /**
   * List of IP addresses from which your client can make requests. If the list is empty, we allow
   * requests from any IP. If the list is not empty and we get a request from an IP which is not on
   * the list, you get a security error.
   *
   * @param allowedIpAddresses List of IP addresses from which your client can make requests. If the
   *     list is empty, we allow requests from any IP. If the list is not empty and we get a request
   *     from an IP which is not on the list, you get a security error.
   * @return the current {@code CreateCompanyApiCredentialResponse} instance, allowing for method
   *     chaining
   */
  public CreateCompanyApiCredentialResponse allowedIpAddresses(List<String> allowedIpAddresses) {
    this.allowedIpAddresses = allowedIpAddresses;
    return this;
  }

  public CreateCompanyApiCredentialResponse addAllowedIpAddressesItem(
      String allowedIpAddressesItem) {
    if (this.allowedIpAddresses == null) {
      this.allowedIpAddresses = new ArrayList<>();
    }
    this.allowedIpAddresses.add(allowedIpAddressesItem);
    return this;
  }

  /**
   * List of IP addresses from which your client can make requests. If the list is empty, we allow
   * requests from any IP. If the list is not empty and we get a request from an IP which is not on
   * the list, you get a security error.
   *
   * @return allowedIpAddresses List of IP addresses from which your client can make requests. If
   *     the list is empty, we allow requests from any IP. If the list is not empty and we get a
   *     request from an IP which is not on the list, you get a security error.
   */
  @JsonProperty(JSON_PROPERTY_ALLOWED_IP_ADDRESSES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getAllowedIpAddresses() {
    return allowedIpAddresses;
  }

  /**
   * List of IP addresses from which your client can make requests. If the list is empty, we allow
   * requests from any IP. If the list is not empty and we get a request from an IP which is not on
   * the list, you get a security error.
   *
   * @param allowedIpAddresses List of IP addresses from which your client can make requests. If the
   *     list is empty, we allow requests from any IP. If the list is not empty and we get a request
   *     from an IP which is not on the list, you get a security error.
   */
  @JsonProperty(JSON_PROPERTY_ALLOWED_IP_ADDRESSES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllowedIpAddresses(List<String> allowedIpAddresses) {
    this.allowedIpAddresses = allowedIpAddresses;
  }

  /**
   * List containing the [allowed
   * origins](https://docs.adyen.com/development-resources/client-side-authentication#allowed-origins)
   * linked to the API credential.
   *
   * @param allowedOrigins List containing the [allowed
   *     origins](https://docs.adyen.com/development-resources/client-side-authentication#allowed-origins)
   *     linked to the API credential.
   * @return the current {@code CreateCompanyApiCredentialResponse} instance, allowing for method
   *     chaining
   */
  public CreateCompanyApiCredentialResponse allowedOrigins(List<AllowedOrigin> allowedOrigins) {
    this.allowedOrigins = allowedOrigins;
    return this;
  }

  public CreateCompanyApiCredentialResponse addAllowedOriginsItem(
      AllowedOrigin allowedOriginsItem) {
    if (this.allowedOrigins == null) {
      this.allowedOrigins = new ArrayList<>();
    }
    this.allowedOrigins.add(allowedOriginsItem);
    return this;
  }

  /**
   * List containing the [allowed
   * origins](https://docs.adyen.com/development-resources/client-side-authentication#allowed-origins)
   * linked to the API credential.
   *
   * @return allowedOrigins List containing the [allowed
   *     origins](https://docs.adyen.com/development-resources/client-side-authentication#allowed-origins)
   *     linked to the API credential.
   */
  @JsonProperty(JSON_PROPERTY_ALLOWED_ORIGINS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<AllowedOrigin> getAllowedOrigins() {
    return allowedOrigins;
  }

  /**
   * List containing the [allowed
   * origins](https://docs.adyen.com/development-resources/client-side-authentication#allowed-origins)
   * linked to the API credential.
   *
   * @param allowedOrigins List containing the [allowed
   *     origins](https://docs.adyen.com/development-resources/client-side-authentication#allowed-origins)
   *     linked to the API credential.
   */
  @JsonProperty(JSON_PROPERTY_ALLOWED_ORIGINS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllowedOrigins(List<AllowedOrigin> allowedOrigins) {
    this.allowedOrigins = allowedOrigins;
  }

  /**
   * The API key for the API credential that was created.
   *
   * @param apiKey The API key for the API credential that was created.
   * @return the current {@code CreateCompanyApiCredentialResponse} instance, allowing for method
   *     chaining
   */
  public CreateCompanyApiCredentialResponse apiKey(String apiKey) {
    this.apiKey = apiKey;
    return this;
  }

  /**
   * The API key for the API credential that was created.
   *
   * @return apiKey The API key for the API credential that was created.
   */
  @JsonProperty(JSON_PROPERTY_API_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getApiKey() {
    return apiKey;
  }

  /**
   * The API key for the API credential that was created.
   *
   * @param apiKey The API key for the API credential that was created.
   */
  @JsonProperty(JSON_PROPERTY_API_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApiKey(String apiKey) {
    this.apiKey = apiKey;
  }

  /**
   * List of merchant accounts that the API credential has access to.
   *
   * @param associatedMerchantAccounts List of merchant accounts that the API credential has access
   *     to.
   * @return the current {@code CreateCompanyApiCredentialResponse} instance, allowing for method
   *     chaining
   */
  public CreateCompanyApiCredentialResponse associatedMerchantAccounts(
      List<String> associatedMerchantAccounts) {
    this.associatedMerchantAccounts = associatedMerchantAccounts;
    return this;
  }

  public CreateCompanyApiCredentialResponse addAssociatedMerchantAccountsItem(
      String associatedMerchantAccountsItem) {
    if (this.associatedMerchantAccounts == null) {
      this.associatedMerchantAccounts = new ArrayList<>();
    }
    this.associatedMerchantAccounts.add(associatedMerchantAccountsItem);
    return this;
  }

  /**
   * List of merchant accounts that the API credential has access to.
   *
   * @return associatedMerchantAccounts List of merchant accounts that the API credential has access
   *     to.
   */
  @JsonProperty(JSON_PROPERTY_ASSOCIATED_MERCHANT_ACCOUNTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getAssociatedMerchantAccounts() {
    return associatedMerchantAccounts;
  }

  /**
   * List of merchant accounts that the API credential has access to.
   *
   * @param associatedMerchantAccounts List of merchant accounts that the API credential has access
   *     to.
   */
  @JsonProperty(JSON_PROPERTY_ASSOCIATED_MERCHANT_ACCOUNTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAssociatedMerchantAccounts(List<String> associatedMerchantAccounts) {
    this.associatedMerchantAccounts = associatedMerchantAccounts;
  }

  /**
   * Public key used for [client-side
   * authentication](https://docs.adyen.com/development-resources/client-side-authentication). The
   * client key is required for Drop-in and Components integrations.
   *
   * @param clientKey Public key used for [client-side
   *     authentication](https://docs.adyen.com/development-resources/client-side-authentication).
   *     The client key is required for Drop-in and Components integrations.
   * @return the current {@code CreateCompanyApiCredentialResponse} instance, allowing for method
   *     chaining
   */
  public CreateCompanyApiCredentialResponse clientKey(String clientKey) {
    this.clientKey = clientKey;
    return this;
  }

  /**
   * Public key used for [client-side
   * authentication](https://docs.adyen.com/development-resources/client-side-authentication). The
   * client key is required for Drop-in and Components integrations.
   *
   * @return clientKey Public key used for [client-side
   *     authentication](https://docs.adyen.com/development-resources/client-side-authentication).
   *     The client key is required for Drop-in and Components integrations.
   */
  @JsonProperty(JSON_PROPERTY_CLIENT_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getClientKey() {
    return clientKey;
  }

  /**
   * Public key used for [client-side
   * authentication](https://docs.adyen.com/development-resources/client-side-authentication). The
   * client key is required for Drop-in and Components integrations.
   *
   * @param clientKey Public key used for [client-side
   *     authentication](https://docs.adyen.com/development-resources/client-side-authentication).
   *     The client key is required for Drop-in and Components integrations.
   */
  @JsonProperty(JSON_PROPERTY_CLIENT_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClientKey(String clientKey) {
    this.clientKey = clientKey;
  }

  /**
   * Description of the API credential.
   *
   * @param description Description of the API credential.
   * @return the current {@code CreateCompanyApiCredentialResponse} instance, allowing for method
   *     chaining
   */
  public CreateCompanyApiCredentialResponse description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Description of the API credential.
   *
   * @return description Description of the API credential.
   */
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDescription() {
    return description;
  }

  /**
   * Description of the API credential.
   *
   * @param description Description of the API credential.
   */
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   * Unique identifier of the API credential.
   *
   * @param id Unique identifier of the API credential.
   * @return the current {@code CreateCompanyApiCredentialResponse} instance, allowing for method
   *     chaining
   */
  public CreateCompanyApiCredentialResponse id(String id) {
    this.id = id;
    return this;
  }

  /**
   * Unique identifier of the API credential.
   *
   * @return id Unique identifier of the API credential.
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getId() {
    return id;
  }

  /**
   * Unique identifier of the API credential.
   *
   * @param id Unique identifier of the API credential.
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }

  /**
   * The password for the API credential that was created.
   *
   * @param password The password for the API credential that was created.
   * @return the current {@code CreateCompanyApiCredentialResponse} instance, allowing for method
   *     chaining
   */
  public CreateCompanyApiCredentialResponse password(String password) {
    this.password = password;
    return this;
  }

  /**
   * The password for the API credential that was created.
   *
   * @return password The password for the API credential that was created.
   */
  @JsonProperty(JSON_PROPERTY_PASSWORD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPassword() {
    return password;
  }

  /**
   * The password for the API credential that was created.
   *
   * @param password The password for the API credential that was created.
   */
  @JsonProperty(JSON_PROPERTY_PASSWORD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPassword(String password) {
    this.password = password;
  }

  /**
   * List of [roles](https://docs.adyen.com/development-resources/api-credentials#roles-1) for the
   * API credential.
   *
   * @param roles List of
   *     [roles](https://docs.adyen.com/development-resources/api-credentials#roles-1) for the API
   *     credential.
   * @return the current {@code CreateCompanyApiCredentialResponse} instance, allowing for method
   *     chaining
   */
  public CreateCompanyApiCredentialResponse roles(List<String> roles) {
    this.roles = roles;
    return this;
  }

  public CreateCompanyApiCredentialResponse addRolesItem(String rolesItem) {
    if (this.roles == null) {
      this.roles = new ArrayList<>();
    }
    this.roles.add(rolesItem);
    return this;
  }

  /**
   * List of [roles](https://docs.adyen.com/development-resources/api-credentials#roles-1) for the
   * API credential.
   *
   * @return roles List of
   *     [roles](https://docs.adyen.com/development-resources/api-credentials#roles-1) for the API
   *     credential.
   */
  @JsonProperty(JSON_PROPERTY_ROLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getRoles() {
    return roles;
  }

  /**
   * List of [roles](https://docs.adyen.com/development-resources/api-credentials#roles-1) for the
   * API credential.
   *
   * @param roles List of
   *     [roles](https://docs.adyen.com/development-resources/api-credentials#roles-1) for the API
   *     credential.
   */
  @JsonProperty(JSON_PROPERTY_ROLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoles(List<String> roles) {
    this.roles = roles;
  }

  /**
   * The name of the [API credential](https://docs.adyen.com/development-resources/api-credentials),
   * for example **ws@Company.TestCompany**.
   *
   * @param username The name of the [API
   *     credential](https://docs.adyen.com/development-resources/api-credentials), for example
   *     **ws@Company.TestCompany**.
   * @return the current {@code CreateCompanyApiCredentialResponse} instance, allowing for method
   *     chaining
   */
  public CreateCompanyApiCredentialResponse username(String username) {
    this.username = username;
    return this;
  }

  /**
   * The name of the [API credential](https://docs.adyen.com/development-resources/api-credentials),
   * for example **ws@Company.TestCompany**.
   *
   * @return username The name of the [API
   *     credential](https://docs.adyen.com/development-resources/api-credentials), for example
   *     **ws@Company.TestCompany**.
   */
  @JsonProperty(JSON_PROPERTY_USERNAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getUsername() {
    return username;
  }

  /**
   * The name of the [API credential](https://docs.adyen.com/development-resources/api-credentials),
   * for example **ws@Company.TestCompany**.
   *
   * @param username The name of the [API
   *     credential](https://docs.adyen.com/development-resources/api-credentials), for example
   *     **ws@Company.TestCompany**.
   */
  @JsonProperty(JSON_PROPERTY_USERNAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUsername(String username) {
    this.username = username;
  }

  /** Return true if this CreateCompanyApiCredentialResponse object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateCompanyApiCredentialResponse createCompanyApiCredentialResponse =
        (CreateCompanyApiCredentialResponse) o;
    return Objects.equals(this.links, createCompanyApiCredentialResponse.links)
        && Objects.equals(this.active, createCompanyApiCredentialResponse.active)
        && Objects.equals(
            this.allowedIpAddresses, createCompanyApiCredentialResponse.allowedIpAddresses)
        && Objects.equals(this.allowedOrigins, createCompanyApiCredentialResponse.allowedOrigins)
        && Objects.equals(this.apiKey, createCompanyApiCredentialResponse.apiKey)
        && Objects.equals(
            this.associatedMerchantAccounts,
            createCompanyApiCredentialResponse.associatedMerchantAccounts)
        && Objects.equals(this.clientKey, createCompanyApiCredentialResponse.clientKey)
        && Objects.equals(this.description, createCompanyApiCredentialResponse.description)
        && Objects.equals(this.id, createCompanyApiCredentialResponse.id)
        && Objects.equals(this.password, createCompanyApiCredentialResponse.password)
        && Objects.equals(this.roles, createCompanyApiCredentialResponse.roles)
        && Objects.equals(this.username, createCompanyApiCredentialResponse.username);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        links,
        active,
        allowedIpAddresses,
        allowedOrigins,
        apiKey,
        associatedMerchantAccounts,
        clientKey,
        description,
        id,
        password,
        roles,
        username);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateCompanyApiCredentialResponse {\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    allowedIpAddresses: ").append(toIndentedString(allowedIpAddresses)).append("\n");
    sb.append("    allowedOrigins: ").append(toIndentedString(allowedOrigins)).append("\n");
    sb.append("    apiKey: ").append(toIndentedString(apiKey)).append("\n");
    sb.append("    associatedMerchantAccounts: ")
        .append(toIndentedString(associatedMerchantAccounts))
        .append("\n");
    sb.append("    clientKey: ").append(toIndentedString(clientKey)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    password: ").append(toIndentedString(password)).append("\n");
    sb.append("    roles: ").append(toIndentedString(roles)).append("\n");
    sb.append("    username: ").append(toIndentedString(username)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of CreateCompanyApiCredentialResponse given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of CreateCompanyApiCredentialResponse
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     CreateCompanyApiCredentialResponse
   */
  public static CreateCompanyApiCredentialResponse fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, CreateCompanyApiCredentialResponse.class);
  }

  /**
   * Convert an instance of CreateCompanyApiCredentialResponse to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
