/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.management;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;

/** SubMerchantData */
@JsonPropertyOrder({
  SubMerchantData.JSON_PROPERTY_EMAIL,
  SubMerchantData.JSON_PROPERTY_ID,
  SubMerchantData.JSON_PROPERTY_MCC,
  SubMerchantData.JSON_PROPERTY_NAME
})
public class SubMerchantData {
  public static final String JSON_PROPERTY_EMAIL = "email";
  private String email;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_MCC = "mcc";
  private String mcc;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public SubMerchantData() {}

  /**
   * The email associated with the sub-merchant&#39;s account.
   *
   * @param email The email associated with the sub-merchant&#39;s account.
   * @return the current {@code SubMerchantData} instance, allowing for method chaining
   */
  public SubMerchantData email(String email) {
    this.email = email;
    return this;
  }

  /**
   * The email associated with the sub-merchant&#39;s account.
   *
   * @return email The email associated with the sub-merchant&#39;s account.
   */
  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getEmail() {
    return email;
  }

  /**
   * The email associated with the sub-merchant&#39;s account.
   *
   * @param email The email associated with the sub-merchant&#39;s account.
   */
  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEmail(String email) {
    this.email = email;
  }

  /**
   * A unique identifier that you create for the sub-merchant, used by schemes to identify the
   * sub-merchant. * Format: Alphanumeric * Maximum length: 15 characters
   *
   * @param id A unique identifier that you create for the sub-merchant, used by schemes to identify
   *     the sub-merchant. * Format: Alphanumeric * Maximum length: 15 characters
   * @return the current {@code SubMerchantData} instance, allowing for method chaining
   */
  public SubMerchantData id(String id) {
    this.id = id;
    return this;
  }

  /**
   * A unique identifier that you create for the sub-merchant, used by schemes to identify the
   * sub-merchant. * Format: Alphanumeric * Maximum length: 15 characters
   *
   * @return id A unique identifier that you create for the sub-merchant, used by schemes to
   *     identify the sub-merchant. * Format: Alphanumeric * Maximum length: 15 characters
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getId() {
    return id;
  }

  /**
   * A unique identifier that you create for the sub-merchant, used by schemes to identify the
   * sub-merchant. * Format: Alphanumeric * Maximum length: 15 characters
   *
   * @param id A unique identifier that you create for the sub-merchant, used by schemes to identify
   *     the sub-merchant. * Format: Alphanumeric * Maximum length: 15 characters
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }

  /**
   * The sub-merchant&#39;s 4-digit Merchant Category Code (MCC). * Format: Numeric * Fixed length:
   * 4 digits
   *
   * @param mcc The sub-merchant&#39;s 4-digit Merchant Category Code (MCC). * Format: Numeric *
   *     Fixed length: 4 digits
   * @return the current {@code SubMerchantData} instance, allowing for method chaining
   */
  public SubMerchantData mcc(String mcc) {
    this.mcc = mcc;
    return this;
  }

  /**
   * The sub-merchant&#39;s 4-digit Merchant Category Code (MCC). * Format: Numeric * Fixed length:
   * 4 digits
   *
   * @return mcc The sub-merchant&#39;s 4-digit Merchant Category Code (MCC). * Format: Numeric *
   *     Fixed length: 4 digits
   */
  @JsonProperty(JSON_PROPERTY_MCC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMcc() {
    return mcc;
  }

  /**
   * The sub-merchant&#39;s 4-digit Merchant Category Code (MCC). * Format: Numeric * Fixed length:
   * 4 digits
   *
   * @param mcc The sub-merchant&#39;s 4-digit Merchant Category Code (MCC). * Format: Numeric *
   *     Fixed length: 4 digits
   */
  @JsonProperty(JSON_PROPERTY_MCC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMcc(String mcc) {
    this.mcc = mcc;
  }

  /**
   * The name of the sub-merchant. Based on scheme specifications, this value will overwrite the
   * shopper statement that will appear in the card statement. * Format: Alphanumeric * Maximum
   * length: 22 characters
   *
   * @param name The name of the sub-merchant. Based on scheme specifications, this value will
   *     overwrite the shopper statement that will appear in the card statement. * Format:
   *     Alphanumeric * Maximum length: 22 characters
   * @return the current {@code SubMerchantData} instance, allowing for method chaining
   */
  public SubMerchantData name(String name) {
    this.name = name;
    return this;
  }

  /**
   * The name of the sub-merchant. Based on scheme specifications, this value will overwrite the
   * shopper statement that will appear in the card statement. * Format: Alphanumeric * Maximum
   * length: 22 characters
   *
   * @return name The name of the sub-merchant. Based on scheme specifications, this value will
   *     overwrite the shopper statement that will appear in the card statement. * Format:
   *     Alphanumeric * Maximum length: 22 characters
   */
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getName() {
    return name;
  }

  /**
   * The name of the sub-merchant. Based on scheme specifications, this value will overwrite the
   * shopper statement that will appear in the card statement. * Format: Alphanumeric * Maximum
   * length: 22 characters
   *
   * @param name The name of the sub-merchant. Based on scheme specifications, this value will
   *     overwrite the shopper statement that will appear in the card statement. * Format:
   *     Alphanumeric * Maximum length: 22 characters
   */
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }

  /** Return true if this SubMerchantData object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SubMerchantData subMerchantData = (SubMerchantData) o;
    return Objects.equals(this.email, subMerchantData.email)
        && Objects.equals(this.id, subMerchantData.id)
        && Objects.equals(this.mcc, subMerchantData.mcc)
        && Objects.equals(this.name, subMerchantData.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(email, id, mcc, name);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SubMerchantData {\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    mcc: ").append(toIndentedString(mcc)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of SubMerchantData given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of SubMerchantData
   * @throws JsonProcessingException if the JSON string is invalid with respect to SubMerchantData
   */
  public static SubMerchantData fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, SubMerchantData.class);
  }

  /**
   * Convert an instance of SubMerchantData to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
