/*
 * Management Webhooks
 *
 * The version of the OpenAPI document: 3
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.managementwebhooks;

import java.util.Optional;
import java.util.logging.Logger;

/**
 * Handler for processing ManagementWebhooks.
 *
 * <p>This class provides functionality to deserialize the payload of ManagementWebhooks events.
 */
public class ManagementWebhooksHandler {

  private static final Logger LOG = Logger.getLogger(ManagementWebhooksHandler.class.getName());

  private final String payload;

  /**
   * Constructs a new handler for the given webhook payload
   *
   * @param payload the raw JSON payload from the webhook
   */
  public ManagementWebhooksHandler(String payload) {
    this.payload = payload;
  }

  /**
   * Attempts to deserialize the webhook payload into a MerchantCreatedNotificationRequest
   *
   * @return an Optional containing the deserialized object, or empty if deserialization fails
   */
  public Optional<MerchantCreatedNotificationRequest> getMerchantCreatedNotificationRequest() {

    var optionalMerchantCreatedNotificationRequest =
        getOptionalField(MerchantCreatedNotificationRequest.class);

    if (optionalMerchantCreatedNotificationRequest.isPresent()) {
      // verify event type
      for (var value : MerchantCreatedNotificationRequest.TypeEnum.values()) {
        if (value.equals(optionalMerchantCreatedNotificationRequest.get().getType())) {
          // found matching event type
          return optionalMerchantCreatedNotificationRequest;
        }
      }
    }

    return Optional.empty();
  }

  /**
   * Attempts to deserialize the webhook payload into a MerchantUpdatedNotificationRequest
   *
   * @return an Optional containing the deserialized object, or empty if deserialization fails
   */
  public Optional<MerchantUpdatedNotificationRequest> getMerchantUpdatedNotificationRequest() {

    var optionalMerchantUpdatedNotificationRequest =
        getOptionalField(MerchantUpdatedNotificationRequest.class);

    if (optionalMerchantUpdatedNotificationRequest.isPresent()) {
      // verify event type
      for (var value : MerchantUpdatedNotificationRequest.TypeEnum.values()) {
        if (value.equals(optionalMerchantUpdatedNotificationRequest.get().getType())) {
          // found matching event type
          return optionalMerchantUpdatedNotificationRequest;
        }
      }
    }

    return Optional.empty();
  }

  /**
   * Attempts to deserialize the webhook payload into a PaymentMethodCreatedNotificationRequest
   *
   * @return an Optional containing the deserialized object, or empty if deserialization fails
   */
  public Optional<PaymentMethodCreatedNotificationRequest>
      getPaymentMethodCreatedNotificationRequest() {

    var optionalPaymentMethodCreatedNotificationRequest =
        getOptionalField(PaymentMethodCreatedNotificationRequest.class);

    if (optionalPaymentMethodCreatedNotificationRequest.isPresent()) {
      // verify event type
      for (var value : PaymentMethodCreatedNotificationRequest.TypeEnum.values()) {
        if (value.equals(optionalPaymentMethodCreatedNotificationRequest.get().getType())) {
          // found matching event type
          return optionalPaymentMethodCreatedNotificationRequest;
        }
      }
    }

    return Optional.empty();
  }

  /**
   * Attempts to deserialize the webhook payload into a
   * PaymentMethodRequestRemovedNotificationRequest
   *
   * @return an Optional containing the deserialized object, or empty if deserialization fails
   */
  public Optional<PaymentMethodRequestRemovedNotificationRequest>
      getPaymentMethodRequestRemovedNotificationRequest() {

    var optionalPaymentMethodRequestRemovedNotificationRequest =
        getOptionalField(PaymentMethodRequestRemovedNotificationRequest.class);

    if (optionalPaymentMethodRequestRemovedNotificationRequest.isPresent()) {
      // verify event type
      for (var value : PaymentMethodRequestRemovedNotificationRequest.TypeEnum.values()) {
        if (value.equals(optionalPaymentMethodRequestRemovedNotificationRequest.get().getType())) {
          // found matching event type
          return optionalPaymentMethodRequestRemovedNotificationRequest;
        }
      }
    }

    return Optional.empty();
  }

  /**
   * Attempts to deserialize the webhook payload into a
   * PaymentMethodScheduledForRemovalNotificationRequest
   *
   * @return an Optional containing the deserialized object, or empty if deserialization fails
   */
  public Optional<PaymentMethodScheduledForRemovalNotificationRequest>
      getPaymentMethodScheduledForRemovalNotificationRequest() {

    var optionalPaymentMethodScheduledForRemovalNotificationRequest =
        getOptionalField(PaymentMethodScheduledForRemovalNotificationRequest.class);

    if (optionalPaymentMethodScheduledForRemovalNotificationRequest.isPresent()) {
      // verify event type
      for (var value : PaymentMethodScheduledForRemovalNotificationRequest.TypeEnum.values()) {
        if (value.equals(
            optionalPaymentMethodScheduledForRemovalNotificationRequest.get().getType())) {
          // found matching event type
          return optionalPaymentMethodScheduledForRemovalNotificationRequest;
        }
      }
    }

    return Optional.empty();
  }

  /**
   * Attempts to deserialize the webhook payload into a TerminalBoardingNotificationRequest
   *
   * @return an Optional containing the deserialized object, or empty if deserialization fails
   */
  public Optional<TerminalBoardingNotificationRequest> getTerminalBoardingNotificationRequest() {

    var optionalTerminalBoardingNotificationRequest =
        getOptionalField(TerminalBoardingNotificationRequest.class);

    if (optionalTerminalBoardingNotificationRequest.isPresent()) {
      // verify event type
      for (var value : TerminalBoardingNotificationRequest.TypeEnum.values()) {
        if (value.equals(optionalTerminalBoardingNotificationRequest.get().getType())) {
          // found matching event type
          return optionalTerminalBoardingNotificationRequest;
        }
      }
    }

    return Optional.empty();
  }

  /**
   * Attempts to deserialize the webhook payload into a TerminalSettingsNotificationRequest
   *
   * @return an Optional containing the deserialized object, or empty if deserialization fails
   */
  public Optional<TerminalSettingsNotificationRequest> getTerminalSettingsNotificationRequest() {

    var optionalTerminalSettingsNotificationRequest =
        getOptionalField(TerminalSettingsNotificationRequest.class);

    if (optionalTerminalSettingsNotificationRequest.isPresent()) {
      // verify event type
      for (var value : TerminalSettingsNotificationRequest.TypeEnum.values()) {
        if (value.equals(optionalTerminalSettingsNotificationRequest.get().getType())) {
          // found matching event type
          return optionalTerminalSettingsNotificationRequest;
        }
      }
    }

    return Optional.empty();
  }

  /**
   * Deserializes the payload into the specified class type.
   *
   * @param clazz the class to deserialize into
   * @param <T> the type of the class
   * @return an Optional containing the deserialized object, or empty if an error occurs
   */
  private <T> Optional<T> getOptionalField(Class<T> clazz) {
    try {
      T val = JSON.getMapper().readValue(payload, clazz);
      return Optional.ofNullable(val);
    } catch (Exception e) {
      // an error has occurred during deserialization (object not found, deserialization error)
      LOG.warning("Object not found or unexpected error trying to access:  " + clazz.getName());
      LOG.warning("Deserialization error: " + e.getMessage());
      return Optional.empty();
    }
  }
}
