/*
 * Management Webhooks
 *
 * The version of the OpenAPI document: 3
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.managementwebhooks;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

/** VerificationErrorRecursive */
@JsonPropertyOrder({
  VerificationErrorRecursive.JSON_PROPERTY_CODE,
  VerificationErrorRecursive.JSON_PROPERTY_MESSAGE,
  VerificationErrorRecursive.JSON_PROPERTY_TYPE,
  VerificationErrorRecursive.JSON_PROPERTY_REMEDIATING_ACTIONS
})
@JsonTypeName("VerificationError-recursive")
public class VerificationErrorRecursive {
  public static final String JSON_PROPERTY_CODE = "code";
  private String code;

  public static final String JSON_PROPERTY_MESSAGE = "message";
  private String message;

  /**
   * The type of verification error. Possible values: **invalidInput**, **dataMissing**, and
   * **pendingStatus**.
   */
  public enum TypeEnum {
    DATAMISSING(String.valueOf("dataMissing")),

    INVALIDINPUT(String.valueOf("invalidInput")),

    PENDINGSTATUS(String.valueOf("pendingStatus"));

    private static final Logger LOG = Logger.getLogger(TypeEnum.class.getName());

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "TypeEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(TypeEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_REMEDIATING_ACTIONS = "remediatingActions";
  private List<RemediatingAction> remediatingActions;

  public VerificationErrorRecursive() {}

  /**
   * The verification error code.
   *
   * @param code The verification error code.
   * @return the current {@code VerificationErrorRecursive} instance, allowing for method chaining
   */
  public VerificationErrorRecursive code(String code) {
    this.code = code;
    return this;
  }

  /**
   * The verification error code.
   *
   * @return code The verification error code.
   */
  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCode() {
    return code;
  }

  /**
   * The verification error code.
   *
   * @param code The verification error code.
   */
  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCode(String code) {
    this.code = code;
  }

  /**
   * The verification error message.
   *
   * @param message The verification error message.
   * @return the current {@code VerificationErrorRecursive} instance, allowing for method chaining
   */
  public VerificationErrorRecursive message(String message) {
    this.message = message;
    return this;
  }

  /**
   * The verification error message.
   *
   * @return message The verification error message.
   */
  @JsonProperty(JSON_PROPERTY_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMessage() {
    return message;
  }

  /**
   * The verification error message.
   *
   * @param message The verification error message.
   */
  @JsonProperty(JSON_PROPERTY_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessage(String message) {
    this.message = message;
  }

  /**
   * The type of verification error. Possible values: **invalidInput**, **dataMissing**, and
   * **pendingStatus**.
   *
   * @param type The type of verification error. Possible values: **invalidInput**, **dataMissing**,
   *     and **pendingStatus**.
   * @return the current {@code VerificationErrorRecursive} instance, allowing for method chaining
   */
  public VerificationErrorRecursive type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * The type of verification error. Possible values: **invalidInput**, **dataMissing**, and
   * **pendingStatus**.
   *
   * @return type The type of verification error. Possible values: **invalidInput**,
   *     **dataMissing**, and **pendingStatus**.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * The type of verification error. Possible values: **invalidInput**, **dataMissing**, and
   * **pendingStatus**.
   *
   * @param type The type of verification error. Possible values: **invalidInput**, **dataMissing**,
   *     and **pendingStatus**.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /**
   * The actions that you can take to resolve the verification error.
   *
   * @param remediatingActions The actions that you can take to resolve the verification error.
   * @return the current {@code VerificationErrorRecursive} instance, allowing for method chaining
   */
  public VerificationErrorRecursive remediatingActions(List<RemediatingAction> remediatingActions) {
    this.remediatingActions = remediatingActions;
    return this;
  }

  public VerificationErrorRecursive addRemediatingActionsItem(
      RemediatingAction remediatingActionsItem) {
    if (this.remediatingActions == null) {
      this.remediatingActions = new ArrayList<>();
    }
    this.remediatingActions.add(remediatingActionsItem);
    return this;
  }

  /**
   * The actions that you can take to resolve the verification error.
   *
   * @return remediatingActions The actions that you can take to resolve the verification error.
   */
  @JsonProperty(JSON_PROPERTY_REMEDIATING_ACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<RemediatingAction> getRemediatingActions() {
    return remediatingActions;
  }

  /**
   * The actions that you can take to resolve the verification error.
   *
   * @param remediatingActions The actions that you can take to resolve the verification error.
   */
  @JsonProperty(JSON_PROPERTY_REMEDIATING_ACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRemediatingActions(List<RemediatingAction> remediatingActions) {
    this.remediatingActions = remediatingActions;
  }

  /** Return true if this VerificationError-recursive object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    VerificationErrorRecursive verificationErrorRecursive = (VerificationErrorRecursive) o;
    return Objects.equals(this.code, verificationErrorRecursive.code)
        && Objects.equals(this.message, verificationErrorRecursive.message)
        && Objects.equals(this.type, verificationErrorRecursive.type)
        && Objects.equals(this.remediatingActions, verificationErrorRecursive.remediatingActions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, type, remediatingActions);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class VerificationErrorRecursive {\n");
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    remediatingActions: ").append(toIndentedString(remediatingActions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of VerificationErrorRecursive given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of VerificationErrorRecursive
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     VerificationErrorRecursive
   */
  public static VerificationErrorRecursive fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, VerificationErrorRecursive.class);
  }

  /**
   * Convert an instance of VerificationErrorRecursive to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
