/*
 * Account API
 * This API is used for the classic integration. If you are just starting your implementation, refer to our [new integration guide](https://docs.adyen.com/marketplaces-and-platforms) instead.  The Account API provides endpoints for managing account-related entities on your platform. These related entities include account holders, accounts, bank accounts, shareholders, and verification-related documents. The management operations include actions such as creation, retrieval, updating, and deletion of them.  For more information, refer to our [documentation](https://docs.adyen.com/marketplaces-and-platforms/classic). ## Authentication Your Adyen contact will provide your API credential and an API key. To connect to the API, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication. For example:  ``` curl -U \"ws@MarketPlace.YOUR_PLATFORM_ACCOUNT\":\"YOUR_WS_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ``` When going live, you need to generate new web service user credentials to access the [live endpoints](https://docs.adyen.com/development-resources/live-endpoints).  ## Versioning The Account API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://cal-test.adyen.com/cal/services/Account/v6/createAccountHolder ```
 *
 * The version of the OpenAPI document: 6
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.marketpayaccount;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** LegalArrangementEntityDetail */
@JsonPropertyOrder({
  LegalArrangementEntityDetail.JSON_PROPERTY_ADDRESS,
  LegalArrangementEntityDetail.JSON_PROPERTY_BUSINESS_DETAILS,
  LegalArrangementEntityDetail.JSON_PROPERTY_EMAIL,
  LegalArrangementEntityDetail.JSON_PROPERTY_FULL_PHONE_NUMBER,
  LegalArrangementEntityDetail.JSON_PROPERTY_INDIVIDUAL_DETAILS,
  LegalArrangementEntityDetail.JSON_PROPERTY_LEGAL_ARRANGEMENT_ENTITY_CODE,
  LegalArrangementEntityDetail.JSON_PROPERTY_LEGAL_ARRANGEMENT_ENTITY_REFERENCE,
  LegalArrangementEntityDetail.JSON_PROPERTY_LEGAL_ARRANGEMENT_MEMBERS,
  LegalArrangementEntityDetail.JSON_PROPERTY_LEGAL_ENTITY_TYPE,
  LegalArrangementEntityDetail.JSON_PROPERTY_PHONE_NUMBER,
  LegalArrangementEntityDetail.JSON_PROPERTY_WEB_ADDRESS
})
public class LegalArrangementEntityDetail {
  public static final String JSON_PROPERTY_ADDRESS = "address";
  private ViasAddress address;

  public static final String JSON_PROPERTY_BUSINESS_DETAILS = "businessDetails";
  private BusinessDetails businessDetails;

  public static final String JSON_PROPERTY_EMAIL = "email";
  private String email;

  public static final String JSON_PROPERTY_FULL_PHONE_NUMBER = "fullPhoneNumber";
  private String fullPhoneNumber;

  public static final String JSON_PROPERTY_INDIVIDUAL_DETAILS = "individualDetails";
  private IndividualDetails individualDetails;

  public static final String JSON_PROPERTY_LEGAL_ARRANGEMENT_ENTITY_CODE =
      "legalArrangementEntityCode";
  private String legalArrangementEntityCode;

  public static final String JSON_PROPERTY_LEGAL_ARRANGEMENT_ENTITY_REFERENCE =
      "legalArrangementEntityReference";
  private String legalArrangementEntityReference;

  /** Gets or Sets legalArrangementMembers */
  public enum LegalArrangementMembersEnum {
    BENEFICIARY("Beneficiary"),

    CONTROLLINGPERSON("ControllingPerson"),

    PARTNER("Partner"),

    PROTECTOR("Protector"),

    SETTLOR("Settlor"),

    SHAREHOLDER("Shareholder"),

    TRUSTEE("Trustee");

    private String value;

    LegalArrangementMembersEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static LegalArrangementMembersEnum fromValue(String value) {
      for (LegalArrangementMembersEnum b : LegalArrangementMembersEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_LEGAL_ARRANGEMENT_MEMBERS = "legalArrangementMembers";
  private List<LegalArrangementMembersEnum> legalArrangementMembers = null;

  /**
   * The legal entity type. Possible values: **Business**, **Individual**, **NonProfit**,
   * **PublicCompany**, or **Partnership**.
   */
  public enum LegalEntityTypeEnum {
    BUSINESS("Business"),

    INDIVIDUAL("Individual"),

    NONPROFIT("NonProfit"),

    PARTNERSHIP("Partnership"),

    PUBLICCOMPANY("PublicCompany");

    private String value;

    LegalEntityTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static LegalEntityTypeEnum fromValue(String value) {
      for (LegalEntityTypeEnum b : LegalEntityTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_LEGAL_ENTITY_TYPE = "legalEntityType";
  private LegalEntityTypeEnum legalEntityType;

  public static final String JSON_PROPERTY_PHONE_NUMBER = "phoneNumber";
  private ViasPhoneNumber phoneNumber;

  public static final String JSON_PROPERTY_WEB_ADDRESS = "webAddress";
  private String webAddress;

  public LegalArrangementEntityDetail() {}

  public LegalArrangementEntityDetail address(ViasAddress address) {
    this.address = address;
    return this;
  }

  /**
   * Get address
   *
   * @return address
   */
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ViasAddress getAddress() {
    return address;
  }

  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress(ViasAddress address) {
    this.address = address;
  }

  public LegalArrangementEntityDetail businessDetails(BusinessDetails businessDetails) {
    this.businessDetails = businessDetails;
    return this;
  }

  /**
   * Get businessDetails
   *
   * @return businessDetails
   */
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_BUSINESS_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public BusinessDetails getBusinessDetails() {
    return businessDetails;
  }

  @JsonProperty(JSON_PROPERTY_BUSINESS_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBusinessDetails(BusinessDetails businessDetails) {
    this.businessDetails = businessDetails;
  }

  public LegalArrangementEntityDetail email(String email) {
    this.email = email;
    return this;
  }

  /**
   * The e-mail address of the entity.
   *
   * @return email
   */
  @ApiModelProperty(value = "The e-mail address of the entity.")
  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getEmail() {
    return email;
  }

  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEmail(String email) {
    this.email = email;
  }

  public LegalArrangementEntityDetail fullPhoneNumber(String fullPhoneNumber) {
    this.fullPhoneNumber = fullPhoneNumber;
    return this;
  }

  /**
   * The phone number of the contact provided as a single string. It will be handled as a landline
   * phone. **Examples:** \&quot;0031 6 11 22 33 44\&quot;, \&quot;+316/1122-3344\&quot;,
   * \&quot;(0031) 611223344\&quot;
   *
   * @return fullPhoneNumber
   */
  @ApiModelProperty(
      value =
          "The phone number of the contact provided as a single string.  It will be handled as a landline phone. **Examples:** \"0031 6 11 22 33 44\", \"+316/1122-3344\", \"(0031) 611223344\"")
  @JsonProperty(JSON_PROPERTY_FULL_PHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getFullPhoneNumber() {
    return fullPhoneNumber;
  }

  @JsonProperty(JSON_PROPERTY_FULL_PHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFullPhoneNumber(String fullPhoneNumber) {
    this.fullPhoneNumber = fullPhoneNumber;
  }

  public LegalArrangementEntityDetail individualDetails(IndividualDetails individualDetails) {
    this.individualDetails = individualDetails;
    return this;
  }

  /**
   * Get individualDetails
   *
   * @return individualDetails
   */
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INDIVIDUAL_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public IndividualDetails getIndividualDetails() {
    return individualDetails;
  }

  @JsonProperty(JSON_PROPERTY_INDIVIDUAL_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIndividualDetails(IndividualDetails individualDetails) {
    this.individualDetails = individualDetails;
  }

  public LegalArrangementEntityDetail legalArrangementEntityCode(
      String legalArrangementEntityCode) {
    this.legalArrangementEntityCode = legalArrangementEntityCode;
    return this;
  }

  /**
   * Adyen-generated unique alphanumeric identifier (UUID) for the entry, returned in the response
   * when you create a legal arrangement entity. Use only when updating an account holder. If you
   * include this field when creating an account holder, the request will fail.
   *
   * @return legalArrangementEntityCode
   */
  @ApiModelProperty(
      value =
          "Adyen-generated unique alphanumeric identifier (UUID) for the entry, returned in the response when you create a legal arrangement entity. Use only when updating an account holder. If you include this field when creating an account holder, the request will fail.")
  @JsonProperty(JSON_PROPERTY_LEGAL_ARRANGEMENT_ENTITY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getLegalArrangementEntityCode() {
    return legalArrangementEntityCode;
  }

  @JsonProperty(JSON_PROPERTY_LEGAL_ARRANGEMENT_ENTITY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLegalArrangementEntityCode(String legalArrangementEntityCode) {
    this.legalArrangementEntityCode = legalArrangementEntityCode;
  }

  public LegalArrangementEntityDetail legalArrangementEntityReference(
      String legalArrangementEntityReference) {
    this.legalArrangementEntityReference = legalArrangementEntityReference;
    return this;
  }

  /**
   * Your reference for the legal arrangement entity.
   *
   * @return legalArrangementEntityReference
   */
  @ApiModelProperty(value = "Your reference for the legal arrangement entity.")
  @JsonProperty(JSON_PROPERTY_LEGAL_ARRANGEMENT_ENTITY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getLegalArrangementEntityReference() {
    return legalArrangementEntityReference;
  }

  @JsonProperty(JSON_PROPERTY_LEGAL_ARRANGEMENT_ENTITY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLegalArrangementEntityReference(String legalArrangementEntityReference) {
    this.legalArrangementEntityReference = legalArrangementEntityReference;
  }

  public LegalArrangementEntityDetail legalArrangementMembers(
      List<LegalArrangementMembersEnum> legalArrangementMembers) {
    this.legalArrangementMembers = legalArrangementMembers;
    return this;
  }

  public LegalArrangementEntityDetail addLegalArrangementMembersItem(
      LegalArrangementMembersEnum legalArrangementMembersItem) {
    if (this.legalArrangementMembers == null) {
      this.legalArrangementMembers = new ArrayList<>();
    }
    this.legalArrangementMembers.add(legalArrangementMembersItem);
    return this;
  }

  /**
   * An array containing the roles of the entity in the legal arrangement. The possible values
   * depend on the legal arrangement &#x60;type&#x60;. - For &#x60;type&#x60; **Association**:
   * **ControllingPerson** and **Shareholder**. - For &#x60;type&#x60; **Partnership**: **Partner**
   * and **Shareholder**. - For &#x60;type&#x60; **Trust**: **Trustee**, **Settlor**, **Protector**,
   * **Beneficiary**, and **Shareholder**.
   *
   * @return legalArrangementMembers
   */
  @ApiModelProperty(
      value =
          "An array containing the roles of the entity in the legal arrangement.  The possible values depend on the legal arrangement `type`.  - For `type` **Association**: **ControllingPerson** and **Shareholder**.  - For `type` **Partnership**: **Partner** and **Shareholder**.  - For `type` **Trust**: **Trustee**, **Settlor**, **Protector**, **Beneficiary**,  and **Shareholder**.  ")
  @JsonProperty(JSON_PROPERTY_LEGAL_ARRANGEMENT_MEMBERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<LegalArrangementMembersEnum> getLegalArrangementMembers() {
    return legalArrangementMembers;
  }

  @JsonProperty(JSON_PROPERTY_LEGAL_ARRANGEMENT_MEMBERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLegalArrangementMembers(
      List<LegalArrangementMembersEnum> legalArrangementMembers) {
    this.legalArrangementMembers = legalArrangementMembers;
  }

  public LegalArrangementEntityDetail legalEntityType(LegalEntityTypeEnum legalEntityType) {
    this.legalEntityType = legalEntityType;
    return this;
  }

  /**
   * The legal entity type. Possible values: **Business**, **Individual**, **NonProfit**,
   * **PublicCompany**, or **Partnership**.
   *
   * @return legalEntityType
   */
  @ApiModelProperty(
      value =
          "The legal entity type.  Possible values: **Business**, **Individual**, **NonProfit**, **PublicCompany**, or **Partnership**. ")
  @JsonProperty(JSON_PROPERTY_LEGAL_ENTITY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public LegalEntityTypeEnum getLegalEntityType() {
    return legalEntityType;
  }

  @JsonProperty(JSON_PROPERTY_LEGAL_ENTITY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLegalEntityType(LegalEntityTypeEnum legalEntityType) {
    this.legalEntityType = legalEntityType;
  }

  public LegalArrangementEntityDetail phoneNumber(ViasPhoneNumber phoneNumber) {
    this.phoneNumber = phoneNumber;
    return this;
  }

  /**
   * Get phoneNumber
   *
   * @return phoneNumber
   */
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ViasPhoneNumber getPhoneNumber() {
    return phoneNumber;
  }

  @JsonProperty(JSON_PROPERTY_PHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPhoneNumber(ViasPhoneNumber phoneNumber) {
    this.phoneNumber = phoneNumber;
  }

  public LegalArrangementEntityDetail webAddress(String webAddress) {
    this.webAddress = webAddress;
    return this;
  }

  /**
   * The URL of the website of the contact.
   *
   * @return webAddress
   */
  @ApiModelProperty(value = "The URL of the website of the contact.")
  @JsonProperty(JSON_PROPERTY_WEB_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getWebAddress() {
    return webAddress;
  }

  @JsonProperty(JSON_PROPERTY_WEB_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWebAddress(String webAddress) {
    this.webAddress = webAddress;
  }

  /** Return true if this LegalArrangementEntityDetail object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LegalArrangementEntityDetail legalArrangementEntityDetail = (LegalArrangementEntityDetail) o;
    return Objects.equals(this.address, legalArrangementEntityDetail.address)
        && Objects.equals(this.businessDetails, legalArrangementEntityDetail.businessDetails)
        && Objects.equals(this.email, legalArrangementEntityDetail.email)
        && Objects.equals(this.fullPhoneNumber, legalArrangementEntityDetail.fullPhoneNumber)
        && Objects.equals(this.individualDetails, legalArrangementEntityDetail.individualDetails)
        && Objects.equals(
            this.legalArrangementEntityCode,
            legalArrangementEntityDetail.legalArrangementEntityCode)
        && Objects.equals(
            this.legalArrangementEntityReference,
            legalArrangementEntityDetail.legalArrangementEntityReference)
        && Objects.equals(
            this.legalArrangementMembers, legalArrangementEntityDetail.legalArrangementMembers)
        && Objects.equals(this.legalEntityType, legalArrangementEntityDetail.legalEntityType)
        && Objects.equals(this.phoneNumber, legalArrangementEntityDetail.phoneNumber)
        && Objects.equals(this.webAddress, legalArrangementEntityDetail.webAddress);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        address,
        businessDetails,
        email,
        fullPhoneNumber,
        individualDetails,
        legalArrangementEntityCode,
        legalArrangementEntityReference,
        legalArrangementMembers,
        legalEntityType,
        phoneNumber,
        webAddress);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LegalArrangementEntityDetail {\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    businessDetails: ").append(toIndentedString(businessDetails)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    fullPhoneNumber: ").append(toIndentedString(fullPhoneNumber)).append("\n");
    sb.append("    individualDetails: ").append(toIndentedString(individualDetails)).append("\n");
    sb.append("    legalArrangementEntityCode: ")
        .append(toIndentedString(legalArrangementEntityCode))
        .append("\n");
    sb.append("    legalArrangementEntityReference: ")
        .append(toIndentedString(legalArrangementEntityReference))
        .append("\n");
    sb.append("    legalArrangementMembers: ")
        .append(toIndentedString(legalArrangementMembers))
        .append("\n");
    sb.append("    legalEntityType: ").append(toIndentedString(legalEntityType)).append("\n");
    sb.append("    phoneNumber: ").append(toIndentedString(phoneNumber)).append("\n");
    sb.append("    webAddress: ").append(toIndentedString(webAddress)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of LegalArrangementEntityDetail given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of LegalArrangementEntityDetail
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     LegalArrangementEntityDetail
   */
  public static LegalArrangementEntityDetail fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, LegalArrangementEntityDetail.class);
  }

  /**
   * Convert an instance of LegalArrangementEntityDetail to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
