/*
 * Account API
 * This API is used for the classic integration. If you are just starting your implementation, refer to our [new integration guide](https://docs.adyen.com/marketplaces-and-platforms) instead.  The Account API provides endpoints for managing account-related entities on your platform. These related entities include account holders, accounts, bank accounts, shareholders, and verification-related documents. The management operations include actions such as creation, retrieval, updating, and deletion of them.  For more information, refer to our [documentation](https://docs.adyen.com/marketplaces-and-platforms/classic). ## Authentication Your Adyen contact will provide your API credential and an API key. To connect to the API, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication. For example:  ``` curl -U \"ws@MarketPlace.YOUR_PLATFORM_ACCOUNT\":\"YOUR_WS_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ``` When going live, you need to generate new web service user credentials to access the [live endpoints](https://docs.adyen.com/development-resources/live-endpoints).  ## Versioning The Account API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://cal-test.adyen.com/cal/services/Account/v6/createAccountHolder ```
 *
 * The version of the OpenAPI document: 6
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.marketpayaccount;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/** ShareholderContact */
@JsonPropertyOrder({
  ShareholderContact.JSON_PROPERTY_ADDRESS,
  ShareholderContact.JSON_PROPERTY_EMAIL,
  ShareholderContact.JSON_PROPERTY_FULL_PHONE_NUMBER,
  ShareholderContact.JSON_PROPERTY_JOB_TITLE,
  ShareholderContact.JSON_PROPERTY_NAME,
  ShareholderContact.JSON_PROPERTY_PERSONAL_DATA,
  ShareholderContact.JSON_PROPERTY_PHONE_NUMBER,
  ShareholderContact.JSON_PROPERTY_SHAREHOLDER_CODE,
  ShareholderContact.JSON_PROPERTY_SHAREHOLDER_REFERENCE,
  ShareholderContact.JSON_PROPERTY_SHAREHOLDER_TYPE,
  ShareholderContact.JSON_PROPERTY_WEB_ADDRESS
})
public class ShareholderContact {
  public static final String JSON_PROPERTY_ADDRESS = "address";
  private ViasAddress address;

  public static final String JSON_PROPERTY_EMAIL = "email";
  private String email;

  public static final String JSON_PROPERTY_FULL_PHONE_NUMBER = "fullPhoneNumber";
  private String fullPhoneNumber;

  public static final String JSON_PROPERTY_JOB_TITLE = "jobTitle";
  private String jobTitle;

  public static final String JSON_PROPERTY_NAME = "name";
  private ViasName name;

  public static final String JSON_PROPERTY_PERSONAL_DATA = "personalData";
  private ViasPersonalData personalData;

  public static final String JSON_PROPERTY_PHONE_NUMBER = "phoneNumber";
  private ViasPhoneNumber phoneNumber;

  public static final String JSON_PROPERTY_SHAREHOLDER_CODE = "shareholderCode";
  private String shareholderCode;

  public static final String JSON_PROPERTY_SHAREHOLDER_REFERENCE = "shareholderReference";
  private String shareholderReference;

  /**
   * Specifies how the person is associated with the account holder. Possible values: * **Owner**:
   * Individuals who directly or indirectly own 25% or more of a company. * **Controller**:
   * Individuals who are members of senior management staff responsible for managing a company or
   * organization.
   */
  public enum ShareholderTypeEnum {
    CONTROLLER("Controller"),

    OWNER("Owner"),

    SIGNATORY("Signatory");

    private String value;

    ShareholderTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ShareholderTypeEnum fromValue(String value) {
      for (ShareholderTypeEnum b : ShareholderTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SHAREHOLDER_TYPE = "shareholderType";
  private ShareholderTypeEnum shareholderType;

  public static final String JSON_PROPERTY_WEB_ADDRESS = "webAddress";
  private String webAddress;

  public ShareholderContact() {}

  public ShareholderContact address(ViasAddress address) {
    this.address = address;
    return this;
  }

  /**
   * Get address
   *
   * @return address
   */
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ViasAddress getAddress() {
    return address;
  }

  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress(ViasAddress address) {
    this.address = address;
  }

  public ShareholderContact email(String email) {
    this.email = email;
    return this;
  }

  /**
   * The e-mail address of the person.
   *
   * @return email
   */
  @ApiModelProperty(value = "The e-mail address of the person.")
  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getEmail() {
    return email;
  }

  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEmail(String email) {
    this.email = email;
  }

  public ShareholderContact fullPhoneNumber(String fullPhoneNumber) {
    this.fullPhoneNumber = fullPhoneNumber;
    return this;
  }

  /**
   * The phone number of the person provided as a single string. It will be handled as a landline
   * phone. Examples: \&quot;0031 6 11 22 33 44\&quot;, \&quot;+316/1122-3344\&quot;, \&quot;(0031)
   * 611223344\&quot;
   *
   * @return fullPhoneNumber
   */
  @ApiModelProperty(
      value =
          "The phone number of the person provided as a single string.  It will be handled as a landline phone. Examples: \"0031 6 11 22 33 44\", \"+316/1122-3344\", \"(0031) 611223344\"")
  @JsonProperty(JSON_PROPERTY_FULL_PHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getFullPhoneNumber() {
    return fullPhoneNumber;
  }

  @JsonProperty(JSON_PROPERTY_FULL_PHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFullPhoneNumber(String fullPhoneNumber) {
    this.fullPhoneNumber = fullPhoneNumber;
  }

  public ShareholderContact jobTitle(String jobTitle) {
    this.jobTitle = jobTitle;
    return this;
  }

  /**
   * Job title of the person. Required when the &#x60;shareholderType&#x60; is **Controller**.
   * Example values: **Chief Executive Officer**, **Chief Financial Officer**, **Chief Operating
   * Officer**, **President**, **Vice President**, **Executive President**, **Managing Member**,
   * **Partner**, **Treasurer**, **Director**, or **Other**.
   *
   * @return jobTitle
   */
  @ApiModelProperty(
      value =
          "Job title of the person. Required when the `shareholderType` is **Controller**.  Example values: **Chief Executive Officer**, **Chief Financial Officer**, **Chief Operating Officer**, **President**, **Vice President**, **Executive President**, **Managing Member**, **Partner**, **Treasurer**, **Director**, or **Other**.")
  @JsonProperty(JSON_PROPERTY_JOB_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getJobTitle() {
    return jobTitle;
  }

  @JsonProperty(JSON_PROPERTY_JOB_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setJobTitle(String jobTitle) {
    this.jobTitle = jobTitle;
  }

  public ShareholderContact name(ViasName name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   *
   * @return name
   */
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ViasName getName() {
    return name;
  }

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(ViasName name) {
    this.name = name;
  }

  public ShareholderContact personalData(ViasPersonalData personalData) {
    this.personalData = personalData;
    return this;
  }

  /**
   * Get personalData
   *
   * @return personalData
   */
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PERSONAL_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ViasPersonalData getPersonalData() {
    return personalData;
  }

  @JsonProperty(JSON_PROPERTY_PERSONAL_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPersonalData(ViasPersonalData personalData) {
    this.personalData = personalData;
  }

  public ShareholderContact phoneNumber(ViasPhoneNumber phoneNumber) {
    this.phoneNumber = phoneNumber;
    return this;
  }

  /**
   * Get phoneNumber
   *
   * @return phoneNumber
   */
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ViasPhoneNumber getPhoneNumber() {
    return phoneNumber;
  }

  @JsonProperty(JSON_PROPERTY_PHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPhoneNumber(ViasPhoneNumber phoneNumber) {
    this.phoneNumber = phoneNumber;
  }

  public ShareholderContact shareholderCode(String shareholderCode) {
    this.shareholderCode = shareholderCode;
    return this;
  }

  /**
   * The unique identifier (UUID) of the shareholder entry. &gt;**If, during an Account Holder
   * create or update request, this field is left blank (but other fields provided), a new
   * Shareholder will be created with a procedurally-generated UUID.** &gt;**If, during an Account
   * Holder create request, a UUID is provided, the creation of Account Holder will fail with a
   * validation Error..** &gt;**If, during an Account Holder update request, a UUID that is not
   * correlated with an existing Shareholder is provided, the update of the Shareholder will fail.**
   * &gt;**If, during an Account Holder update request, a UUID that is correlated with an existing
   * Shareholder is provided, the existing Shareholder will be updated.**
   *
   * @return shareholderCode
   */
  @ApiModelProperty(
      value =
          "The unique identifier (UUID) of the shareholder entry. >**If, during an Account Holder create or update request, this field is left blank (but other fields provided), a new Shareholder will be created with a procedurally-generated UUID.**  >**If, during an Account Holder create request, a UUID is provided, the creation of Account Holder will fail with a validation Error..**  >**If, during an Account Holder update request, a UUID that is not correlated with an existing Shareholder is provided, the update of the Shareholder will fail.**  >**If, during an Account Holder update request, a UUID that is correlated with an existing Shareholder is provided, the existing Shareholder will be updated.** ")
  @JsonProperty(JSON_PROPERTY_SHAREHOLDER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getShareholderCode() {
    return shareholderCode;
  }

  @JsonProperty(JSON_PROPERTY_SHAREHOLDER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShareholderCode(String shareholderCode) {
    this.shareholderCode = shareholderCode;
  }

  public ShareholderContact shareholderReference(String shareholderReference) {
    this.shareholderReference = shareholderReference;
    return this;
  }

  /**
   * Your reference for the shareholder entry.
   *
   * @return shareholderReference
   */
  @ApiModelProperty(value = "Your reference for the shareholder entry.")
  @JsonProperty(JSON_PROPERTY_SHAREHOLDER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getShareholderReference() {
    return shareholderReference;
  }

  @JsonProperty(JSON_PROPERTY_SHAREHOLDER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShareholderReference(String shareholderReference) {
    this.shareholderReference = shareholderReference;
  }

  public ShareholderContact shareholderType(ShareholderTypeEnum shareholderType) {
    this.shareholderType = shareholderType;
    return this;
  }

  /**
   * Specifies how the person is associated with the account holder. Possible values: * **Owner**:
   * Individuals who directly or indirectly own 25% or more of a company. * **Controller**:
   * Individuals who are members of senior management staff responsible for managing a company or
   * organization.
   *
   * @return shareholderType
   */
  @ApiModelProperty(
      value =
          "Specifies how the person is associated with the account holder.   Possible values:   * **Owner**: Individuals who directly or indirectly own 25% or more of a company.  * **Controller**: Individuals who are members of senior management staff responsible for managing a company or organization.")
  @JsonProperty(JSON_PROPERTY_SHAREHOLDER_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ShareholderTypeEnum getShareholderType() {
    return shareholderType;
  }

  @JsonProperty(JSON_PROPERTY_SHAREHOLDER_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShareholderType(ShareholderTypeEnum shareholderType) {
    this.shareholderType = shareholderType;
  }

  public ShareholderContact webAddress(String webAddress) {
    this.webAddress = webAddress;
    return this;
  }

  /**
   * The URL of the person&#39;s website.
   *
   * @return webAddress
   */
  @ApiModelProperty(value = "The URL of the person's website.")
  @JsonProperty(JSON_PROPERTY_WEB_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getWebAddress() {
    return webAddress;
  }

  @JsonProperty(JSON_PROPERTY_WEB_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWebAddress(String webAddress) {
    this.webAddress = webAddress;
  }

  /** Return true if this ShareholderContact object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ShareholderContact shareholderContact = (ShareholderContact) o;
    return Objects.equals(this.address, shareholderContact.address)
        && Objects.equals(this.email, shareholderContact.email)
        && Objects.equals(this.fullPhoneNumber, shareholderContact.fullPhoneNumber)
        && Objects.equals(this.jobTitle, shareholderContact.jobTitle)
        && Objects.equals(this.name, shareholderContact.name)
        && Objects.equals(this.personalData, shareholderContact.personalData)
        && Objects.equals(this.phoneNumber, shareholderContact.phoneNumber)
        && Objects.equals(this.shareholderCode, shareholderContact.shareholderCode)
        && Objects.equals(this.shareholderReference, shareholderContact.shareholderReference)
        && Objects.equals(this.shareholderType, shareholderContact.shareholderType)
        && Objects.equals(this.webAddress, shareholderContact.webAddress);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        address,
        email,
        fullPhoneNumber,
        jobTitle,
        name,
        personalData,
        phoneNumber,
        shareholderCode,
        shareholderReference,
        shareholderType,
        webAddress);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ShareholderContact {\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    fullPhoneNumber: ").append(toIndentedString(fullPhoneNumber)).append("\n");
    sb.append("    jobTitle: ").append(toIndentedString(jobTitle)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    personalData: ").append(toIndentedString(personalData)).append("\n");
    sb.append("    phoneNumber: ").append(toIndentedString(phoneNumber)).append("\n");
    sb.append("    shareholderCode: ").append(toIndentedString(shareholderCode)).append("\n");
    sb.append("    shareholderReference: ")
        .append(toIndentedString(shareholderReference))
        .append("\n");
    sb.append("    shareholderType: ").append(toIndentedString(shareholderType)).append("\n");
    sb.append("    webAddress: ").append(toIndentedString(webAddress)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of ShareholderContact given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of ShareholderContact
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     ShareholderContact
   */
  public static ShareholderContact fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, ShareholderContact.class);
  }

  /**
   * Convert an instance of ShareholderContact to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
