/*
 * Fund API
 * This API is used for the classic integration. If you are just starting your implementation, refer to our [new integration guide](https://docs.adyen.com/marketplaces-and-platforms) instead.  The Fund API provides endpoints for managing the funds in the accounts on your platform. These management operations include, for example, the transfer of funds from one account to another, the payout of funds to an account holder, and the retrieval of balances in an account.  For more information, refer to our [documentation](https://docs.adyen.com/marketplaces-and-platforms/classic/). ## Authentication Your Adyen contact will provide your API credential and an API key. To connect to the API, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication. For example:  ``` curl -U \"ws@MarketPlace.YOUR_PLATFORM_ACCOUNT\":\"YOUR_WS_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ``` When going live, you need to generate new web service user credentials to access the [live endpoints](https://docs.adyen.com/development-resources/live-endpoints).  ## Versioning The Fund API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://cal-test.adyen.com/cal/services/Fund/v6/accountHolderBalance ```
 *
 * The version of the OpenAPI document: 6
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.marketpayfund;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/** ErrorFieldType */
@JsonPropertyOrder({
  ErrorFieldType.JSON_PROPERTY_ERROR_CODE,
  ErrorFieldType.JSON_PROPERTY_ERROR_DESCRIPTION,
  ErrorFieldType.JSON_PROPERTY_FIELD_TYPE
})
public class ErrorFieldType {
  public static final String JSON_PROPERTY_ERROR_CODE = "errorCode";
  private Integer errorCode;

  public static final String JSON_PROPERTY_ERROR_DESCRIPTION = "errorDescription";
  private String errorDescription;

  public static final String JSON_PROPERTY_FIELD_TYPE = "fieldType";
  private FieldType fieldType;

  public ErrorFieldType() {}

  public ErrorFieldType errorCode(Integer errorCode) {
    this.errorCode = errorCode;
    return this;
  }

  /**
   * The validation error code.
   *
   * @return errorCode
   */
  @ApiModelProperty(value = "The validation error code.")
  @JsonProperty(JSON_PROPERTY_ERROR_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getErrorCode() {
    return errorCode;
  }

  @JsonProperty(JSON_PROPERTY_ERROR_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setErrorCode(Integer errorCode) {
    this.errorCode = errorCode;
  }

  public ErrorFieldType errorDescription(String errorDescription) {
    this.errorDescription = errorDescription;
    return this;
  }

  /**
   * A description of the validation error.
   *
   * @return errorDescription
   */
  @ApiModelProperty(value = "A description of the validation error.")
  @JsonProperty(JSON_PROPERTY_ERROR_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getErrorDescription() {
    return errorDescription;
  }

  @JsonProperty(JSON_PROPERTY_ERROR_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setErrorDescription(String errorDescription) {
    this.errorDescription = errorDescription;
  }

  public ErrorFieldType fieldType(FieldType fieldType) {
    this.fieldType = fieldType;
    return this;
  }

  /**
   * Get fieldType
   *
   * @return fieldType
   */
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FIELD_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public FieldType getFieldType() {
    return fieldType;
  }

  @JsonProperty(JSON_PROPERTY_FIELD_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFieldType(FieldType fieldType) {
    this.fieldType = fieldType;
  }

  /** Return true if this ErrorFieldType object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ErrorFieldType errorFieldType = (ErrorFieldType) o;
    return Objects.equals(this.errorCode, errorFieldType.errorCode)
        && Objects.equals(this.errorDescription, errorFieldType.errorDescription)
        && Objects.equals(this.fieldType, errorFieldType.fieldType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(errorCode, errorDescription, fieldType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ErrorFieldType {\n");
    sb.append("    errorCode: ").append(toIndentedString(errorCode)).append("\n");
    sb.append("    errorDescription: ").append(toIndentedString(errorDescription)).append("\n");
    sb.append("    fieldType: ").append(toIndentedString(fieldType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of ErrorFieldType given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of ErrorFieldType
   * @throws JsonProcessingException if the JSON string is invalid with respect to ErrorFieldType
   */
  public static ErrorFieldType fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, ErrorFieldType.class);
  }

  /**
   * Convert an instance of ErrorFieldType to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
