/*
 * Hosted onboarding API
 * This API is used for the classic integration. If you are just starting your implementation, refer to our [new integration guide](https://docs.adyen.com/marketplaces-and-platforms) instead.  The Hosted onboarding API provides endpoints that you can use to generate links to Adyen-hosted pages, such as an [onboarding page](https://docs.adyen.com/marketplaces-and-platforms/classic/hosted-onboarding-page) or a [PCI compliance questionnaire](https://docs.adyen.com/marketplaces-and-platforms/classic/platforms-for-partners). You can provide these links to your account holders so that they can complete their onboarding.  ## Authentication Your Adyen contact will provide your API credential and an API key. To connect to the API, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication. For example:  ``` curl -U \"ws@MarketPlace.YOUR_PLATFORM_ACCOUNT\":\"YOUR_WS_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ``` When going live, you need to generate new web service user credentials to access the [live endpoints](https://docs.adyen.com/development-resources/live-endpoints).  ## Versioning The Hosted onboarding API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://cal-test.adyen.com/cal/services/Hop/v6/getOnboardingUrl ```
 *
 * The version of the OpenAPI document: 6
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.marketpayhop;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/** ShowPages */
@JsonPropertyOrder({
  ShowPages.JSON_PROPERTY_BANK_DETAILS_SUMMARY_PAGE,
  ShowPages.JSON_PROPERTY_BANK_VERIFICATION_PAGE,
  ShowPages.JSON_PROPERTY_BUSINESS_DETAILS_SUMMARY_PAGE,
  ShowPages.JSON_PROPERTY_CHECKS_OVERVIEW_PAGE,
  ShowPages.JSON_PROPERTY_INDIVIDUAL_DETAILS_SUMMARY_PAGE,
  ShowPages.JSON_PROPERTY_LEGAL_ARRANGEMENTS_DETAILS_SUMMARY_PAGE,
  ShowPages.JSON_PROPERTY_MANUAL_BANK_ACCOUNT_PAGE,
  ShowPages.JSON_PROPERTY_SHAREHOLDER_DETAILS_SUMMARY_PAGE,
  ShowPages.JSON_PROPERTY_WELCOME_PAGE
})
public class ShowPages {
  public static final String JSON_PROPERTY_BANK_DETAILS_SUMMARY_PAGE = "bankDetailsSummaryPage";
  private Boolean bankDetailsSummaryPage;

  public static final String JSON_PROPERTY_BANK_VERIFICATION_PAGE = "bankVerificationPage";
  private Boolean bankVerificationPage;

  public static final String JSON_PROPERTY_BUSINESS_DETAILS_SUMMARY_PAGE =
      "businessDetailsSummaryPage";
  private Boolean businessDetailsSummaryPage;

  public static final String JSON_PROPERTY_CHECKS_OVERVIEW_PAGE = "checksOverviewPage";
  private Boolean checksOverviewPage;

  public static final String JSON_PROPERTY_INDIVIDUAL_DETAILS_SUMMARY_PAGE =
      "individualDetailsSummaryPage";
  private Boolean individualDetailsSummaryPage;

  public static final String JSON_PROPERTY_LEGAL_ARRANGEMENTS_DETAILS_SUMMARY_PAGE =
      "legalArrangementsDetailsSummaryPage";
  private Boolean legalArrangementsDetailsSummaryPage;

  public static final String JSON_PROPERTY_MANUAL_BANK_ACCOUNT_PAGE = "manualBankAccountPage";
  private Boolean manualBankAccountPage;

  public static final String JSON_PROPERTY_SHAREHOLDER_DETAILS_SUMMARY_PAGE =
      "shareholderDetailsSummaryPage";
  private Boolean shareholderDetailsSummaryPage;

  public static final String JSON_PROPERTY_WELCOME_PAGE = "welcomePage";
  private Boolean welcomePage;

  public ShowPages() {}

  public ShowPages bankDetailsSummaryPage(Boolean bankDetailsSummaryPage) {
    this.bankDetailsSummaryPage = bankDetailsSummaryPage;
    return this;
  }

  /**
   * Indicates whether the page with bank account details must be shown. Defaults to **true**.
   *
   * @return bankDetailsSummaryPage
   */
  @ApiModelProperty(
      value =
          "Indicates whether the page with bank account details must be shown. Defaults to **true**.")
  @JsonProperty(JSON_PROPERTY_BANK_DETAILS_SUMMARY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getBankDetailsSummaryPage() {
    return bankDetailsSummaryPage;
  }

  @JsonProperty(JSON_PROPERTY_BANK_DETAILS_SUMMARY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBankDetailsSummaryPage(Boolean bankDetailsSummaryPage) {
    this.bankDetailsSummaryPage = bankDetailsSummaryPage;
  }

  public ShowPages bankVerificationPage(Boolean bankVerificationPage) {
    this.bankVerificationPage = bankVerificationPage;
    return this;
  }

  /**
   * Indicates whether the bank check instant verification&#39; details must be shown. Defaults to
   * **true**.
   *
   * @return bankVerificationPage
   */
  @ApiModelProperty(
      value =
          "Indicates whether the bank check instant verification' details must be shown. Defaults to **true**.")
  @JsonProperty(JSON_PROPERTY_BANK_VERIFICATION_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getBankVerificationPage() {
    return bankVerificationPage;
  }

  @JsonProperty(JSON_PROPERTY_BANK_VERIFICATION_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBankVerificationPage(Boolean bankVerificationPage) {
    this.bankVerificationPage = bankVerificationPage;
  }

  public ShowPages businessDetailsSummaryPage(Boolean businessDetailsSummaryPage) {
    this.businessDetailsSummaryPage = businessDetailsSummaryPage;
    return this;
  }

  /**
   * Indicates whether the page with the company&#39;s or organization&#39;s details must be shown.
   * Defaults to **true**.
   *
   * @return businessDetailsSummaryPage
   */
  @ApiModelProperty(
      value =
          "Indicates whether the page with the company's or organization's details must be shown. Defaults to **true**.")
  @JsonProperty(JSON_PROPERTY_BUSINESS_DETAILS_SUMMARY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getBusinessDetailsSummaryPage() {
    return businessDetailsSummaryPage;
  }

  @JsonProperty(JSON_PROPERTY_BUSINESS_DETAILS_SUMMARY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBusinessDetailsSummaryPage(Boolean businessDetailsSummaryPage) {
    this.businessDetailsSummaryPage = businessDetailsSummaryPage;
  }

  public ShowPages checksOverviewPage(Boolean checksOverviewPage) {
    this.checksOverviewPage = checksOverviewPage;
    return this;
  }

  /**
   * Indicates whether the checks overview page must be shown. Defaults to **false**.
   *
   * @return checksOverviewPage
   */
  @ApiModelProperty(
      value = "Indicates whether the checks overview page must be shown. Defaults to **false**.")
  @JsonProperty(JSON_PROPERTY_CHECKS_OVERVIEW_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getChecksOverviewPage() {
    return checksOverviewPage;
  }

  @JsonProperty(JSON_PROPERTY_CHECKS_OVERVIEW_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChecksOverviewPage(Boolean checksOverviewPage) {
    this.checksOverviewPage = checksOverviewPage;
  }

  public ShowPages individualDetailsSummaryPage(Boolean individualDetailsSummaryPage) {
    this.individualDetailsSummaryPage = individualDetailsSummaryPage;
    return this;
  }

  /**
   * Indicates whether the page with the individual&#39;s details must be shown. Defaults to
   * **true**.
   *
   * @return individualDetailsSummaryPage
   */
  @ApiModelProperty(
      value =
          "Indicates whether the page with the individual's details must be shown. Defaults to **true**.")
  @JsonProperty(JSON_PROPERTY_INDIVIDUAL_DETAILS_SUMMARY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getIndividualDetailsSummaryPage() {
    return individualDetailsSummaryPage;
  }

  @JsonProperty(JSON_PROPERTY_INDIVIDUAL_DETAILS_SUMMARY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIndividualDetailsSummaryPage(Boolean individualDetailsSummaryPage) {
    this.individualDetailsSummaryPage = individualDetailsSummaryPage;
  }

  public ShowPages legalArrangementsDetailsSummaryPage(
      Boolean legalArrangementsDetailsSummaryPage) {
    this.legalArrangementsDetailsSummaryPage = legalArrangementsDetailsSummaryPage;
    return this;
  }

  /**
   * Indicates whether the page with the legal arrangements&#39; details must be shown. Defaults to
   * **true**.
   *
   * @return legalArrangementsDetailsSummaryPage
   */
  @ApiModelProperty(
      value =
          "Indicates whether the page with the legal arrangements' details must be shown. Defaults to **true**.")
  @JsonProperty(JSON_PROPERTY_LEGAL_ARRANGEMENTS_DETAILS_SUMMARY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getLegalArrangementsDetailsSummaryPage() {
    return legalArrangementsDetailsSummaryPage;
  }

  @JsonProperty(JSON_PROPERTY_LEGAL_ARRANGEMENTS_DETAILS_SUMMARY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLegalArrangementsDetailsSummaryPage(Boolean legalArrangementsDetailsSummaryPage) {
    this.legalArrangementsDetailsSummaryPage = legalArrangementsDetailsSummaryPage;
  }

  public ShowPages manualBankAccountPage(Boolean manualBankAccountPage) {
    this.manualBankAccountPage = manualBankAccountPage;
    return this;
  }

  /**
   * Indicates whether the page to manually add bank account&#39; details must be shown. Defaults to
   * **true**.
   *
   * @return manualBankAccountPage
   */
  @ApiModelProperty(
      value =
          "Indicates whether the page to manually add bank account' details must be shown. Defaults to **true**.")
  @JsonProperty(JSON_PROPERTY_MANUAL_BANK_ACCOUNT_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getManualBankAccountPage() {
    return manualBankAccountPage;
  }

  @JsonProperty(JSON_PROPERTY_MANUAL_BANK_ACCOUNT_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setManualBankAccountPage(Boolean manualBankAccountPage) {
    this.manualBankAccountPage = manualBankAccountPage;
  }

  public ShowPages shareholderDetailsSummaryPage(Boolean shareholderDetailsSummaryPage) {
    this.shareholderDetailsSummaryPage = shareholderDetailsSummaryPage;
    return this;
  }

  /**
   * Indicates whether the page with the shareholders&#39; details must be shown. Defaults to
   * **true**.
   *
   * @return shareholderDetailsSummaryPage
   */
  @ApiModelProperty(
      value =
          "Indicates whether the page with the shareholders' details must be shown. Defaults to **true**.")
  @JsonProperty(JSON_PROPERTY_SHAREHOLDER_DETAILS_SUMMARY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getShareholderDetailsSummaryPage() {
    return shareholderDetailsSummaryPage;
  }

  @JsonProperty(JSON_PROPERTY_SHAREHOLDER_DETAILS_SUMMARY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShareholderDetailsSummaryPage(Boolean shareholderDetailsSummaryPage) {
    this.shareholderDetailsSummaryPage = shareholderDetailsSummaryPage;
  }

  public ShowPages welcomePage(Boolean welcomePage) {
    this.welcomePage = welcomePage;
    return this;
  }

  /**
   * Indicates whether the welcome page must be shown. Defaults to **false**.
   *
   * @return welcomePage
   */
  @ApiModelProperty(
      value = "Indicates whether the welcome page must be shown. Defaults to **false**.")
  @JsonProperty(JSON_PROPERTY_WELCOME_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getWelcomePage() {
    return welcomePage;
  }

  @JsonProperty(JSON_PROPERTY_WELCOME_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWelcomePage(Boolean welcomePage) {
    this.welcomePage = welcomePage;
  }

  /** Return true if this ShowPages object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ShowPages showPages = (ShowPages) o;
    return Objects.equals(this.bankDetailsSummaryPage, showPages.bankDetailsSummaryPage)
        && Objects.equals(this.bankVerificationPage, showPages.bankVerificationPage)
        && Objects.equals(this.businessDetailsSummaryPage, showPages.businessDetailsSummaryPage)
        && Objects.equals(this.checksOverviewPage, showPages.checksOverviewPage)
        && Objects.equals(this.individualDetailsSummaryPage, showPages.individualDetailsSummaryPage)
        && Objects.equals(
            this.legalArrangementsDetailsSummaryPage, showPages.legalArrangementsDetailsSummaryPage)
        && Objects.equals(this.manualBankAccountPage, showPages.manualBankAccountPage)
        && Objects.equals(
            this.shareholderDetailsSummaryPage, showPages.shareholderDetailsSummaryPage)
        && Objects.equals(this.welcomePage, showPages.welcomePage);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        bankDetailsSummaryPage,
        bankVerificationPage,
        businessDetailsSummaryPage,
        checksOverviewPage,
        individualDetailsSummaryPage,
        legalArrangementsDetailsSummaryPage,
        manualBankAccountPage,
        shareholderDetailsSummaryPage,
        welcomePage);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ShowPages {\n");
    sb.append("    bankDetailsSummaryPage: ")
        .append(toIndentedString(bankDetailsSummaryPage))
        .append("\n");
    sb.append("    bankVerificationPage: ")
        .append(toIndentedString(bankVerificationPage))
        .append("\n");
    sb.append("    businessDetailsSummaryPage: ")
        .append(toIndentedString(businessDetailsSummaryPage))
        .append("\n");
    sb.append("    checksOverviewPage: ").append(toIndentedString(checksOverviewPage)).append("\n");
    sb.append("    individualDetailsSummaryPage: ")
        .append(toIndentedString(individualDetailsSummaryPage))
        .append("\n");
    sb.append("    legalArrangementsDetailsSummaryPage: ")
        .append(toIndentedString(legalArrangementsDetailsSummaryPage))
        .append("\n");
    sb.append("    manualBankAccountPage: ")
        .append(toIndentedString(manualBankAccountPage))
        .append("\n");
    sb.append("    shareholderDetailsSummaryPage: ")
        .append(toIndentedString(shareholderDetailsSummaryPage))
        .append("\n");
    sb.append("    welcomePage: ").append(toIndentedString(welcomePage)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of ShowPages given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of ShowPages
   * @throws JsonProcessingException if the JSON string is invalid with respect to ShowPages
   */
  public static ShowPages fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, ShowPages.class);
  }

  /**
   * Convert an instance of ShowPages to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
