/*
 * Classic Platforms - Notifications
 *
 * The version of the OpenAPI document: 6
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.marketpaywebhooks;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** KYCSignatoryCheckResult */
@JsonPropertyOrder({
  KYCSignatoryCheckResult.JSON_PROPERTY_CHECKS,
  KYCSignatoryCheckResult.JSON_PROPERTY_SIGNATORY_CODE
})
public class KYCSignatoryCheckResult {
  public static final String JSON_PROPERTY_CHECKS = "checks";
  private List<KYCCheckStatusData> checks = null;

  public static final String JSON_PROPERTY_SIGNATORY_CODE = "signatoryCode";
  private String signatoryCode;

  public KYCSignatoryCheckResult() {}

  public KYCSignatoryCheckResult checks(List<KYCCheckStatusData> checks) {
    this.checks = checks;
    return this;
  }

  public KYCSignatoryCheckResult addChecksItem(KYCCheckStatusData checksItem) {
    if (this.checks == null) {
      this.checks = new ArrayList<>();
    }
    this.checks.add(checksItem);
    return this;
  }

  /**
   * A list of the checks and their statuses.
   *
   * @return checks
   */
  @ApiModelProperty(value = "A list of the checks and their statuses.")
  @JsonProperty(JSON_PROPERTY_CHECKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<KYCCheckStatusData> getChecks() {
    return checks;
  }

  @JsonProperty(JSON_PROPERTY_CHECKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChecks(List<KYCCheckStatusData> checks) {
    this.checks = checks;
  }

  public KYCSignatoryCheckResult signatoryCode(String signatoryCode) {
    this.signatoryCode = signatoryCode;
    return this;
  }

  /**
   * The code of the signatory to which the check applies.
   *
   * @return signatoryCode
   */
  @ApiModelProperty(value = "The code of the signatory to which the check applies.")
  @JsonProperty(JSON_PROPERTY_SIGNATORY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getSignatoryCode() {
    return signatoryCode;
  }

  @JsonProperty(JSON_PROPERTY_SIGNATORY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSignatoryCode(String signatoryCode) {
    this.signatoryCode = signatoryCode;
  }

  /** Return true if this KYCSignatoryCheckResult object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    KYCSignatoryCheckResult kyCSignatoryCheckResult = (KYCSignatoryCheckResult) o;
    return Objects.equals(this.checks, kyCSignatoryCheckResult.checks)
        && Objects.equals(this.signatoryCode, kyCSignatoryCheckResult.signatoryCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(checks, signatoryCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class KYCSignatoryCheckResult {\n");
    sb.append("    checks: ").append(toIndentedString(checks)).append("\n");
    sb.append("    signatoryCode: ").append(toIndentedString(signatoryCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of KYCSignatoryCheckResult given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of KYCSignatoryCheckResult
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     KYCSignatoryCheckResult
   */
  public static KYCSignatoryCheckResult fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, KYCSignatoryCheckResult.class);
  }

  /**
   * Convert an instance of KYCSignatoryCheckResult to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
