/*
 * Negative balance compensation warning
 *
 * The version of the OpenAPI document: 1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.negativebalancewarningwebhooks;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.OffsetDateTime;
import java.util.*;

/** NegativeBalanceCompensationWarningNotificationData */
@JsonPropertyOrder({
  NegativeBalanceCompensationWarningNotificationData.JSON_PROPERTY_ACCOUNT_HOLDER,
  NegativeBalanceCompensationWarningNotificationData.JSON_PROPERTY_AMOUNT,
  NegativeBalanceCompensationWarningNotificationData.JSON_PROPERTY_BALANCE_PLATFORM,
  NegativeBalanceCompensationWarningNotificationData.JSON_PROPERTY_CREATION_DATE,
  NegativeBalanceCompensationWarningNotificationData.JSON_PROPERTY_ID,
  NegativeBalanceCompensationWarningNotificationData.JSON_PROPERTY_LIABLE_BALANCE_ACCOUNT_ID,
  NegativeBalanceCompensationWarningNotificationData.JSON_PROPERTY_NEGATIVE_BALANCE_SINCE,
  NegativeBalanceCompensationWarningNotificationData.JSON_PROPERTY_SCHEDULED_COMPENSATION_AT
})
public class NegativeBalanceCompensationWarningNotificationData {
  public static final String JSON_PROPERTY_ACCOUNT_HOLDER = "accountHolder";
  private ResourceReference accountHolder;

  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private Amount amount;

  public static final String JSON_PROPERTY_BALANCE_PLATFORM = "balancePlatform";
  private String balancePlatform;

  public static final String JSON_PROPERTY_CREATION_DATE = "creationDate";
  private OffsetDateTime creationDate;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_LIABLE_BALANCE_ACCOUNT_ID = "liableBalanceAccountId";
  private String liableBalanceAccountId;

  public static final String JSON_PROPERTY_NEGATIVE_BALANCE_SINCE = "negativeBalanceSince";
  private OffsetDateTime negativeBalanceSince;

  public static final String JSON_PROPERTY_SCHEDULED_COMPENSATION_AT = "scheduledCompensationAt";
  private OffsetDateTime scheduledCompensationAt;

  public NegativeBalanceCompensationWarningNotificationData() {}

  /**
   * accountHolder
   *
   * @param accountHolder
   * @return the current {@code NegativeBalanceCompensationWarningNotificationData} instance,
   *     allowing for method chaining
   */
  public NegativeBalanceCompensationWarningNotificationData accountHolder(
      ResourceReference accountHolder) {
    this.accountHolder = accountHolder;
    return this;
  }

  /**
   * Get accountHolder
   *
   * @return accountHolder
   */
  @JsonProperty(JSON_PROPERTY_ACCOUNT_HOLDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ResourceReference getAccountHolder() {
    return accountHolder;
  }

  /**
   * accountHolder
   *
   * @param accountHolder
   */
  @JsonProperty(JSON_PROPERTY_ACCOUNT_HOLDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountHolder(ResourceReference accountHolder) {
    this.accountHolder = accountHolder;
  }

  /**
   * amount
   *
   * @param amount
   * @return the current {@code NegativeBalanceCompensationWarningNotificationData} instance,
   *     allowing for method chaining
   */
  public NegativeBalanceCompensationWarningNotificationData amount(Amount amount) {
    this.amount = amount;
    return this;
  }

  /**
   * Get amount
   *
   * @return amount
   */
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Amount getAmount() {
    return amount;
  }

  /**
   * amount
   *
   * @param amount
   */
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmount(Amount amount) {
    this.amount = amount;
  }

  /**
   * The unique identifier of the balance platform.
   *
   * @param balancePlatform The unique identifier of the balance platform.
   * @return the current {@code NegativeBalanceCompensationWarningNotificationData} instance,
   *     allowing for method chaining
   */
  public NegativeBalanceCompensationWarningNotificationData balancePlatform(
      String balancePlatform) {
    this.balancePlatform = balancePlatform;
    return this;
  }

  /**
   * The unique identifier of the balance platform.
   *
   * @return balancePlatform The unique identifier of the balance platform.
   */
  @JsonProperty(JSON_PROPERTY_BALANCE_PLATFORM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getBalancePlatform() {
    return balancePlatform;
  }

  /**
   * The unique identifier of the balance platform.
   *
   * @param balancePlatform The unique identifier of the balance platform.
   */
  @JsonProperty(JSON_PROPERTY_BALANCE_PLATFORM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBalancePlatform(String balancePlatform) {
    this.balancePlatform = balancePlatform;
  }

  /**
   * The date and time when the event was triggered, in ISO 8601 extended format. For example,
   * **2020-12-18T10:15:30+01:00**.
   *
   * @param creationDate The date and time when the event was triggered, in ISO 8601 extended
   *     format. For example, **2020-12-18T10:15:30+01:00**.
   * @return the current {@code NegativeBalanceCompensationWarningNotificationData} instance,
   *     allowing for method chaining
   */
  public NegativeBalanceCompensationWarningNotificationData creationDate(
      OffsetDateTime creationDate) {
    this.creationDate = creationDate;
    return this;
  }

  /**
   * The date and time when the event was triggered, in ISO 8601 extended format. For example,
   * **2020-12-18T10:15:30+01:00**.
   *
   * @return creationDate The date and time when the event was triggered, in ISO 8601 extended
   *     format. For example, **2020-12-18T10:15:30+01:00**.
   */
  @JsonProperty(JSON_PROPERTY_CREATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getCreationDate() {
    return creationDate;
  }

  /**
   * The date and time when the event was triggered, in ISO 8601 extended format. For example,
   * **2020-12-18T10:15:30+01:00**.
   *
   * @param creationDate The date and time when the event was triggered, in ISO 8601 extended
   *     format. For example, **2020-12-18T10:15:30+01:00**.
   */
  @JsonProperty(JSON_PROPERTY_CREATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreationDate(OffsetDateTime creationDate) {
    this.creationDate = creationDate;
  }

  /**
   * The ID of the resource.
   *
   * @param id The ID of the resource.
   * @return the current {@code NegativeBalanceCompensationWarningNotificationData} instance,
   *     allowing for method chaining
   */
  public NegativeBalanceCompensationWarningNotificationData id(String id) {
    this.id = id;
    return this;
  }

  /**
   * The ID of the resource.
   *
   * @return id The ID of the resource.
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getId() {
    return id;
  }

  /**
   * The ID of the resource.
   *
   * @param id The ID of the resource.
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }

  /**
   * The balance account ID of the account that will be used to compensate the balance account whose
   * balance is negative.
   *
   * @param liableBalanceAccountId The balance account ID of the account that will be used to
   *     compensate the balance account whose balance is negative.
   * @return the current {@code NegativeBalanceCompensationWarningNotificationData} instance,
   *     allowing for method chaining
   */
  public NegativeBalanceCompensationWarningNotificationData liableBalanceAccountId(
      String liableBalanceAccountId) {
    this.liableBalanceAccountId = liableBalanceAccountId;
    return this;
  }

  /**
   * The balance account ID of the account that will be used to compensate the balance account whose
   * balance is negative.
   *
   * @return liableBalanceAccountId The balance account ID of the account that will be used to
   *     compensate the balance account whose balance is negative.
   */
  @JsonProperty(JSON_PROPERTY_LIABLE_BALANCE_ACCOUNT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getLiableBalanceAccountId() {
    return liableBalanceAccountId;
  }

  /**
   * The balance account ID of the account that will be used to compensate the balance account whose
   * balance is negative.
   *
   * @param liableBalanceAccountId The balance account ID of the account that will be used to
   *     compensate the balance account whose balance is negative.
   */
  @JsonProperty(JSON_PROPERTY_LIABLE_BALANCE_ACCOUNT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLiableBalanceAccountId(String liableBalanceAccountId) {
    this.liableBalanceAccountId = liableBalanceAccountId;
  }

  /**
   * The date the balance for the account became negative.
   *
   * @param negativeBalanceSince The date the balance for the account became negative.
   * @return the current {@code NegativeBalanceCompensationWarningNotificationData} instance,
   *     allowing for method chaining
   */
  public NegativeBalanceCompensationWarningNotificationData negativeBalanceSince(
      OffsetDateTime negativeBalanceSince) {
    this.negativeBalanceSince = negativeBalanceSince;
    return this;
  }

  /**
   * The date the balance for the account became negative.
   *
   * @return negativeBalanceSince The date the balance for the account became negative.
   */
  @JsonProperty(JSON_PROPERTY_NEGATIVE_BALANCE_SINCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getNegativeBalanceSince() {
    return negativeBalanceSince;
  }

  /**
   * The date the balance for the account became negative.
   *
   * @param negativeBalanceSince The date the balance for the account became negative.
   */
  @JsonProperty(JSON_PROPERTY_NEGATIVE_BALANCE_SINCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNegativeBalanceSince(OffsetDateTime negativeBalanceSince) {
    this.negativeBalanceSince = negativeBalanceSince;
  }

  /**
   * The date when a compensation transfer to the account is scheduled to happen.
   *
   * @param scheduledCompensationAt The date when a compensation transfer to the account is
   *     scheduled to happen.
   * @return the current {@code NegativeBalanceCompensationWarningNotificationData} instance,
   *     allowing for method chaining
   */
  public NegativeBalanceCompensationWarningNotificationData scheduledCompensationAt(
      OffsetDateTime scheduledCompensationAt) {
    this.scheduledCompensationAt = scheduledCompensationAt;
    return this;
  }

  /**
   * The date when a compensation transfer to the account is scheduled to happen.
   *
   * @return scheduledCompensationAt The date when a compensation transfer to the account is
   *     scheduled to happen.
   */
  @JsonProperty(JSON_PROPERTY_SCHEDULED_COMPENSATION_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getScheduledCompensationAt() {
    return scheduledCompensationAt;
  }

  /**
   * The date when a compensation transfer to the account is scheduled to happen.
   *
   * @param scheduledCompensationAt The date when a compensation transfer to the account is
   *     scheduled to happen.
   */
  @JsonProperty(JSON_PROPERTY_SCHEDULED_COMPENSATION_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setScheduledCompensationAt(OffsetDateTime scheduledCompensationAt) {
    this.scheduledCompensationAt = scheduledCompensationAt;
  }

  /**
   * Return true if this NegativeBalanceCompensationWarningNotificationData object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    NegativeBalanceCompensationWarningNotificationData
        negativeBalanceCompensationWarningNotificationData =
            (NegativeBalanceCompensationWarningNotificationData) o;
    return Objects.equals(
            this.accountHolder, negativeBalanceCompensationWarningNotificationData.accountHolder)
        && Objects.equals(this.amount, negativeBalanceCompensationWarningNotificationData.amount)
        && Objects.equals(
            this.balancePlatform,
            negativeBalanceCompensationWarningNotificationData.balancePlatform)
        && Objects.equals(
            this.creationDate, negativeBalanceCompensationWarningNotificationData.creationDate)
        && Objects.equals(this.id, negativeBalanceCompensationWarningNotificationData.id)
        && Objects.equals(
            this.liableBalanceAccountId,
            negativeBalanceCompensationWarningNotificationData.liableBalanceAccountId)
        && Objects.equals(
            this.negativeBalanceSince,
            negativeBalanceCompensationWarningNotificationData.negativeBalanceSince)
        && Objects.equals(
            this.scheduledCompensationAt,
            negativeBalanceCompensationWarningNotificationData.scheduledCompensationAt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        accountHolder,
        amount,
        balancePlatform,
        creationDate,
        id,
        liableBalanceAccountId,
        negativeBalanceSince,
        scheduledCompensationAt);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class NegativeBalanceCompensationWarningNotificationData {\n");
    sb.append("    accountHolder: ").append(toIndentedString(accountHolder)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    balancePlatform: ").append(toIndentedString(balancePlatform)).append("\n");
    sb.append("    creationDate: ").append(toIndentedString(creationDate)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    liableBalanceAccountId: ")
        .append(toIndentedString(liableBalanceAccountId))
        .append("\n");
    sb.append("    negativeBalanceSince: ")
        .append(toIndentedString(negativeBalanceSince))
        .append("\n");
    sb.append("    scheduledCompensationAt: ")
        .append(toIndentedString(scheduledCompensationAt))
        .append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of NegativeBalanceCompensationWarningNotificationData given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of NegativeBalanceCompensationWarningNotificationData
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     NegativeBalanceCompensationWarningNotificationData
   */
  public static NegativeBalanceCompensationWarningNotificationData fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper()
        .readValue(jsonString, NegativeBalanceCompensationWarningNotificationData.class);
  }

  /**
   * Convert an instance of NegativeBalanceCompensationWarningNotificationData to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
