/*
 * Adyen Payment API
 *
 * The version of the OpenAPI document: 68
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.payment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;
import java.util.Arrays;
import java.util.logging.Logger;

/** AcctInfo */
@JsonPropertyOrder({
  AcctInfo.JSON_PROPERTY_CH_ACC_AGE_IND,
  AcctInfo.JSON_PROPERTY_CH_ACC_CHANGE,
  AcctInfo.JSON_PROPERTY_CH_ACC_CHANGE_IND,
  AcctInfo.JSON_PROPERTY_CH_ACC_PW_CHANGE,
  AcctInfo.JSON_PROPERTY_CH_ACC_PW_CHANGE_IND,
  AcctInfo.JSON_PROPERTY_CH_ACC_STRING,
  AcctInfo.JSON_PROPERTY_NB_PURCHASE_ACCOUNT,
  AcctInfo.JSON_PROPERTY_PAYMENT_ACC_AGE,
  AcctInfo.JSON_PROPERTY_PAYMENT_ACC_IND,
  AcctInfo.JSON_PROPERTY_PROVISION_ATTEMPTS_DAY,
  AcctInfo.JSON_PROPERTY_SHIP_ADDRESS_USAGE,
  AcctInfo.JSON_PROPERTY_SHIP_ADDRESS_USAGE_IND,
  AcctInfo.JSON_PROPERTY_SHIP_NAME_INDICATOR,
  AcctInfo.JSON_PROPERTY_SUSPICIOUS_ACC_ACTIVITY,
  AcctInfo.JSON_PROPERTY_TXN_ACTIVITY_DAY,
  AcctInfo.JSON_PROPERTY_TXN_ACTIVITY_YEAR
})
public class AcctInfo {
  /**
   * Length of time that the cardholder has had the account with the 3DS Requestor. Allowed values:
   * * **01** — No account * **02** — Created during this transaction * **03** — Less than 30 days *
   * **04** — 30–60 days * **05** — More than 60 days
   */
  public enum ChAccAgeIndEnum {
    _01(String.valueOf("01")),

    _02(String.valueOf("02")),

    _03(String.valueOf("03")),

    _04(String.valueOf("04")),

    _05(String.valueOf("05"));

    private static final Logger LOG = Logger.getLogger(ChAccAgeIndEnum.class.getName());

    private String value;

    ChAccAgeIndEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ChAccAgeIndEnum fromValue(String value) {
      for (ChAccAgeIndEnum b : ChAccAgeIndEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "ChAccAgeIndEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(ChAccAgeIndEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_CH_ACC_AGE_IND = "chAccAgeInd";
  private ChAccAgeIndEnum chAccAgeInd;

  public static final String JSON_PROPERTY_CH_ACC_CHANGE = "chAccChange";
  private String chAccChange;

  /**
   * Length of time since the cardholder’s account information with the 3DS Requestor was last
   * changed, including Billing or Shipping address, new payment account, or new user(s) added.
   * Allowed values: * **01** — Changed during this transaction * **02** — Less than 30 days *
   * **03** — 30–60 days * **04** — More than 60 days
   */
  public enum ChAccChangeIndEnum {
    _01(String.valueOf("01")),

    _02(String.valueOf("02")),

    _03(String.valueOf("03")),

    _04(String.valueOf("04"));

    private static final Logger LOG = Logger.getLogger(ChAccChangeIndEnum.class.getName());

    private String value;

    ChAccChangeIndEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ChAccChangeIndEnum fromValue(String value) {
      for (ChAccChangeIndEnum b : ChAccChangeIndEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "ChAccChangeIndEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(ChAccChangeIndEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_CH_ACC_CHANGE_IND = "chAccChangeInd";
  private ChAccChangeIndEnum chAccChangeInd;

  public static final String JSON_PROPERTY_CH_ACC_PW_CHANGE = "chAccPwChange";
  private String chAccPwChange;

  /**
   * Indicates the length of time since the cardholder’s account with the 3DS Requestor had a
   * password change or account reset. Allowed values: * **01** — No change * **02** — Changed
   * during this transaction * **03** — Less than 30 days * **04** — 30–60 days * **05** — More than
   * 60 days
   */
  public enum ChAccPwChangeIndEnum {
    _01(String.valueOf("01")),

    _02(String.valueOf("02")),

    _03(String.valueOf("03")),

    _04(String.valueOf("04")),

    _05(String.valueOf("05"));

    private static final Logger LOG = Logger.getLogger(ChAccPwChangeIndEnum.class.getName());

    private String value;

    ChAccPwChangeIndEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ChAccPwChangeIndEnum fromValue(String value) {
      for (ChAccPwChangeIndEnum b : ChAccPwChangeIndEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "ChAccPwChangeIndEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(ChAccPwChangeIndEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_CH_ACC_PW_CHANGE_IND = "chAccPwChangeInd";
  private ChAccPwChangeIndEnum chAccPwChangeInd;

  public static final String JSON_PROPERTY_CH_ACC_STRING = "chAccString";
  private String chAccString;

  public static final String JSON_PROPERTY_NB_PURCHASE_ACCOUNT = "nbPurchaseAccount";
  private String nbPurchaseAccount;

  public static final String JSON_PROPERTY_PAYMENT_ACC_AGE = "paymentAccAge";
  private String paymentAccAge;

  /**
   * Indicates the length of time that the payment account was enrolled in the cardholder’s account
   * with the 3DS Requestor. Allowed values: * **01** — No account (guest checkout) * **02** —
   * During this transaction * **03** — Less than 30 days * **04** — 30–60 days * **05** — More than
   * 60 days
   */
  public enum PaymentAccIndEnum {
    _01(String.valueOf("01")),

    _02(String.valueOf("02")),

    _03(String.valueOf("03")),

    _04(String.valueOf("04")),

    _05(String.valueOf("05"));

    private static final Logger LOG = Logger.getLogger(PaymentAccIndEnum.class.getName());

    private String value;

    PaymentAccIndEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PaymentAccIndEnum fromValue(String value) {
      for (PaymentAccIndEnum b : PaymentAccIndEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "PaymentAccIndEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(PaymentAccIndEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_PAYMENT_ACC_IND = "paymentAccInd";
  private PaymentAccIndEnum paymentAccInd;

  public static final String JSON_PROPERTY_PROVISION_ATTEMPTS_DAY = "provisionAttemptsDay";
  private String provisionAttemptsDay;

  public static final String JSON_PROPERTY_SHIP_ADDRESS_USAGE = "shipAddressUsage";
  private String shipAddressUsage;

  /**
   * Indicates when the shipping address used for this transaction was first used with the 3DS
   * Requestor. Allowed values: * **01** — This transaction * **02** — Less than 30 days * **03** —
   * 30–60 days * **04** — More than 60 days
   */
  public enum ShipAddressUsageIndEnum {
    _01(String.valueOf("01")),

    _02(String.valueOf("02")),

    _03(String.valueOf("03")),

    _04(String.valueOf("04"));

    private static final Logger LOG = Logger.getLogger(ShipAddressUsageIndEnum.class.getName());

    private String value;

    ShipAddressUsageIndEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ShipAddressUsageIndEnum fromValue(String value) {
      for (ShipAddressUsageIndEnum b : ShipAddressUsageIndEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "ShipAddressUsageIndEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(ShipAddressUsageIndEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_SHIP_ADDRESS_USAGE_IND = "shipAddressUsageInd";
  private ShipAddressUsageIndEnum shipAddressUsageInd;

  /**
   * Indicates if the Cardholder Name on the account is identical to the shipping Name used for this
   * transaction. Allowed values: * **01** — Account Name identical to shipping Name * **02** —
   * Account Name different to shipping Name
   */
  public enum ShipNameIndicatorEnum {
    _01(String.valueOf("01")),

    _02(String.valueOf("02"));

    private static final Logger LOG = Logger.getLogger(ShipNameIndicatorEnum.class.getName());

    private String value;

    ShipNameIndicatorEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ShipNameIndicatorEnum fromValue(String value) {
      for (ShipNameIndicatorEnum b : ShipNameIndicatorEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "ShipNameIndicatorEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(ShipNameIndicatorEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_SHIP_NAME_INDICATOR = "shipNameIndicator";
  private ShipNameIndicatorEnum shipNameIndicator;

  /**
   * Indicates whether the 3DS Requestor has experienced suspicious activity (including previous
   * fraud) on the cardholder account. Allowed values: * **01** — No suspicious activity has been
   * observed * **02** — Suspicious activity has been observed
   */
  public enum SuspiciousAccActivityEnum {
    _01(String.valueOf("01")),

    _02(String.valueOf("02"));

    private static final Logger LOG = Logger.getLogger(SuspiciousAccActivityEnum.class.getName());

    private String value;

    SuspiciousAccActivityEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SuspiciousAccActivityEnum fromValue(String value) {
      for (SuspiciousAccActivityEnum b : SuspiciousAccActivityEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "SuspiciousAccActivityEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(SuspiciousAccActivityEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_SUSPICIOUS_ACC_ACTIVITY = "suspiciousAccActivity";
  private SuspiciousAccActivityEnum suspiciousAccActivity;

  public static final String JSON_PROPERTY_TXN_ACTIVITY_DAY = "txnActivityDay";
  private String txnActivityDay;

  public static final String JSON_PROPERTY_TXN_ACTIVITY_YEAR = "txnActivityYear";
  private String txnActivityYear;

  public AcctInfo() {}

  /**
   * Length of time that the cardholder has had the account with the 3DS Requestor. Allowed values:
   * * **01** — No account * **02** — Created during this transaction * **03** — Less than 30 days *
   * **04** — 30–60 days * **05** — More than 60 days
   *
   * @param chAccAgeInd Length of time that the cardholder has had the account with the 3DS
   *     Requestor. Allowed values: * **01** — No account * **02** — Created during this transaction
   *     * **03** — Less than 30 days * **04** — 30–60 days * **05** — More than 60 days
   * @return the current {@code AcctInfo} instance, allowing for method chaining
   */
  public AcctInfo chAccAgeInd(ChAccAgeIndEnum chAccAgeInd) {
    this.chAccAgeInd = chAccAgeInd;
    return this;
  }

  /**
   * Length of time that the cardholder has had the account with the 3DS Requestor. Allowed values:
   * * **01** — No account * **02** — Created during this transaction * **03** — Less than 30 days *
   * **04** — 30–60 days * **05** — More than 60 days
   *
   * @return chAccAgeInd Length of time that the cardholder has had the account with the 3DS
   *     Requestor. Allowed values: * **01** — No account * **02** — Created during this transaction
   *     * **03** — Less than 30 days * **04** — 30–60 days * **05** — More than 60 days
   */
  @JsonProperty(JSON_PROPERTY_CH_ACC_AGE_IND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ChAccAgeIndEnum getChAccAgeInd() {
    return chAccAgeInd;
  }

  /**
   * Length of time that the cardholder has had the account with the 3DS Requestor. Allowed values:
   * * **01** — No account * **02** — Created during this transaction * **03** — Less than 30 days *
   * **04** — 30–60 days * **05** — More than 60 days
   *
   * @param chAccAgeInd Length of time that the cardholder has had the account with the 3DS
   *     Requestor. Allowed values: * **01** — No account * **02** — Created during this transaction
   *     * **03** — Less than 30 days * **04** — 30–60 days * **05** — More than 60 days
   */
  @JsonProperty(JSON_PROPERTY_CH_ACC_AGE_IND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChAccAgeInd(ChAccAgeIndEnum chAccAgeInd) {
    this.chAccAgeInd = chAccAgeInd;
  }

  /**
   * Date that the cardholder’s account with the 3DS Requestor was last changed, including Billing
   * or Shipping address, new payment account, or new user(s) added. Format: **YYYYMMDD**
   *
   * @param chAccChange Date that the cardholder’s account with the 3DS Requestor was last changed,
   *     including Billing or Shipping address, new payment account, or new user(s) added. Format:
   *     **YYYYMMDD**
   * @return the current {@code AcctInfo} instance, allowing for method chaining
   */
  public AcctInfo chAccChange(String chAccChange) {
    this.chAccChange = chAccChange;
    return this;
  }

  /**
   * Date that the cardholder’s account with the 3DS Requestor was last changed, including Billing
   * or Shipping address, new payment account, or new user(s) added. Format: **YYYYMMDD**
   *
   * @return chAccChange Date that the cardholder’s account with the 3DS Requestor was last changed,
   *     including Billing or Shipping address, new payment account, or new user(s) added. Format:
   *     **YYYYMMDD**
   */
  @JsonProperty(JSON_PROPERTY_CH_ACC_CHANGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getChAccChange() {
    return chAccChange;
  }

  /**
   * Date that the cardholder’s account with the 3DS Requestor was last changed, including Billing
   * or Shipping address, new payment account, or new user(s) added. Format: **YYYYMMDD**
   *
   * @param chAccChange Date that the cardholder’s account with the 3DS Requestor was last changed,
   *     including Billing or Shipping address, new payment account, or new user(s) added. Format:
   *     **YYYYMMDD**
   */
  @JsonProperty(JSON_PROPERTY_CH_ACC_CHANGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChAccChange(String chAccChange) {
    this.chAccChange = chAccChange;
  }

  /**
   * Length of time since the cardholder’s account information with the 3DS Requestor was last
   * changed, including Billing or Shipping address, new payment account, or new user(s) added.
   * Allowed values: * **01** — Changed during this transaction * **02** — Less than 30 days *
   * **03** — 30–60 days * **04** — More than 60 days
   *
   * @param chAccChangeInd Length of time since the cardholder’s account information with the 3DS
   *     Requestor was last changed, including Billing or Shipping address, new payment account, or
   *     new user(s) added. Allowed values: * **01** — Changed during this transaction * **02** —
   *     Less than 30 days * **03** — 30–60 days * **04** — More than 60 days
   * @return the current {@code AcctInfo} instance, allowing for method chaining
   */
  public AcctInfo chAccChangeInd(ChAccChangeIndEnum chAccChangeInd) {
    this.chAccChangeInd = chAccChangeInd;
    return this;
  }

  /**
   * Length of time since the cardholder’s account information with the 3DS Requestor was last
   * changed, including Billing or Shipping address, new payment account, or new user(s) added.
   * Allowed values: * **01** — Changed during this transaction * **02** — Less than 30 days *
   * **03** — 30–60 days * **04** — More than 60 days
   *
   * @return chAccChangeInd Length of time since the cardholder’s account information with the 3DS
   *     Requestor was last changed, including Billing or Shipping address, new payment account, or
   *     new user(s) added. Allowed values: * **01** — Changed during this transaction * **02** —
   *     Less than 30 days * **03** — 30–60 days * **04** — More than 60 days
   */
  @JsonProperty(JSON_PROPERTY_CH_ACC_CHANGE_IND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ChAccChangeIndEnum getChAccChangeInd() {
    return chAccChangeInd;
  }

  /**
   * Length of time since the cardholder’s account information with the 3DS Requestor was last
   * changed, including Billing or Shipping address, new payment account, or new user(s) added.
   * Allowed values: * **01** — Changed during this transaction * **02** — Less than 30 days *
   * **03** — 30–60 days * **04** — More than 60 days
   *
   * @param chAccChangeInd Length of time since the cardholder’s account information with the 3DS
   *     Requestor was last changed, including Billing or Shipping address, new payment account, or
   *     new user(s) added. Allowed values: * **01** — Changed during this transaction * **02** —
   *     Less than 30 days * **03** — 30–60 days * **04** — More than 60 days
   */
  @JsonProperty(JSON_PROPERTY_CH_ACC_CHANGE_IND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChAccChangeInd(ChAccChangeIndEnum chAccChangeInd) {
    this.chAccChangeInd = chAccChangeInd;
  }

  /**
   * Date that cardholder’s account with the 3DS Requestor had a password change or account reset.
   * Format: **YYYYMMDD**
   *
   * @param chAccPwChange Date that cardholder’s account with the 3DS Requestor had a password
   *     change or account reset. Format: **YYYYMMDD**
   * @return the current {@code AcctInfo} instance, allowing for method chaining
   */
  public AcctInfo chAccPwChange(String chAccPwChange) {
    this.chAccPwChange = chAccPwChange;
    return this;
  }

  /**
   * Date that cardholder’s account with the 3DS Requestor had a password change or account reset.
   * Format: **YYYYMMDD**
   *
   * @return chAccPwChange Date that cardholder’s account with the 3DS Requestor had a password
   *     change or account reset. Format: **YYYYMMDD**
   */
  @JsonProperty(JSON_PROPERTY_CH_ACC_PW_CHANGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getChAccPwChange() {
    return chAccPwChange;
  }

  /**
   * Date that cardholder’s account with the 3DS Requestor had a password change or account reset.
   * Format: **YYYYMMDD**
   *
   * @param chAccPwChange Date that cardholder’s account with the 3DS Requestor had a password
   *     change or account reset. Format: **YYYYMMDD**
   */
  @JsonProperty(JSON_PROPERTY_CH_ACC_PW_CHANGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChAccPwChange(String chAccPwChange) {
    this.chAccPwChange = chAccPwChange;
  }

  /**
   * Indicates the length of time since the cardholder’s account with the 3DS Requestor had a
   * password change or account reset. Allowed values: * **01** — No change * **02** — Changed
   * during this transaction * **03** — Less than 30 days * **04** — 30–60 days * **05** — More than
   * 60 days
   *
   * @param chAccPwChangeInd Indicates the length of time since the cardholder’s account with the
   *     3DS Requestor had a password change or account reset. Allowed values: * **01** — No change
   *     * **02** — Changed during this transaction * **03** — Less than 30 days * **04** — 30–60
   *     days * **05** — More than 60 days
   * @return the current {@code AcctInfo} instance, allowing for method chaining
   */
  public AcctInfo chAccPwChangeInd(ChAccPwChangeIndEnum chAccPwChangeInd) {
    this.chAccPwChangeInd = chAccPwChangeInd;
    return this;
  }

  /**
   * Indicates the length of time since the cardholder’s account with the 3DS Requestor had a
   * password change or account reset. Allowed values: * **01** — No change * **02** — Changed
   * during this transaction * **03** — Less than 30 days * **04** — 30–60 days * **05** — More than
   * 60 days
   *
   * @return chAccPwChangeInd Indicates the length of time since the cardholder’s account with the
   *     3DS Requestor had a password change or account reset. Allowed values: * **01** — No change
   *     * **02** — Changed during this transaction * **03** — Less than 30 days * **04** — 30–60
   *     days * **05** — More than 60 days
   */
  @JsonProperty(JSON_PROPERTY_CH_ACC_PW_CHANGE_IND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ChAccPwChangeIndEnum getChAccPwChangeInd() {
    return chAccPwChangeInd;
  }

  /**
   * Indicates the length of time since the cardholder’s account with the 3DS Requestor had a
   * password change or account reset. Allowed values: * **01** — No change * **02** — Changed
   * during this transaction * **03** — Less than 30 days * **04** — 30–60 days * **05** — More than
   * 60 days
   *
   * @param chAccPwChangeInd Indicates the length of time since the cardholder’s account with the
   *     3DS Requestor had a password change or account reset. Allowed values: * **01** — No change
   *     * **02** — Changed during this transaction * **03** — Less than 30 days * **04** — 30–60
   *     days * **05** — More than 60 days
   */
  @JsonProperty(JSON_PROPERTY_CH_ACC_PW_CHANGE_IND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChAccPwChangeInd(ChAccPwChangeIndEnum chAccPwChangeInd) {
    this.chAccPwChangeInd = chAccPwChangeInd;
  }

  /**
   * Date that the cardholder opened the account with the 3DS Requestor. Format: **YYYYMMDD**
   *
   * @param chAccString Date that the cardholder opened the account with the 3DS Requestor. Format:
   *     **YYYYMMDD**
   * @return the current {@code AcctInfo} instance, allowing for method chaining
   */
  public AcctInfo chAccString(String chAccString) {
    this.chAccString = chAccString;
    return this;
  }

  /**
   * Date that the cardholder opened the account with the 3DS Requestor. Format: **YYYYMMDD**
   *
   * @return chAccString Date that the cardholder opened the account with the 3DS Requestor. Format:
   *     **YYYYMMDD**
   */
  @JsonProperty(JSON_PROPERTY_CH_ACC_STRING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getChAccString() {
    return chAccString;
  }

  /**
   * Date that the cardholder opened the account with the 3DS Requestor. Format: **YYYYMMDD**
   *
   * @param chAccString Date that the cardholder opened the account with the 3DS Requestor. Format:
   *     **YYYYMMDD**
   */
  @JsonProperty(JSON_PROPERTY_CH_ACC_STRING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChAccString(String chAccString) {
    this.chAccString = chAccString;
  }

  /**
   * Number of purchases with this cardholder account during the previous six months. Max length: 4
   * characters.
   *
   * @param nbPurchaseAccount Number of purchases with this cardholder account during the previous
   *     six months. Max length: 4 characters.
   * @return the current {@code AcctInfo} instance, allowing for method chaining
   */
  public AcctInfo nbPurchaseAccount(String nbPurchaseAccount) {
    this.nbPurchaseAccount = nbPurchaseAccount;
    return this;
  }

  /**
   * Number of purchases with this cardholder account during the previous six months. Max length: 4
   * characters.
   *
   * @return nbPurchaseAccount Number of purchases with this cardholder account during the previous
   *     six months. Max length: 4 characters.
   */
  @JsonProperty(JSON_PROPERTY_NB_PURCHASE_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getNbPurchaseAccount() {
    return nbPurchaseAccount;
  }

  /**
   * Number of purchases with this cardholder account during the previous six months. Max length: 4
   * characters.
   *
   * @param nbPurchaseAccount Number of purchases with this cardholder account during the previous
   *     six months. Max length: 4 characters.
   */
  @JsonProperty(JSON_PROPERTY_NB_PURCHASE_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNbPurchaseAccount(String nbPurchaseAccount) {
    this.nbPurchaseAccount = nbPurchaseAccount;
  }

  /**
   * String that the payment account was enrolled in the cardholder’s account with the 3DS
   * Requestor. Format: **YYYYMMDD**
   *
   * @param paymentAccAge String that the payment account was enrolled in the cardholder’s account
   *     with the 3DS Requestor. Format: **YYYYMMDD**
   * @return the current {@code AcctInfo} instance, allowing for method chaining
   */
  public AcctInfo paymentAccAge(String paymentAccAge) {
    this.paymentAccAge = paymentAccAge;
    return this;
  }

  /**
   * String that the payment account was enrolled in the cardholder’s account with the 3DS
   * Requestor. Format: **YYYYMMDD**
   *
   * @return paymentAccAge String that the payment account was enrolled in the cardholder’s account
   *     with the 3DS Requestor. Format: **YYYYMMDD**
   */
  @JsonProperty(JSON_PROPERTY_PAYMENT_ACC_AGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPaymentAccAge() {
    return paymentAccAge;
  }

  /**
   * String that the payment account was enrolled in the cardholder’s account with the 3DS
   * Requestor. Format: **YYYYMMDD**
   *
   * @param paymentAccAge String that the payment account was enrolled in the cardholder’s account
   *     with the 3DS Requestor. Format: **YYYYMMDD**
   */
  @JsonProperty(JSON_PROPERTY_PAYMENT_ACC_AGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentAccAge(String paymentAccAge) {
    this.paymentAccAge = paymentAccAge;
  }

  /**
   * Indicates the length of time that the payment account was enrolled in the cardholder’s account
   * with the 3DS Requestor. Allowed values: * **01** — No account (guest checkout) * **02** —
   * During this transaction * **03** — Less than 30 days * **04** — 30–60 days * **05** — More than
   * 60 days
   *
   * @param paymentAccInd Indicates the length of time that the payment account was enrolled in the
   *     cardholder’s account with the 3DS Requestor. Allowed values: * **01** — No account (guest
   *     checkout) * **02** — During this transaction * **03** — Less than 30 days * **04** — 30–60
   *     days * **05** — More than 60 days
   * @return the current {@code AcctInfo} instance, allowing for method chaining
   */
  public AcctInfo paymentAccInd(PaymentAccIndEnum paymentAccInd) {
    this.paymentAccInd = paymentAccInd;
    return this;
  }

  /**
   * Indicates the length of time that the payment account was enrolled in the cardholder’s account
   * with the 3DS Requestor. Allowed values: * **01** — No account (guest checkout) * **02** —
   * During this transaction * **03** — Less than 30 days * **04** — 30–60 days * **05** — More than
   * 60 days
   *
   * @return paymentAccInd Indicates the length of time that the payment account was enrolled in the
   *     cardholder’s account with the 3DS Requestor. Allowed values: * **01** — No account (guest
   *     checkout) * **02** — During this transaction * **03** — Less than 30 days * **04** — 30–60
   *     days * **05** — More than 60 days
   */
  @JsonProperty(JSON_PROPERTY_PAYMENT_ACC_IND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public PaymentAccIndEnum getPaymentAccInd() {
    return paymentAccInd;
  }

  /**
   * Indicates the length of time that the payment account was enrolled in the cardholder’s account
   * with the 3DS Requestor. Allowed values: * **01** — No account (guest checkout) * **02** —
   * During this transaction * **03** — Less than 30 days * **04** — 30–60 days * **05** — More than
   * 60 days
   *
   * @param paymentAccInd Indicates the length of time that the payment account was enrolled in the
   *     cardholder’s account with the 3DS Requestor. Allowed values: * **01** — No account (guest
   *     checkout) * **02** — During this transaction * **03** — Less than 30 days * **04** — 30–60
   *     days * **05** — More than 60 days
   */
  @JsonProperty(JSON_PROPERTY_PAYMENT_ACC_IND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentAccInd(PaymentAccIndEnum paymentAccInd) {
    this.paymentAccInd = paymentAccInd;
  }

  /**
   * Number of Add Card attempts in the last 24 hours. Max length: 3 characters.
   *
   * @param provisionAttemptsDay Number of Add Card attempts in the last 24 hours. Max length: 3
   *     characters.
   * @return the current {@code AcctInfo} instance, allowing for method chaining
   */
  public AcctInfo provisionAttemptsDay(String provisionAttemptsDay) {
    this.provisionAttemptsDay = provisionAttemptsDay;
    return this;
  }

  /**
   * Number of Add Card attempts in the last 24 hours. Max length: 3 characters.
   *
   * @return provisionAttemptsDay Number of Add Card attempts in the last 24 hours. Max length: 3
   *     characters.
   */
  @JsonProperty(JSON_PROPERTY_PROVISION_ATTEMPTS_DAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getProvisionAttemptsDay() {
    return provisionAttemptsDay;
  }

  /**
   * Number of Add Card attempts in the last 24 hours. Max length: 3 characters.
   *
   * @param provisionAttemptsDay Number of Add Card attempts in the last 24 hours. Max length: 3
   *     characters.
   */
  @JsonProperty(JSON_PROPERTY_PROVISION_ATTEMPTS_DAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProvisionAttemptsDay(String provisionAttemptsDay) {
    this.provisionAttemptsDay = provisionAttemptsDay;
  }

  /**
   * String when the shipping address used for this transaction was first used with the 3DS
   * Requestor. Format: **YYYYMMDD**
   *
   * @param shipAddressUsage String when the shipping address used for this transaction was first
   *     used with the 3DS Requestor. Format: **YYYYMMDD**
   * @return the current {@code AcctInfo} instance, allowing for method chaining
   */
  public AcctInfo shipAddressUsage(String shipAddressUsage) {
    this.shipAddressUsage = shipAddressUsage;
    return this;
  }

  /**
   * String when the shipping address used for this transaction was first used with the 3DS
   * Requestor. Format: **YYYYMMDD**
   *
   * @return shipAddressUsage String when the shipping address used for this transaction was first
   *     used with the 3DS Requestor. Format: **YYYYMMDD**
   */
  @JsonProperty(JSON_PROPERTY_SHIP_ADDRESS_USAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getShipAddressUsage() {
    return shipAddressUsage;
  }

  /**
   * String when the shipping address used for this transaction was first used with the 3DS
   * Requestor. Format: **YYYYMMDD**
   *
   * @param shipAddressUsage String when the shipping address used for this transaction was first
   *     used with the 3DS Requestor. Format: **YYYYMMDD**
   */
  @JsonProperty(JSON_PROPERTY_SHIP_ADDRESS_USAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShipAddressUsage(String shipAddressUsage) {
    this.shipAddressUsage = shipAddressUsage;
  }

  /**
   * Indicates when the shipping address used for this transaction was first used with the 3DS
   * Requestor. Allowed values: * **01** — This transaction * **02** — Less than 30 days * **03** —
   * 30–60 days * **04** — More than 60 days
   *
   * @param shipAddressUsageInd Indicates when the shipping address used for this transaction was
   *     first used with the 3DS Requestor. Allowed values: * **01** — This transaction * **02** —
   *     Less than 30 days * **03** — 30–60 days * **04** — More than 60 days
   * @return the current {@code AcctInfo} instance, allowing for method chaining
   */
  public AcctInfo shipAddressUsageInd(ShipAddressUsageIndEnum shipAddressUsageInd) {
    this.shipAddressUsageInd = shipAddressUsageInd;
    return this;
  }

  /**
   * Indicates when the shipping address used for this transaction was first used with the 3DS
   * Requestor. Allowed values: * **01** — This transaction * **02** — Less than 30 days * **03** —
   * 30–60 days * **04** — More than 60 days
   *
   * @return shipAddressUsageInd Indicates when the shipping address used for this transaction was
   *     first used with the 3DS Requestor. Allowed values: * **01** — This transaction * **02** —
   *     Less than 30 days * **03** — 30–60 days * **04** — More than 60 days
   */
  @JsonProperty(JSON_PROPERTY_SHIP_ADDRESS_USAGE_IND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ShipAddressUsageIndEnum getShipAddressUsageInd() {
    return shipAddressUsageInd;
  }

  /**
   * Indicates when the shipping address used for this transaction was first used with the 3DS
   * Requestor. Allowed values: * **01** — This transaction * **02** — Less than 30 days * **03** —
   * 30–60 days * **04** — More than 60 days
   *
   * @param shipAddressUsageInd Indicates when the shipping address used for this transaction was
   *     first used with the 3DS Requestor. Allowed values: * **01** — This transaction * **02** —
   *     Less than 30 days * **03** — 30–60 days * **04** — More than 60 days
   */
  @JsonProperty(JSON_PROPERTY_SHIP_ADDRESS_USAGE_IND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShipAddressUsageInd(ShipAddressUsageIndEnum shipAddressUsageInd) {
    this.shipAddressUsageInd = shipAddressUsageInd;
  }

  /**
   * Indicates if the Cardholder Name on the account is identical to the shipping Name used for this
   * transaction. Allowed values: * **01** — Account Name identical to shipping Name * **02** —
   * Account Name different to shipping Name
   *
   * @param shipNameIndicator Indicates if the Cardholder Name on the account is identical to the
   *     shipping Name used for this transaction. Allowed values: * **01** — Account Name identical
   *     to shipping Name * **02** — Account Name different to shipping Name
   * @return the current {@code AcctInfo} instance, allowing for method chaining
   */
  public AcctInfo shipNameIndicator(ShipNameIndicatorEnum shipNameIndicator) {
    this.shipNameIndicator = shipNameIndicator;
    return this;
  }

  /**
   * Indicates if the Cardholder Name on the account is identical to the shipping Name used for this
   * transaction. Allowed values: * **01** — Account Name identical to shipping Name * **02** —
   * Account Name different to shipping Name
   *
   * @return shipNameIndicator Indicates if the Cardholder Name on the account is identical to the
   *     shipping Name used for this transaction. Allowed values: * **01** — Account Name identical
   *     to shipping Name * **02** — Account Name different to shipping Name
   */
  @JsonProperty(JSON_PROPERTY_SHIP_NAME_INDICATOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ShipNameIndicatorEnum getShipNameIndicator() {
    return shipNameIndicator;
  }

  /**
   * Indicates if the Cardholder Name on the account is identical to the shipping Name used for this
   * transaction. Allowed values: * **01** — Account Name identical to shipping Name * **02** —
   * Account Name different to shipping Name
   *
   * @param shipNameIndicator Indicates if the Cardholder Name on the account is identical to the
   *     shipping Name used for this transaction. Allowed values: * **01** — Account Name identical
   *     to shipping Name * **02** — Account Name different to shipping Name
   */
  @JsonProperty(JSON_PROPERTY_SHIP_NAME_INDICATOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShipNameIndicator(ShipNameIndicatorEnum shipNameIndicator) {
    this.shipNameIndicator = shipNameIndicator;
  }

  /**
   * Indicates whether the 3DS Requestor has experienced suspicious activity (including previous
   * fraud) on the cardholder account. Allowed values: * **01** — No suspicious activity has been
   * observed * **02** — Suspicious activity has been observed
   *
   * @param suspiciousAccActivity Indicates whether the 3DS Requestor has experienced suspicious
   *     activity (including previous fraud) on the cardholder account. Allowed values: * **01** —
   *     No suspicious activity has been observed * **02** — Suspicious activity has been observed
   * @return the current {@code AcctInfo} instance, allowing for method chaining
   */
  public AcctInfo suspiciousAccActivity(SuspiciousAccActivityEnum suspiciousAccActivity) {
    this.suspiciousAccActivity = suspiciousAccActivity;
    return this;
  }

  /**
   * Indicates whether the 3DS Requestor has experienced suspicious activity (including previous
   * fraud) on the cardholder account. Allowed values: * **01** — No suspicious activity has been
   * observed * **02** — Suspicious activity has been observed
   *
   * @return suspiciousAccActivity Indicates whether the 3DS Requestor has experienced suspicious
   *     activity (including previous fraud) on the cardholder account. Allowed values: * **01** —
   *     No suspicious activity has been observed * **02** — Suspicious activity has been observed
   */
  @JsonProperty(JSON_PROPERTY_SUSPICIOUS_ACC_ACTIVITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public SuspiciousAccActivityEnum getSuspiciousAccActivity() {
    return suspiciousAccActivity;
  }

  /**
   * Indicates whether the 3DS Requestor has experienced suspicious activity (including previous
   * fraud) on the cardholder account. Allowed values: * **01** — No suspicious activity has been
   * observed * **02** — Suspicious activity has been observed
   *
   * @param suspiciousAccActivity Indicates whether the 3DS Requestor has experienced suspicious
   *     activity (including previous fraud) on the cardholder account. Allowed values: * **01** —
   *     No suspicious activity has been observed * **02** — Suspicious activity has been observed
   */
  @JsonProperty(JSON_PROPERTY_SUSPICIOUS_ACC_ACTIVITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSuspiciousAccActivity(SuspiciousAccActivityEnum suspiciousAccActivity) {
    this.suspiciousAccActivity = suspiciousAccActivity;
  }

  /**
   * Number of transactions (successful and abandoned) for this cardholder account with the 3DS
   * Requestor across all payment accounts in the previous 24 hours. Max length: 3 characters.
   *
   * @param txnActivityDay Number of transactions (successful and abandoned) for this cardholder
   *     account with the 3DS Requestor across all payment accounts in the previous 24 hours. Max
   *     length: 3 characters.
   * @return the current {@code AcctInfo} instance, allowing for method chaining
   */
  public AcctInfo txnActivityDay(String txnActivityDay) {
    this.txnActivityDay = txnActivityDay;
    return this;
  }

  /**
   * Number of transactions (successful and abandoned) for this cardholder account with the 3DS
   * Requestor across all payment accounts in the previous 24 hours. Max length: 3 characters.
   *
   * @return txnActivityDay Number of transactions (successful and abandoned) for this cardholder
   *     account with the 3DS Requestor across all payment accounts in the previous 24 hours. Max
   *     length: 3 characters.
   */
  @JsonProperty(JSON_PROPERTY_TXN_ACTIVITY_DAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getTxnActivityDay() {
    return txnActivityDay;
  }

  /**
   * Number of transactions (successful and abandoned) for this cardholder account with the 3DS
   * Requestor across all payment accounts in the previous 24 hours. Max length: 3 characters.
   *
   * @param txnActivityDay Number of transactions (successful and abandoned) for this cardholder
   *     account with the 3DS Requestor across all payment accounts in the previous 24 hours. Max
   *     length: 3 characters.
   */
  @JsonProperty(JSON_PROPERTY_TXN_ACTIVITY_DAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTxnActivityDay(String txnActivityDay) {
    this.txnActivityDay = txnActivityDay;
  }

  /**
   * Number of transactions (successful and abandoned) for this cardholder account with the 3DS
   * Requestor across all payment accounts in the previous year. Max length: 3 characters.
   *
   * @param txnActivityYear Number of transactions (successful and abandoned) for this cardholder
   *     account with the 3DS Requestor across all payment accounts in the previous year. Max
   *     length: 3 characters.
   * @return the current {@code AcctInfo} instance, allowing for method chaining
   */
  public AcctInfo txnActivityYear(String txnActivityYear) {
    this.txnActivityYear = txnActivityYear;
    return this;
  }

  /**
   * Number of transactions (successful and abandoned) for this cardholder account with the 3DS
   * Requestor across all payment accounts in the previous year. Max length: 3 characters.
   *
   * @return txnActivityYear Number of transactions (successful and abandoned) for this cardholder
   *     account with the 3DS Requestor across all payment accounts in the previous year. Max
   *     length: 3 characters.
   */
  @JsonProperty(JSON_PROPERTY_TXN_ACTIVITY_YEAR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getTxnActivityYear() {
    return txnActivityYear;
  }

  /**
   * Number of transactions (successful and abandoned) for this cardholder account with the 3DS
   * Requestor across all payment accounts in the previous year. Max length: 3 characters.
   *
   * @param txnActivityYear Number of transactions (successful and abandoned) for this cardholder
   *     account with the 3DS Requestor across all payment accounts in the previous year. Max
   *     length: 3 characters.
   */
  @JsonProperty(JSON_PROPERTY_TXN_ACTIVITY_YEAR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTxnActivityYear(String txnActivityYear) {
    this.txnActivityYear = txnActivityYear;
  }

  /** Return true if this AcctInfo object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AcctInfo acctInfo = (AcctInfo) o;
    return Objects.equals(this.chAccAgeInd, acctInfo.chAccAgeInd)
        && Objects.equals(this.chAccChange, acctInfo.chAccChange)
        && Objects.equals(this.chAccChangeInd, acctInfo.chAccChangeInd)
        && Objects.equals(this.chAccPwChange, acctInfo.chAccPwChange)
        && Objects.equals(this.chAccPwChangeInd, acctInfo.chAccPwChangeInd)
        && Objects.equals(this.chAccString, acctInfo.chAccString)
        && Objects.equals(this.nbPurchaseAccount, acctInfo.nbPurchaseAccount)
        && Objects.equals(this.paymentAccAge, acctInfo.paymentAccAge)
        && Objects.equals(this.paymentAccInd, acctInfo.paymentAccInd)
        && Objects.equals(this.provisionAttemptsDay, acctInfo.provisionAttemptsDay)
        && Objects.equals(this.shipAddressUsage, acctInfo.shipAddressUsage)
        && Objects.equals(this.shipAddressUsageInd, acctInfo.shipAddressUsageInd)
        && Objects.equals(this.shipNameIndicator, acctInfo.shipNameIndicator)
        && Objects.equals(this.suspiciousAccActivity, acctInfo.suspiciousAccActivity)
        && Objects.equals(this.txnActivityDay, acctInfo.txnActivityDay)
        && Objects.equals(this.txnActivityYear, acctInfo.txnActivityYear);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        chAccAgeInd,
        chAccChange,
        chAccChangeInd,
        chAccPwChange,
        chAccPwChangeInd,
        chAccString,
        nbPurchaseAccount,
        paymentAccAge,
        paymentAccInd,
        provisionAttemptsDay,
        shipAddressUsage,
        shipAddressUsageInd,
        shipNameIndicator,
        suspiciousAccActivity,
        txnActivityDay,
        txnActivityYear);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AcctInfo {\n");
    sb.append("    chAccAgeInd: ").append(toIndentedString(chAccAgeInd)).append("\n");
    sb.append("    chAccChange: ").append(toIndentedString(chAccChange)).append("\n");
    sb.append("    chAccChangeInd: ").append(toIndentedString(chAccChangeInd)).append("\n");
    sb.append("    chAccPwChange: ").append(toIndentedString(chAccPwChange)).append("\n");
    sb.append("    chAccPwChangeInd: ").append(toIndentedString(chAccPwChangeInd)).append("\n");
    sb.append("    chAccString: ").append(toIndentedString(chAccString)).append("\n");
    sb.append("    nbPurchaseAccount: ").append(toIndentedString(nbPurchaseAccount)).append("\n");
    sb.append("    paymentAccAge: ").append(toIndentedString(paymentAccAge)).append("\n");
    sb.append("    paymentAccInd: ").append(toIndentedString(paymentAccInd)).append("\n");
    sb.append("    provisionAttemptsDay: ")
        .append(toIndentedString(provisionAttemptsDay))
        .append("\n");
    sb.append("    shipAddressUsage: ").append(toIndentedString(shipAddressUsage)).append("\n");
    sb.append("    shipAddressUsageInd: ")
        .append(toIndentedString(shipAddressUsageInd))
        .append("\n");
    sb.append("    shipNameIndicator: ").append(toIndentedString(shipNameIndicator)).append("\n");
    sb.append("    suspiciousAccActivity: ")
        .append(toIndentedString(suspiciousAccActivity))
        .append("\n");
    sb.append("    txnActivityDay: ").append(toIndentedString(txnActivityDay)).append("\n");
    sb.append("    txnActivityYear: ").append(toIndentedString(txnActivityYear)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of AcctInfo given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of AcctInfo
   * @throws JsonProcessingException if the JSON string is invalid with respect to AcctInfo
   */
  public static AcctInfo fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, AcctInfo.class);
  }

  /**
   * Convert an instance of AcctInfo to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
