/*
 * Payments App API
 *
 * The version of the OpenAPI document: 1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.paymentsapp;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;

/** BoardingTokenResponse */
@JsonPropertyOrder({
  BoardingTokenResponse.JSON_PROPERTY_BOARDING_TOKEN,
  BoardingTokenResponse.JSON_PROPERTY_INSTALLATION_ID
})
public class BoardingTokenResponse {
  public static final String JSON_PROPERTY_BOARDING_TOKEN = "boardingToken";
  private String boardingToken;

  public static final String JSON_PROPERTY_INSTALLATION_ID = "installationId";
  private String installationId;

  public BoardingTokenResponse() {}

  /**
   * The boarding token that allows the Payments App to board.
   *
   * @param boardingToken The boarding token that allows the Payments App to board.
   * @return the current {@code BoardingTokenResponse} instance, allowing for method chaining
   */
  public BoardingTokenResponse boardingToken(String boardingToken) {
    this.boardingToken = boardingToken;
    return this;
  }

  /**
   * The boarding token that allows the Payments App to board.
   *
   * @return boardingToken The boarding token that allows the Payments App to board.
   */
  @JsonProperty(JSON_PROPERTY_BOARDING_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getBoardingToken() {
    return boardingToken;
  }

  /**
   * The boarding token that allows the Payments App to board.
   *
   * @param boardingToken The boarding token that allows the Payments App to board.
   */
  @JsonProperty(JSON_PROPERTY_BOARDING_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBoardingToken(String boardingToken) {
    this.boardingToken = boardingToken;
  }

  /**
   * The unique identifier of the Payments App instance.
   *
   * @param installationId The unique identifier of the Payments App instance.
   * @return the current {@code BoardingTokenResponse} instance, allowing for method chaining
   */
  public BoardingTokenResponse installationId(String installationId) {
    this.installationId = installationId;
    return this;
  }

  /**
   * The unique identifier of the Payments App instance.
   *
   * @return installationId The unique identifier of the Payments App instance.
   */
  @JsonProperty(JSON_PROPERTY_INSTALLATION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getInstallationId() {
    return installationId;
  }

  /**
   * The unique identifier of the Payments App instance.
   *
   * @param installationId The unique identifier of the Payments App instance.
   */
  @JsonProperty(JSON_PROPERTY_INSTALLATION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInstallationId(String installationId) {
    this.installationId = installationId;
  }

  /** Return true if this BoardingTokenResponse object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BoardingTokenResponse boardingTokenResponse = (BoardingTokenResponse) o;
    return Objects.equals(this.boardingToken, boardingTokenResponse.boardingToken)
        && Objects.equals(this.installationId, boardingTokenResponse.installationId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(boardingToken, installationId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BoardingTokenResponse {\n");
    sb.append("    boardingToken: ").append(toIndentedString(boardingToken)).append("\n");
    sb.append("    installationId: ").append(toIndentedString(installationId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of BoardingTokenResponse given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of BoardingTokenResponse
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     BoardingTokenResponse
   */
  public static BoardingTokenResponse fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, BoardingTokenResponse.class);
  }

  /**
   * Convert an instance of BoardingTokenResponse to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
