/*
 * Session authentication API
 *
 * The version of the OpenAPI document: 1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.sessionauthentication;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;

/** LegalEntityResource */
@JsonPropertyOrder({LegalEntityResource.JSON_PROPERTY_LEGAL_ENTITY_ID})
@JsonIgnoreProperties(
    value =
        "type", // ignore manually set type, it will be automatically generated by Jackson during
    // serialization
    allowSetters = true // allows the type to be set during deserialization
    )
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "type",
    visible = true)
public class LegalEntityResource extends Resource {
  public static final String JSON_PROPERTY_LEGAL_ENTITY_ID = "legalEntityId";
  private String legalEntityId;

  public LegalEntityResource() {}

  /**
   * The unique identifier of the resource connected to the component. For [Onboarding
   * components](https://docs.adyen.com/platforms/onboard-users/components), this is the legal
   * entity that has a contractual relationship with your platform and owns the [transfer
   * instrument](https://docs.adyen.com/api-explorer/legalentity/latest/post/transferInstruments).
   * For sole proprietorships, this is the legal entity of the individual owner.
   *
   * @param legalEntityId The unique identifier of the resource connected to the component. For
   *     [Onboarding components](https://docs.adyen.com/platforms/onboard-users/components), this is
   *     the legal entity that has a contractual relationship with your platform and owns the
   *     [transfer
   *     instrument](https://docs.adyen.com/api-explorer/legalentity/latest/post/transferInstruments).
   *     For sole proprietorships, this is the legal entity of the individual owner.
   * @return the current {@code LegalEntityResource} instance, allowing for method chaining
   */
  public LegalEntityResource legalEntityId(String legalEntityId) {
    this.legalEntityId = legalEntityId;
    return this;
  }

  /**
   * The unique identifier of the resource connected to the component. For [Onboarding
   * components](https://docs.adyen.com/platforms/onboard-users/components), this is the legal
   * entity that has a contractual relationship with your platform and owns the [transfer
   * instrument](https://docs.adyen.com/api-explorer/legalentity/latest/post/transferInstruments).
   * For sole proprietorships, this is the legal entity of the individual owner.
   *
   * @return legalEntityId The unique identifier of the resource connected to the component. For
   *     [Onboarding components](https://docs.adyen.com/platforms/onboard-users/components), this is
   *     the legal entity that has a contractual relationship with your platform and owns the
   *     [transfer
   *     instrument](https://docs.adyen.com/api-explorer/legalentity/latest/post/transferInstruments).
   *     For sole proprietorships, this is the legal entity of the individual owner.
   */
  @JsonProperty(JSON_PROPERTY_LEGAL_ENTITY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getLegalEntityId() {
    return legalEntityId;
  }

  /**
   * The unique identifier of the resource connected to the component. For [Onboarding
   * components](https://docs.adyen.com/platforms/onboard-users/components), this is the legal
   * entity that has a contractual relationship with your platform and owns the [transfer
   * instrument](https://docs.adyen.com/api-explorer/legalentity/latest/post/transferInstruments).
   * For sole proprietorships, this is the legal entity of the individual owner.
   *
   * @param legalEntityId The unique identifier of the resource connected to the component. For
   *     [Onboarding components](https://docs.adyen.com/platforms/onboard-users/components), this is
   *     the legal entity that has a contractual relationship with your platform and owns the
   *     [transfer
   *     instrument](https://docs.adyen.com/api-explorer/legalentity/latest/post/transferInstruments).
   *     For sole proprietorships, this is the legal entity of the individual owner.
   */
  @JsonProperty(JSON_PROPERTY_LEGAL_ENTITY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLegalEntityId(String legalEntityId) {
    this.legalEntityId = legalEntityId;
  }

  /** Return true if this LegalEntityResource object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LegalEntityResource legalEntityResource = (LegalEntityResource) o;
    return Objects.equals(this.legalEntityId, legalEntityResource.legalEntityId) && super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(legalEntityId, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LegalEntityResource {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    legalEntityId: ").append(toIndentedString(legalEntityId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  static {
    // Initialize and register the discriminator mappings.
    Map<String, Class<?>> mappings = new HashMap<>();
    mappings.put("LegalEntityResource", LegalEntityResource.class);
    JSON.registerDiscriminator(LegalEntityResource.class, "type", mappings);
  }

  /**
   * Create an instance of LegalEntityResource given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of LegalEntityResource
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     LegalEntityResource
   */
  public static LegalEntityResource fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, LegalEntityResource.class);
  }

  /**
   * Convert an instance of LegalEntityResource to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
