/*
 * Session authentication API
 *
 * The version of the OpenAPI document: 1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.sessionauthentication;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.*;
import java.util.LinkedHashSet;
import java.util.Set;

/** Policy */
@JsonPropertyOrder({Policy.JSON_PROPERTY_RESOURCES, Policy.JSON_PROPERTY_ROLES})
public class Policy {
  public static final String JSON_PROPERTY_RESOURCES = "resources";
  private Set<Resource> resources;

  public static final String JSON_PROPERTY_ROLES = "roles";
  private Set<String> roles;

  public Policy() {}

  /**
   * An object containing the type and the unique identifier of the user of the component. For
   * [Onboarding components](https://docs.adyen.com/platforms/onboard-users/components), this is the
   * ID of the legal entity that has a contractual relationship with your platform. For sole
   * proprietorships, use the ID of the legal entity of the individual owner. For [Platform
   * Experience components](https://docs.adyen.com/platforms/build-user-dashboards), this is the ID
   * of the account holder that is associated with the balance account shown in the component.
   *
   * @param resources An object containing the type and the unique identifier of the user of the
   *     component. For [Onboarding
   *     components](https://docs.adyen.com/platforms/onboard-users/components), this is the ID of
   *     the legal entity that has a contractual relationship with your platform. For sole
   *     proprietorships, use the ID of the legal entity of the individual owner. For [Platform
   *     Experience components](https://docs.adyen.com/platforms/build-user-dashboards), this is the
   *     ID of the account holder that is associated with the balance account shown in the
   *     component.
   * @return the current {@code Policy} instance, allowing for method chaining
   */
  public Policy resources(Set<Resource> resources) {
    this.resources = resources;
    return this;
  }

  public Policy addResourcesItem(Resource resourcesItem) {
    if (this.resources == null) {
      this.resources = new LinkedHashSet<>();
    }
    this.resources.add(resourcesItem);
    return this;
  }

  /**
   * An object containing the type and the unique identifier of the user of the component. For
   * [Onboarding components](https://docs.adyen.com/platforms/onboard-users/components), this is the
   * ID of the legal entity that has a contractual relationship with your platform. For sole
   * proprietorships, use the ID of the legal entity of the individual owner. For [Platform
   * Experience components](https://docs.adyen.com/platforms/build-user-dashboards), this is the ID
   * of the account holder that is associated with the balance account shown in the component.
   *
   * @return resources An object containing the type and the unique identifier of the user of the
   *     component. For [Onboarding
   *     components](https://docs.adyen.com/platforms/onboard-users/components), this is the ID of
   *     the legal entity that has a contractual relationship with your platform. For sole
   *     proprietorships, use the ID of the legal entity of the individual owner. For [Platform
   *     Experience components](https://docs.adyen.com/platforms/build-user-dashboards), this is the
   *     ID of the account holder that is associated with the balance account shown in the
   *     component.
   */
  @JsonProperty(JSON_PROPERTY_RESOURCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Set<Resource> getResources() {
    return resources;
  }

  /**
   * An object containing the type and the unique identifier of the user of the component. For
   * [Onboarding components](https://docs.adyen.com/platforms/onboard-users/components), this is the
   * ID of the legal entity that has a contractual relationship with your platform. For sole
   * proprietorships, use the ID of the legal entity of the individual owner. For [Platform
   * Experience components](https://docs.adyen.com/platforms/build-user-dashboards), this is the ID
   * of the account holder that is associated with the balance account shown in the component.
   *
   * @param resources An object containing the type and the unique identifier of the user of the
   *     component. For [Onboarding
   *     components](https://docs.adyen.com/platforms/onboard-users/components), this is the ID of
   *     the legal entity that has a contractual relationship with your platform. For sole
   *     proprietorships, use the ID of the legal entity of the individual owner. For [Platform
   *     Experience components](https://docs.adyen.com/platforms/build-user-dashboards), this is the
   *     ID of the account holder that is associated with the balance account shown in the
   *     component.
   */
  @JsonDeserialize(as = LinkedHashSet.class)
  @JsonProperty(JSON_PROPERTY_RESOURCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResources(Set<Resource> resources) {
    this.resources = resources;
  }

  /**
   * The name of the role required to use the component.
   *
   * @param roles The name of the role required to use the component.
   * @return the current {@code Policy} instance, allowing for method chaining
   */
  public Policy roles(Set<String> roles) {
    this.roles = roles;
    return this;
  }

  public Policy addRolesItem(String rolesItem) {
    if (this.roles == null) {
      this.roles = new LinkedHashSet<>();
    }
    this.roles.add(rolesItem);
    return this;
  }

  /**
   * The name of the role required to use the component.
   *
   * @return roles The name of the role required to use the component.
   */
  @JsonProperty(JSON_PROPERTY_ROLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Set<String> getRoles() {
    return roles;
  }

  /**
   * The name of the role required to use the component.
   *
   * @param roles The name of the role required to use the component.
   */
  @JsonDeserialize(as = LinkedHashSet.class)
  @JsonProperty(JSON_PROPERTY_ROLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoles(Set<String> roles) {
    this.roles = roles;
  }

  /** Return true if this Policy object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Policy policy = (Policy) o;
    return Objects.equals(this.resources, policy.resources)
        && Objects.equals(this.roles, policy.roles);
  }

  @Override
  public int hashCode() {
    return Objects.hash(resources, roles);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Policy {\n");
    sb.append("    resources: ").append(toIndentedString(resources)).append("\n");
    sb.append("    roles: ").append(toIndentedString(roles)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of Policy given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of Policy
   * @throws JsonProcessingException if the JSON string is invalid with respect to Policy
   */
  public static Policy fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, Policy.class);
  }

  /**
   * Convert an instance of Policy to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
