/*
 * Transfers API
 *
 * The version of the OpenAPI document: 4
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.transfers;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

/** MerchantPurchaseData */
@JsonPropertyOrder({
  MerchantPurchaseData.JSON_PROPERTY_AIRLINE,
  MerchantPurchaseData.JSON_PROPERTY_LODGING,
  MerchantPurchaseData.JSON_PROPERTY_TYPE
})
public class MerchantPurchaseData {
  public static final String JSON_PROPERTY_AIRLINE = "airline";
  private Airline airline;

  public static final String JSON_PROPERTY_LODGING = "lodging";
  private List<Lodging> lodging;

  /**
   * The type of events data. Possible values: - **merchantPurchaseData**: merchant purchase data
   */
  public enum TypeEnum {
    MERCHANTPURCHASEDATA(String.valueOf("merchantPurchaseData"));

    private static final Logger LOG = Logger.getLogger(TypeEnum.class.getName());

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "TypeEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(TypeEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public MerchantPurchaseData() {}

  /**
   * airline
   *
   * @param airline
   * @return the current {@code MerchantPurchaseData} instance, allowing for method chaining
   */
  public MerchantPurchaseData airline(Airline airline) {
    this.airline = airline;
    return this;
  }

  /**
   * Get airline
   *
   * @return airline
   */
  @JsonProperty(JSON_PROPERTY_AIRLINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Airline getAirline() {
    return airline;
  }

  /**
   * airline
   *
   * @param airline
   */
  @JsonProperty(JSON_PROPERTY_AIRLINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAirline(Airline airline) {
    this.airline = airline;
  }

  /**
   * Lodging information.
   *
   * @param lodging Lodging information.
   * @return the current {@code MerchantPurchaseData} instance, allowing for method chaining
   */
  public MerchantPurchaseData lodging(List<Lodging> lodging) {
    this.lodging = lodging;
    return this;
  }

  public MerchantPurchaseData addLodgingItem(Lodging lodgingItem) {
    if (this.lodging == null) {
      this.lodging = new ArrayList<>();
    }
    this.lodging.add(lodgingItem);
    return this;
  }

  /**
   * Lodging information.
   *
   * @return lodging Lodging information.
   */
  @JsonProperty(JSON_PROPERTY_LODGING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<Lodging> getLodging() {
    return lodging;
  }

  /**
   * Lodging information.
   *
   * @param lodging Lodging information.
   */
  @JsonProperty(JSON_PROPERTY_LODGING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLodging(List<Lodging> lodging) {
    this.lodging = lodging;
  }

  /**
   * The type of events data. Possible values: - **merchantPurchaseData**: merchant purchase data
   *
   * @param type The type of events data. Possible values: - **merchantPurchaseData**: merchant
   *     purchase data
   * @return the current {@code MerchantPurchaseData} instance, allowing for method chaining
   */
  public MerchantPurchaseData type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * The type of events data. Possible values: - **merchantPurchaseData**: merchant purchase data
   *
   * @return type The type of events data. Possible values: - **merchantPurchaseData**: merchant
   *     purchase data
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * The type of events data. Possible values: - **merchantPurchaseData**: merchant purchase data
   *
   * @param type The type of events data. Possible values: - **merchantPurchaseData**: merchant
   *     purchase data
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /** Return true if this MerchantPurchaseData object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MerchantPurchaseData merchantPurchaseData = (MerchantPurchaseData) o;
    return Objects.equals(this.airline, merchantPurchaseData.airline)
        && Objects.equals(this.lodging, merchantPurchaseData.lodging)
        && Objects.equals(this.type, merchantPurchaseData.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(airline, lodging, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MerchantPurchaseData {\n");
    sb.append("    airline: ").append(toIndentedString(airline)).append("\n");
    sb.append("    lodging: ").append(toIndentedString(lodging)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of MerchantPurchaseData given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of MerchantPurchaseData
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     MerchantPurchaseData
   */
  public static MerchantPurchaseData fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, MerchantPurchaseData.class);
  }

  /**
   * Convert an instance of MerchantPurchaseData to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
