/*
 * Transfer webhooks
 *
 * The version of the OpenAPI document: 4
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.transferwebhooks;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.LocalDate;
import java.util.*;

/** ExecutionDate */
@JsonPropertyOrder({ExecutionDate.JSON_PROPERTY_DATE, ExecutionDate.JSON_PROPERTY_TIMEZONE})
public class ExecutionDate {
  public static final String JSON_PROPERTY_DATE = "date";
  private LocalDate date;

  public static final String JSON_PROPERTY_TIMEZONE = "timezone";
  private String timezone;

  public ExecutionDate() {}

  /**
   * The date when the transfer will be processed. This date must be: * Within 30 days of the
   * current date. * In the [ISO 8601
   * format](https://www.iso.org/iso-8601-date-and-time-format.html) **YYYY-MM-DD**. For example:
   * 2025-01-31
   *
   * @param date The date when the transfer will be processed. This date must be: * Within 30 days
   *     of the current date. * In the [ISO 8601
   *     format](https://www.iso.org/iso-8601-date-and-time-format.html) **YYYY-MM-DD**. For
   *     example: 2025-01-31
   * @return the current {@code ExecutionDate} instance, allowing for method chaining
   */
  public ExecutionDate date(LocalDate date) {
    this.date = date;
    return this;
  }

  /**
   * The date when the transfer will be processed. This date must be: * Within 30 days of the
   * current date. * In the [ISO 8601
   * format](https://www.iso.org/iso-8601-date-and-time-format.html) **YYYY-MM-DD**. For example:
   * 2025-01-31
   *
   * @return date The date when the transfer will be processed. This date must be: * Within 30 days
   *     of the current date. * In the [ISO 8601
   *     format](https://www.iso.org/iso-8601-date-and-time-format.html) **YYYY-MM-DD**. For
   *     example: 2025-01-31
   */
  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public LocalDate getDate() {
    return date;
  }

  /**
   * The date when the transfer will be processed. This date must be: * Within 30 days of the
   * current date. * In the [ISO 8601
   * format](https://www.iso.org/iso-8601-date-and-time-format.html) **YYYY-MM-DD**. For example:
   * 2025-01-31
   *
   * @param date The date when the transfer will be processed. This date must be: * Within 30 days
   *     of the current date. * In the [ISO 8601
   *     format](https://www.iso.org/iso-8601-date-and-time-format.html) **YYYY-MM-DD**. For
   *     example: 2025-01-31
   */
  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDate(LocalDate date) {
    this.date = date;
  }

  /**
   * The timezone that applies to the execution date. Use a timezone identifier from the [tz
   * database](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). Example:
   * **America/Los_Angeles**. Default value: **Europe/Amsterdam**.
   *
   * @param timezone The timezone that applies to the execution date. Use a timezone identifier from
   *     the [tz database](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). Example:
   *     **America/Los_Angeles**. Default value: **Europe/Amsterdam**.
   * @return the current {@code ExecutionDate} instance, allowing for method chaining
   */
  public ExecutionDate timezone(String timezone) {
    this.timezone = timezone;
    return this;
  }

  /**
   * The timezone that applies to the execution date. Use a timezone identifier from the [tz
   * database](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). Example:
   * **America/Los_Angeles**. Default value: **Europe/Amsterdam**.
   *
   * @return timezone The timezone that applies to the execution date. Use a timezone identifier
   *     from the [tz database](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones).
   *     Example: **America/Los_Angeles**. Default value: **Europe/Amsterdam**.
   */
  @JsonProperty(JSON_PROPERTY_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getTimezone() {
    return timezone;
  }

  /**
   * The timezone that applies to the execution date. Use a timezone identifier from the [tz
   * database](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). Example:
   * **America/Los_Angeles**. Default value: **Europe/Amsterdam**.
   *
   * @param timezone The timezone that applies to the execution date. Use a timezone identifier from
   *     the [tz database](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). Example:
   *     **America/Los_Angeles**. Default value: **Europe/Amsterdam**.
   */
  @JsonProperty(JSON_PROPERTY_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimezone(String timezone) {
    this.timezone = timezone;
  }

  /** Return true if this ExecutionDate object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ExecutionDate executionDate = (ExecutionDate) o;
    return Objects.equals(this.date, executionDate.date)
        && Objects.equals(this.timezone, executionDate.timezone);
  }

  @Override
  public int hashCode() {
    return Objects.hash(date, timezone);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ExecutionDate {\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    timezone: ").append(toIndentedString(timezone)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of ExecutionDate given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of ExecutionDate
   * @throws JsonProcessingException if the JSON string is invalid with respect to ExecutionDate
   */
  public static ExecutionDate fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, ExecutionDate.class);
  }

  /**
   * Convert an instance of ExecutionDate to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
