/*
 * Transfer webhooks
 *
 * The version of the OpenAPI document: 4
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.transferwebhooks;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;

/** TransferNotificationMerchantData */
@JsonPropertyOrder({
  TransferNotificationMerchantData.JSON_PROPERTY_ACQUIRER_ID,
  TransferNotificationMerchantData.JSON_PROPERTY_CITY,
  TransferNotificationMerchantData.JSON_PROPERTY_COUNTRY,
  TransferNotificationMerchantData.JSON_PROPERTY_MCC,
  TransferNotificationMerchantData.JSON_PROPERTY_MERCHANT_ID,
  TransferNotificationMerchantData.JSON_PROPERTY_NAME,
  TransferNotificationMerchantData.JSON_PROPERTY_POSTAL_CODE
})
public class TransferNotificationMerchantData {
  public static final String JSON_PROPERTY_ACQUIRER_ID = "acquirerId";
  private String acquirerId;

  public static final String JSON_PROPERTY_CITY = "city";
  private String city;

  public static final String JSON_PROPERTY_COUNTRY = "country";
  private String country;

  public static final String JSON_PROPERTY_MCC = "mcc";
  private String mcc;

  public static final String JSON_PROPERTY_MERCHANT_ID = "merchantId";
  private String merchantId;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_POSTAL_CODE = "postalCode";
  private String postalCode;

  public TransferNotificationMerchantData() {}

  /**
   * The unique identifier of the merchant&#39;s acquirer.
   *
   * @param acquirerId The unique identifier of the merchant&#39;s acquirer.
   * @return the current {@code TransferNotificationMerchantData} instance, allowing for method
   *     chaining
   */
  public TransferNotificationMerchantData acquirerId(String acquirerId) {
    this.acquirerId = acquirerId;
    return this;
  }

  /**
   * The unique identifier of the merchant&#39;s acquirer.
   *
   * @return acquirerId The unique identifier of the merchant&#39;s acquirer.
   */
  @JsonProperty(JSON_PROPERTY_ACQUIRER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAcquirerId() {
    return acquirerId;
  }

  /**
   * The unique identifier of the merchant&#39;s acquirer.
   *
   * @param acquirerId The unique identifier of the merchant&#39;s acquirer.
   */
  @JsonProperty(JSON_PROPERTY_ACQUIRER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAcquirerId(String acquirerId) {
    this.acquirerId = acquirerId;
  }

  /**
   * The city where the merchant is located.
   *
   * @param city The city where the merchant is located.
   * @return the current {@code TransferNotificationMerchantData} instance, allowing for method
   *     chaining
   */
  public TransferNotificationMerchantData city(String city) {
    this.city = city;
    return this;
  }

  /**
   * The city where the merchant is located.
   *
   * @return city The city where the merchant is located.
   */
  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCity() {
    return city;
  }

  /**
   * The city where the merchant is located.
   *
   * @param city The city where the merchant is located.
   */
  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCity(String city) {
    this.city = city;
  }

  /**
   * The country where the merchant is located.
   *
   * @param country The country where the merchant is located.
   * @return the current {@code TransferNotificationMerchantData} instance, allowing for method
   *     chaining
   */
  public TransferNotificationMerchantData country(String country) {
    this.country = country;
    return this;
  }

  /**
   * The country where the merchant is located.
   *
   * @return country The country where the merchant is located.
   */
  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCountry() {
    return country;
  }

  /**
   * The country where the merchant is located.
   *
   * @param country The country where the merchant is located.
   */
  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountry(String country) {
    this.country = country;
  }

  /**
   * The merchant category code.
   *
   * @param mcc The merchant category code.
   * @return the current {@code TransferNotificationMerchantData} instance, allowing for method
   *     chaining
   */
  public TransferNotificationMerchantData mcc(String mcc) {
    this.mcc = mcc;
    return this;
  }

  /**
   * The merchant category code.
   *
   * @return mcc The merchant category code.
   */
  @JsonProperty(JSON_PROPERTY_MCC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMcc() {
    return mcc;
  }

  /**
   * The merchant category code.
   *
   * @param mcc The merchant category code.
   */
  @JsonProperty(JSON_PROPERTY_MCC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMcc(String mcc) {
    this.mcc = mcc;
  }

  /**
   * The unique identifier of the merchant.
   *
   * @param merchantId The unique identifier of the merchant.
   * @return the current {@code TransferNotificationMerchantData} instance, allowing for method
   *     chaining
   */
  public TransferNotificationMerchantData merchantId(String merchantId) {
    this.merchantId = merchantId;
    return this;
  }

  /**
   * The unique identifier of the merchant.
   *
   * @return merchantId The unique identifier of the merchant.
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMerchantId() {
    return merchantId;
  }

  /**
   * The unique identifier of the merchant.
   *
   * @param merchantId The unique identifier of the merchant.
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantId(String merchantId) {
    this.merchantId = merchantId;
  }

  /**
   * The name of the merchant&#39;s shop or service.
   *
   * @param name The name of the merchant&#39;s shop or service.
   * @return the current {@code TransferNotificationMerchantData} instance, allowing for method
   *     chaining
   */
  public TransferNotificationMerchantData name(String name) {
    this.name = name;
    return this;
  }

  /**
   * The name of the merchant&#39;s shop or service.
   *
   * @return name The name of the merchant&#39;s shop or service.
   */
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getName() {
    return name;
  }

  /**
   * The name of the merchant&#39;s shop or service.
   *
   * @param name The name of the merchant&#39;s shop or service.
   */
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }

  /**
   * The postal code of the merchant.
   *
   * @param postalCode The postal code of the merchant.
   * @return the current {@code TransferNotificationMerchantData} instance, allowing for method
   *     chaining
   */
  public TransferNotificationMerchantData postalCode(String postalCode) {
    this.postalCode = postalCode;
    return this;
  }

  /**
   * The postal code of the merchant.
   *
   * @return postalCode The postal code of the merchant.
   */
  @JsonProperty(JSON_PROPERTY_POSTAL_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPostalCode() {
    return postalCode;
  }

  /**
   * The postal code of the merchant.
   *
   * @param postalCode The postal code of the merchant.
   */
  @JsonProperty(JSON_PROPERTY_POSTAL_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPostalCode(String postalCode) {
    this.postalCode = postalCode;
  }

  /** Return true if this TransferNotificationMerchantData object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TransferNotificationMerchantData transferNotificationMerchantData =
        (TransferNotificationMerchantData) o;
    return Objects.equals(this.acquirerId, transferNotificationMerchantData.acquirerId)
        && Objects.equals(this.city, transferNotificationMerchantData.city)
        && Objects.equals(this.country, transferNotificationMerchantData.country)
        && Objects.equals(this.mcc, transferNotificationMerchantData.mcc)
        && Objects.equals(this.merchantId, transferNotificationMerchantData.merchantId)
        && Objects.equals(this.name, transferNotificationMerchantData.name)
        && Objects.equals(this.postalCode, transferNotificationMerchantData.postalCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(acquirerId, city, country, mcc, merchantId, name, postalCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TransferNotificationMerchantData {\n");
    sb.append("    acquirerId: ").append(toIndentedString(acquirerId)).append("\n");
    sb.append("    city: ").append(toIndentedString(city)).append("\n");
    sb.append("    country: ").append(toIndentedString(country)).append("\n");
    sb.append("    mcc: ").append(toIndentedString(mcc)).append("\n");
    sb.append("    merchantId: ").append(toIndentedString(merchantId)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    postalCode: ").append(toIndentedString(postalCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of TransferNotificationMerchantData given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of TransferNotificationMerchantData
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     TransferNotificationMerchantData
   */
  public static TransferNotificationMerchantData fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, TransferNotificationMerchantData.class);
  }

  /**
   * Convert an instance of TransferNotificationMerchantData to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
