/*
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.service.balanceplatform;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.balanceplatform.CapitalGrantAccount;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class GrantAccountsApi extends Service {

  public static final String API_VERSION = "2";

  protected String baseURL;

  /**
   * Grant accounts constructor in {@link com.adyen.service.balanceplatform package}.
   *
   * @param client {@link Client } (required)
   */
  public GrantAccountsApi(Client client) {
    super(client);
    this.baseURL = createBaseURL("https://balanceplatform-api-test.adyen.com/bcl/v2");
  }

  /**
   * Grant accounts constructor in {@link com.adyen.service.balanceplatform package}. Please use
   * this constructor only if you would like to pass along your own url for routing or testing
   * purposes. The latest API version is defined in this class as a constant.
   *
   * @param client {@link Client } (required)
   * @param baseURL {@link String } (required)
   */
  public GrantAccountsApi(Client client, String baseURL) {
    super(client);
    this.baseURL = baseURL;
  }

  /**
   * Get a grant account
   *
   * @param id {@link String } The unique identifier of the grant account. (required)
   * @return {@link CapitalGrantAccount }
   * @throws ApiException if fails to make API call
   * @deprecated since Configuration API v2 Use the `/grantAccounts/{id}` endpoint from the [Capital
   *     API](https://docs.adyen.com/api-explorer/capital/latest/get/grantAccounts/(id)) instead.
   */
  @Deprecated
  public CapitalGrantAccount getGrantAccount(String id) throws ApiException, IOException {
    return getGrantAccount(id, null);
  }

  /**
   * Get a grant account
   *
   * @param id {@link String } The unique identifier of the grant account. (required)
   * @param requestOptions {@link RequestOptions } Object to store additional data such as
   *     idempotency-keys (optional)
   * @return {@link CapitalGrantAccount }
   * @throws ApiException if fails to make API call
   * @deprecated since Configuration API v2 Use the `/grantAccounts/{id}` endpoint from the [Capital
   *     API](https://docs.adyen.com/api-explorer/capital/latest/get/grantAccounts/(id)) instead.
   */
  @Deprecated
  public CapitalGrantAccount getGrantAccount(String id, RequestOptions requestOptions)
      throws ApiException, IOException {
    // Add path params
    Map<String, String> pathParams = new HashMap<>();
    if (id == null) {
      throw new IllegalArgumentException("Please provide the id path parameter");
    }
    pathParams.put("id", id);

    String requestBody = null;
    Resource resource = new Resource(this, this.baseURL + "/grantAccounts/{id}", null);
    String jsonResult =
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
    return CapitalGrantAccount.fromJson(jsonResult);
  }
}
