/*
 * Session authentication API
 *
 * The version of the OpenAPI document: 1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.service.sessionauthentication;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.sessionauthentication.AuthenticationSessionRequest;
import com.adyen.model.sessionauthentication.AuthenticationSessionResponse;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;

public class SessionAuthenticationApi extends Service {

  public static final String API_VERSION = "1";

  protected String baseURL;

  /**
   * Session authentication constructor in {@link com.adyen.service.sessionauthentication package}.
   *
   * @param client {@link Client } (required)
   */
  public SessionAuthenticationApi(Client client) {
    super(client);
    this.baseURL = createBaseURL("https://test.adyen.com/authe/api/v1");
  }

  /**
   * Session authentication constructor in {@link com.adyen.service.sessionauthentication package}.
   * Please use this constructor only if you would like to pass along your own url for routing or
   * testing purposes. The latest API version is defined in this class as a constant.
   *
   * @param client {@link Client } (required)
   * @param baseURL {@link String } (required)
   */
  public SessionAuthenticationApi(Client client, String baseURL) {
    super(client);
    this.baseURL = baseURL;
  }

  /**
   * Create a session token
   *
   * @param authenticationSessionRequest {@link AuthenticationSessionRequest } (required)
   * @param authenticationSessionRequest {@link AuthenticationSessionRequest } (required)
   * @return {@link AuthenticationSessionResponse }
   * @throws ApiException if fails to make API call
   */
  public AuthenticationSessionResponse createAuthenticationSession(
      AuthenticationSessionRequest authenticationSessionRequest) throws ApiException, IOException {
    return createAuthenticationSession(authenticationSessionRequest, null);
  }

  /**
   * Create a session token
   *
   * @param authenticationSessionRequest {@link AuthenticationSessionRequest } (required)
   * @param requestOptions {@link RequestOptions } Object to store additional data such as
   *     idempotency-keys (optional)
   * @return {@link AuthenticationSessionResponse }
   * @throws ApiException if fails to make API call
   */
  public AuthenticationSessionResponse createAuthenticationSession(
      AuthenticationSessionRequest authenticationSessionRequest, RequestOptions requestOptions)
      throws ApiException, IOException {
    String requestBody = authenticationSessionRequest.toJson();
    Resource resource = new Resource(this, this.baseURL + "/sessions", null);
    String jsonResult =
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
    return AuthenticationSessionResponse.fromJson(jsonResult);
  }
}
