/*
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.balanceplatform;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

/** AccountHolderCapability */
@JsonPropertyOrder({
  AccountHolderCapability.JSON_PROPERTY_ALLOWED,
  AccountHolderCapability.JSON_PROPERTY_ALLOWED_LEVEL,
  AccountHolderCapability.JSON_PROPERTY_ALLOWED_SETTINGS,
  AccountHolderCapability.JSON_PROPERTY_ENABLED,
  AccountHolderCapability.JSON_PROPERTY_PROBLEMS,
  AccountHolderCapability.JSON_PROPERTY_REQUESTED,
  AccountHolderCapability.JSON_PROPERTY_REQUESTED_LEVEL,
  AccountHolderCapability.JSON_PROPERTY_REQUESTED_SETTINGS,
  AccountHolderCapability.JSON_PROPERTY_TRANSFER_INSTRUMENTS,
  AccountHolderCapability.JSON_PROPERTY_VERIFICATION_STATUS
})
public class AccountHolderCapability {
  public static final String JSON_PROPERTY_ALLOWED = "allowed";
  private Boolean allowed;

  /**
   * The capability level that is allowed for the account holder. Possible values:
   * **notApplicable**, **low**, **medium**, **high**.
   */
  public enum AllowedLevelEnum {
    HIGH(String.valueOf("high")),

    LOW(String.valueOf("low")),

    MEDIUM(String.valueOf("medium")),

    NOTAPPLICABLE(String.valueOf("notApplicable"));

    private static final Logger LOG = Logger.getLogger(AllowedLevelEnum.class.getName());

    private String value;

    AllowedLevelEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static AllowedLevelEnum fromValue(String value) {
      for (AllowedLevelEnum b : AllowedLevelEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "AllowedLevelEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(AllowedLevelEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_ALLOWED_LEVEL = "allowedLevel";
  private AllowedLevelEnum allowedLevel;

  public static final String JSON_PROPERTY_ALLOWED_SETTINGS = "allowedSettings";
  private CapabilitySettings allowedSettings;

  public static final String JSON_PROPERTY_ENABLED = "enabled";
  private Boolean enabled;

  public static final String JSON_PROPERTY_PROBLEMS = "problems";
  private List<CapabilityProblem> problems;

  public static final String JSON_PROPERTY_REQUESTED = "requested";
  private Boolean requested;

  /**
   * The requested level of the capability. Some capabilities, such as those used in [card
   * issuing](https://docs.adyen.com/issuing/add-capabilities#capability-levels), have different
   * levels. Levels increase the capability, but also require additional checks and increased
   * monitoring. Possible values: **notApplicable**, **low**, **medium**, **high**.
   */
  public enum RequestedLevelEnum {
    HIGH(String.valueOf("high")),

    LOW(String.valueOf("low")),

    MEDIUM(String.valueOf("medium")),

    NOTAPPLICABLE(String.valueOf("notApplicable"));

    private static final Logger LOG = Logger.getLogger(RequestedLevelEnum.class.getName());

    private String value;

    RequestedLevelEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RequestedLevelEnum fromValue(String value) {
      for (RequestedLevelEnum b : RequestedLevelEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "RequestedLevelEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(RequestedLevelEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_REQUESTED_LEVEL = "requestedLevel";
  private RequestedLevelEnum requestedLevel;

  public static final String JSON_PROPERTY_REQUESTED_SETTINGS = "requestedSettings";
  private CapabilitySettings requestedSettings;

  public static final String JSON_PROPERTY_TRANSFER_INSTRUMENTS = "transferInstruments";
  private List<AccountSupportingEntityCapability> transferInstruments;

  /**
   * The status of the verification checks for the capability. Possible values: * **pending**: Adyen
   * is running the verification. * **invalid**: The verification failed. Check if the
   * &#x60;errors&#x60; array contains more information. * **valid**: The verification has been
   * successfully completed. * **rejected**: Adyen has verified the information, but found reasons
   * to not allow the capability.
   */
  public enum VerificationStatusEnum {
    INVALID(String.valueOf("invalid")),

    PENDING(String.valueOf("pending")),

    REJECTED(String.valueOf("rejected")),

    VALID(String.valueOf("valid"));

    private static final Logger LOG = Logger.getLogger(VerificationStatusEnum.class.getName());

    private String value;

    VerificationStatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static VerificationStatusEnum fromValue(String value) {
      for (VerificationStatusEnum b : VerificationStatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "VerificationStatusEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(VerificationStatusEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_VERIFICATION_STATUS = "verificationStatus";
  private VerificationStatusEnum verificationStatus;

  public AccountHolderCapability() {}

  @JsonCreator
  public AccountHolderCapability(
      @JsonProperty(JSON_PROPERTY_ALLOWED) Boolean allowed,
      @JsonProperty(JSON_PROPERTY_ALLOWED_LEVEL) AllowedLevelEnum allowedLevel,
      @JsonProperty(JSON_PROPERTY_PROBLEMS) List<CapabilityProblem> problems,
      @JsonProperty(JSON_PROPERTY_TRANSFER_INSTRUMENTS)
          List<AccountSupportingEntityCapability> transferInstruments,
      @JsonProperty(JSON_PROPERTY_VERIFICATION_STATUS) VerificationStatusEnum verificationStatus) {
    this();
    this.allowed = allowed;
    this.allowedLevel = allowedLevel;
    this.problems = problems;
    this.transferInstruments = transferInstruments;
    this.verificationStatus = verificationStatus;
  }

  /**
   * Indicates whether the capability is allowed. Adyen sets this to **true** if the verification is
   * successful and the account holder is permitted to use the capability.
   *
   * @return allowed Indicates whether the capability is allowed. Adyen sets this to **true** if the
   *     verification is successful and the account holder is permitted to use the capability.
   */
  @JsonProperty(JSON_PROPERTY_ALLOWED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getAllowed() {
    return allowed;
  }

  /**
   * The capability level that is allowed for the account holder. Possible values:
   * **notApplicable**, **low**, **medium**, **high**.
   *
   * @return allowedLevel The capability level that is allowed for the account holder. Possible
   *     values: **notApplicable**, **low**, **medium**, **high**.
   */
  @JsonProperty(JSON_PROPERTY_ALLOWED_LEVEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public AllowedLevelEnum getAllowedLevel() {
    return allowedLevel;
  }

  /**
   * allowedSettings
   *
   * @param allowedSettings
   * @return the current {@code AccountHolderCapability} instance, allowing for method chaining
   */
  public AccountHolderCapability allowedSettings(CapabilitySettings allowedSettings) {
    this.allowedSettings = allowedSettings;
    return this;
  }

  /**
   * Get allowedSettings
   *
   * @return allowedSettings
   */
  @JsonProperty(JSON_PROPERTY_ALLOWED_SETTINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public CapabilitySettings getAllowedSettings() {
    return allowedSettings;
  }

  /**
   * allowedSettings
   *
   * @param allowedSettings
   */
  @JsonProperty(JSON_PROPERTY_ALLOWED_SETTINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllowedSettings(CapabilitySettings allowedSettings) {
    this.allowedSettings = allowedSettings;
  }

  /**
   * Indicates whether the capability is enabled. If **false**, the capability is temporarily
   * disabled for the account holder.
   *
   * @param enabled Indicates whether the capability is enabled. If **false**, the capability is
   *     temporarily disabled for the account holder.
   * @return the current {@code AccountHolderCapability} instance, allowing for method chaining
   */
  public AccountHolderCapability enabled(Boolean enabled) {
    this.enabled = enabled;
    return this;
  }

  /**
   * Indicates whether the capability is enabled. If **false**, the capability is temporarily
   * disabled for the account holder.
   *
   * @return enabled Indicates whether the capability is enabled. If **false**, the capability is
   *     temporarily disabled for the account holder.
   */
  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getEnabled() {
    return enabled;
  }

  /**
   * Indicates whether the capability is enabled. If **false**, the capability is temporarily
   * disabled for the account holder.
   *
   * @param enabled Indicates whether the capability is enabled. If **false**, the capability is
   *     temporarily disabled for the account holder.
   */
  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }

  /**
   * Contains verification errors and the actions that you can take to resolve them.
   *
   * @return problems Contains verification errors and the actions that you can take to resolve
   *     them.
   */
  @JsonProperty(JSON_PROPERTY_PROBLEMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<CapabilityProblem> getProblems() {
    return problems;
  }

  /**
   * Indicates whether the capability is requested. To check whether the account holder is permitted
   * to use the capability, refer to the &#x60;allowed&#x60; field.
   *
   * @param requested Indicates whether the capability is requested. To check whether the account
   *     holder is permitted to use the capability, refer to the &#x60;allowed&#x60; field.
   * @return the current {@code AccountHolderCapability} instance, allowing for method chaining
   */
  public AccountHolderCapability requested(Boolean requested) {
    this.requested = requested;
    return this;
  }

  /**
   * Indicates whether the capability is requested. To check whether the account holder is permitted
   * to use the capability, refer to the &#x60;allowed&#x60; field.
   *
   * @return requested Indicates whether the capability is requested. To check whether the account
   *     holder is permitted to use the capability, refer to the &#x60;allowed&#x60; field.
   */
  @JsonProperty(JSON_PROPERTY_REQUESTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getRequested() {
    return requested;
  }

  /**
   * Indicates whether the capability is requested. To check whether the account holder is permitted
   * to use the capability, refer to the &#x60;allowed&#x60; field.
   *
   * @param requested Indicates whether the capability is requested. To check whether the account
   *     holder is permitted to use the capability, refer to the &#x60;allowed&#x60; field.
   */
  @JsonProperty(JSON_PROPERTY_REQUESTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRequested(Boolean requested) {
    this.requested = requested;
  }

  /**
   * The requested level of the capability. Some capabilities, such as those used in [card
   * issuing](https://docs.adyen.com/issuing/add-capabilities#capability-levels), have different
   * levels. Levels increase the capability, but also require additional checks and increased
   * monitoring. Possible values: **notApplicable**, **low**, **medium**, **high**.
   *
   * @param requestedLevel The requested level of the capability. Some capabilities, such as those
   *     used in [card issuing](https://docs.adyen.com/issuing/add-capabilities#capability-levels),
   *     have different levels. Levels increase the capability, but also require additional checks
   *     and increased monitoring. Possible values: **notApplicable**, **low**, **medium**,
   *     **high**.
   * @return the current {@code AccountHolderCapability} instance, allowing for method chaining
   */
  public AccountHolderCapability requestedLevel(RequestedLevelEnum requestedLevel) {
    this.requestedLevel = requestedLevel;
    return this;
  }

  /**
   * The requested level of the capability. Some capabilities, such as those used in [card
   * issuing](https://docs.adyen.com/issuing/add-capabilities#capability-levels), have different
   * levels. Levels increase the capability, but also require additional checks and increased
   * monitoring. Possible values: **notApplicable**, **low**, **medium**, **high**.
   *
   * @return requestedLevel The requested level of the capability. Some capabilities, such as those
   *     used in [card issuing](https://docs.adyen.com/issuing/add-capabilities#capability-levels),
   *     have different levels. Levels increase the capability, but also require additional checks
   *     and increased monitoring. Possible values: **notApplicable**, **low**, **medium**,
   *     **high**.
   */
  @JsonProperty(JSON_PROPERTY_REQUESTED_LEVEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public RequestedLevelEnum getRequestedLevel() {
    return requestedLevel;
  }

  /**
   * The requested level of the capability. Some capabilities, such as those used in [card
   * issuing](https://docs.adyen.com/issuing/add-capabilities#capability-levels), have different
   * levels. Levels increase the capability, but also require additional checks and increased
   * monitoring. Possible values: **notApplicable**, **low**, **medium**, **high**.
   *
   * @param requestedLevel The requested level of the capability. Some capabilities, such as those
   *     used in [card issuing](https://docs.adyen.com/issuing/add-capabilities#capability-levels),
   *     have different levels. Levels increase the capability, but also require additional checks
   *     and increased monitoring. Possible values: **notApplicable**, **low**, **medium**,
   *     **high**.
   */
  @JsonProperty(JSON_PROPERTY_REQUESTED_LEVEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRequestedLevel(RequestedLevelEnum requestedLevel) {
    this.requestedLevel = requestedLevel;
  }

  /**
   * requestedSettings
   *
   * @param requestedSettings
   * @return the current {@code AccountHolderCapability} instance, allowing for method chaining
   */
  public AccountHolderCapability requestedSettings(CapabilitySettings requestedSettings) {
    this.requestedSettings = requestedSettings;
    return this;
  }

  /**
   * Get requestedSettings
   *
   * @return requestedSettings
   */
  @JsonProperty(JSON_PROPERTY_REQUESTED_SETTINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public CapabilitySettings getRequestedSettings() {
    return requestedSettings;
  }

  /**
   * requestedSettings
   *
   * @param requestedSettings
   */
  @JsonProperty(JSON_PROPERTY_REQUESTED_SETTINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRequestedSettings(CapabilitySettings requestedSettings) {
    this.requestedSettings = requestedSettings;
  }

  /**
   * Contains the status of the transfer instruments associated with this capability.
   *
   * @return transferInstruments Contains the status of the transfer instruments associated with
   *     this capability.
   */
  @JsonProperty(JSON_PROPERTY_TRANSFER_INSTRUMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<AccountSupportingEntityCapability> getTransferInstruments() {
    return transferInstruments;
  }

  /**
   * The status of the verification checks for the capability. Possible values: * **pending**: Adyen
   * is running the verification. * **invalid**: The verification failed. Check if the
   * &#x60;errors&#x60; array contains more information. * **valid**: The verification has been
   * successfully completed. * **rejected**: Adyen has verified the information, but found reasons
   * to not allow the capability.
   *
   * @return verificationStatus The status of the verification checks for the capability. Possible
   *     values: * **pending**: Adyen is running the verification. * **invalid**: The verification
   *     failed. Check if the &#x60;errors&#x60; array contains more information. * **valid**: The
   *     verification has been successfully completed. * **rejected**: Adyen has verified the
   *     information, but found reasons to not allow the capability.
   */
  @JsonProperty(JSON_PROPERTY_VERIFICATION_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public VerificationStatusEnum getVerificationStatus() {
    return verificationStatus;
  }

  /** Return true if this AccountHolderCapability object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AccountHolderCapability accountHolderCapability = (AccountHolderCapability) o;
    return Objects.equals(this.allowed, accountHolderCapability.allowed)
        && Objects.equals(this.allowedLevel, accountHolderCapability.allowedLevel)
        && Objects.equals(this.allowedSettings, accountHolderCapability.allowedSettings)
        && Objects.equals(this.enabled, accountHolderCapability.enabled)
        && Objects.equals(this.problems, accountHolderCapability.problems)
        && Objects.equals(this.requested, accountHolderCapability.requested)
        && Objects.equals(this.requestedLevel, accountHolderCapability.requestedLevel)
        && Objects.equals(this.requestedSettings, accountHolderCapability.requestedSettings)
        && Objects.equals(this.transferInstruments, accountHolderCapability.transferInstruments)
        && Objects.equals(this.verificationStatus, accountHolderCapability.verificationStatus);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        allowed,
        allowedLevel,
        allowedSettings,
        enabled,
        problems,
        requested,
        requestedLevel,
        requestedSettings,
        transferInstruments,
        verificationStatus);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AccountHolderCapability {\n");
    sb.append("    allowed: ").append(toIndentedString(allowed)).append("\n");
    sb.append("    allowedLevel: ").append(toIndentedString(allowedLevel)).append("\n");
    sb.append("    allowedSettings: ").append(toIndentedString(allowedSettings)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    problems: ").append(toIndentedString(problems)).append("\n");
    sb.append("    requested: ").append(toIndentedString(requested)).append("\n");
    sb.append("    requestedLevel: ").append(toIndentedString(requestedLevel)).append("\n");
    sb.append("    requestedSettings: ").append(toIndentedString(requestedSettings)).append("\n");
    sb.append("    transferInstruments: ")
        .append(toIndentedString(transferInstruments))
        .append("\n");
    sb.append("    verificationStatus: ").append(toIndentedString(verificationStatus)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of AccountHolderCapability given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of AccountHolderCapability
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     AccountHolderCapability
   */
  public static AccountHolderCapability fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, AccountHolderCapability.class);
  }

  /**
   * Convert an instance of AccountHolderCapability to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
