/*
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.balanceplatform;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;
import java.util.ArrayList;
import java.util.List;

/** BalanceWebhookSetting */
@JsonPropertyOrder({BalanceWebhookSetting.JSON_PROPERTY_CONDITIONS})
@JsonIgnoreProperties(
    value =
        "type", // ignore manually set type, it will be automatically generated by Jackson during
    // serialization
    allowSetters = true // allows the type to be set during deserialization
    )
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "type",
    visible = true)
public class BalanceWebhookSetting extends WebhookSetting {
  public static final String JSON_PROPERTY_CONDITIONS = "conditions";
  private List<Condition> conditions;

  public BalanceWebhookSetting() {}

  /**
   * The list of settings and criteria for triggering the [balance
   * webhook](https://docs.adyen.com/api-explorer/balance-webhooks/latest/post/balanceAccount.balance.updated).
   *
   * @param conditions The list of settings and criteria for triggering the [balance
   *     webhook](https://docs.adyen.com/api-explorer/balance-webhooks/latest/post/balanceAccount.balance.updated).
   * @return the current {@code BalanceWebhookSetting} instance, allowing for method chaining
   */
  public BalanceWebhookSetting conditions(List<Condition> conditions) {
    this.conditions = conditions;
    return this;
  }

  public BalanceWebhookSetting addConditionsItem(Condition conditionsItem) {
    if (this.conditions == null) {
      this.conditions = new ArrayList<>();
    }
    this.conditions.add(conditionsItem);
    return this;
  }

  /**
   * The list of settings and criteria for triggering the [balance
   * webhook](https://docs.adyen.com/api-explorer/balance-webhooks/latest/post/balanceAccount.balance.updated).
   *
   * @return conditions The list of settings and criteria for triggering the [balance
   *     webhook](https://docs.adyen.com/api-explorer/balance-webhooks/latest/post/balanceAccount.balance.updated).
   */
  @JsonProperty(JSON_PROPERTY_CONDITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<Condition> getConditions() {
    return conditions;
  }

  /**
   * The list of settings and criteria for triggering the [balance
   * webhook](https://docs.adyen.com/api-explorer/balance-webhooks/latest/post/balanceAccount.balance.updated).
   *
   * @param conditions The list of settings and criteria for triggering the [balance
   *     webhook](https://docs.adyen.com/api-explorer/balance-webhooks/latest/post/balanceAccount.balance.updated).
   */
  @JsonProperty(JSON_PROPERTY_CONDITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setConditions(List<Condition> conditions) {
    this.conditions = conditions;
  }

  /** Return true if this BalanceWebhookSetting object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BalanceWebhookSetting balanceWebhookSetting = (BalanceWebhookSetting) o;
    return Objects.equals(this.conditions, balanceWebhookSetting.conditions) && super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(conditions, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BalanceWebhookSetting {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    conditions: ").append(toIndentedString(conditions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  static {
    // Initialize and register the discriminator mappings.
    Map<String, Class<?>> mappings = new HashMap<>();
    mappings.put("BalanceWebhookSetting", BalanceWebhookSetting.class);
    JSON.registerDiscriminator(BalanceWebhookSetting.class, "type", mappings);
  }

  /**
   * Create an instance of BalanceWebhookSetting given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of BalanceWebhookSetting
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     BalanceWebhookSetting
   */
  public static BalanceWebhookSetting fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, BalanceWebhookSetting.class);
  }

  /**
   * Convert an instance of BalanceWebhookSetting to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
